<?php

$clientScript = Yii::app()->clientScript;

?>

<style>
.list-file-upload .btn {
    width: 45% !important;
}
</style>

<h1 class="page-header"><?php echo $this->pageTitle; ?></h1>

<div class="row">
    <div class="col-md-12">
        <?php $this->widget('Flash', array('flashes' => Yii::app()->user->getFlashes()));?>
    </div>
    <div class="col-md-12" style="margin-bottom: 10px;">
        <?php echo CHtml::link('<span class="glyphicon glyphicon-cloud-upload"></span> Upload Spreadsheet', '#', ['class' => 'btn btn-primary', 'id' => 'btn-upload-vendor']); ?>
        <?php echo CHtml::link('<span class="glyphicon glyphicon-briefcase"></span> View Archive Spreadsheets', '#', ['class' => 'btn btn-primary pull-right', 'id' => 'btn-view-archived-spreadsheet']); ?>
        <?php echo CHtml::link('<span class="glyphicon glyphicon-briefcase"></span> View Last Published Spreadsheets', '#', ['class' => 'btn btn-primary pull-right', 'id' => 'btn-view-published-spreadsheet', 'style' => 'margin-right: 15px;']); ?>
        <?php echo CHtml::link('<span class="glyphicon glyphicon-briefcase"></span> Test Cron Performance', '#', ['class' => 'btn btn-primary pull-right', 'id' => 'btn-view-cron-performance', 'style' => 'margin-right: 15px;']); ?>
        <?php //echo CHtml::link('<span class="glyphicon glyphicon-stats"></span> Review Vendor', ['reviewVendorSpreadsheet/index'], ['class' => 'btn btn-success  pull-right']); ?>
    </div>
    <div class="col-md-12">
        <?php 

        $this->widget('zii.widgets.CListView', array(
            'id' => 'vendor-fileupload-status',
            'dataProvider' => $vendorFileDataProvider,
            'itemView' => '_index',
            'template' => '

                <table class="table table-striped table-hover list-file-upload">
                    <colgroup>
                        <col style="width: 5%;">
                        <col style="width: 10%;">
                        <col style="width: 25%;">
                        <col style="width: 10%;">
                        <col style="width: 10%;">
                        <col style="width: 17.5%;">
                        <col style="width: 17.5%;">
                    </colgroup>
                    <thead> 
                        <tr class="active">
                            <th class="text-left">#</th>
                            <th>Vendor</th>
                            <th>File Name</th>
                            <th class="text-left">Records</th>
                            <th class="text-left">Status</th>
                            <th class="text-left">Uploaded</th>
                            <th class="text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {items}
                    </tbody>
                </table>

            ',
            'emptyText' => '<tr><td colspan="7">No uploaded spreadsheets.</td></tr>',
            'pager' => array(
                'cssFile' => false, 
                'header' => false, 
                'firstPageLabel' => '&lt;&lt;',
                'prevPageLabel' => '&lt;',
                'nextPageLabel' => '&gt;',
                'lastPageLabel' => '&gt;&gt;'
            ),
        ));

        ?>
    </div>
</div>

<div class="modal fade" tabindex="-1" role="dialog" id="popup-upload-vendor">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Upload Spreadsheet</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <p><span class="glyphicon glyphicon-info-sign"></span> Supported spreadsheets: <strong>(
                                <?php 
                                $x = 1;
                                $length = count($vendors);
                                foreach($vendors as $index => $vendor){
                                    $addtlStr = ($x == $length ? '' : ', ');
                                    echo Vendor::getVendorNameLabel($vendor->id).$addtlStr; 
                                    $x++;
                                }?> )</strong></p>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="alert alert-success" id="alert-success-upload-vendor" style="display: none;"></div>
                        <div class="alert alert-danger" id="alert-danger-upload-vendor" style="display: none;"></div>
                    </div>
                    <form id="form-upload-vendor">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?php echo CHtml::activeDropDownList($vendorFile, 'vendor_id', Vendor::getListData(), ['class' => 'form-control', 'empty' => 'Select Vendor']); ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <?php $this->widget('Uploader'); ?>
                    </div>
                    </form>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="submit-upload-vendor">Save</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" tabindex="-1" role="dialog" id="popup-view-report-error">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body" style="margin-bottom: 0; padding-bottom: 0;">
                <div class="alert alert-danger"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" tabindex="-1" role="dialog" id="view-archived-spreadsheet">
    <div class="modal-dialog modal-lg" style="width: 90% !important;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">View Archived Spreadsheets</h4>
            </div>
            <div class="modal-body" style="margin-bottom: 0; padding-bottom: 0;">
                <div class="row">
                    <div class="col-md-12">
                        <?php 

                        $this->widget('zii.widgets.CListView', array(
                            'id' => 'vendor-fileupload-archive',
                            'dataProvider' => $vendorFileDataArchiveProvider,
                            'itemView' => '_index',
                            'template' => '

                                <table class="table table-striped table-hover">
                                    <colgroup>
                                        <col style="width: 3%;">
                                        <col style="width: 8%;">
                                        <col style="width: 34%;">
                                        <col style="width: 8%;">
                                        <col style="width: 8%;">
                                        <col style="width: 14%;">
                                        <col style="width: 15%;">
                                    </colgroup>
                                    <thead>
                                        <tr class="active">
                                            <th class="text-center">#</th>
                                            <th>Vendor</th>
                                            <th>File Name</th>
                                            <th class="text-center">Records</th>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Uploaded</th>
                                            <th class="text-center">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {items}
                                    </tbody>
                                </table>

                            ',
                            'emptyText' => '<tr><td colspan="7">No archived spreadsheets.</td></tr>',
                            'pager' => array(
                                'cssFile' => false, 
                                'header' => false, 
                                'firstPageLabel' => '&lt;&lt;',
                                'prevPageLabel' => '&lt;',
                                'nextPageLabel' => '&gt;',
                                'lastPageLabel' => '&gt;&gt;'
                            ),
                        ));

                        ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" tabindex="-1" role="dialog" id="view-published-spreadsheet">
    <div class="modal-dialog modal-lg" style="width: 90% !important;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">View Last Published Spreadsheets</h4>
            </div>
            <div class="modal-body" style="margin-bottom: 0; padding-bottom: 0;">
                <p>
                    Google Feed
                    <label class="toggleSwitch" onclick="">
                        <input type="checkbox" name="toggle_google" id="toggleGoogle" checked/>
                        <span>
                            <span>OFF</span>
                            <span>ON</span>
                        </span>
                        <a></a>
                    </label>
                </p>
                <div class="row">
                    <div class="col-md-12">
                        <?php 
                        $this->widget('zii.widgets.CListView', array(
                            'id' => 'spreadsheets-published-table',
                            'dataProvider' => $vendorProvider,
                            'itemView' => '_publishedVendor',
                            'template' => '
                
                                <table class="table table-striped table-hover list-published-spreadsheet">
                                    <colgroup>
                                        <col style="width: 5%;">
                                        <col style="width: 10%;">
                                        <col style="width: 25%;">
                                        <col style="width: 10%;">
                                        <col style="width: 10%;">
                                        <col style="width: 17.5%;">
                                        <col style="width: 17.5%;">
                                    </colgroup>
                                    <thead> 
                                        <tr class="active">
                                            <th class="text-left">#</th>
                                            <th>Vendor</th>
                                            <th>File Name</th>
                                            <th class="text-left">Records</th>
                                            <th class="text-left">Status</th>
                                            <th class="text-left">Published</th>
                                            <th class="text-left">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {items}
                                    </tbody>
                                </table>
                
                            ',
                            'emptyText' => '<tr><td colspan="7">No latest published spreadsheets.</td></tr>',
                            'pager' => array(
                                'cssFile' => false, 
                                'header' => false, 
                                'firstPageLabel' => '&lt;&lt;',
                                'prevPageLabel' => '&lt;',
                                'nextPageLabel' => '&gt;',
                                'lastPageLabel' => '&gt;&gt;'
                            ),
                        ));
                
                        ?>                        
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" tabindex="-1" role="dialog" id="view-cron-performance">
    <div class="modal-dialog modal-lg" style="width: 90% !important;">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Test Cron Performance</h4>
            </div>
            <div class="modal-body" style="margin-bottom: 0; padding-bottom: 0;">
                <div class="row">
                    <div class="col-md-12 response">
                        <div id="gssResponse">
                            <h3>GSS</h3>
                            <ul id="gssResponseList">

                            </ul>
                        </div>
                        <div id="sbbResponse">
                            <h3>SBB</h3>
                            <ul id="sbbResponseList">

                            </ul>
                        </div>
                        
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<?php 

$clientScript->registerScript("upload-script", " 

    var uploadVendorPopup = $('#popup-upload-vendor');
    var uploadVendorBtn = $('#btn-upload-vendor');
    var uploadVendorSubmit = $('#submit-upload-vendor');
    var uploadVendorSubmitDefault = uploadVendorSubmit.text();
    var uploadVendorForm = $('#form-upload-vendor');
    var uploadVendorAlertSuccess = $('#alert-success-upload-vendor');
    var uploadVendorAlertDanger = $('#alert-danger-upload-vendor');

    $('document').ready(function() {
        uploadVendorBtn.click(function() {
            uploadVendorAlertSuccess.hide();
            uploadVendorAlertDanger.hide();

            resetUploadVendor();

            uploadVendorPopup.modal('show');
        });

        uploadVendorSubmit.click(function() {
            uploadVendorAlertSuccess.hide();
            uploadVendorAlertDanger.hide();
            console.log(uploadVendorForm.serialize());
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('UploadVendorSpreadsheet/index') ."',
                data: uploadVendorForm.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    if (res.status == 'ok') {
                        uploadVendorAlertSuccess.html('<p>' + res.message + '</p>').fadeIn();
                        resetUploadVendor();

                        $.fn.yiiListView.update('vendor-fileupload-status');
                    } else {
                        uploadVendorAlertDanger.fadeIn();
                        uploadVendorAlertDanger.html('<p>' + res.message + '</p>').fadeIn();
                    }
                }, 
                error: function(res, xhr, status, error) {
                    console.log('Error:' + xhr.responseText);
                    console.log(status);
                    console.log(error);
                    console.log(res);
                    // location.reload();
                },
                beforeSend: function() {
                    uploadVendorSubmit.prop('disabled', true);
                    uploadVendorSubmit.text('Saving...');
                },
                complete: function() {
                    uploadVendorSubmit.prop('disabled', false);
                    uploadVendorSubmit.text(uploadVendorSubmitDefault);
                }
            });
        });
    });

    function resetUploadVendor() {
        uploadVendorForm.find('select[name=\"VendorFile[vendor_id]\"]').val('');

        if (dropVar.files.length > 0) {
            dropVar.removeFile(dropVar.files[0]);
        }
    }

    setInterval(function() {
        $.fn.yiiListView.update('vendor-fileupload-status');
    }, 5000);

");

$clientScript->registerScript("list-delete", "

    $('body').on('click', '.delete-file', function(e) {
        e.preventDefault();
        
        if (confirm('Are you sure you want to delete this spreadsheet?')) {
            location.href = $(this).attr('href');
        }
    });

"); 


$clientScript->registerScript("list-archive", "

    $('body').on('click', '.archive-file', function(e) {
        e.preventDefault();
        
        if (confirm('Are you sure you want to archive this spreadsheet?')) {
            location.href = $(this).attr('href');
        }
    });

    $('#btn-view-archived-spreadsheet').click(function() {
        $('#view-archived-spreadsheet').modal('show');
    });
"); 

$clientScript->registerScript("list-republished", "
$('#btn-view-published-spreadsheet').click(function() {
        
    $.fn.yiiListView.update('spreadsheets-published-table');
    $('#view-published-spreadsheet').modal('show');
});
");

$clientScript->registerScript("test-cron-performance", "
$('#btn-view-cron-performance').click(function() {
    var btnCronPerformance = $('#btn-view-cron-performance');
    $.ajax({
        url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/testPublishData') ."',
        dataType: 'JSON',
        method: 'GET',
        success: function(data) {
            if(data.error != undefined){
                $('.response div').remove();
                $('.response').html('<p><strong>'+data.error+'</strong></p>');
            }
            $('#gssResponseList').html('<li>Get Product Data Response Time - '+data.gssSearchResponse+' seconds</li><li>Insert / Update WordPress Product Response Time - '+data.gssInsertResponse+' seconds</li><li>Insert / Update Google Product Response Time - '+data.gssGoogleResponse+' seconds</li>');

            $('#sbbResponseList').html('<li>Get Product Data Response Time - '+data.sbbSearchResponse+' seconds</li><li>Insert / Update WordPress Product Response Time - '+data.sbbInsertResponse+' seconds</li><li>Insert / Update Google Product Response Time - '+data.sbbGoogleResponse+' seconds</li>');

            $('#view-cron-performance').modal('show');
        }, 
        error: function(res) {
            console.log(res)
        },
        beforeSend: function() {
            btnCronPerformance.attr('disabled',true);
            btnCronPerformance.html('Loading...');
        },
        complete: function() {
            btnCronPerformance.attr('disabled',false);
            btnCronPerformance.html('Test Cron Performance');
        }
    });
});
");

$clientScript->registerScript("report-error", "

    $('body').on('click', '.btn-view-report-error', function(e) {
        e.preventDefault();

        var self = $(this);
        var popupViewReportError = $('#popup-view-report-error');

        popupViewReportError.find('.alert').html(self.attr('data-report'));
        popupViewReportError.modal('show');
    });

");

$clientScript->registerScript("toggle-goggle", "
    $('#toggleGoogle').change(function() {
        var toggleGoogle = true;
        if(this.checked){
            toggleGoogle = true;
        }else{
            toggleGoogle = false;
        }
        $('.republish-file').each(function(){
            console.log($(this).data('id'));
            var url = '". Yii::app()->createAbsoluteUrl('uploadVendorSpreadsheet/republish')."'+'/'+$(this).data('id')+'?toggleGoogle='+toggleGoogle
            $(this).attr('href', url);
        });
    });
")

?>