<?php

$clientScript = Yii::app()->clientScript;

$clientScript->registerCss("dashboard-css", "
    .panel-heading {
        font-size: 16px;
    }
");

?>

<h1 class="page-header"><?php echo $this->pageTitle; ?></h1>

<div class="table-responsive">

<div class="row">
    <div class="col-md-4">
        <div class="panel panel-primary">
            <div class="panel-heading text-center">
                <strong><span class="glyphicon glyphicon-info-sign"></span>  Uploaded Spreadsheets Reports</strong>
            </div>
            <div class="panel-body">
                <section class="text-center">
                <p style="font-size: 32px; font-weight: 700;"><?php echo $reportSpreadSheets['count']; ?><br></p><small style="font-size: 12px;">Spreadsheets</small>
                </span>
                <hr>
                <table class="table table-condensed table-striped table-hover">
                    <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Vendors</th>
                    </tr>
                    </thead>
                    <tr>
                        <td class="text-left"><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_GEO_VISION); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['vendor'][Vendor::INDEX_GEO_VISION]; ?></span></td>
                        <td></td>
                    </tr>         
                    <tr>
                        <td class="text-left"><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_MOTOBIX); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['vendor'][Vendor::INDEX_MOTOBIX]; ?></span></td>
                        <td></td>
                    </tr>                    
                    <tr>
                        <td class="text-left"><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_FLIR); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['vendor'][Vendor::INDEX_FLIR]; ?></span></td>
                        <td></td>
                    </tr>    
                    <tr>
                        <td class="text-left"><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_ACTI); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['vendor'][Vendor::INDEX_ACTI]; ?></span></td>
                        <td></td>
                    </tr>  
                </table>
                <table class="table table-condensed table-striped table-hover">
                <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Progress Status</th>
                    </tr>
                    </thead>
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_PENDING) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_PENDING]; ?></span></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_PARSING) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_PARSING]; ?></span></td>
                        <td></td>
                    </tr>   
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_FOR_REVIEW) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_FOR_REVIEW]; ?></span></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_PUSHING) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_PUSHING]; ?></span></td>
                        <td></td>
                    </tr>  
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_PUSHED) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_PUSHED]; ?></span></td>
                        <td></td>
                    </tr>                   
                    <tr>
                        <td class="text-left"><?php echo VendorFile::getStatusLabel(VendorFile::STATUS_ERROR) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportSpreadSheets['status'][VendorFile::STATUS_ERROR]; ?></span></td>
                        <td></td>
                    </tr>  
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="panel panel-primary">
            <div class="panel-heading text-center">
                <strong><span class="glyphicon glyphicon-info-sign"></span> Parsed Data Reports</strong>
            </div>
            <div class="panel-body">
                <section class="text-center">
                <p class="text-center" style="font-size: 32px; font-weight: 700;"><?php echo $reportParsedData['count']; ?></p><small style="font-size: 12px;">Parsed Data</small>
                </section>
                <hr>
                <table class="table table-condensed table-striped">
                    <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Product Status</th>
                    </tr>
                    </thead>
                    <tr>
                        <td><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_NEW); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_NEW]; ?></span></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_UPDATED) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_UPDATED]; ?></span></td>
                        <td></td>
                    </tr>   
                    <tr>
                        <td><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_REMAIN) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_REMAIN]; ?></span></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_EOL) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_EOL]; ?></span></td>
                        <td></td>
                    </tr>
                </table>
                <table class="table table-condensed table-striped">
                <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Progress Status</th>
                    </tr>
                    </thead>
                    <tr>
                        <td><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_FOR_REVIEW) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['status'][VendorNormalized::STATUS_FOR_REVIEW]; ?></span></td>
                        <td></td>
                    </tr>
                    <!--<tr>
                        <td><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_PUSHING) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['status'][VendorNormalized::STATUS_PUSHING]; ?></span></td>
                        <td></td>
                    </tr>   
                    <tr>
                        <td><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_PUSHED) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['status'][VendorNormalized::STATUS_PUSHED]; ?></span></td>
                        <td></td>
                    </tr>-->
                    <tr>
                        <td><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_DELETED) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['status'][VendorNormalized::STATUS_DELETED]; ?></span></td>
                        <td></td>
                    </tr>  
                    <tr>
                        <td><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_ERROR) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportParsedData['status'][VendorNormalized::STATUS_ERROR]; ?></span></td>
                        <td></td>
                    </tr>                   
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="panel panel-primary">
            <div class="panel-heading text-center">
                <strong><span class="glyphicon glyphicon-info-sign"></span> Published Products Reports</strong>
            </div>
            <div class="panel-body">
                <section class="text-center">
                <p class="text-center" style="font-size: 32px; font-weight: 700;"><?php echo $reportPublishedProduct['count']; ?></p><small style="font-size: 12px;">Products</small>
                </section>
                <hr>
                <table class="table table-condensed table-striped">
                    <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Platforms</th>
                    </tr>
                    </thead>
                    <tr>
                        <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_WOO_COMMERCE); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['websites'][Product::WEBSITE_WOO_COMMERCE]; ?></span></td>
                        <td></td>
                    </tr>    
                    <tr>
                        <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_GSS); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['websites'][Product::WEBSITE_GSS]; ?></span></td>
                        <td></td>
                    </tr>                                     
                    <tr>
                        <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_GOOGLE_MERCHANT); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['websites'][Product::WEBSITE_GOOGLE_MERCHANT]; ?></span></td>
                        <td></td>
                    </tr>                              
                </table>
                <table class="table table-condensed table-striped">
                    <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Vendors</th>
                    </tr>
                    </thead>
                    <tr>
                        <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_GEO_VISION); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['vendor'][Vendor::INDEX_GEO_VISION]; ?></span></td>
                        <td></td>
                    </tr>         
                    <tr>
                        <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_MOTOBIX); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['vendor'][Vendor::INDEX_MOTOBIX]; ?></span></td>
                        <td></td>
                    </tr>                    
                    <tr>
                        <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_FLIR); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['vendor'][Vendor::INDEX_FLIR]; ?></span></td>
                        <td></td>
                    </tr>    
                    <tr>
                        <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_ACTI); ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['vendor'][Vendor::INDEX_ACTI]; ?></span></td>
                        <td></td>
                    </tr>  
                </table>
                <table class="table table-condensed table-striped">
                    <colgroup>
                        <col style="width: 40%;">
                        <col style="width: 30%;">
                        <col style="width: 30%;">   
                    </colgroup>
                    <thead>
                    <tr class="active">
                        <th colspan="3">Status</th>
                    </tr>
                    </thead>
                    <tr>
                        <td><?php echo Product::getStatusLabel(Product::STATUS_ACTIVE) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['status'][Product::STATUS_ACTIVE]; ?></span></td>
                        <td></td>
                    </tr>         
                    <tr>
                        <td><?php echo Product::getStatusLabel(Product::STATUS_ERROR) ?></td> 
                        <td class="text-center"><span class="badge"><?php echo $reportPublishedProduct['status'][Product::STATUS_ERROR]; ?></span></td>
                        <td></td>
                    </tr>                    
                </table>
            </div>
        </div>
    </div>
</div>



<h2></h2>

<h2></h2>

</div>

