<?php if (isset($isPublished)) : ?>
    <?php if ($isPublished == true) : ?>

    <div class="alert alert-info" style="padding: 10px 10px; margin: 0px; margin-bottom: 10px;">
        <p>Price tier successfully published to gss website.</p>
    </div>

    <?php else : ?>

    <div class="alert alert-warning" style="padding: 10px 10px; margin: 0px; margin-bottom: 10px;">
        <p>Publishing price tier can take up to minutes or hours. click the reload button to refresh.</p>
    </div>

    <?php endif; ?>
<?php endif; ?>

<table class="table table-bordered table-striped table-condensed" style="margin: 0; width: 100%; table-layout: fixed;white-space: normal;">
    <thead>
        <tr class="active">
            <th style="word-wrap: break-word;" width="40%">Levels</th>
            <th style="word-wrap: break-word;" width="20%">
                <span>Type</span>
            </th>
            <th style="word-wrap: break-word;" width="20%">
                <span>Price</span>
            </th>
        </tr>
    </thead>
    <tbody>
    <?php if ($productLevels) : ?>
        <?php 
        
        foreach ($productLevels as $productLevel) : 
        
        $pricingTier = PricingTier::model()->active()->findByPk($productLevel['pricing_tier_id']);
        if(!empty($pricingTier)):
        ?>
            <tr>
                <td style="word-wrap: break-word;white-space: normal;"><?php echo $pricingTier->description->tier_name; ?></td>
                <td style="word-wrap: break-word;">
                    <?php 

                    if ($productLevel['selected_price_type'] == PricingTier::TYPE_MARK_UP) {
                        echo 'Cost Markup';
                    } else {
                        echo 'MSRP Markdown';
                    }

                    ?>
                </td>
                <td style="word-wrap: break-word;">
                    <?php 

                    if ($productLevel['selected_price_type'] == PricingTier::TYPE_MARK_UP) {
                        echo '<strong>'. $productLevel->cost_markup_computed  . '</strong> (<strong>'. $pricingTier->cost_markup . '%)</strong>';
                    } else {
                        echo '<strong>' . $productLevel->msrp_markdown_computed  . '</strong> (<strong>'. $pricingTier->msrp_markdown . '%)</strong> ';
                    }

                    ?>
                </td>
            </tr>
        <?php 
        endif;
        endforeach; 
        
        ?>
    <?php else : ?>
        <p>Empty product pricing.</p>
    <?php endif; ?>
    </tbody>
</table>

<?php if (isset($productData)) : ?>

<script type="text/javascript">
    var apiPriceGroupStatus = parseInt(<?php echo isset($isPublished) && $isPublished == true ? 1 : 0; ?>);
    var listPriceLabelStatus = $('.product-pricing-tier-label-status-'+ <?php echo $productData->id; ?>);

    if (apiPriceGroupStatus == 1) {
        listPriceLabelStatus.removeClass('label-warning');
        listPriceLabelStatus.addClass('label-info');
    } else {
        listPriceLabelStatus.removeClass('label-info');
        listPriceLabelStatus.addClass('label-warning');
    }
</script>

<?php endif; ?>