<?php

$clientScript = Yii::app()->clientScript;

$clientScript->registerScriptFile("https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.3.3/bootbox.min.js");

$clientScript->registerCss("list_style", "

table { 
    width: 100%; 
}

div.table-scrolled {
    overflow: scroll;
}

.list-view table thead th, table tbody td {
    white-space: nowrap;
    text-align: left;
    padding-left: 5px !important;
    padding-right: 20px !important;
}

.list-view table thead th.default-padding, table tbody td.default-padding {
    padding-left: 5px !important;
    padding-right: 5px !important;
}

.list-view table tbody td {
    font-size: 13px;
}


/* make this code global */
ul.yiiPager {
    padding-left: 0px !important;
    margin-bottom: 0px !important;
}

ul.yiiPager .previous {
    float: left !important;
}

.list-view div.summary, .list-view .pager {
    text-align: center !important;
}

.pager li > a, .pager li > span {
    padding: 0px 15px !important;
    border-radius: initial;
}

.list-view  .label {
    font-size: 11px;
}

.progress-bar {
    padding: 6px;   
}

.progress-bar {
    font-size: 14px;
    font-weight: bold;
}

.pager .next > a, .pager .next > span {
    float: none;
}

ul.yiiPager .previous {
    float: none !important;
}

.pager .previous > a, .pager .previous > span {
    float: none;
}

.popover {
    min-width: 390px;
}

.popover ul {
    padding-left: 10px;
}

.container-gss-pricing .popover {
    min-width: 460px !important;
    top: 0px !important;
}

.container-gss-pricing .popover .arrow {
    display: none !important;
}

/*.tbl-header {
    position: sticky;
    position: -webkit-sticky;
    position: -moz-sticky;
    position: -ms-sticky;
    position: -o-sticky;
    top: 0;
}*/

.list-group a:hover
{
    background-color: #E8E8E8;
}

.progress-bar {
    padding: 6px;   
}

.progress-bar {
    font-size: 14px;
}
");

if($cronAction && $cronAction->status == CronProductActionStatus::STATUS_IN_PROGRESS){
    if($cronAction->type == CronProductActionStatus::TYPE_SET_EOL || $cronAction->type == CronProductActionStatus::TYPE_SET_NOT_EOL)
        $spanAction = 'Product Status Update Processing...';
    if($cronAction->type == CronProductActionStatus::TYPE_RE_PUBLISH)
        $spanAction = 'Re-Publish Product Processing...';
    if($cronAction->type == CronProductActionStatus::TYPE_OVERWRITE)
        $spanAction = 'Overwrite Product Processing...';
    if($cronAction->type == CronProductActionStatus::TYPE_DELETE)
        $spanAction = 'Delete Product Processing...';
    if($cronAction->type == CronProductActionStatus::TYPE_PRICE_SETTING)
        $spanAction = 'Update SBB Price Setting Processing...';
    if($cronAction->type == CronProductActionStatus::TYPE_SYNC_GOOGLE_PRODUCT_IMAGE)
        $spanAction = 'Sync Google Product Image Processing...';
}
if($cronAction->status == CronProductActionStatus::STATUS_COMPLETED){
    $spanAction = 'Process Completed! Click Dismiss button to dismiss!';
}
?>

<h1 class="page-header">
    <?php echo $this->pageTitle; ?>
    <?php if ($batchId != '') : ?>
    <span style="font-size: 12px; font-weight: bold;">
        <?php echo CHtml::link('Upload Spreadsheets', ['UploadVendorSpreadsheet/index']); ?>
        &nbsp;&nbsp;>>&nbsp;&nbsp;
        <?php echo CHtml::link('Review Spreadsheet', ['ReviewVendorSpreadsheet/index', 'id' => $batchId]); ?>
        &nbsp;&nbsp;>>&nbsp;&nbsp;
        <?php echo CHtml::link('Published Products', ['product/index']); ?>
    </span>
    <?php else : ?>
    <span style="font-size: 12px; font-weight: bold;">
        <?php echo CHtml::link('Upload Spreadsheets', ['UploadVendorSpreadsheet/index']); ?>
        &nbsp;&nbsp;>>&nbsp;&nbsp;
        <?php echo CHtml::link('Published Products', ['product/index']); ?>
    </span>
    <?php endif; ?>
</h1>

<div class="row">
    <div class="col-md-12" style="margin-bottom: 10px;">
        <div class="row">
            <div class="col-md-12">
                <?php echo CHtml::link('<span class="glyphicon glyphicon-info-sign"></span> Details (<span class="count-published">' . $productCountPublish . '</span>)', '#', ['class' => 'btn btn-info btn-product-details']); ?>
                <?php echo CHtml::link('<span class="glyphicon glyphicon-refresh"></span> Reload', '#', ['class' => 'btn btn-primary btn-refresh-list']); ?>
                <?php echo CHtml::link('<span class="glyphicon glyphicon-filter"></span> Filters', '#', ['class' => 'btn btn-primary btn-advance-search']); ?>
                <?php echo CHtml::link('<span class="glyphicon glyphicon-list-alt"></span> View Action Logs', '#', ['class' => 'btn btn-primary btn-action-logs pull-right']) ?>
                <?php //echo CHtml::link('<span class="glyphicon glyphicon-plus"></span> Add Product', '#', ['class' => 'btn btn-primary btn-']); 
                ?>
                <?php //echo CHtml::link('<span class="glyphicon glyphicon-remove"></span> Delete', '#', ['class' => 'btn btn-danger btn-delete-data-multiple ', 'style' => 'display: none;']); 
                ?>
                <?php //echo CHtml::link('', '#', ['class' => 'btn btn-success btn-republish-selected-items', 'style' => 'display: none;']); 
                ?>
                <div class="dropdown btn-options" style="display: none">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown" <?php echo (!empty($cronAction) && $cronAction->status != CronProductActionStatus::STATUS_NOT_RUNNING) ? 'disabled' : ''; ?>><span
                            class="fa fa-bars"></span> Options</button>
                    <ul class="dropdown-menu">
                        <li><a href="#" class="btn-set-product-status"
                                data-product-status="<?php echo Product::PRODUCT_STATUS_EOL; ?>">Set Product Status as
                                <?php echo Product::getProductStatusLabel(Product::PRODUCT_STATUS_EOL); ?></a></li>
                        <li><a href="#" class="btn-set-product-status"
                                data-product-status="<?php echo Product::PRODUCT_STATUS_EXISTING; ?>">Set Product Status
                                as Not EOL</a></li>
                        <li role="presentation" class="divider"></li>
                        <li><a href="#" class="btn-republish-selected-items">Re-Publish Products</a></li>
                        <!-- <li><a href="#" class="btn-overwrite-selected-items">Overwrite Products</a></li> -->
                        <li><a href="#" class="btn-delete-data-multiple">Delete Products</a></li>
                        <li role="presentation" class="divider"></li>
                        <li><a href="#" class="btn-options-lock-pricing">MPN Lock Pricing</a></li>
                        <li><a href="#" class="btn-options-unlock-pricing">MPN Unlock Pricing</a></li>
                        <li role="presentation" class="divider"></li>
                        <li><a href="#" class="btn-sbb-price-setting">SBB Price Setting</a></li>
                        <li><a href="#" class="btn-gss-price-setting">GSS Price Setting</a></li>
                        <li role="presentation" class="divider"></li>
                        <!-- <li><a href="#" class="btn-sync-googler-merchant-products-image">Sync Google Product Image</a> -->
                        </li>
                    </ul>
                </div>
                <button class="btn btn-primary btn-dismiss <?php echo ($cronAction->status != CronProductActionStatus::STATUS_COMPLETED) ? 'hide' : ''; ?>"><span>Dismiss</span></button>
            </div>
            <div class="col-md-4 text-right">
                <form action="product/DownloadQuickbook" id="dl-qb-brand" method="POST">
                    <?php // echo CHtml::dropdownList('search[vendor]', '', Vendor::getListData() , ['class' => '', 'empty' => 'Download All']); 
                    ?>

                    <input type="hidden" name="selected_brand_qb" id="selected_brand_qb">

                    <button type="submit" class="btn btn-primary p hide" id=""><span
                            class="glyphicon glyphicon-cloud-download"></span> Download Quick Books</button>

                    <?php //echo CHtml::link('<span class="glyphicon glyphicon-cloud-download"></span> Download Quick Books', ['product/DownloadQuickbook'], ['class' => 'btn btn-primary p', 'title' => 'Download Quickbooks Format', 'style' => 'display: inline-block;']); 
                    ?>


                </form>
            </div>
        </div>
    </div>
    <div class="col-md-12">         

        <div class="progress <?php echo (!$cronAction) ? 'hide' : ''; ?>" id="progress-action" style="display:initial">
            <div class="progress-bar progress-bar-striped active" role="progressbar"
            aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px; background-color:  <?php echo ($cronAction && $cronAction->status == CronProductActionStatus::STATUS_COMPLETED) ? '#4BB543' : '#428bca'; ?>">
                <span><?php echo !empty($cronAction) ? $spanAction : ''; ?></span>
            </div>
        </div>      
    </div>
    <div class="col-md-12">
    <div class="col-md-12">
        <?php

        $advanceSearchParamsHtml = '';
        $advanceSearchParamsData = '';

        if (!empty($advanceSearchParams['search'])) {
            foreach ($advanceSearchParams['search'] as $advanceSearchParamIdx => $advanceSearchParamVal) {
                $advanceSearchParamName = $advanceSearchParamIdx;
                $advanceSearchParamValue = $advanceSearchParamVal;

                if ($advanceSearchParamName == 'vendor' && $advanceSearchParamValue != '') {
                    $advanceSearchParamValue = Vendor::getName($advanceSearchParamValue);
                }

                if ($advanceSearchParamName == 'status' && $advanceSearchParamValue != '') {
                    $advanceSearchParamValue = Product::getStatusLabel($advanceSearchParamValue);
                }

                if ($advanceSearchParamName == 'product_status' && $advanceSearchParamValue != '') {
                    $advanceSearchParamValue = Product::getProductStatusLabel($advanceSearchParamValue);
                }

                $advanceSearchParamsData .= '<span class="label label-default filter-options" style="font-size: 13px;">Filter-' .  ucfirst($advanceSearchParamName) . ' : ' . $advanceSearchParamValue . '</span>&nbsp;';
            }
        }

        if ($advanceSearchParamsData != '') {
            $advanceSearchParamsData = '<span id="advance-search-params-data" style="font-size: 13px; margin-bottom: 10px; display: inline-block;">' . $advanceSearchParamsData . ' <a href="' . Yii::app()->createAbsoluteUrl('product') . '" class="xbtn-reset-advance-search"><strong><span class="glyphicon glyphicon-remove"></span> Reset Filters</strong></a></span>';
        }

        $this->widget('zii.widgets.CListView', array(
            'id' => 'list-vendor-product',
            'dataProvider' => $productdDataProvider,
            'itemView' => '_index',
            'template' => '
                <span style="display: none;" class="product-count-publish">' . $productCountPublish . '</span>
                ' . $advanceSearchParamsData . '
                <input type="hidden" name="product_ids" value="' . urlencode(CJSON::encode($productIds)) . '">
                <div class="table-responsive table-scrolled">
                    <form id="form-product-vendor">
                         {sorter}
                        <table class="table table-condensed table-striped table-hover header-fixed" style="margin: 0;">
                            <thead>
                                <tr class="active tbl-header">
                                    <th style="width: 1%;"><input type="checkbox" class="select-all-review-data"></th>
                                    <th style="width: 5%;">Platforms Status</th>
                                    <th>Vendor</th>
                                    <th>MPN</th>
                                    <th>SBB Price</th>
                                    <th>GSS Price</th>
                                    <th>Cost</th>
                                    <th>MSRP</th>
                                    <th>SKU</th>
                                    <th>GTIN / EAN</th>
                                    <th>Description</th>
                                    <th>Weight</th>
                                    <th>Width</th>
                                    <th>Length</th>
                                    <th>Height</th>
                                    <!-- <th>Quantity</th>-->
                                </tr>
                            </thead>
                            <tbody>
                                {items}
                            </tbody>
                        </table>
                    </form>
                </div>
                {pager}
            ',
            'emptyText' => '<tr><td colspan="16">Nothing to review.</td></tr>',
            'pager' => array(
                'cssFile' => false,
                'header' => false,
                'firstPageLabel' => '&lt;&lt;',
                'prevPageLabel' => '&lt;',
                'nextPageLabel' => '&gt;',
                'lastPageLabel' => '&gt;&gt;'
            ),
            'afterAjaxUpdate' => "function() {
                $('document').ready(function() {
                    activateLisTableScroll(); 
                    $('[data-toggle=\"popover\"]').popover();
                });

                $('.count-published').text($('.product-count-publish').text());
            }"
        ));

        ?>
    </div>
</div>




<div id="popup-advance-search" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="advance-search">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Filters</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4 form-group">
                            <label>Page Size</label>
                            <?php echo CHtml::dropdownList('search[pageSize]', '', array(
                                '50' => '50',
                                '100' => '100',
                                '500' => '500',
                                '1000' => '1000',
                            ), [
                                'class' => 'form-control',
                                'selected' => '50'
                            ]); ?>
                        </div>
                        <div class="col-md-4 form-group">
                            <label>Vendor</label>
                            <?php echo CHtml::dropdownList('search[vendor]', '', Vendor::getListData(), ['class' => 'form-control', 'empty' => 'All Vendors']); ?>
                        </div>
                        <div class="col-md-4 form-group">
                            <label>Product Status</label>
                            <select name="search[product_status]" class="form-control">
                                <option value="">All</option>
                                <option value="<?php echo Product::PRODUCT_STATUS_EOL ?>">
                                    <?php echo Product::getProductStatusLabel(Product::PRODUCT_STATUS_EOL); ?></option>
                                <option value="<?php echo Product::PRODUCT_STATUS_EXISTING ?>">
                                    <?php echo Product::getProductStatusLabel(Product::PRODUCT_STATUS_EXISTING); ?>
                                </option>
                            </select>
                        </div>
                        <div class="col-md-4 form-group">
                            <label>Status</label>
                            <select name="search[status]" class="form-control">
                                <option value="">All</option>
                                <option value="<?php echo Product::STATUS_ACTIVE ?>">
                                    <?php echo Product::getStatusLabel(Product::STATUS_ACTIVE); ?></option>
                                <option value="<?php echo Product::STATUS_ERROR ?>">
                                    <?php echo Product::getStatusLabel(Product::STATUS_ERROR); ?></option>
                            </select>
                        </div>
                        <div class="col-md-4 form-group">
                            <label>MPN</label>
                            <input type="name" class="form-control" placeholder="Enter MPN" name="search[mpn]">
                        </div>
                        <div class="col-md-4 form-group">
                            <label>SKU</label>
                            <input type="name" class="form-control" placeholder="Enter SKU" name="search[sku]">
                        </div>
                        <div class="col-md-12 form-group">
                            <label>Description</label>
                            <input type="name" class="form-control" placeholder="Enter Description Keyword"
                                name="search[description]">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-default btn-reset-advance-search">Reset</button>
                    <button type="submit" class="btn btn-primary" id="btn-apply-advance-search">Apply</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-item-report" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="advance-search">
                <div class="modal-body" style="padding-bottom: 0;">
                    <div class="alert alert-danger"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-edit-product-data" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <?php echo CHtml::beginForm('', 'POST', ['id' => 'edit-product-data']); ?>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Published Data</h4>
            </div>
            <div class="modal-body" style="padding-bottom: 0;">
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert" style="display: none;"></div>
                    </div>
                    <div class="col-md-6 form-group">
                        <?php echo CHtml::activeHiddenField($productInfo, 'product_id'); ?>
                        <?php echo CHtml::activeLabel($productInfo, 'Vendor'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'brand_name', ['class' => 'form-control input-sm', 'disabled' => true, 'readonly' => true]); ?>
                    </div>
                    <div class="col-md-6 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'mpn'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'mpn', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <label>SBB Price</label>
                        <?php echo CHtml::activeTextField($productInfo, 'sbb_price', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'cost'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'cost', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'msrp'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'msrp', ['class' => 'form-control input-sm']); ?>
                    </div>

                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'weight'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'weight', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'width'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'width', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'length'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'length', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'height'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'height', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <!-- <div class="col-md-6 form-group">
                        <?php //echo CHtml::activeLabel($productInfo, 'quantity'); 
                        ?>
                        <?php //echo CHtml::activeTextField($productInfo, 'quantity', ['class' => 'form-control input-sm']); 
                        ?>
                    </div> -->
                    <div class="col-md-6 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'sku'); ?>
                        <?php echo CHtml::activeTextField($productInfo, 'sku', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-6 form-group">
                        <?php //echo CHtml::activeLabel($productInfo, 'ean'); 
                        ?>
                        <label>GTIN / EAN</label>
                        <?php echo CHtml::activeTextField($productInfo, 'ean', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-12 form-group">
                        <?php echo CHtml::activeLabel($productInfo, 'description'); ?>
                        <?php echo CHtml::activeTextArea($productInfo, 'description', ['class' => 'form-control input-sm'/*, 'disabled' => 'disabled'*/]); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Save and Publish</button>
            </div>
            <?php echo CHtml::endform(); ?>
        </div>
    </div>
</div>

<div id="popup-product-details" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Published Products Details</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 container-filter-options">
                    </div>
                    <div class="col-md-6">
                        <table class="table table-condensed table-striped">
                            <colgroup>
                                <col style="width: 50%;">
                                <col style="width: 50%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th><strong>Total</strong></th>
                                    <th><span class="badge data-published-total">0</span></th>
                                </tr>
                            </thead>
                        </table>
                    </div>

                    <div class="clearfix"></div>

                    <div class="col-md-6">
                        <table class="table table-condensed table-striped">
                            <colgroup>
                                <col style="width: 40%;">
                                <col style="width: 30%;">
                                <col style="width: 30%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="3">Platforms</th>
                                </tr>
                            </thead>
                            <tr>
                                <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_WOO_COMMERCE); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-website-count-<?php echo Product::WEBSITE_WOO_COMMERCE; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_GOOGLE_MERCHANT); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-website-count-<?php echo Product::WEBSITE_GOOGLE_MERCHANT; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Product::getWebsiteLabel(Product::WEBSITE_GSS); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-website-count-<?php echo Product::WEBSITE_GSS; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                        </table>
                    </div>

                    <div class="col-md-6">
                        <table class="table table-condensed table-striped">
                            <colgroup>
                                <col style="width: 40%;">
                                <col style="width: 30%;">
                                <col style="width: 30%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="3">Status</th>
                                </tr>
                            </thead>
                            <tr>
                                <td><?php echo Product::getStatusLabel(Product::STATUS_ACTIVE) ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-status-count-<?php echo Product::STATUS_ACTIVE; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Product::getStatusLabel(Product::STATUS_ERROR) ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-status-count-<?php echo Product::STATUS_ERROR; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                        </table>
                    </div>

                    <div class="col-md-12">
                        <table class="table table-condensed table-striped">
                            <colgroup>
                                <col style="width: 10%;">
                                <col style="width: 30%;">
                                <col style="width: 60%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="3">Vendors</th>
                                </tr>
                            </thead>
                            <tr>
                                <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_GEO_VISION); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-vendors-count-<?php echo Vendor::INDEX_GEO_VISION; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_MOTOBIX); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-vendors-count-<?php echo Vendor::INDEX_MOTOBIX; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_FLIR); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-vendors-count-<?php echo Vendor::INDEX_FLIR; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo Vendor::getVendorNameLabel(Vendor::INDEX_ACTI); ?></td>
                                <td class="text-center"><span
                                        class="badge data-published-vendors-count-<?php echo Vendor::INDEX_ACTI; ?>">0</span>
                                </td>
                                <td></td>
                            </tr>
                        </table>
                    </div>

                    <div class="col-md-12">
                        <div style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-striped table-condensed" style="width: 100%; margin: 0;">
                                <colgroup>
                                    <col class="col-md-10">
                                    <col class="col-md-2">
                                </colgroup>
                                <thead>
                                    <tr class="active">
                                        <th colspan="2">Vendor Filename</th>
                                        <th>Date Created</th>
                                    </tr>
                                </thead>
                                <tbody class="data-published-files-html"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div id="popup-gss-price-setting" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="form-gss-price-setting" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">GSS Price Setting</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert-gss-price-setting alert" style="display:none;"></div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Pricing Group</label>
                                <?php echo CHtml::dropDownList('pricing_group_id', '', PricingGroup::getDataList(), [
                                    'class' => 'form-control',
                                    'empty' => 'None'
                                ]); ?>
                            </div>
                        </div>

                        <!-- <div class="col-md-6">
                                <div class="form-group">
                                <label>Pricing Type</label>
                                <?php

                                /*echo CHtml::dropDownList('pricing_type_x', '', [
                                    PricingTier::TYPE_MARK_UP => 'Cost Markup',    
                                    PricingTier::TYPE_MARK_DOWN => 'MSRP Markdown',    
                                ], 
                                [
                                    'empty' => 'None',
                                    'class' => 'form-control',
                                    'disabled' => true
                                ]); */

                                ?>
                            </div>
                        </div> -->

                        <div class="col-md-12 container-price-tier-gss-price-setting" style="display: none;">
                        </div>
                        <!-- 
                        <div class="col-md-12 container-empty-price-tier-gss-price-setting">
                            <div class="alert alert-info">No pricing tier selected.</div>
                        </div> 
                        -->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Apply and Publish</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-parsed-settings" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="price-settings" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">SBB Price Setting</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert" style="display:none;"></div>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Price Setting</label>
                            <select class="form-control" name="price_setting[type]">
                                <option value="<?php echo SettingSalesPrice::SALES_PRICE_SETTING_COST; ?>">Based on Cost
                                </option>
                                <option value="<?php echo SettingSalesPrice::SALES_PRICE_SETTING_MSRP; ?>">Based on MSRP
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="row form-group" id="container-sales-price-setting-based">
                        <div class="col-md-6 base-cost-markup-container">
                            <label>Cost Markup</label>
                            <div class="input-group">
                                <input id="password" type="text" class="form-control"
                                    name="price_setting[sales_margin_cost_markup]" placeholder="Enter Sales Margin"
                                    value="0">
                                <span class="input-group-addon"><strong>%</strong></span>
                            </div>
                        </div>
                        <div class="col-md-6 base-msrp-markup-container" style="display: none;">
                            <label>MSRP Markdown</label>
                            <div class="input-group">
                                <input id="password" type="text" class="form-control"
                                    name="price_setting[sales_margin_msrp_markdown]" placeholder="Enter Sales Margin"
                                    value="0">
                                <span class="input-group-addon"><strong>%</strong></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label>Shipping Dollar</label>
                            <div class="input-group">
                                <span class="input-group-addon"><strong>+</strong></span>
                                <input type="text" name="price_setting[dollor]" class="form-control" value="0"
                                    placeholder="Enter Added Dollars">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Apply and Publish</button>
                </div>
            </form>
        </div>
    </div>
</div>


<div id="view-action-logs" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="advance-search">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Action Logs</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php 
                            $this->widget('zii.widgets.CListView', array(
                                'id' => 'action-logs-table',
                                'dataProvider' => $actionLogsProvider,
                                'itemView' => '_action-logs',
                                'template' => '
                    
                                    <table class="table table-striped table-hover list-published-spreadsheet">
                                        <colgroup>
                                            <col style="width: 10%;">
                                            <col style="width: 20%;">
                                            <col style="width: 40%;">
                                            <col style="width: 30%;">
                                        </colgroup>
                                        <thead> 
                                            <tr class="active">
                                                <th class="text-left">#</th>
                                                <th>Action Name</th>
                                                <th>Description</th>
                                                <th>Created at</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {items}
                                        </tbody>
                                    </table>
                                    {pager}
                    
                                ',
                                'emptyText' => '<tr><td colspan="7">No latest published spreadsheets.</td></tr>',
                                'pager' => array(
                                    'cssFile' => false, 
                                    'header' => false, 
                                    'firstPageLabel' => '&lt;&lt;',
                                    'prevPageLabel' => '&lt;',
                                    'nextPageLabel' => '&gt;',
                                    'lastPageLabel' => '&gt;&gt;'
                                ),
                            ));
                    
                            ?>                        
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php



$clientScript->registerScript("init", "
    $('document').ready(function() {
        $('[data-toggle=\"popover\"]').popover();
    });
");

$clientScript->registerScript("qb-select", "
    var dropDown = document.getElementById('search_vendor');
    
    dropDown.addEventListener('change', function(){
        var brand = document.getElementById('selected_brand_qb');
        
        brand.value = dropDown.options[dropDown.selectedIndex].text;
    });
");

$clientScript->registerScript("table-scrolled-main", "

function activateLisTableScroll() {
    var listScrollHeight = window.innerHeight-240;
    var advanceSearchParamsDataHeight = $('#advance-search-params-data').height();

    if (advanceSearchParamsDataHeight != null) {
        listScrollHeight -= advanceSearchParamsDataHeight + 20;
    }

    $('.table-scrolled').css('height', listScrollHeight + 'px');
    $('.table-scrolled').css('overflow-y', 'scroll');
}


");

if ($productdDataProvider->itemCount  > 0) {

    $clientScript->registerScript("table-scrolled", "

    $('document').ready(function() {
        activateLisTableScroll(); 
    });

");
} else {

    $clientScript->registerScript("table-scrolled", "

    $('document').ready(function() {
        $('.table-scrolled').css('height', 80 + 'px');
        $('.table-scrolled').css('overflow-y', 'hidden');
    });

    ");
}

$clientScript->registerScript("addvance-search", "

    var btnApplyAdvanceSearch = $('#btn-apply-advance-search');
    var btnResetAdvanceSearch = $('.btn-reset-advance-search');
    var popupAdvanceSearch = $('#popup-advance-search')
    var formAdvanceSearch = $('form#advance-search');

    $('.btn-advance-search').click(function() {
        popupAdvanceSearch.modal('show');
    });

    formAdvanceSearch.submit(function(e) {
        e.preventDefault();

        var brand = document.getElementById('selected_brand_qb');
    
        dropDown.addEventListener('change', function(){
            var brand = document.getElementById('selected_brand_qb');
            
            brand.value = dropDown.options[dropDown.selectedIndex].text;
        });

        $.fn.yiiListView.update('list-vendor-product', {
            data: formAdvanceSearch.serialize() + '&ProductInfo_page=1',
            beforeSend: function() {
                btnApplyAdvanceSearch.html('Applying...');
                btnApplyAdvanceSearch.prop('disabled', true);
            },
            complete: function() {
                popupAdvanceSearch.modal('hide');

                btnApplyAdvanceSearch.html('Apply');
                btnApplyAdvanceSearch.prop('disabled', false);
            }
        });
    });
    
    $('body').on('click', '.btn-reset-advance-search', function() {
        var brand = document.getElementById('selected_brand_qb');
        formAdvanceSearch.find('input').val('');
        formAdvanceSearch.find('select').val('');
            
        brand.value = '';

        if (!btnResetAdvanceSearch.is(':disabled')) {
            $.fn.yiiListView.update('list-vendor-product', {
                data: formAdvanceSearch.serialize(),
                beforeSend: function() {
                    btnResetAdvanceSearch.html('Resetting ...');
                    btnResetAdvanceSearch.prop('disabled', true);
                },
                complete: function() {
                    popupAdvanceSearch.modal('hide');

                    btnResetAdvanceSearch.html('Reset');
                    btnResetAdvanceSearch.prop('disabled', false);
                }
            });
        }
    });
");



$clientScript->registerScript("progress-details", "
    var progressAction = $('#progress-action');
    //var progressComplete= $('#progress-complete');
    var popupError = $('#popup-error');
    var getProgressDetailsInterval 
    
    window.onload = function() {
        getProgressDetailsIntervalx();
    }


    function getProgressDetailsIntervalx() {
        getProgressDetailsInterval = setInterval(function() {
        getProgressDetails();
        }, 5000);
    }

    function getProgressDetails() {
        var btnPushVendorToLive = $('.display-push-vendor');
        var btnViewProducts = $('.display-view-products');
        var displayPushingProgress = $('.display-pushing-vendor');
        
        var listParsedItems = $('.parsed-items');

        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('product/getProgressDetails') ."',
            dataType: 'JSON',
            success: function(res) {
                //status in progress
                if (res.status == 1) {
                    progressAction.find('span').html(res.span_action + ' ' + res.item_done + '/' + res.item_count);
                    progressAction.find('.progress-bar').css('background-color', '#428bca');
                    progressAction.show();
                    progressAction.removeClass('hide');
                }
                //status completed
                if (res.status == 2) {
                    progressAction.find('.progress-bar').css('background-color', '#4BB543');
                    progressAction.find('span').html('Process Completed! Click Dismiss button to Dismiss!');
                    $('.btn-dismiss').removeClass('hide');
                }
                //status not running
                if (res.status == 0) {
                    progressAction.find('.progress-bar').css('background-color', '#428bca');
                    clearInterval(getProgressDetailsInterval);
                }

                //status error
                if(res.status == 3){
                    progressAction.find('.progress-bar').css('background-color', '#428bca');
                    progressAction.hide();
                    clearInterval(getProgressDetailsInterval);
                }

                console.log(listParsedItems.length);
            },
            error: function(res) {
                console.log(res);
                //alert('something went wrong!!');
            }
        });
    }

    $('body').on('click', '.btn-dismiss', function(e){
        e.preventDefault();

        $.ajax({
                url: '" . Yii::app()->createAbsoluteUrl('Product/dismissAction') . "',
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    $.fn.yiiListView.update('list-vendor-product');
                    progressAction.find('.progress-bar').css('background-color', '#428bca');
                    progressAction.hide();
                    progressAction.addClass('hide');
                    $('.btn-options button').html(btnPriceOptionsButtonDefault)
                    $('.btn-options button').attr('disabled', false);
                    $('.btn-options').css('display', 'none');
                    $('.list-vendor-product').find('input[type=checkbox]').attr('checked', false);
                    $('.checkbox-review-data').prop('checked', false);
                    clearInterval(getProgressDetailsInterval);
                    $('.btn-dismiss').addClass('hide');
                },
                error: function(res) {
                    console.log(res);
                    alert('Something went wrong.');
                },
            });
    });

");

$clientScript->registerScript("list-item-report", "

$('body').on('click', '.btn-item-report', function(e) {
    e.preventDefault();

    var self = $(this);
    var popupItemReport = $('#popup-item-report');
    
    popupItemReport.find('.alert').html(self.attr('data-report'));
    popupItemReport.modal('show');
});

");

$clientScript->registerScript("republish-n-delete-parsed-data", "
    var btnDeleteDataMultiple = $('.btn-delete-data-multiple');
    var btnDeleteDataMultipleDefaultText = btnDeleteDataMultiple.html();
    var btnRepublishSelectedItems = $('.btn-republish-selected-items');
    var btnOptions = $('.btn-options');
     
    $('body').on('click', '.select-all-review-data', function() {
        if ($(this).is(':checked')) {
            $('.checkbox-review-data').prop('checked', true);
            btnDeleteDataMultiple.show();
            btnRepublishSelectedItems.show();
            btnOptions.show().css('display', 'inline');
        } else {
            $('.checkbox-review-data').prop('checked', false);
            //btnDeleteDataMultiple.hide();
            //btnRepublishSelectedItems.hide();
            btnOptions.show().css('display', 'none');
        }
    });

    $('body').on('click', '.checkbox-review-data', function() {
        if ($('.checkbox-review-data').is(':checked')) {
           // btnDeleteDataMultiple.show();
            btnRepublishSelectedItems.show();
            btnOptions.show().css('display', 'inline');
        } else {
            //btnDeleteDataMultiple.hide();
           // btnRepublishSelectedItems.hide();
            btnOptions.show().css('display', 'none');
        }
    });
    
    $('body').on('click', '.btn-delete-data-multiple', function() {
        var formVendor = $('form#form-product-vendor');

        if (confirm('Are you sure you want to delete selected data?')) {

            $.ajax({
                url: '" . Yii::app()->createAbsoluteUrl('Product/DeleteData') . "',
                data: formVendor.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    //btnDeleteDataMultiple.hide();
                    getProgressDetailsIntervalx();
                     //btnOptionsButton.parent().hide();

                    //$.fn.yiiListView.update('list-vendor-product');

                    /*bootbox.alert({
                        size: 'medium',
                        message: res.message
                    });*/
                },
                error: function(res) {
                    console.log(res);
                    alert('Something went wrong.');
                }, 
                // beforeSend: function() {
                //     btnDeleteDataMultiple.attr('disabled', true);
                //     btnDeleteDataMultiple.html('Deleting...');
                // },
                // complete: function() {
                //     btnDeleteDataMultiple.attr('disabled', false);
                //     btnDeleteDataMultiple.html(btnDeleteDataMultipleDefaultText);
                // }
                beforeSend: function() {
                    btnOptionsButton.html('Deleting Item(s)... Please Wait...');
                    btnOptionsButton.attr('disabled', true);
                },
                /*complete: function() {
                    btnOptionsButton.html(btnPriceOptionsButtonDefault);
                    btnOptionsButton.attr('disabled', false);
                }*/
            });
        }
    });


    $('body').on('click', '.btn-republish-selected-items', function() {
        var formVendor = $('form#form-product-vendor');

        var self = $(this);
        var btnRepublishSelectedItemsDefaultText = btnRepublishSelectedItems.html();

        if (confirm('Are you sure you want to Re-Publish selected data?')) {

            $.ajax({
                url: '" . Yii::app()->createAbsoluteUrl('Product/RePublish') . "',
                data: formVendor.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    //btnOptionsButton.parent().hide();
                    getProgressDetailsIntervalx();
                    //$.fn.yiiListView.update('list-vendor-product');

                    /*bootbox.alert({
                        size: 'medium',
                        message: res.message
                    });*/
                },
                error: function(res) {
                    console.log(res);
                    alert('Something went wrong.');
                },
                beforeSend: function() {
                    btnOptionsButton.html('Republishing Item(s)... Please Wait...');
                    btnOptionsButton.attr('disabled', true);
                },
                /*complete: function() {
                    btnOptionsButton.html(btnPriceOptionsButtonDefault);
                    btnOptionsButton.attr('disabled', false);
                }*/
            });
        }
    });

    $('body').on('click', '.btn-overwrite-selected-items', function() {
        var formVendor = $('form#form-product-vendor');

        var self = $(this);
        // var btnRepublishSelectedItemsDefaultText = btnRepublishSelectedItems.html();

        if (confirm('Are you sure you want to Overwrite selected data?')) {

            $.ajax({
                url: '" . Yii::app()->createAbsoluteUrl('Product/Overwrite') . "',
                data: formVendor.serialize(),
                method: 'POST',
                success: function(res) {
                    //btnOptionsButton.parent().hide();
                    
                    //$.fn.yiiListView.update('list-vendor-product');
                    getProgressDetailsIntervalx();
                    /*bootbox.alert({
                        size: 'medium',
                        message: 'Product/s has been successfully overwritten.'
                    });*/
                },
                error: function(res) {
                    console.log(res);
                    alert('Something went wrong.');
                },
                beforeSend: function() {
                    btnOptionsButton.html('Overwriting Item(s)... Please Wait...');
                    btnOptionsButton.attr('disabled', true);
                },
                /*complete: function() {
                    btnOptionsButton.html(btnPriceOptionsButtonDefault);
                    btnOptionsButton.attr('disabled', false);
                }*/
            });
        }
    });

");

$clientScript->registerScript("edit-product-data", "

    var formEditProductData = $('form#edit-product-data');
    var alertEditParsedData = formEditProductData.find('.alert');

    $('body').on('click', '.btn-edit-product-data', function(e) {
        e.preventDefault();

        var self = $(this);

        alertEditParsedData.removeClass('alert-success');
        alertEditParsedData.removeClass('alert-danger');
        alertEditParsedData.hide();

        $('#popup-edit-product-data').modal('show');
    
        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/getPublisedData') . "',
            data: {id: self.attr('data-id')},
            dataType: 'JSON',
            success: function(res) {
                formEditProductData.find('input[name=\"ProductInfo[product_id]\"]').val(res.product_id);
                
                formEditProductData.find('input[name=\"ProductInfo[brand_name]\"]').val(res.brand_name);
                formEditProductData.find('input[name=\"ProductInfo[mpn]\"]').val(res.mpn);
                formEditProductData.find('input[name=\"ProductInfo[sbb_price]\"]').val(res.price);

                formEditProductData.find('input[name=\"ProductInfo[cost]\"]').val(res.cost);
                formEditProductData.find('input[name=\"ProductInfo[msrp]\"]').val(res.msrp);
                formEditProductData.find('input[name=\"ProductInfo[sku]\"]').val(res.sku);

                formEditProductData.find('input[name=\"ProductInfo[ean]\"]').val(res.ean);
                formEditProductData.find('input[name=\"ProductInfo[weight]\"]').val(res.weight);
                formEditProductData.find('input[name=\"ProductInfo[width]\"]').val(res.width);

                formEditProductData.find('input[name=\"ProductInfo[length]\"]').val(res.length);
                formEditProductData.find('input[name=\"ProductInfo[height]\"]').val(res.height);
                formEditProductData.find('input[name=\"ProductInfo[quantity]\"]').val(res.quantity);

                formEditProductData.find('textarea[name=\"ProductInfo[description]\"]').val(res.description);

                formEditProductData.find('select[name=\"Product[status]\"]').val(res.status);
            },
            error: function(res) {
                console.log(res);
                alert('Something went wrong!!');
            }
        });
    });

    formEditProductData.submit(function(e) {
        e.preventDefault();

        var self = $(this);

        var btnSubmit = self.find('button[type=submit]');
        var btnSubmitDefaultText = btnSubmit.text();

        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('Product/EditData') . "',
            data: self.serialize(),
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                if (res.status == 'ok') {
                    alertEditParsedData.addClass('alert-success');
                    $.fn.yiiListView.update('list-vendor-product');
                } else {
                    alertEditParsedData.addClass('alert-danger');
                }

                alertEditParsedData.html('<p>'+ res.message +'</p>');
                alertEditParsedData.show();
            },
            error: function(res) {
                console.log(res);
            },
            beforeSend: function() {
                alertEditParsedData.removeClass('alert-success');
                alertEditParsedData.removeClass('alert-danger');
                alertEditParsedData.hide();

                btnSubmit.prop('disabled', true);
                btnSubmit.text('Saving and Publishing Changes....');
            }, 
            complete: function() {
                btnSubmit.prop('disabled', false);
                btnSubmit.text(btnSubmitDefaultText);
            }
        });
    });

");

$clientScript->registerScript("review-list", "
    $('.btn-refresh-list').click(function(e){
        e.preventDefault();

        var self = $(this);
        var defaultText = self.html();

        self.html('Re-loading...');

        $.fn.yiiListView.update('list-vendor-product', {
            complete: function() {
                self.html(defaultText);
            }
        });
    });
");

$clientScript->registerScript("product-details", "

    var btnProductDetails = $('.btn-product-details');
    var popupProductDetails = $('#popup-product-details');
    var containerFilterOptions = $('.container-filter-options');

    btnProductDetails.click(function() {
        popupProductDetails.modal('show');

        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('Product/GetDetails') . "',
            data: $('input[name=product_ids]').serialize(),
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                containerFilterOptions.html('');

                var filterOptions = $('body').find('.filter-options');

                filterOptions.each(function(i, e) {
                    containerFilterOptions.append('<span class=\"label label-default\" style=\"font-size: 13px; margin-bottom: 3px;\">(' + $(e).html() + ')</span> ');
                });

                if (filterOptions.length > 0) {
                    containerFilterOptions.append('<hr>');
                }

                $('.data-published-files-html').html(res.published_files_html);

                $('.data-published-total').html(res.published_total);

                $('.data-published-website-count-" . Product::WEBSITE_WOO_COMMERCE . "').html(res.pubished_websites_count[" . Product::WEBSITE_WOO_COMMERCE . "]);
                $('.data-published-website-count-" . Product::WEBSITE_GOOGLE_MERCHANT . "').html(res.pubished_websites_count[" . Product::WEBSITE_GOOGLE_MERCHANT . "]);
                $('.data-published-website-count-" . Product::WEBSITE_GSS . "').html(res.pubished_websites_count[" . Product::WEBSITE_GSS . "]);

                $('.data-published-vendors-count-" . Vendor::INDEX_GEO_VISION . "').html(res.pubished_vendors_count[" . Vendor::INDEX_GEO_VISION . "]);
                $('.data-published-vendors-count-" . Vendor::INDEX_MOTOBIX . "').html(res.pubished_vendors_count[" . Vendor::INDEX_MOTOBIX . "]);
                $('.data-published-vendors-count-" . Vendor::INDEX_FLIR . "').html(res.pubished_vendors_count[" . Vendor::INDEX_FLIR . "]);
                $('.data-published-vendors-count-" . Vendor::INDEX_ACTI . "').html(res.pubished_vendors_count[" . Vendor::INDEX_ACTI . "]);

                $('.data-published-status-count-" . Product::STATUS_ACTIVE . "').html(res.published_status_count[" . Product::STATUS_ACTIVE . "]);
                $('.data-published-status-count-" . Product::STATUS_ERROR . "').html(res.published_status_count[" . Product::STATUS_ERROR . "]);
            },
            error: function(res) {
                alert('something went wrong.');
            }
        });
    });

");

$clientScript->registerScript("options", "

var btnOptionsButton = $('.btn-options button'); 
var btnPriceOptionsButtonDefault = btnOptionsButton.html();

$('body').on('click', '.btn-options-lock-pricing', function() {
    var formVendor = $('form#form-product-vendor');

    if (confirm('Are you sure you want to lock the pricing of the selected data?')) {
        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/lockPricing') . "',
            data: formVendor.serialize(),
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                bootbox.alert({
                    size: 'medium',
                    message: res.message
                });

                btnOptionsButton.parent().hide();
                
                $.fn.yiiListView.update('list-vendor-product');
            },
            error: function(res) {
                alert(res);
            },
            beforeSend: function() {
                btnOptionsButton.html('Locking Item(s) MPN Pricing... Please Wait...');
                btnOptionsButton.attr('disabled', true);
            },
            complete: function() {
                btnOptionsButton.html(btnPriceOptionsButtonDefault);
                btnOptionsButton.attr('disabled', false);
            }
        });
    }
});

$('body').on('click', '.btn-options-unlock-pricing', function(e) {
    e.preventDefault();

    var formVendor = $('form#form-product-vendor');

    if (confirm('Are you sure you want to unlock the pricing of the selected data?')) {
        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/unlockPricing') . "',
            data: formVendor.serialize(),
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                bootbox.alert({
                    size: 'medium',
                    message: res.message
                });

                btnOptionsButton.parent().hide();
                
                $.fn.yiiListView.update('list-vendor-product');
            },
            error: function(res) {
                alert(res);
            },
            beforeSend: function() {
                btnOptionsButton.html('Un-locking Item(s) MPN Pricing... Please Wait...');
                btnOptionsButton.attr('disabled', true);
            },
            complete: function() {
                btnOptionsButton.html(btnPriceOptionsButtonDefault);
                btnOptionsButton.attr('disabled', false);
            }
        });
    }
});

$('body').on('click', '.btn-set-product-status', function() {
    var self = $(this);
    var btnOptions = $('.btn-options button');
    var btnOptionsDefault = btnOptions.html();  
    var formVendor = $('form#form-product-vendor');
    var productStatusId = self.attr('data-product-status');
    var productStatusText = self.text();
    var btnPriceOption = $('.btn-options');
    var listVendorProduct = $('.list-vendor-product');

    if (confirm('Are you sure you want to '+ productStatusText +'?')) {
        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/setProductsStatus') . "',
            data: formVendor.serialize() + '&product_status_id=' + productStatusId,
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                //btnPriceOption.hide();
                getProgressDetailsIntervalx();
                //$.fn.yiiListView.update('list-vendor-product');

                /*bootbox.alert({
                    message: res.message
                });*/
            },
            error: function(res) {
                alert(res);
            },
            beforeSend: function() {
                btnOptions.attr('disabled', true);
                btnOptions.html('Setting product status... Please wait...');
            },
            /*complete: function() {
                btnOptions.attr('disabled', false);
                btnOptions.html(btnOptionsDefault);

                listVendorProduct.find('input[type=checkbox]').attr('checked', false);
            }*/
        });
    }
});

");

$clientScript->registerScript("price-setting-gssx", "

var btnGssPriceSetting = $('.btn-gss-price-setting'); 
var popupGssPriceSetting = $('#popup-gss-price-setting');
var formGssPriceSetting = $('#form-gss-price-setting');
var dropdownGssPriceSetting = formGssPriceSetting.find('select#pricing_group_id');
var dropdownPriceTypeGssPriceSetting = formGssPriceSetting.find('select#pricing_type');
var containerPriceTierGssPriceSetting = popupGssPriceSetting.find('.container-price-tier-gss-price-setting'); 
var containerEmptyPriceTierGssPriceSetting = popupGssPriceSetting.find('.container-empty-price-tier-gss-price-setting'); 
var alertGssPriceSetting = popupGssPriceSetting.find('.alert-gss-price-setting');
var autoSelectPricingGroupIdGssPriceSetting = '" . (isset($priceSettingDefaultGss['pricing_group_id']) ? $priceSettingDefaultGss['pricing_group_id'] : '') . "';
var autoSelectPricingTypeGssPriceSetting = '" . (isset($priceSettingDefaultGss['pricing_type']) ? $priceSettingDefaultGss['pricing_type'] : '') . "';

btnGssPriceSetting.click(function(e) {
    e.preventDefault();

    alertGssPriceSetting.removeClass('alert-danger alert-success');
    alertGssPriceSetting.html('');
    alertGssPriceSetting.hide();

    popupGssPriceSetting.modal('show');
});

dropdownGssPriceSetting.change(function() {
    if ($(this).val() != '') {
        getPricingGroupPricingTier($(this).val());
        dropdownPriceTypeGssPriceSetting.attr('disabled', false);
    } else {
        containerPriceTierGssPriceSetting.hide();
        dropdownPriceTypeGssPriceSetting.attr('disabled', true);
    }
});

formGssPriceSetting.submit(function(e) {
    e.preventDefault();

    var submitFormButton = formGssPriceSetting.find('button.btn-primary');
    var submitFormButtonOriginalState = submitFormButton.text();

    $.ajax({
        url: '" . Yii::app()->createAbsoluteUrl('product/createUpdatePriceSettingGss') . "',
        data: $('#form-product-vendor, #form-gss-price-setting').serialize(),
        method: 'POST',
        dataType: 'JSON',
        success: function(res) {
            console.log(res);
            if (res.status == 'ok') {
                popupGssPriceSetting.modal('hide');
                
                bootbox.alert({
                    message: res.message
                });

                $.fn.yiiListView.update('list-vendor-product');
            } else {
                bootbox.alert({
                    message: res.message
                });
            }
        },
        beforeSend: function() {
            submitFormButton.text('Applying... Please wait...');
            submitFormButton.attr('disabled', true);

            alertGssPriceSetting.removeClass('alert-danger alert-success');
            alertGssPriceSetting.html('');
            alertGssPriceSetting.hide();
        },
        complete: function() {
            submitFormButton.text(submitFormButtonOriginalState);
            submitFormButton.attr('disabled', false);
            $('.btn-options').hide();
        },
        error: function(res) {
            console.log(res);
            alertGssPriceSetting.addClass('alert-danger');
            alertGssPriceSetting.html('Something went wrong with the request.');
            alertGssPriceSetting.fadeIn();
        }
    });
});

function getPricingGroupPricingTier(pricingGroupId, pricingType) {
    var pringGroupId = parseInt(pricingGroupId);
    var pricingType = (typeof pricingType != 'undefined') ? parseInt(pricingType) : '';

    containerEmptyPriceTierGssPriceSetting.hide();
    containerPriceTierGssPriceSetting.hide();

    if (pringGroupId == '') {
        containerEmptyPriceTierGssPriceSetting.fadeIn();
        containerPriceTierGssPriceSetting.hide();
        return;
    }

    $.ajax({
        url: '" . Yii::app()->createAbsoluteUrl('pricingGroup/getPricingGroupPricingTier') . "',
        data: {id: pringGroupId},
        success: function(res) {
            containerPriceTierGssPriceSetting.html(res);
            containerPriceTierGssPriceSetting.fadeIn();

            if (pricingType != '') {
                formGssPriceSetting.find('#pricing_type').val(pricingType);
            }
        }, 
        error: function(e) {
            alert('Invalid Request');
        }
    });
}

$('body').on('mouseenter', '.show-product-pricing-gss', function() {
    var self = $(this);
    var productId = self.attr('data-product-id');
    var popover = self.next('.popover');
    var popoverContent = popover.find('.popover-content');

    $.ajax({
        url: '" . Yii::app()->createAbsoluteUrl('product/getProductDataGssPricing') . "',
        data: {productId: productId},
        success: function(res) {
            popoverContent.html(res);
        },
        error: function(res) {
            console.log(res);
            popoverContent.html('Something went wrong.');
        },
        beforeSend: function() {
            popoverContent.html('<em>Retrieving product pricing... Please wait...</em>');
        }
    });
});

");

$clientScript->registerScript("sbb0price-settings", "
    var btnParsedSettings = $('.btn-sbb-price-setting');
    var popupParsedSettings = $('#popup-parsed-settings');
    var alertParsedSettings = popupParsedSettings.find('.alert');

    btnParsedSettings.click(function(e) {
        e.preventDefault();

        alertParsedSettings.hide();
        alertParsedSettings.removeClass('alert-success');
        alertParsedSettings.removeClass('alert-danger');
        alertParsedSettings.html('');

        popupParsedSettings.modal('show');
    });

    var baseOnColumn = parseInt('" . SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN . "');
    var baseOnCost = parseInt('" . SettingSalesPrice::SALES_PRICE_SETTING_COST . "');
    var baseOnMSRP = parseInt('" . SettingSalesPrice::SALES_PRICE_SETTING_MSRP . "');
    var containerSalesPriceSettingBased = $('#container-sales-price-setting-based');
    var baseCostMarkupContainer  = $('.base-cost-markup-container');
    var baseMsrpMarkupContainer  = $('.base-msrp-markup-container');
    
    var inputPriceSettingColumnName = $('input[name=\"price_setting[column_name]\"]');

    $('select[name=\"price_setting[type]\"]').change(function() {
        var self = $(this);
        var value = self.val();

        if (value == baseOnColumn) {
            containerSalesPriceSettingBased.hide();
            inputPriceSettingColumnName.removeAttr('disabled');
        } else if (value == baseOnCost || value == baseOnMSRP) {
            containerSalesPriceSettingBased.show();
            inputPriceSettingColumnName.attr('disabled', true);
        
            if (value == baseOnCost) {
                baseCostMarkupContainer.show();
                baseMsrpMarkupContainer.hide();
            } else if (value == baseOnMSRP) {
                baseCostMarkupContainer.hide();
                baseMsrpMarkupContainer.show();
            }

        }
    });

    $('body').on('submit', 'form#price-settings', function(e) {
        e.preventDefault();
        
        var self = $(this);

        var submitBtn = self.find('button[type=submit]');
        var submitBtnDefaultText = submitBtn.html();

        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/updatePriceSetting') . "',
            data: $('#price-settings, #form-product-vendor').serialize(),
            dataType: 'JSON',
            type: 'POST',
            success: function(res) {
                if (res.status == 'ok') {
                    /*alertParsedSettings.addClass('alert-success');
                    alertParsedSettings.html('<p>'+ res.message +'</p>');
                    alertParsedSettings.fadeIn();*/
                    getProgressDetailsIntervalx();
                    //$.fn.yiiListView.update('list-vendor-product');
                } else {
                    alertParsedSettings.addClass('alert-danger');
                    alertParsedSettings.html('<p>'+ res.message +'</p>');
                    alertParsedSettings.fadeIn();
                }
            },
            error: function(res) {
                console.log(res);
                alert('Something went wrong');
            },
            beforeSend: function() {
                alertParsedSettings.hide();
                alertParsedSettings.removeClass('alert-success');
                alertParsedSettings.removeClass('alert-danger');
                alertParsedSettings.html('');
 
                submitBtn.prop('disabled', true);
                submitBtn.html('Applying...')
            },
            /*complete: function() {
                submitBtn.prop('disabled', false);
                submitBtn.html(submitBtnDefaultText)

                console.log(submitBtn);
            }*/
        });
    });

");


$clientScript->registerScript("options-script", "

    $('.btn-sync-googler-merchant-products-image').click(function(e) {
        e.preventDefault();

        var formVendor = $('form#form-product-vendor');
        var btnOptions = $('.btn-options button');
        var btnOptionsDefault = btnOptions.html(); 
        var btnOptionsParent = $('.btn-options');

        $.ajax({
            url: '" . Yii::app()->createAbsoluteUrl('product/syncGoogleMerchantProductsImage') . "',
            method: 'POST', 
            data: formVendor.serialize(),
            dataType: 'JSON',
            success: function(res) {
                //btnOptionsParent.hide();
                getProgressDetailsIntervalx();
                /*bootbox.alert({
                    message: res.message
                });*/

                /*btnOptions.attr('disabled', false);
                btnOptions.html(btnOptionsDefault);*/

                //$('.select-all-review-data').prop('checked', false)
                //$('.checkbox-review-data').prop('checked', false);
            },
            error: function() {
                console.log('error');
            },
            beforeSend: function() {
                btnOptions.attr('disabled', true);
                btnOptions.html('Syncing google merchant product image... Please wait...');
            }
        });
    });

");

$clientScript->registerScript("view-action-logs", "
console.log('test')
    $('.btn-action-logs').click(function(){
        console.log('test1')
        $('#view-action-logs').modal('show');
    });
");
?>