<h1 class="page-header"><?php echo $this->pageTitle; ?></h1>

<div class="row">
  <div class="col-md-8">
    <div class="col-md-12">
      <?php $this->widget('Flash', array('flashes' => Yii::app()->user->getFlashes())); ?>
    </div>
    <?php echo CHtml::beginForm('', 'POST'); ?>
    <div class="col-md-6">
      <div class="form-group">
        <?php echo CHtml::activeLabel($pricingGroup, 'group_name'); ?>
        <?php echo CHtml::activeTextField($pricingGroup, 'group_name', ['class' => 'form-control', 'placeholder' => 'Group Name']); ?>
      </div>
    </div>
    <div class="col-md-12">
        <button class="btn btn-primary btn-sm pull-right addTier" type="button">Add Price Tier</button>
    </div>
    <?php echo $this->renderPartial('_priceTierForm', array(
      'vendors' => $vendors, 
      'pricingGroup' => $pricingGroup,
      'pricingTiers' => $pricingTiers,
      'pricingTierDescriptions' => $pricingTierDescriptions,
      'action' => $action,
    )); 
    ?>
    <div class="form-group col-md-12">
      <hr style="width: 100%; border: solid 1px black;">
      <?php echo CHtml::submitButton($pricingGroup->isNewRecord ? 'Create' : 'Save', ['class' => 'btn btn-primary pull-right']); ?>
      <button class="btn btn-primary pull-right addTier" type="button" style="margin-right: 10px;">Add Price Tier</button>
      <?php echo CHtml::link('Cancel', Yii::app()->createUrl('pricingGroup'), [
            'title' => 'Pricing Group',
            'class' => 'btn btn-default pull-right',
            'style' => 'margin-right:10px;'
            ]); ?>
    </div>
    <?php echo CHtml::endForm(); ?>
  </div>
</div>
  <!-- modal of custom pricing role -->
<div class="modal fade" id="customPricingRole" tabindex="-1" role="dialog" aria-labelledby="customPricingRole" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Create Custom Price Role</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">      
          <form>
            <div class="col-md-12 error">

            </div>  
            <div class="col-md-6">
              <div class="form-group" style="position: relative;">
                <label>Pricing Role Key<span class="text-danger">*</span></label>               <span style="font-size: 12px; color: gray;"><small>e.g. : bronze-member</small></span>
                <input class="form-control" type="text" name="pricingRoleKey" id="roleKey" placeholder="Pricing Role Key">
                <div class="valid-feedback feedback-icon">
                    <i class="fa fa-check"></i>
                </div>
                <div class="invalid-feedback feedback-icon">
                    <i class="fa fa-times"></i>
                </div>
                <div class="invalid-feedback" id="roleKeyFeedback">
                  <!-- Role key already exist, please change it! -->
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group " style="position: relative;">
                <label>Pricing Role Name<span class="text-danger">*</span></label>
                <input class="form-control" type="text" name="pricingRoleName" id="roleName" placeholder="Pricing Role Name" required>
                <div class="valid-feedback feedback-icon">
                    <i class="fa fa-check"></i>
                </div>
                <div class="invalid-feedback feedback-icon">
                    <i class="fa fa-times"></i>
                </div>
                <div class="invalid-feedback" id="roleNameFeedback">
                  Role name cannot be empty!
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <input type="hidden" name="tier" value="">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
              <button type="button" class="btn btn-primary" id="btnValidateRole">Validate</button>
              <button type="button" class="btn btn-primary hide" id="btnSaveRole">Save</button>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>
