<h1 class="page-header"><?php echo $this->pageTitle; ?></h1>
<div class="row" style="margin-bottom: 10px;">
  <div class="col-md-12">
    <?php $this->widget('Flash', array('flashes' => Yii::app()->user->getFlashes())); ?>
  </div>
  <div class="col-md-6">
    <?php echo CHtml::link('<span class="glyphicon glyphicon-plus"></span> Create Pricing Group', ['pricingGroup/create'], [
      'class' => 'btn btn-primary btn-sm text-center pull-right', 
      'title' => 'Create Account Group',
      'style' => 'margin-bottom: 10px;'
    ]); ?>


<?php

$this->widget('zii.widgets.CListView', array(
  'dataProvider' => $pricingGroupDataProvider,
  'itemView' => '_priceGroupListing',
  'template' => '     
      <div class="table-responsive">
        <table class="table table-condensed table-striped table-hover header-fixed" style="margin: 0;">
          <thead>
            <tr class="active">
              <th>Group Name</th>
              <th class="text-center">No. of Tiers</th>
              <th class="text-center">Status</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>
          <tbody>
            {items}
          </tbody>
        </table>
      </div>
    {pager}
  ',
  'emptyText' => '<tr><td colspan="16" class="text-center">No data available.</td></tr>',
  'pager' => array(
    'cssFile' => false,
    'header' => false,
    'firstPageLabel' => '&lt;&lt;',
    'prevPageLabel' => '&lt;',
    'nextPageLabel' => '&gt;',
    'lastPageLabel' => '&gt;&gt;'
  ),
));

$clientScript = Yii::app()->clientScript;
$clientScript->registerCss("list_style", "

  .list-view table thead th, table tbody td {
      white-space: nowrap;
      padding-left: 5px !important;
      padding-right: 20px !important;
  }

  .list-view table thead th.default-padding, table tbody td.default-padding {
      padding-left: 5px !important;
      padding-right: 5px !important;
  }

  .list-view table tbody td {
      font-size: 13px;
  }


  /* make this code global */
  ul.yiiPager {
      padding-left: 0px !important;
      margin-bottom: 0px !important;
  }

  ul.yiiPager .previous {
      float: left !important;
  }

  .list-view div.summary, .list-view .pager {
      text-align: center !important;
  }

  .pager li > a, .pager li > span {
      padding: 0px 15px !important;
      border-radius: initial;
  }

  .list-view  .label {
      font-size: 11px;
  }

  .progress-bar {
      padding: 6px;   
  }

  .progress-bar {
      font-size: 14px;
  }

  .pager .next > a, .pager .next > span {
      float: none;
  }

  ul.yiiPager .previous {
      float: none !important;
  }

  .pager .previous > a, .pager .previous > span {
      float: none;
  }

  .swal-title{
    font-size:17px;
  }

  .swal-text{
    font-size:12px;
    text-align: center;
  }

  .swal-modal{
    height: 280px;
    width: 300px;
  }

  .swal-icon{
    padding:0;
    margin-bottom: 0;
    margin-top: 0;
  }  

  .swal-icon--warning{
    width:50px;
    height:50px;
  }

  .swal-icon--warning > [class*='swal-icon--']{
    margin-top: 0;
    width:5px;
    height:22px;
  }

");
$clientScript->registerScriptFile(Yii::app()->request->baseUrl.'/js/plugins/sweetalert/sweetalert.min.js', 0);
$clientScript->registerScript('script', '
  $(".confirmation").on("click", function(e){
    e.preventDefault();
    var link = $(this).attr("href");
    var action = $(this).attr("data-action");

    swal({
        icon: "warning",
        title: "Are you sure you want to "+action+" this pricing group?",
        text: "You will not be able to undo this once you confirmed!",
        buttons: {
          cancel: {
            text: "Cancel",
            value: null,
            visible: true,
            className: "btn btn-default",
            closeModal: true,
          },
          confirm: {
            text: "Confirm",
            value: true,
            visible: true,
            className: "btn btn-info",
            closeModal: true
          },
        },
      }).then((isConfirm) => {
          if(isConfirm){
            window.location.href = link;
          }
      });
  })
');

?>
</div>