<div class="col-md-6 item-container">
    <div class="dropdown pull-right" style="margin-top: 10px;">
        <a class="btn btn-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown">Action <span class="caret"></span></a>
        <ul class="dropdown-menu text-left">
          <li><?php echo CHtml::link('<span class="glyphicon glyphicon-edit fa-fw"></span> Update Details', ['pricingGroup/tier/action/update/id/' . $data->id], ['title' => 'Update Details']); ?></li>
          <?php if ($parentGroupStatus == PricingGroup::STATUS_ACTIVE) { ?>
          <?php if ($data->status == PricingTier::STATUS_ACTIVE) { ?>
            <li><?php echo CHtml::link('<span class="glyphicon glyphicon-off fa-fw"></span> Deactivate', Yii::app()->createUrl('pricingGroup/deactivateTier', array('id' => $data->id)), [
              'title' => 'Deactivate',
              'class' => 'confirmation',
              'data-action' => 'deactivate',
              ]); ?></li>
          <?php } else { ?>
            <li><?php echo CHtml::link('<span class="glyphicon glyphicon-off fa-fw"></span> Activate', Yii::app()->createUrl('pricingGroup/activateTier', array('id' => $data->id)), ['title' => 'Activate']); ?></li>
          <?php } ?>
        <?php } ?>
        <li role="separator" class="divider"></li>
        <li><?php echo CHtml::link('<span class="glyphicon glyphicon-trash fa-fw"></span> Delete', Yii::app()->createUrl('pricingGroup/deleteTier', array('id' => $data->id)), [
          'title' => 'Delete',
          'class' => 'confirmation',
          'data-action' => 'deactivate',
        ]); ?></li>
      </ul>
    </div>
    <h4><?php echo $data->tier_name; ?>&nbsp;<?php echo PricingTierDescription::model()->getStatusLabelWithColor($data->status); ?></h4>
    <!-- </div> -->
  <div class="table-responsive">
    <table class="table table-condensed table-hover" width="100%">
      <thead>
        <tr class="active">
          <th width="15%">Vendor</th>
          <th class="text-center">Cost Markup</th>
          <th class="text-center">MSRP Markdown</th>
          <th class="text-center">Pricing Type</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($data->pricingTier() as $pricingTier): ?>
          <tr>
            <td><?php echo $pricingTier->vendor()->name ?></td>
            <td class="text-center"><?php echo $pricingTier->cost_markup . "%"; ?></td>
            <td class="text-center"><?php echo $pricingTier->msrp_markdown . "%"; ?></td>
            <td class="text-center"><?php echo PricingTier::model()->getPriceTypeLabel($pricingTier->default_type); ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="tier-footer">
    <div class="tier-description">
      <label>Description:</label>
      <p style="word-break: wrap;"><?php echo $data->description ?: 'No Description'; ?></p>
    </div>
    <?php if(!empty($data->pricing_tier_wp_role_id)): ?>
    <div class="tier-role">
      <label>Woocommerce Pricing Role</label>
      <p><?php echo $data->pricingTierWpRole->label; ?></p>
    </div>
    <?php endif; ?>
  </div>
</div>