<div class="col-md-12" id="tierList">
  <?php
    $count = 0;
    $removeBtnClass = (count($pricingTierDescriptions) == 1 ? 'hide' : '');
    //do while for pricingtierdescription still produce one form even if its new record
    do{
      $desc_id = ($action == 'update' ? (isset($pricingTierDescriptions[$count]) ? $pricingTierDescriptions[$count]->id : $pricingTierDescriptions->id ) : '');
  ?>
  <div class="price-tier-content" id="tier<?php echo $count+1; ?>">
    <hr width="100%" style="border: solid 1px black;">
    <div class="row">
      <div class="col-md-12">
        <div class="form-group">
          <label>Tier Name</label>
          <?php echo CHtml::textField('tierName['.$desc_id.']', 
            ($action == 'update' ? (isset($pricingTierDescriptions[$count]) ? $pricingTierDescriptions[$count]->tier_name : $pricingTierDescriptions->tier_name ) : ''), 
            array(
                'class' => 'form-control',
                'placeholder' => 'Tier Name',
                'required' => 'required',
            )
          ); ?>
        </div>
      </div> 
    </div>
    <div class="row">
      <div class="col-md-12">
        <table class="table table-condensed table-bordered table-striped table-hover header-fixed table-list">
          <thead>
            <th width="30%">Vendor</th>
            <th>Cost Markup</th>
            <th>MSRP Markdown</th>
            <th>Price Type</th>
          </thead>
          <tbody>
            <?php 
              foreach ($vendors as $vendor):
            ?>
              <tr>
                <td><?php echo $vendor->name ?></td>
                <td>
                  <div class="input-group">
                    <?php echo CHtml::numberField(
                      'markUp['.$vendor->id.']['.$desc_id.']', 
                      ($action == 'update' ? (!empty($pricingTiers[$desc_id][$vendor->id]) ? $pricingTiers[$desc_id][$vendor->id]->cost_markup : '') : ''),
                      array(
                        'class' => 'form-control',
                        'placeholder' => '0',  
                        'min' => 0,
                        'max' => 100,  
                        )
                    ); ?>
                    <span class="input-group-addon">%</span>
                  </div>
                </td>
                <td>
                  <div class="input-group">
                    <?php echo CHtml::numberField(
                      'markDown['.$vendor->id.']['.$desc_id.']',
                      ($action == 'update' ? (!empty($pricingTiers[$desc_id][$vendor->id]) ? $pricingTiers[$desc_id][$vendor->id]->msrp_markdown : '') : ''), 
                      array(
                        'class' => 'form-control',
                        'placeholder' => '0',
                        'min' => 0,
                        'max' => 100,
                      )
                    ); ?>
                    <span class="input-group-addon">%</span>
                  </div>
                </td>
                <td>
                  <?php echo CHtml::dropDownList('priceType['.$vendor->id.']['.$desc_id.']',
                   ($action == 'update' ? (!empty($pricingTiers[$desc_id][$vendor->id]) ? $pricingTiers[$desc_id][$vendor->id]->default_type : '') : ''),
                   PricingTier::model()->getPricingType(),
                   array(
                      'class' => 'form-control',
                      'required' => 'required',
                      'empty' => 'Select Price Type',
                    )
                  ); ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6">
        <div class="form-group">
          <label>Description</label>
          <!-- <textarea class="form-control" name="description[]" placeholder="Description"></textarea> -->
          <?php echo CHtml::textArea('description['.$desc_id.']',
            ($action == 'update' ? (isset($pricingTierDescriptions[$count]) ? $pricingTierDescriptions[$count]->description : $pricingTierDescriptions->description ) : ''),
            array(
                'class' => 'form-control',
                'placeholder' => 'Tier Description',
            )
          ); ?>
        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <label>Woocommerce Price role&nbsp;</label>
          <?php
          $selectTier = $count+1;
          $pricingTierWpRoleId = ($action == 'update' ? (isset($pricingTierDescriptions[$count]) ? $pricingTierDescriptions[$count]->pricing_tier_wp_role_id : $pricingTierDescriptions->pricing_tier_wp_role_id ) : '');
          echo CHtml::dropDownList('wpRole['.$desc_id.']',
           $pricingTierWpRoleId, 
           PricingTierWpRole::model()->getActiveWpRole($pricingTierWpRoleId),
           array(
              'class' => 'form-control wp-role',
              'required' => 'required',
              'empty' => 'Select Pricing Role',
              'onchange' => 'customRole($(this), \'#tier'.$selectTier.'\')',
            )
          ); ?>
        </div>
      </div> 
    </div>
    <?php if($action == 'update'): ?>
    <!-- only show when form is update -->
    <div class="row">
      <div class="col-md-4">
        <div class="form-group">
          <label>Status</label>
          <!-- <textarea class="form-control" name="description[]" placeholder="Description"></textarea> -->
          <?php echo CHtml::dropDownList('tierStatus['.$desc_id.']',
             (isset($pricingTierDescriptions[$count]) ? $pricingTierDescriptions[$count]->status : $pricingTierDescriptions->status ),
             array(
                '1' => 'Activate',
                '2' => 'Deactivate',
             ),
             array(
                'class' => 'form-control',
                'required' => 'required',
                'empty' => 'Select Price Type',
              )
          ); ?>
        </div>
      </div>
    </div>
    <?php endif; ?>
    <div class="row">
      <div class="col-md-8 pull-right div-remove">
        <?php if($action != 'update'): ?>
          <button type="button" class="btn btn-danger btn-remove-tier pull-right <?php echo $removeBtnClass; ?>" onclick="removeTier('#tier<?php echo $count+1;?>')">Remove</button>
        <?php else: ?>
          <button type="button" class="btn btn-danger btn-delete-tier pull-right <?php echo $removeBtnClass; ?>" onclick="removeAjax('#tier<?php echo $count+1;?>', <?php echo $desc_id ?>)" data-count="<?php echo count($pricingTierDescriptions); ?>">Remove</button>
        <?php endif; ?>
      </div>
    </div>
  </div>
<?php 
  $count++;
}while($count<count($pricingTierDescriptions)); 

?>
</div>

<!-- push sweetalert js for confirmation -->
<?php Yii::app()->clientScript->registerScriptFile(Yii::app()->request->baseUrl.'/js/plugins/sweetalert/sweetalert.min.js', 0); 
 /*Push javascript to the lower of html body */
Yii::app()->clientScript->registerScript("form-script", 
  $this->renderPartial('_priceTierFormScript', 
  array(
  'vendors' => $vendors,
  'action' => $action,
  'pricingTierDescriptions' => $pricingTierDescriptions,
), true),
2);

Yii::app()->clientScript->registerCss("css", "
  .close{
    position: absolute;
    top: 0;
    right: 0;
    margin-right: 30px;
  }
  .modal-header .close{
    margin-top: 12px;
  }
  .swal-title{
    font-size:17px;
  }
  .swal-text{
    font-size:12px;
    text-align: center;
  }
  .swal-modal{
    height: 280px;
    width: 300px;
  }
  .swal-icon{
    padding:0;
    margin-bottom: 0;
    margin-top: 0;
  }  
  .swal-icon--warning{
    width:50px;
    height:50px;
  }
  .swal-icon--warning > [class*='swal-icon--']{
    margin-top: 0;
    width:5px;
    height:22px;
  }
");
?>