<?php
$this->pageTitle = 'Manage Contacts | '.Yii::app()->name;
$baseUrl = Yii::app()->request->baseUrl; 
Yii::app()->clientScript->registerScriptFile($baseUrl.'/js/bootbox.min.js');
Yii::app()->clientScript->registerScript('manageScript',"
	$('body').on('click', '.btn-delete', function(e){
		e.preventDefault();
		var thisButton = $(this);
		
		bootbox.confirm('Are you sure you want to delete this record?', function(result){
			if ( result )
			{
				window.location = thisButton.attr('href');
			}
		}); 
	});
");
?>

<h1 class="page-header">Mailer List</h1>

<?php $this->widget('Flash', array('flashes'=>Yii::app()->user->getFlashes(), 'hide'=>false)); ?>

<?php	echo CHtml::beginForm(array('mailer/index'),'get');  ?>
<div class="row">
	<div class="col-lg-6">
		<div class="input-group" style="padding-bottom:5px;">
			<span class="input-group-btn">
				<button class="btn btn-primary" type="submit"><i class="glyphicon glyphicon-search"></i></button>
			</span>
			<?php echo CHtml::textField('searchQuery',$searchQuery,array('class'=>'form-control','placeholder'=>'Search by subject or outbound name')); ?>
		</div><!-- /input-group -->
	</div><!-- /.col-lg-6 -->
	<div class="col-lg-6">
		<?php 
			if ( Yii::app()->user->account->account_type == Account::TYPE_ADMIN )
				echo CHtml::link('<span class="glyphicon glyphicon-plus"></span> New', array('/mailer/CreateEmailer'), array('class' => 'btn btn-sm btn-primary pull-right')) 
		?>
	</div><!-- /.col-lg-6 -->
</div><!-- /.row -->
<?php	echo CHtml::endForm(); ?>

<hr class="clear clearfix" style="margin-top:5px;" />

<div class="table-responsive">
	<?php 
	$this->widget('zii.widgets.CListView', array(
		'dataProvider' => $dataProvider,
		'itemsTagName' => 'table',
		'itemsCssClass' => 'table table-hover',
		'template' => ' {items} <br/> {pager}'   ,
		'itemView' => 'application.yii_app_emailer.yii_app_emailer_views.mailer._manage',
		'pager' => array(
			// 'class' => 'BootstrapLinkPager', 
			'cssFile' => false, 
			'header' => false, 
			'firstPageLabel' => '&lt;&lt;',
			'prevPageLabel' => '&lt;',
			'nextPageLabel' => '&gt;',
			'lastPageLabel' => '&gt;&gt;',
		),
	));
	?>
</div>