<?php

/**
 * This is the model class for table "{{vendor}}".
 *
 * The followings are the available columns in table '{{vendor}}':
 * @property integer $id
 * @property string $name
 * @property integer $status
 * @property string $date_created
 * @property string $date_updated
 *
 * The followings are the available model relations:
 * @property VendorFileuploadStatus[] $vendorFileuploadStatuses
 * @property VendorFileuploadStatusTmp[] $vendorFileuploadStatusTmps
 */
class Vendor extends CActiveRecord
{
    const STATUS_UPLOADING = 1;
    const STATUS_PARSING = 2;
    const STATUS_REVIEWING = 3;
    const STATUS_PUSHING = 4;
    const STATUS_PUSHED = 5;

    const INDEX_GEO_VISION = 1;
    const INDEX_MOTOBIX = 2;
    const INDEX_FLIR = 3;
    const INDEX_ACTI = 4;
    const INDEX_VIVOTEK = 5;
    const INDEX_AXIS = 6;
    const INDEX_BOSCH = 7;
    const INDEX_ISONAS = 8;
    const INDEX_QNAP = 9;
    const INDEX_RAYTEC = 10;
    const INDEX_ENTRUST_DATACARD = 11;
    const INDEX_AV_COSTAR = 12;
    const INDEX_LOCKNETICS = 13;
    const INDEX_DIGITAL_WATCHDOG = 14;
    const INDEX_SCHLAGE = 15;
    const INDEX_USA_VISION = 16;
    const INDEX_AXTON = 17;
    const INDEX_ABB = 18;

    const INDEX_GEO_VISION_START_ROW = 7;
    const INDEX_MOTOBIX_START_ROW = 2;
    const INDEX_FLIR_START_ROW = 6;
    const INDEX_ACTI_START_ROW = 7;

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{vendor}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('status', 'numerical', 'integerOnly'=>true),
            array('name', 'length', 'max'=>128),
            array('date_created, date_updated', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, status, date_created, date_updated', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'vendorFileuploadStatuses' => array(self::HAS_MANY, 'VendorFileuploadStatus', 'vendor_id'),
            'vendorFileuploadStatusTmps' => array(self::HAS_MANY, 'VendorFileuploadStatusTmp', 'vendor_id')
            ,
            'vendorFilePublished' => array(self::HAS_ONE, 'VendorFile', 'vendor_id', 'on' => 'status='.self::STATUS_PUSHED, 'order' => 'id desc'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'status' => 'Status',
            'date_created' => 'Date Created',
            'date_updated' => 'Date Updated',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('status', $this->status);
        $criteria->compare('date_created', $this->date_created, true);
        $criteria->compare('date_updated', $this->date_updated, true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Vendor the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public static function getListData()
    {
        $vendors = self::model()->findAll();
        return CHtml::listData($vendors, 'id', 'name');
    }

    public static function getName($id)
    {
        $vendorData = Vendor::model()->findByPk($id);

        if ($vendorData) {
            return $vendorData->name;
        } else {
            return '';
        }
    }

    public static function getVendorNameLabel($index)
    {
        $list = [
            self::INDEX_GEO_VISION => 'GEOVISION',
            self::INDEX_MOTOBIX => 'MOBOTIX',
            self::INDEX_FLIR => 'FLIR',
            self::INDEX_ACTI => 'ACTI',
            self::INDEX_VIVOTEK => 'VIVOTEK',
            self::INDEX_AXIS => 'AXIS',
            self::INDEX_BOSCH => 'BOSCH',
            self::INDEX_ISONAS => 'ISONAS',
            self::INDEX_QNAP => 'QNAP',
            self::INDEX_RAYTEC => 'RAYTEC',
            self::INDEX_ENTRUST_DATACARD => 'ENTRUST DATACARD',
            self::INDEX_AV_COSTAR => 'AV COSTAR',
            self::INDEX_LOCKNETICS => 'LOCKNETICS',
            self::INDEX_DIGITAL_WATCHDOG => 'DIGITAL WATCHDOG',
            self::INDEX_SCHLAGE => 'SCHLAGE',
            self::INDEX_USA_VISION => 'USA VISION',
            self::INDEX_AXTON => 'AXTON',
            self::INDEX_ABB => 'ABB'
        ];

        return $list[$index];
    }
}
