<?php

/**
 * This is the model class for table "{{setting_sales_price}}".
 *
 * The followings are the available columns in table '{{setting_sales_price}}':
 * @property integer $id
 * @property string $column_name
 * @property integer $sales_margin
 * @property integer $dollors
 * @property integer $status
 * @property string $date_created
 * @property string $date_updated
 */
class SettingSalesPrice extends CActiveRecord
{
	const SALES_PRICE_SETTING_FROM_COLUMN = 1;
	const SALES_PRICE_SETTING_COST = 2;
	const SALES_PRICE_SETTING_MSRP = 3;


	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{setting_sales_price}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sales_margin, dollors, status', 'numerical', 'integerOnly'=>true),
			array('column_name', 'length', 'max'=>50),
			array('date_created, date_updated', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, column_name, sales_margin, dollors, status, date_created, date_updated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'column_name' => 'Column Name',
			'sales_margin' => 'Sales Margin',
			'dollors' => 'Dollors',
			'status' => 'Status',
			'date_created' => 'Date Created',
			'date_updated' => 'Date Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('column_name',$this->column_name,true);
		$criteria->compare('sales_margin',$this->sales_margin);
		$criteria->compare('dollors',$this->dollors);
		$criteria->compare('status',$this->status);
		$criteria->compare('date_created',$this->date_created,true);
		$criteria->compare('date_updated',$this->date_updated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SettingSalesPrice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
