<?php

/**
 * This is the model class for table "{{pricing_tier_wp_role}}".
 *
 * The followings are the available columns in table '{{pricing_tier_wp_role}}':
 * @property integer $id
 * @property string $name
 * @property integer $status
 * @property integer $type
 * @property string $date_created
 * @property string $date_updated
 */
class PricingTierWpRole extends CActiveRecord
{
    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 2;
    const STATUS_DELETED = 3;

    const TYPE_DEFAULT = 0;
    const TYPE_CUSTOM = 1;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{pricing_tier_wp_role}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type, status', 'numerical', 'integerOnly'=>true),
            array('key, label, date_created, date_updated', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, key, type, status, date_created, date_updated', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'key' => 'Key',
            'label' => 'Label',
            'type' => 'Type',
            'status' => 'Status',
            'date_created' => 'Date Created',
            'date_updated' => 'Date Updated',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('key', $this->key, true);
        $criteria->compare('label', $this->label, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('status', $this->status);
        $criteria->compare('date_created', $this->date_created, true);
        $criteria->compare('date_updated', $this->date_updated, true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PricingTierWpRole the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public function scopes()
    {
        return array(
            'active' => array(
                'condition' => $this->tableAlias . '.status = ' . self::STATUS_ACTIVE,
            ),
            'existing' => array(
                'condition' => $this->tableAlias . '.status <> ' . self::STATUS_DELETED,
            ),
        );
    }


    protected function beforeSave()
    {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->date_created = $this->date_updated = date('Y-m-d H:i:s');
                $this->status = self::STATUS_ACTIVE;
            } else {
                $this->date_updated = date('Y-m-d H:i:s');
            }
            return true;
        }
    }
    //get the active wordpress role id and name
    public function getActiveWpRole($roleId = null)
    {
        $updateWpRole = '';
        if ($roleId != null && $roleId != '') {
            $updateWpRole = ' OR ptwr.id = '.$roleId;
        }

        $activeWpRoles = self::model()->findAll(array(
            'alias' => 'ptwr',
            'join' => 'LEFT JOIN {{pricing_tier_description}} as ptd on ptd.pricing_tier_wp_role_id = ptwr.id',
            'condition' => 'ptwr.type = 0 OR (ptwr.type = 1 AND (ptd.pricing_tier_wp_role_id IS NULL OR ptd.status = '.self::STATUS_DELETED.'))'.$updateWpRole.' AND ptwr.status = '.self::STATUS_ACTIVE,
            'order' => 'id asc',
        ));
        
        $data = array();
        //passing wp roles to data
        foreach ($activeWpRoles as $role) {
            $data[] = array(
                'id' => $role->id,
                'label' => $role->label
            );
        }
        //create new option for custom role
        $data[] = array(
            'id' => 'custom',
            'label' => 'Create Custom Role'
        );
        $listData = CHtml::listData($data, 'id', 'label');
        return $listData;
    }
}
