<?php

/**
 * This is the model class for table "{{pricing_tier_description}}".
 *
 * The followings are the available columns in table '{{pricing_tier_description}}':
 * @property integer $id
 * @property integer $group_id
 * @property integer $pricing_tier_wp_role_id
 * @property string $tier_name
 * @property string $description
 * @property integer $sort_order
 * @property integer $status
 * @property string $date_created
 * @property string $date_updated
 */
class PricingTierDescription extends CActiveRecord
{
	const STATUS_ACTIVE = 1;
	const STATUS_INACTIVE = 2;
	const STATUS_DELETED = 3;

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pricing_tier_description}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('group_id, tier_name', 'required'),
			array('group_id, pricing_tier_wp_role_id, sort_order, status', 'numerical', 'integerOnly'=>true),
			array('tier_name', 'length', 'max'=>128),
			array('pricing_tier_wp_role_id, description, date_created, date_updated', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, group_id, pricing_tier_wp_role_id, tier_name, description, sort_order, status, date_created, date_updated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'group' => array(self::BELONGS_TO, 'PricingGroup', 'group_id'),
			'pricingTierWpRole' => array(self::BELONGS_TO, 'PricingTierWpRole', 'pricing_tier_wp_role_id'),
			'pricingTier' => array(self::HAS_MANY, 'PricingTier', 'desc_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'group_id' => 'Group',
			'pricing_tier_wp_role_id' => 'Pricing Tier Wp Role ID',
			'tier_name' => 'Tier Name',
			'description' => 'Description',
			'sort_order' => 'Sort Order',
			'status' => 'Status',
			'date_created' => 'Date Created',
			'date_updated' => 'Date Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('group_id',$this->group_id);
		$criteria->compare('pricing_tier_wp_role_id',$this->pricing_tier_wp_role_id);
		$criteria->compare('tier_name',$this->tier_name,true);
		$criteria->compare('description',$this->description);
		$criteria->compare('sort_order',$this->sort_order);
		$criteria->compare('status',$this->status);
		$criteria->compare('date_created',$this->date_created,true);
		$criteria->compare('date_updated',$this->date_updated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function scopes()
	{
		return array(
			'active' => array(
				'condition' => $this->tableAlias . '.status = ' . self::STATUS_ACTIVE,
			),
			'existing' => array(
				'condition' => $this->tableAlias . '.status <> ' . self::STATUS_DELETED,
			),
		);
	}

	protected function beforeSave()
	{
		if (parent::beforeSave()) {
			if ($this->isNewRecord) {
				$this->date_created = $this->date_updated = date('Y-m-d H:i:s');
			} else {
				$this->date_updated = date('Y-m-d H:i:s');
			}
			return true;
		}
	}

	public static function getStatusList($withColor = false)
	{
		if (!$withColor) {
			return [
				self::STATUS_ACTIVE => 'Active',
				self::STATUS_INACTIVE => 'Inactive',
				self::STATUS_DELETED => 'Deleted',
			];
		} else {
			return [
				self::STATUS_ACTIVE => '<span class="label label-primary">Active</span>',
				self::STATUS_INACTIVE => '<span class="label label-default">Inactive</span>',
				self::STATUS_DELETED => '<span class="label label-warning">Deleted</span>',
			];
		}
	}

	public static function getStatusLabelWithColor($idx)
	{
		return self::getStatusList(true)[$idx];
	}

	public static function getStatusLabel($idx)
	{
		return self::getStatusList()[$idx];
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PricingTierDescription the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
