<?php

/**
 * This is the model class for table "{{normalized_pricing_tier_lookup}}".
 *
 * The followings are the available columns in table '{{normalized_pricing_tier_lookup}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $selected_price_type
 * @property string $cost_markup_computed
 * @property string $msrp_markdown_computed
 * @property integer $pricing_tier_id
 * @property integer $group_id
 * @property integer $status
 */
class NormalizedPricingTierLookup extends CActiveRecord
{
	const STATUS_ACTIVE = 1;
	const STATUS_INACTIVE = 2;
	const STATUS_DELETED = 3;

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{normalized_pricing_tier_lookup}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, selected_price_type, pricing_tier_id, group_id, status', 'numerical', 'integerOnly'=>true),
			array('cost_markup_computed, msrp_markdown_computed', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, selected_price_type, cost_markup_computed, msrp_markdown_computed, pricing_tier_id, group_id, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'selected_price_type' => 'Selected Price Type',
			'cost_markup_computed' => 'Cost Markup Computed',
			'msrp_markdown_computed' => 'Msrp Markdown Computed',
			'pricing_tier_id' => 'Pricing Tier',
			'group_id' => 'Group',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('selected_price_type',$this->selected_price_type);
		$criteria->compare('cost_markup_computed',$this->cost_markup_computed,true);
		$criteria->compare('msrp_markdown_computed',$this->msrp_markdown_computed,true);
		$criteria->compare('pricing_tier_id',$this->pricing_tier_id);
		$criteria->compare('group_id',$this->group_id);
		$criteria->compare('status',$this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return NormalizedPricingTierLookup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
