<?php
//Written DL31214
//to create a segregated area where all types and status / lookups / functions are stored

class LookUp extends CFormModel
{
	//  note module type
	const TYPE_MODULE_LEAD = 1;
	const TYPE_MODULE_APPOINTMENT = 2;
	const TYPE_MODULE_TASK = 3;
	const TYPE_MODULE_NOTE = 4;
	const TYPE_MODULE_REMINDER = 5;
	const TYPE_MODULE_GROUP = 6;
	
	const TYPE_MODULE_LEAD_ACTION_CREATE = 1;
	const TYPE_MODULE_LEAD_ACTION_UPDATE = 2;
	const TYPE_MODULE_LEAD_ACTION_DELETE = 3;
	
	const TYPE_MODULE_APPOINTMENT_ACTION_CREATE = 4;
	const TYPE_MODULE_APPOINTMENT_ACTION_UPDATE = 5;
	const TYPE_MODULE_APPOINTMENT_ACTION_DELETE = 6;
	const TYPE_MODULE_APPOINTMENT_ACTION_RESCHEDULE = 7;
	
	const TYPE_MODULE_TASK_ACTION_CREATE = 8;
	const TYPE_MODULE_TASK_ACTION_UPDATE = 9;
	const TYPE_MODULE_TASK_ACTION_DELETE = 10;
	
	const TYPE_MODULE_NOTE_ACTION_CREATE = 11;
	const TYPE_MODULE_NOTE_ACTION_UPDATE = 12;
	const TYPE_MODULE_NOTE_ACTION_DELETE = 13;

	//
	const TYPE_MODULE_REMINDER_CREATE = 14;
	const TYPE_MODULE_REMINDER_UPDATE = 15;
	const TYPE_MODULE_REMINDER_DELETE = 16;
	
	const TYPE_MODULE_GROUP_CREATE = 17;
	const TYPE_MODULE_GROUP_UPDATE = 18;
	const TYPE_MODULE_GROUP_DELETE = 19;
	const TYPE_MODULE_GROUP_CREATE_LEAD = 20;
	const TYPE_MODULE_GROUP_CREATE_MEMBER = 21;
	
	//default values for status fields
	CONST STATUS_ENABLED = 1;
	CONST STATUS_DISABLED = 2;
	CONST STATUS_DELETED = 3;
	CONST STATUS_PENDING = 4;
	
	//accounts
	CONST TYPE_SUPER_ADMIN = 1;
	CONST TYPE_REGULAR_USER = 2;
	//editable account types
	CONST TYPE_ACCOUNT_STATIC = 1;
	CONST TYPE_ACCOUNT_DYNAMIC = 2;
	//gender
	CONST GENDER_MALE = 'm';
	CONST GENDER_FEMALE = 'f';

	//page sizes
	CONST CONST_PAGE_SIZE_BIG = 10;
	CONST CONST_PAGE_SIZE_SMALL = 5;
	CONST CONST_PAGE_SIZE_LIST = 12;
	
	//for uploader widget
	// values affects the upload widget
	CONST FILE_TYPE_VIDEO_LIST = 'mp4,3gp,mov,ogg,ogv,webm,wmv'; // image	
	CONST FILE_TYPE_IMAGE_LIST = 'jpg,jpeg,gif,png'; // image extensions
	// CONST FILE_TYPE_OTHER_LIST = 'doc,docx,pdf,xls,xlsx,txt'; // image extensions
	CONST FILE_TYPE_OTHER_LIST = 'pdf,doc,docx,csv,xls,xlsx,txt'; // image extensions
	CONST FILE_TYPE_IMPORT_LIST = 'csv,xls,xlsx'; // image extensions
	CONST TEMP_FOLDER = 'temp/'; // temp before conversion
	CONST UPLOAD_FOLDER = 'upload/'; // location after conversion
	CONST UPLOAD_FOLDER_PROD = 'uploads/'; // location after conversion
	CONST FILE_TYPE_IMAGE = 1; // image	
	CONST FILE_TYPE_VIDEO = 2; // video	
	CONST FILE_TYPE_OTHER = 3; // other	
	CONST FILE_TYPE_IMPORT = 4; // other	
	
	//days before clean up temp files in temp folder
	CONST TEMP_FILE_DAYS = 1; // days
	
	//different image sizes
	// l
	// m
	// s
	// th
	// -- blank for original
	
	//for meal type
	CONST MEAL_ADMIN = 1; //admin created 
	CONST MEAL_USER = 2; //user created meal
	
	CONST TYPE_PRODUCT = 1;
	CONST TYPE_MEAL = 2;
	
	//returns status
	public static function getStatus($id = null) 
	{ 
		$array = array(
			self::STATUS_ENABLED => 'Enabled',
			self::STATUS_DISABLED => 'Disabled',
		);

		if($id != null)
		{
			$color = '';
			switch($id)
			{
				case self::STATUS_ENABLED:
				default:
					$color = 'color: green;';
				break;
				case self::STATUS_DISABLED:
					$color = 'color: red;';
				break;
			}
			
			return '<span style="'.$color.'">'.$array[$id].'</span>';
		}
		else
		{
			return $array;
		}
    }
	
	//segregated retrive current date function
	public static function getCurrentDate($format = 'Y-m-d H:i:s')
	{
		return date($format);
	}
	
	// centralized styling function for clist view
	public static function formatClistView($otherVars = array())
	{
		$array = $otherVars;
		$array += array(
				'id' => 'generic-list',	
				'loadingCssClass' => 'list-view-loading-big',
				'pagerCssClass' => 'list-pager',
				'itemsTagName' => 'table',
				'itemsCssClass' => 'table table-hover table-condensed',
				'pager' => array(
					'header' => false, 
					'firstPageLabel' => '<span class="glyphicon glyphicon-chevron-left"></span><span class="glyphicon glyphicon-chevron-left"></span>',
					'prevPageLabel'  => '<span class="glyphicon glyphicon-chevron-left"></span>',
					'nextPageLabel'  => '<span class="glyphicon glyphicon-chevron-right"></span>',
					'lastPageLabel'  => '<span class="glyphicon glyphicon-chevron-right"></span><span class="glyphicon glyphicon-chevron-right"></span>',
				),
				// 'template' => '{pager}{items}{pager}',
				'template' => '{items}{pager}',
				'emptyText' => '<div class="new-flash alert-danger" style="position: static;">Empty...</div>'
			);
		return $array;
	}
	
	//segregated retrive current date function
	public static function getGender()
	{
		return array(
			'm'=>'Male',
			'f'=>'Female',
		);
	}
	
	// redactor options, used for cms //DEPRECATED DL1915
	public static function redactorOptions()
	{
		return array(      
			'minHeight'=>'500px',
			// 'html'=>array(
				// 'style'=>'min-height: 500px;'
			// ),
			// 'buttons'=>array(
				// 'formatting', '|', 'bold', 'italic', 'deleted', '|',
				// 'unorderedlist', 'orderedlist', 'outdent', 'indent', '|',
				// 'image', 'video', 'link', '|', 'html',
			// ),
		);
	}
	
	// tinymce options, used for cms
	public static function mceOptions()
	{
		return array(      
			'plugins'=>array(
				'advlist autolink lists link image charmap print preview anchor',
				'searchreplace visualblocks code'
			),
			'toolbar'=>array(
				'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image'
			),
			'height' => 500,
			'selector' => '#content-block',
			'convert_urls' => false			
		);
	}

	//sorting arrays 
	public static function bubbleSort($array,$key)
	{
		$size = count($array);
		for($i=0; $i<$size; $i++) 
		{
			for($j=0; $j<$size-1-$i; $j++) 
			{
				if($array[$j+1]->$key < $array[$j]->$key) 
				{					
					$b = $j+1;
					$tmp = $array[$j];
					$array[$j] = $array[$b];
					$array[$b] = $tmp;								
				}
			}
		}
		return $array;
	}	
	
	//sorting arrays 
	//custom error message is written in type
	public static function flashMessage($type,$dataName = null)
	{		
		$message = '';
		if($dataName == null)
		{
			$dataName = 'Data';
		}		
		switch($type)
		{	
			case 'create':
				$message = $dataName.' successfully created';
			break;
			case 'update':
				$message = $dataName.' successfully updated';
			break;
			case 'delete': // delete
				$message = $dataName.' successfully deleted';
			break;
			case 'remove': // unlink
				$message = $dataName.' successfully removed';
			break;
			case 'existError':
				$message = $dataName.' already exist';
			break;
			case 'dataError':
				$message = 'No data selected';
			break;
			case 'error':
				$message = $dataName.' can not be saved';
			break;
			case 'danger':
				$message = 'An error occurred while processing request. Please try again later';
			break;	
			case 'response':
				$message = $dataName.' sent';
			break;
			default:
				$message = $type;
			break;
		}
		return $message;		
	}	
	
	// error messages for chttpexception
	public static function exceptionErrorMessages($id)
	{
		$message = '';
		switch($id)
		{
			case 404:
			default:
				$message = 'The requested page does not exist.';
			break;
			case 500:
				$message = 'Page restricted. Please contact administrator.';
			break;
		}
		return $message;	
	}
		
	//max file size
	//format to bytes variable
	public static function getMaxFileSize($format = false)
	{
		$maxSize = ini_get("upload_max_filesize");
		// $postMaxSize = ini_get("post_max_size");
		
		if($format)
		{				
			$maxSize = trim($maxSize);
			$last = strtolower($maxSize[strlen($maxSize)-1]);
			switch($last) 
			{			
				case 'g':
					$maxSize *= 1024;
				case 'm':
					$maxSize *= 1024;
				case 'k':
					$maxSize *= 1024;
			}			
		}		
		return $maxSize;	
	}
		
	public static function getMediaType($id) 
	{
		$type = '';
		switch($id)
		{
			case self::FILE_TYPE_IMAGE:
				$type = 'Image';
			break;
			case self::FILE_TYPE_VIDEO:
				$type = 'Video';
			break;
			default:
				$type = 'Other';
			break;
		}
		return $type;
	}	
	
	public static function formatDate($date, $format = 'Y-m-d H:i:s')
	{		
		return date($format,strtotime($date));
	}
	
	public static function formatPrice($price, $currency = 'PHP ')
	{
		return $currency.number_format($price,2);
	}
	
	//returns status
	public static function getFeaturedStatus($id = null) 
	{ 
		$array = array(
			self::STATUS_ENABLED => 'Yes',
			self::STATUS_DISABLED => 'No',
		);
		
		if($id != null)
		{
			$color = '';
			switch($id)
			{
				case self::STATUS_ENABLED:
				default:
					$color = 'color: green;';
				break;
				case self::STATUS_DISABLED:
					$color = 'color: red;';
				break;
			}
			
			return '<span style="'.$color.'">'.$array[$id].'</span>';
		}
		else
		{
			return $array;
		}
    }
	
	public static function genericScope($tableAlias)
	{
		return array(
			'enabled' => array(				
				'alias' => $tableAlias,
				'condition' => $tableAlias.".status = :status",
				'params' => array(
					':status' => LookUp::STATUS_ENABLED					
				)
			),	
			'exist' => array(				
				'alias' => $tableAlias,
				'condition' => $tableAlias.".status != :status",
				'params' => array(
					':status' => LookUp::STATUS_DELETED					
				)
			),			
			'disabled' => array(				
				'alias' => $tableAlias,
				'condition' => $tableAlias.".status = :status",
				'params' => array(
					':status' => LookUp::STATUS_DISABLED
				)
			),
			'deleted' => array(				
				'alias' => $tableAlias,
				'condition' => $tableAlias.".status = :status",
				'params' => array(
					':status' => LookUp::STATUS_DELETED
				)
			),
			'sortOrder' => array(				
				'alias' => $tableAlias,
				'order' => $tableAlias.'.sort_order'
			),
			'sortOrderDesc' => array(				
				'alias' => $tableAlias,
				'order' => $tableAlias.'.sort_order desc'
			)
		);
	}
	
	//returns status
	public static function getStatusInquiry($id = null) 
	{ 
		$array = array(
			self::STATUS_ENABLED => 'Responded',
			self::STATUS_PENDING => 'Pending',
		);

		if($id != null)
		{
			$color = '';
			switch($id)
			{
				case self::STATUS_ENABLED:
				default:
					$color = 'color: green;';
				break;
				case self::STATUS_PENDING:
					$color = 'color: red;';
				break;
			}
			
			return '<span style="'.$color.'">'.$array[$id].'</span>';
		}
		else
		{
			return $array;
		}
    }
	
	public static function cutString($str,$length = 0)
	{
		$return = $str;
		if(strlen($str) > $length)
		{
			$return = substr($str, 0, $length).'...';
		}
		return $return; 
	}	
		
	//returns status
	public static function getType($id = null) 
	{ 
		$array = array(
			self::TYPE_PRODUCT => 'Product',
			self::TYPE_MEAL => 'Meal',
		);

		if($id != null)
		{
			$color = '';
			switch($id)
			{
				case self::TYPE_PRODUCT:
				default:
					$color = 'color: green;';
				break;
				case self::TYPE_MEAL:
					$color = 'color: blue;';
				break;
			}
			
			return '<span style="'.$color.'">'.$array[$id].'</span>';
		}
		else
		{
			return $array;
		}
    }
	
	//pushes values inside array and moving other values
	public static function arrayInsert($model,$index,$id)
	{
		$tempArr = array();
		$tempArr2 = array();						
		$modelHierarchy = $index-1;
		$tempArr2[$modelHierarchy] = $id;
		foreach($model as $chunk)
		{													
			$tempArr[] = $chunk->id;						
		}						
		if(isset($tempArr[$modelHierarchy]))
		{							
			$tempArr[] = 0;											
			$tempVar = $tempArr[$modelHierarchy];																					
			$counter = $modelHierarchy;
			$tempArr = $tempArr2 + $tempArr;				
			if(isset($tempArr[$counter]))
			{
				$counter += 1;								
				while(isset($tempArr[$counter]))							
				{									
					$tempVar2 = $tempArr[$counter];
					$tempArr[$counter] = $tempVar;
					$tempVar = $tempVar2;
					$counter += 1;																
				}
			}								
			else
			{									
				$tempArr[] = $tempVar;
			}						
		}
		else
		{
			$tempArr = $tempArr2 + $tempArr;
		}
		ksort($tempArr);					
		return $tempArr;
	}
	
	public static function dateModifiedText($date)
	{		
		return '<p class="">Last Modified: '. self::formatDate($date,'F j, Y, H:i:s').'</p>';
	}
	
	public static function convertArrayToJs($array)
	{
		return htmlspecialchars(json_encode($array));
	}

	public static function validateDate($date)
	{
		$date = strtotime($date); 
		if(!is_numeric($date)) 
		{
			return false; 
		}
		
		$month = date('m', $date); 
		$day = date('d', $date); 
		$year = date('Y', $date); 
		if(checkdate($month, $day, $year))
		{
			return true; 
		}
		return false; 
	}
	
	//special purpose code
	public static function validateGender($gender)
	{	
		// acceptable male terms
		$maleArray = array(
			'm',
			'male',
			'herrn',
		);
		
		// acceptable female terms
		$femaleArray = array(
			'f',
			'female',
			'frau',
		);
		
		$bothArray = array_merge($femaleArray,$maleArray);
		
		if(in_array(strtolower(trim($gender)),$bothArray))
		{
			if(in_array(strtolower(trim($gender)),$maleArray))
			{
				$gender = 'm';
			}
			else
			{
				$gender = 'f';
			}
			return $gender;
		}
		return false;
	}
	
	public static function generateRandomColor($keyColor = '')
	{
		$colorArray = array('#19cce6','#844e7b','#79a886');
		// if($keyColor == '')
		// {
			// return '#' . dechex(rand(256,16777215)); // random
		// }
		// else		
		// {
			return 	$colorArray[$keyColor];	
		// }
	}

	public static function getMonthList()
	{
		return array(
			'01' => 'January',
			'02' => 'February',
			'03' => 'March',
			'04' => 'April',
			'05' => 'May',
			'06' => 'June',
			'07' => 'July',
			'08' => 'Agust',
			'09' => 'September',
			'10'=> 'October',
			'11' => 'November',
			'12' => 'December',
		);
	}
	
	public static function validateEmailAddress($email)
	{
		if(preg_match("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$^",$email))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public static function checkLegacy($data,$styleMod = '')
	{
		$tag = '';
		$color = '';
		$status = false;
		if(isset($data->legacy) || isset($data['legacy']))
		{
			$flag = false;
			if(isset($data['legacy']) && $data['legacy'] == 1)
			{
				$flag = true;
			}
			if(isset($data->legacy) && $data->legacy == 1)
			{
				$flag = true;
			}
			if($flag)
			{
				$color = 'rgba(255, 165, 0, 0.25)';
				$status = true;
				$tag = '<span style="background-color:'.$color.'; position: absolute; top: 7px; right: 15px; padding: 8px 15px; border-radius: 4px; font-weight: bold; font-size: 11px; '.$styleMod.'"><i class="fa fa-exclamation-circle"></i> Legacy Data</span>';
			}
		}
		return array(
			'status' => $status,
			'color' => $color,
			'tag' => $tag,
		);
	}
}


?>
