<?php

/**
 * This is the model class for table "{{fileupload}}".
 *
 * The followings are the available columns in table '{{fileupload}}':
 * @property integer $id
 * @property string $guid
 * @property string $original_filename
 * @property string $name
 * @property string $extension
 * @property integer $status
 * @property string $date_created
 * @property string $guid_path
 * @property string $size
 * @property integer $account_id
 */
class Fileupload extends CActiveRecord
{
	const STATUS_ACTIVE = 1;
	const STATUS_INACTIVE = 2;
	const STATUS_DELTED = 3;
	const STATUS_TEMP = 4;
	const STATUS_SAMPLE = 5; /* for testing purposes */

	const FILE_TYPE_IMAGE = 1; // image	
	const FILE_TYPE_IMAGE_LIST = 'image/*'; 		
	const FILE_TYPE_VIDEO = 2; // video	
	const FILE_TYPE_VIDEO_LIST = 'video/*';  	
	const FILE_TYPE_AUDIO = 3; // audio
	const FILE_TYPE_AUDIO_LIST = 'audio/*';  
	const FILE_TYPE_APPLICATION = 4; 
	const FILE_TYPE_APPLICATION_LIST = 'application/*';   	
	const FILE_TYPE_TEXT = 5;
	const FILE_TYPE_TEXT_LIST = 'text/*';   	
	const FILE_TYPE_X_WORLD = 6;   	
	const FILE_TYPE_X_WORLD_LIST = 'x-world/*';   	
	const FILE_TYPE_ALL = 7; 

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fileupload}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('original_filename, name, extension, status, date_created, account_id', 'required'),
			array('status, account_id', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>128),
			array('original_filename', 'length', 'max'=>256),
			array('extension', 'length', 'max'=>100),
			array('size', 'length', 'max'=>10),
			// The following rule is used by search(). 
			// @todo Please remove those attributes that should not be searched.
			array('id, original_filename, name, extension, status, date_created, size, account_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'original_filename' => 'Original Filename',
			'name' => 'Name',
			'extension' => 'Extension',
			'status' => 'Status',
			'date_created' => 'Date Created',
			'size' => 'Size',
			'account_id' => 'Account',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('original_filename',$this->original_filename,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('extension',$this->extension,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('date_created',$this->date_created,true);
		$criteria->compare('size',$this->size,true);
		$criteria->compare('account_id',$this->account_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Fileupload the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getAbsPath()
	{
		return Yii::app()->getBasePath() . '/../temp/' . $this->getFile();
	}

	public function getFile($size = null)
	{
		switch($size)
		{
			case "large":
				$filename = $this->name . "_l";
				break;
			case "medium":
				$filename = $this->name . "_m";
				break;
			case "small":
				$filename = $this->name . "_s";
				break;
			case "thumb":
				$filename = $this->name . "_th";
				break;
			default:
				$filename = $this->name;
				break;
		}
		$return = $filename . "." . $this->extension;
		return $return;
	}
}
