<?php

class SiteController extends Controller
{
	public $layout = 'dashboard';
	public $activeSideNav = array('manage_dashboard');
	public $pageTitle = '';
	public $pageSubTitle = '';
	public $reportType = '';
	 
	public function filters()
	{
		return array(
			'accessControl', 
		);
	}

	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('upload', 'logout', 'index','dashboard', 'getCampaignSummary', 'cadenceDashboard', 'image'),
				'users' => array('@'),
			),
			array(
				'allow',
				'actions' => array('login', 'error'),
				'users' => array('*'),
			),
			array(
				'deny',
				'users' => array('*'),
			),
		);
	}
	
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		//$this->render('index');
		$this->redirect(array('site/dashboard'));
	}
	
	public function actionDashboard()
	{
		ini_set("memory_limit","600M");
		$this->pageTitle = 'Dashboard';
		$this->activeSideNav = array('manage_dashboard');		
		
		$spreadSheetCount = VendorFile::countSpreadSheet();
		$spreadSheetCountVendors = VendorFile::countVendors();
		$spreadSheetCountStatuses = VendorFile::countStatuses();

		$reportSpreadSheets['count'] = $spreadSheetCount;
		$reportSpreadSheets['vendor'][Vendor::INDEX_GEO_VISION] = $spreadSheetCountVendors[Vendor::INDEX_GEO_VISION];
		$reportSpreadSheets['vendor'][Vendor::INDEX_MOTOBIX] = $spreadSheetCountVendors[Vendor::INDEX_MOTOBIX];
		$reportSpreadSheets['vendor'][Vendor::INDEX_FLIR] = $spreadSheetCountVendors[Vendor::INDEX_FLIR];
		$reportSpreadSheets['vendor'][Vendor::INDEX_ACTI] = $spreadSheetCountVendors[Vendor::INDEX_ACTI];
		$reportSpreadSheets['status'][VendorFile::STATUS_PENDING] = $spreadSheetCountStatuses[VendorFile::STATUS_PENDING];
		$reportSpreadSheets['status'][VendorFile::STATUS_PARSING] = $spreadSheetCountStatuses[VendorFile::STATUS_PARSING];
		$reportSpreadSheets['status'][VendorFile::STATUS_FOR_REVIEW] = $spreadSheetCountStatuses[VendorFile::STATUS_FOR_REVIEW];
		$reportSpreadSheets['status'][VendorFile::STATUS_PUSHING] = $spreadSheetCountStatuses[VendorFile::STATUS_PUSHING];
		$reportSpreadSheets['status'][VendorFile::STATUS_PUSHED] = $spreadSheetCountStatuses[VendorFile::STATUS_PUSHED];
		$reportSpreadSheets['status'][VendorFile::STATUS_ERROR] = $spreadSheetCountStatuses[VendorFile::STATUS_ERROR];

		$reportParsedCount = VendorNormalized::countParsedData();
		$reportParsedCuntProductCheckStatuses = VendorNormalized::countProductCheckStatuses();
		$reportParsedCountStatuses = VendorNormalized::countStatuses();

		$reportParsedData['count'] = $reportParsedCount;
		$reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_NEW] = $reportParsedCuntProductCheckStatuses[VendorNormalized::PRODUCT_STATUS_NEW];
		$reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_UPDATED] = $reportParsedCuntProductCheckStatuses[VendorNormalized::PRODUCT_STATUS_UPDATED];
		$reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_REMAIN] = $reportParsedCuntProductCheckStatuses[VendorNormalized::PRODUCT_STATUS_REMAIN];
		$reportParsedData['product_check'][VendorNormalized::PRODUCT_STATUS_EOL] = $reportParsedCuntProductCheckStatuses[VendorNormalized::PRODUCT_STATUS_EOL];
		$reportParsedData['status'][VendorNormalized::STATUS_FOR_REVIEW] = $reportParsedCountStatuses[VendorNormalized::STATUS_FOR_REVIEW];
		$reportParsedData['status'][VendorNormalized::STATUS_PUSHING] = $reportParsedCountStatuses[VendorNormalized::STATUS_PUSHING];
		$reportParsedData['status'][VendorNormalized::STATUS_PUSHED] = $reportParsedCountStatuses[VendorNormalized::STATUS_PUSHED];
		$reportParsedData['status'][VendorNormalized::STATUS_DELETED] = $reportParsedCountStatuses[VendorNormalized::STATUS_DELETED];
		$reportParsedData['status'][VendorNormalized::STATUS_ERROR] = $reportParsedCountStatuses[VendorNormalized::STATUS_ERROR];

		$reportPublishedCount = Product::countPublishedData();
		$reportPublishedCountWebsites = Product::countWebsites();
		$reportPublishedCountVendors = Product::countVendors();

		$reportPublishedCountStatuses = Product::countStatuses();

		$reportPublishedProduct['count'] = $reportPublishedCount;
		$reportPublishedProduct['websites'][Product::WEBSITE_WOO_COMMERCE] = $reportPublishedCountWebsites[Product::WEBSITE_WOO_COMMERCE];
		$reportPublishedProduct['websites'][Product::WEBSITE_GOOGLE_MERCHANT] = $reportPublishedCountWebsites[Product::WEBSITE_GOOGLE_MERCHANT];
		$reportPublishedProduct['websites'][Product::WEBSITE_GSS] = $reportPublishedCountWebsites[Product::WEBSITE_GSS];
		
		$reportPublishedProduct['vendor'][Vendor::INDEX_GEO_VISION] = $reportPublishedCountVendors[Vendor::INDEX_GEO_VISION];
		$reportPublishedProduct['vendor'][Vendor::INDEX_MOTOBIX] = $reportPublishedCountVendors[Vendor::INDEX_MOTOBIX];
		$reportPublishedProduct['vendor'][Vendor::INDEX_FLIR] = $reportPublishedCountVendors[Vendor::INDEX_FLIR];
		$reportPublishedProduct['vendor'][Vendor::INDEX_ACTI] = $reportPublishedCountVendors[Vendor::INDEX_ACTI];
		$reportPublishedProduct['status'][Product::STATUS_ACTIVE] = $reportPublishedCountStatuses[Product::STATUS_ACTIVE];
		$reportPublishedProduct['status'][Product::STATUS_ERROR] = $reportPublishedCountStatuses[Product::STATUS_ERROR];

		$this->render('dashboard', array(
			'reportSpreadSheets' => $reportSpreadSheets,
			'reportParsedData' => $reportParsedData,
			'reportPublishedProduct' => $reportPublishedProduct
		));
	}
	
	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		$this->layout = 'layout_blank';
		if (!Yii::app()->user->isGuest)
		{
			$this->redirect(array('/'));
		}

		$model=new LoginForm;

		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			{
				$this->redirect(array('site/dashboard'));
			}
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}
	
	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
	
	
	
	
	
	
	public function actionComponents()
	{
		Yii::app()->user->setFlash('success','This message is for acknowledge "Success" on the last transaction!');
		Yii::app()->user->setFlash('info','This box is for sending "info address" to viewers.');
		Yii::app()->user->setFlash('danger','This message is for acknowledge "Error" on the last transaction!');
		Yii::app()->user->setFlash('warning','This message is for acknowledge "Warning" on the last transaction!');

		$this->render('components');
		
	}
	
	
	
	
	public function actionDashboardTest()
	{
		// if need date filter use this mailer/campaignMailerReport\
		
		$this->pageTitle = 'Retain Dashboard';
		
		// TODAY!!!!!!!!!!
		
		$this->activeSideNav = array('manage_dashboard');
		
		$totaClickCount = array(
			'visits' => 0,
			'downloads' => 0,
			'registered' => 0,
			'openedEmails' => 0,
			'unsubscribed' => 0,
			'total' => 0,
			'sentEmails' => 0,
		);
		$campaignEngagements = array();
		
		// get all active Mailers
		$activeCampaigns = ActiveEmailCampaign::model()->inactive()->findAll();
		foreach( $activeCampaigns as $activeCampaign )
		{
			$campaignModel = MailerContent::model()->findByPk($activeCampaign->mailer_content_id);
			if ( is_null($campaignModel) )
				$campaignModel = new MailerContent;
			
			$campaignEngagementData = $this->getEngagements( $campaignModel );
			$campaignEngagements[$campaignModel->id] = $campaignEngagementData;
			$totaClickCount['visits'] += $campaignEngagementData['visits'];
			$totaClickCount['downloads'] += $campaignEngagementData['downloads'];
			$totaClickCount['registered'] += $campaignEngagementData['registered'];
			$totaClickCount['openedEmails'] += $campaignEngagementData['openedEmails'];
			$totaClickCount['unsubscribed'] += $campaignEngagementData['unsubscribed'];
		}
		
		
		$totaClickCount['total'] =  $totaClickCount['downloads'] + $totaClickCount['registered'];
		$totalPerTime = $this->getCampaignSumOpenedTime( $campaignEngagements );
	
		$this->render('dashboard', array( 'totaClickCount' => $totaClickCount, 'activeCampaigns' => $activeCampaigns, 'campaignEngagements' => $campaignEngagements, 'totalPerTime' => $totalPerTime ) );
	}
	
	public function actionGetCampaignSummary($cadence = false)
	{
		if( $cadence )
			$activeCampaigns = MailerContent::model()->cadence()->findAll();
		else
			$activeCampaigns = ActiveEmailCampaign::model()->active()->findAll();
		
		$campaignReports = array();
		if( $activeCampaigns )
		{
			$totalEngagements = $totalOpenedEmails = $totalVisits = $totalUnsubscribed = 0;
			foreach( $activeCampaigns as $activeCampaign )
			{
				$data = array();
				
				if( $cadence )
					$mailerContent = $activeCampaign;
				else
					$mailerContent = $activeCampaign->mailerContent;
				
				$campaignSummaryReports = $mailerContent->campaignSummaryReports;
					
				foreach( $campaignSummaryReports as $campaignSummaryReport )
				{
					$data[$campaignSummaryReport->key] = $campaignSummaryReport->value;
					if( in_array($campaignSummaryReport->key, array('registered','downloads')) )
						$totalEngagements += $campaignSummaryReport->value;
					
					if( $campaignSummaryReport->key == 'openedEmails' )
						$totalOpenedEmails += $campaignSummaryReport->value;
					
					if( $campaignSummaryReport->key == 'visits' )
						$totalVisits += $campaignSummaryReport->value;
					
					if( $campaignSummaryReport->key == 'unsubscribed' )
						$totalUnsubscribed += $campaignSummaryReport->value;
				}
				$data['name'] = $mailerContent->subject;
				$campaignReports[$mailerContent->id] = $data;
			}
			if( $cadence )
				$totalPerTime = $this->getCadanceCampaignSumOpenedTime( $campaignReports );	
			else
				$totalPerTime = $this->getCampaignSumOpenedTime( $campaignReports );	
			$campaignReports['totalPerTime'] = $totalPerTime;			
			$campaignReports['totalEngagements'] = $totalEngagements;			
			$campaignReports['totalOpenedEmails'] = $totalOpenedEmails;			
			$campaignReports['totalVisits'] = $totalVisits;			
			$campaignReports['totalUnsubscribed'] = $totalUnsubscribed;			
		}
		
		exit( json_encode($campaignReports) );
	}
	
	public function getCampaignSumOpenedTime($campaignEngagements)
	{
		$totalPerTime = array();
		foreach( $campaignEngagements as $campaignEngagement )
		{
			if( !empty($campaignEngagement['openedEmailsTime']) )
			{
				if( !is_array($campaignEngagement['openedEmailsTime']) )
					$campaignEngagement['openedEmailsTime'] = json_decode($campaignEngagement['openedEmailsTime']);
				
				foreach( $campaignEngagement['openedEmailsTime'] as $key => $_campaignEngagement )
				{
					if( isset($totalPerTime[$key]) )
						$totalPerTime[$key] += $_campaignEngagement;
					else
						$totalPerTime[$key] = $_campaignEngagement;
					
				}
			}
		}
		ksort($totalPerTime);
		
		return $this->get12hrFormat($totalPerTime);
	}
	
		
	public function getCadanceCampaignSumOpenedTime($campaignEngagements)
	{
		$totalPerTime = array();
		foreach( $campaignEngagements as $campaignEngagementKey => $campaignEngagement )
		{
			if( !empty($campaignEngagement['openedEmailsTime']) )
			{
				if( !is_array($campaignEngagement['openedEmailsTime']) )
					$campaignEngagement['openedEmailsTime'] = json_decode($campaignEngagement['openedEmailsTime'], true);
				
				
				
				foreach( $campaignEngagement['openedEmailsTime'] as $key => $_campaignEngagement )
				{
					if( isset($totalPerTime[$key][$campaignEngagementKey]) )
						$totalPerTime[$key][$campaignEngagementKey] += $_campaignEngagement;
					else
						$totalPerTime[$key][$campaignEngagementKey] = $_campaignEngagement;
					
				}
			}
		}
		ksort($totalPerTime);
		
		return $this->get12hrFormat($totalPerTime);
	}
	
	
	public function get12hrFormat($totalPerTime)
	{
		$time = array();
		foreach($totalPerTime as $hr => $__totalPerTime)
		{
			$dayPeriod = ' AM';
			if( $hr > 12)
			{
				$dayPeriod = ' PM';
				$hr = $hr - 12;
			}
			$time[$hr.$dayPeriod] = $__totalPerTime;
		}
		return $time;
	}
	
	public function getEngagements($campaignModel)
	{
		$totaClickCount = array(
			'openedEmails' => 0,
			'visits' => 0,
			'downloads' => 0,
			'registered' => 0,
			'unsubscribed' => 0,
			'sentEmails' => 0,
		);
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_opened >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_opened <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		
		$campaignOpenersTime = array();

		$openedCount = 0;
		$successfullySentCount = 0;
		$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
		foreach ( $mailerTrackingsAll as $_mailerTracking )
		{
			if ( $_mailerTracking->opened_flag == 1 )
			{
				if( isset($campaignOpenersTime[ date('H', strtotime($_mailerTracking->date_opened))]) )
					$campaignOpenersTime[ date('H', strtotime($_mailerTracking->date_opened))] += 1;
				else
					$campaignOpenersTime[ date('H', strtotime($_mailerTracking->date_opened))] = 1;
				$openedCount++;
			}
		}
		
		$totaClickCount['openedEmails'] = $openedCount;
		$totaClickCount['openedEmailsTime'] = $campaignOpenersTime;
		
		$mailerTrackings = $campaignModel->mailerContentTrackings(array('scopes' => array('liveTracking')));

		$successfullySentCount = 0;

		foreach ( $mailerTrackings as $trackingData )
		{
			if ( $trackingData->status == MailerContentTracking::STATUS_SUCCESS )
			{
				$successfullySentCount++;
			}
		}

		$totaClickCount['sentEmails'] = $successfullySentCount;
		
		
		$mailerContentTrackingIds = array();
		$params = array( 'condition' => 'mailer_id = :mailer_id ',
				 'params' => array( ':mailer_id' => $campaignModel->id )
			   );
	    $params['scopes'] = array('liveTracking');

		$mailerTrackings = $campaignModel->mailerContentTrackings( $params );
		foreach ( $mailerTrackings as $trackingData )
		{
			$mailerContentTrackingIds[] = $trackingData->id;
		}
		
		
		$totaClickCount['contacts'] = count($mailerTrackings);
		
		
		$params = array( 'condition' => 'mailer_id = :mailer_id ',
						 'params' => array( ':mailer_id' => $campaignModel->id )
					   );
					   
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] .= ' AND date_created BETWEEN :start_date AND :end_date ';
			$params['params'] += array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] .= ' AND date_created >= :start_date';
			$params['params'] += array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] .= ' AND date_created <= :end_date';
			$params['params'] += array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';
		

		$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );

		$unsubCount = array();

		foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
		{
			if( $mailerContentTrackingLink->mailer_content_link )
				$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
			
			if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
			{
				if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
				{
					if ( !isset($unsubCount[$trackingLinkVar->id.'-'.$mailerContentTrackingLink->email_contact_id]) )
					{
						$unsubCount[$mailerContentTrackingLink->email_contact_id] = $trackingLinkVar->id;
					}
				}
				else
				{
					if ( $trackingLinkVar->link_type == 1 )
						$totaClickCount['visits'] += 1;
					elseif( $trackingLinkVar->link_type == MailerContentLinkVar::LINK_TYPE_DOWNLOAD )
						$totaClickCount['downloads'] += 1;
					elseif( $trackingLinkVar->link_type == MailerContentLinkVar::LINK_TYPE_FORM_SUBMISSION )
					{
						$totaClickCount['registered'] += 1;
					}
				}
			}
		}
		$totaClickCount['unsubscribed'] = count($unsubCount);
		
		return $totaClickCount;
	}
	
	
	public function actionUpload()
	{

		
		$this->render('upload');
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$name='=?UTF-8?B?'.base64_encode($model->name).'?=';
				$subject='=?UTF-8?B?'.base64_encode($model->subject).'?=';
				$headers="From: $name <{$model->email}>\r\n".
					"Reply-To: {$model->email}\r\n".
					"MIME-Version: 1.0\r\n".
					"Content-Type: text/plain; charset=UTF-8";

				mail(Yii::app()->params['adminEmail'],$subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}

	

	
	
	
	public function actionSignUp()
	{
		$account = new Account;
		$user = new User;
		$account->scenario = 'register';
	
		if (isset($_POST['submit']))
		{
			
			$connection = Yii::app()->db;
			$transaction = $connection->beginTransaction();
			$account->attributes = $_POST['Account'];
			$user->attributes = $_POST['User'];
			/* preset value */
			$account->type = 2;
			$account->salt = $account->generateSalt();
			
			
			$valid = $account->validate() && $user->validate();

			if ($valid)
			{
				try
				{
					if ($account->save(false))
					{
						$user->account_id = $account->id;
						if($user->save(false))
						{
							Yii::app()->user->setFlash("success", "User successfully registered.");
							$transaction->commit();
							$this->refresh();
						}
						else
						{
							Yii::app()->user->setFlash("error", "Registration error, user failed to save.");
						}
					}
					else
					{
						Yii::app()->user->setFlash("error", "Registration error, account failed to save.");
					}
				}
				catch (Exception $e)
				{
					$transaction->rollBack();
					Yii::app()->user->setFlash("error",  $e);
				}
			}	
			else
			{
				print_r($user->attributes);
				Yii::app()->user->setFlash("error", "Adding account failed. Please check your entries!");
			}
			
			exit();
		}
	
	
	
		$this->render('signup',array(
			'account'=>$account,
			'user'=>$user,
		));
	}
	
	public function actionEngagements( $dataType=null ) 
	{
		$this->pageTitle = 'Engagements List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$activeCampaigns = ActiveEmailCampaign::model()->active()->findAll();
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$contentLinkEngagements = array();
		
		foreach( $activeCampaigns as $activeCampaign )
		{

			$_params = array( 'condition' => 'mailer_id = :mailer_id ',
					 'params' => array( ':mailer_id' => $activeCampaign->mailer_content_id )
				   );
			$_params['scopes'] = array('liveTracking');
			$mailerContentTrackingIds = array();
			
			$mailerTrackings = $activeCampaign->mailerContent->mailerContentTrackings( $_params );
			foreach ( $mailerTrackings as $trackingData )
			{
				$mailerContentTrackingIds[] = $trackingData->id;
			}
			
			$params['params'][':mailer_id'] = $activeCampaign->mailer_content_id;
			
			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
				
				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
					{
						if ( !isset($unsubCount[$trackingLinkVar->id.'-'.$mailerContentTrackingLink->email_contact_id]) )
						{
							$unsubCount[$mailerContentTrackingLink->email_contact_id] = $trackingLinkVar->id;
						}
					}
					else
					{
						//  $trackingLinkVar->id == 17  quick fix on watched video
						if( $trackingLinkVar->id == 17 OR $trackingLinkVar->link_type == MailerContentLinkVar::LINK_TYPE_DOWNLOAD OR $trackingLinkVar->link_type == MailerContentLinkVar::LINK_TYPE_FORM_SUBMISSION )
						{
							$contentLinkEngagements[] = $mailerContentTrackingLink;
						}
					}
				}
			}
			
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
					'pageSize'=>100,
				)));
		$this->render('engagement', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);

	}
	
	public function actionOpenedEmails( $dataType=null ) 
	{
		$this->pageTitle = 'Opened Emails List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_opened >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_opened <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		$params['scopes'] = array('liveTracking');
		$openedCount = 0;
		$contentLinkEngagements = array();
		$activeCampaigns = ActiveEmailCampaign::model()->active()->findAll();
		foreach( $activeCampaigns as $activeCampaign )
		{
			$campaignModel = MailerContent::model()->findByPk($activeCampaign->mailer_content_id);
			$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
			foreach ( $mailerTrackingsAll as $_mailerTracking )
			{
				if ( $_mailerTracking->opened_flag == 1 )
				{
					$contentLinkEngagements[] = $_mailerTracking;
					$openedCount++;
				}
			}
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('openedEmails', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);
		
	}
	
	public function actionPageVisits( $dataType=null ) 
	{
		$this->pageTitle = 'Page Visits List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$activeCampaigns = ActiveEmailCampaign::model()->active()->findAll();
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$contentLinkEngagements = array();
		
		foreach( $activeCampaigns as $activeCampaign )
		{

			$_params = array( 'condition' => 'mailer_id = :mailer_id ',
					 'params' => array( ':mailer_id' => $activeCampaign->mailer_content_id )
				   );
			$_params['scopes'] = array('liveTracking');
			$mailerContentTrackingIds = array();
			
			$mailerTrackings = $activeCampaign->mailerContent->mailerContentTrackings( $_params );
			foreach ( $mailerTrackings as $trackingData )
			{
				$mailerContentTrackingIds[] = $trackingData->id;
			}
			
			$params['params'][':mailer_id'] = $activeCampaign->mailer_content_id;
			
			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
				
				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					if ( $trackingLinkVar->link_variable_name != 'unsubscribe_link' )
					{
						if( $trackingLinkVar->link_type == 1 )
						{
							$contentLinkEngagements[] = $mailerContentTrackingLink;
						}
					}
				}
			}
			
		}
		
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
					'pageSize'=>100,
				)));
		$this->render('pageVisits', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);

	}

	public function actionUnsubscribed( $dataType=null ) 
	{
		$this->pageTitle = 'Unsubscribed List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$activeCampaigns = ActiveEmailCampaign::model()->active()->findAll();
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$contentLinkEngagements = array();
		
		foreach( $activeCampaigns as $activeCampaign )
		{

			$_params = array( 'condition' => 'mailer_id = :mailer_id ',
					 'params' => array( ':mailer_id' => $activeCampaign->mailer_content_id )
				   );
			$_params['scopes'] = array('liveTracking');
			$mailerContentTrackingIds = array();
			
			$mailerTrackings = $activeCampaign->mailerContent->mailerContentTrackings( $_params );
			foreach ( $mailerTrackings as $trackingData )
			{
				$mailerContentTrackingIds[] = $trackingData->id;
			}
			
			$params['params'][':mailer_id'] = $activeCampaign->mailer_content_id;
			
			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
				
				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
					{
						$contentLinkEngagements[$mailerContentTrackingLink->email_contact_id] = $mailerContentTrackingLink;
					}
				}
			}
			
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
					'pageSize'=>100,
				)));
		$this->render('unsubscribed', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);

	}

	// Test
	public function actionOpenedEmailsTest( $dataType=null ) 
	{
		$this->pageTitle = 'Opened Emails List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_opened >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_opened <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		$params['scopes'] = array('liveTracking');
		$openedCount = 0;
		$contentLinkEngagements = array();
		$activeCampaigns = ActiveEmailCampaign::model()->inactive()->findAll();
		
		foreach( $activeCampaigns as $activeCampaign )
		{
			
			$campaignModel = MailerContent::model()->findByPk($activeCampaign->mailer_content_id);
			$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
			foreach ( $mailerTrackingsAll as $_mailerTracking )
			{
				if ( $_mailerTracking->opened_flag == 1 )
				{
					$contentLinkEngagements[] = $_mailerTracking;
					$openedCount++;
				}
			}
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('openedEmails', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);
		
	}
	
	public function actionPageVisitsTest( $dataType=null ) 
	{
		$this->pageTitle = 'Page Visits List';
		
		$startDate = $this->startDate;
		$endDate = $this->endDate;
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$activeCampaigns = ActiveEmailCampaign::model()->inactive()->findAll();
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$contentLinkEngagements = array();
		
		foreach( $activeCampaigns as $activeCampaign )
		{

			$_params = array( 'condition' => 'mailer_id = :mailer_id ',
					 'params' => array( ':mailer_id' => $activeCampaign->mailer_content_id )
				   );
			$_params['scopes'] = array('liveTracking');
			$mailerContentTrackingIds = array();
			
			$mailerTrackings = $activeCampaign->mailerContent->mailerContentTrackings( $_params );
			foreach ( $mailerTrackings as $trackingData )
			{
				$mailerContentTrackingIds[] = $trackingData->id;
			}
			
			$params['params'][':mailer_id'] = $activeCampaign->mailer_content_id;
			
			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
				
				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					if ( $trackingLinkVar->link_variable_name != 'unsubscribe_link' )
					{
						if( $trackingLinkVar->link_type == 1 )
						{
							$contentLinkEngagements[] = $mailerContentTrackingLink;
						}
					}
				}
			}
			
		}
		
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
					'pageSize'=>100,
				)));
		$this->render('pageVisits', array( 'dataProvider' => $dataProvider, 
				'dataType' => $dataType, 
			) 
		);

	}

	
	
	 
	
	
	/* ------ */
	
	public function actionCadenceDashboard($startDate = '', $endDate = '')
	{

		if( empty($startDate) )
			$startDate = date('m/d/Y');
		if( empty($endDate) )
			$endDate = date('m/d/Y');
		

		$this->pageTitle = 'Retain Dashboard';
		

		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		$totaClickCount = array(
			'visits' => 0,
			'downloads' => 0,
			'registered' => 0,
			'openedEmails' => 0,
			'unsubscribed' => 0,
			'total' => 0,
			'sentEmails' => 0,
		);
		$campaignEngagements = array();
		
		// get all active Mailers
		$mailerContentModels =  MailerContent::model()->cadence()->findAll();
		foreach( $mailerContentModels as $mailerContentModel )
		{
			$campaignModel = MailerContent::model()->findByPk($mailerContentModel->id);
			if ( is_null($campaignModel) )
				$campaignModel = new MailerContent;
			
			$campaignEngagementData = $this->getEngagements( $campaignModel );
			$campaignEngagements[$campaignModel->id] = $campaignEngagementData;
			$totaClickCount['visits'] += $campaignEngagementData['visits'];
			$totaClickCount['downloads'] += $campaignEngagementData['downloads'];
			$totaClickCount['registered'] += $campaignEngagementData['registered'];
			$totaClickCount['openedEmails'] += $campaignEngagementData['openedEmails'];
			$totaClickCount['unsubscribed'] += $campaignEngagementData['unsubscribed'];
		}
		
		
		$totaClickCount['total'] =  $totaClickCount['downloads'] + $totaClickCount['registered'];
		$totalPerTime = $this->getCampaignSumOpenedTime( $campaignEngagements );
	
		$this->render('cadenceDashboard', array( 'totaClickCount' => $totaClickCount, 
												'activeCampaigns' => $mailerContentModels, 
												'campaignEngagements' => $campaignEngagements, 
												'totalPerTime' => $totalPerTime, 
												'startDate' => $startDate, 
												'endDate' => $endDate, 
											   ) 
					 );
	}
	
	public function actionGetAgentEmailsCount($startDate, $endDate)
	{
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$params = array( 'scopes' => array('liveTracking') );
		$params2 = array();
		

		
		$accountOpenedCount = array();
		$accountUnsubsubscribeCount = array();
		$accountSentCount = array();
		$mailerContentTrackingIds = array();
		
		// $activeCampaigns = ActiveEmailCampaign::model()->cadence()->findAll();
		$mailerContentCadenceModels = MailerContent::model()->cadence()->findAll();
		
		foreach( $mailerContentCadenceModels as $mailerContentCadenceModel )
		{
			if( $startDate AND $endDate )
			{
				$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
				$params2['condition'] = 'date_created BETWEEN :start_date AND :end_date ';
				$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
				$params2['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
			}
			else if ( $startDate )
			{
				$params['condition'] = 'date_opened >= :start_date';
				$params2['condition'] = 'date_created >= :start_date';
				$params['params'] = array( ':start_date'=> $startDate );
				$params2['params'] = array( ':start_date'=> $startDate );
			}
			else if ( $endDate )
			{
				$params['condition'] = 'date_opened <= :end_date';
				$params2['condition'] = 'date_created <= :end_date';
				$params['params'] = array( ':end_date'=> $endDate );
				$params2['params'] = array( ':end_date'=> $endDate );
			}
				
			$campaignModel = MailerContent::model()->findByPk($mailerContentCadenceModel->id);
			$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
			
			$mailerTrackingsAll2 = $campaignModel->mailerContentTrackings( array_merge($params2, array( 'scopes' => array('liveTracking') )) );
			
			foreach ( $mailerTrackingsAll2 as $_mailerTrackingsAll2 )
			{
				if( isset($accountSentCount[$_mailerTrackingsAll2->account_id]) )
				{
					$accountSentCount[$_mailerTrackingsAll2->account_id] += 1;
				}
				else
				{
					$accountSentCount[$_mailerTrackingsAll2->account_id] = 1;
				}
			}
			
			foreach ( $mailerTrackingsAll as $_mailerTracking )
			{
				
				if ( $_mailerTracking->opened_flag == 1 )
				{
					if( isset($accountOpenedCount[$_mailerTracking->account_id]) )
					{
						$accountOpenedCount[$_mailerTracking->account_id] += 1;
					}
					else
					{
						$accountOpenedCount[$_mailerTracking->account_id] = 1;
					}
				}
				
			}
			
			$_mailerTrackingsAll = $campaignModel->mailerContentTrackings( );
			
			foreach( $_mailerTrackingsAll as $__mailerTrackingsAll )
			{
				$mailerContentTrackingIds[] = $__mailerTrackingsAll->id;
			}
			
			$params2['condition'] = $params2['condition'].' AND mailer_id = '.$mailerContentCadenceModel->id;

			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params2 );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);

				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
					{
						$emailContactModel = EmailContact::model()->findByPk( $mailerContentTrackingLink->email_contact_id );
						
						if( $emailContactModel->subscription_status == EmailContact::SUBSCRIPTION_STATUS_UNSUBSCRIBED )
						{
							if( !isset($accountUnsubsubscribeCount[$mailerContentTrackingLink->account_id]) )
								$accountUnsubsubscribeCount[$mailerContentTrackingLink->account_id] = array($mailerContentTrackingLink->email_contact_id);
							else
								$accountUnsubsubscribeCount[$mailerContentTrackingLink->account_id] = array_merge($accountUnsubsubscribeCount[$mailerContentTrackingLink->account_id], array($mailerContentTrackingLink->email_contact_id));	
						}
					}
				}
				else
				{
					echo $mailerContentTrackingLink->mailer_content_tracking_id;
				}
			}
		}
		
		$accountModels = Account::model()->active()->findAll();
		$accountOpenedEmailsCount = array();
		$unsubscribeEmailsCount = array();
		$sentEmailsCount = array();
		$agentNames = array();
		
		foreach( $accountModels as $accountModel )
		{
			$agentNames[$accountModel->id] = $accountModel->getFullName();
			
			if( isset( $accountOpenedCount[$accountModel->id] ) )
				$accountOpenedEmailsCount[$accountModel->id] = $accountOpenedCount[$accountModel->id];
			else
				$accountOpenedEmailsCount[$accountModel->id] = 0;
			
			if( isset( $accountUnsubsubscribeCount[$accountModel->id] ) )
				$unsubscribeEmailsCount[$accountModel->id] = count(array_unique($accountUnsubsubscribeCount[$accountModel->id]));
			else
				$unsubscribeEmailsCount[$accountModel->id] = 0;
			
			if( isset( $accountSentCount[$accountModel->id] ) )
				$sentEmailsCount[$accountModel->id] = $accountSentCount[$accountModel->id];
			else
				$sentEmailsCount[$accountModel->id] = 0;
			
			
		}
		
		$returnArray = array( 'agentNames' => $agentNames, 
							  'sentEmails' => $sentEmailsCount, 
							  'openedEmails' => $accountOpenedEmailsCount, 
							  'unsubcribed' => $unsubscribeEmailsCount );
		
		// Dev::pv( $agentNames );
		
		// echo 'Sent Emails';
		// Dev::pv( $sentEmailsCount );
		
		// echo 'Opened Emails';
		// Dev::pv( $accountOpenedEmailsCount );
		
		// echo 'Unsubscribed';
		// Dev::pv( $unsubscribeEmailsCount );
		
		
		exit(json_encode($returnArray));
	}
	
	public function actionGetActiveCampaign()
	{
		// $activeCampaigns =  ActiveEmailCampaign::model()->cadence()->findAll();
		$mailerContentCadenceModels = MailerContent::model()->cadence()->findAll();
		$mailerContentCadenceArr = array();
		foreach ( $mailerContentCadenceModels as $_mailerContentCadenceModelKey => $mailerContentCadenceModel )
		{
			$mailerContentCadenceArr[$mailerContentCadenceModel->id] = $mailerContentCadenceModel->outbound_name;
		}
		exit(json_encode($mailerContentCadenceArr));
	}


	/* CADENCE REPORT */
	public function actionCadenceReportSent( $mailerId, $startDate, $endDate )
	{
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$this->pageTitle = 'Sent Emails List';
		$this->reportType = 'mailer';
		
		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
				
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_created BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		
		$params['scopes'] = array('liveTracking');
		$contentLinkEngagements = array();
		$campaignModel = MailerContent::model()->findByPk($mailerId);
		
		$this->pageSubTitle = 'Emailer: '.$campaignModel->outbound_name.' - '.$campaignModel->subject;
		
		$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );

		foreach ( $mailerTrackingsAll as $_mailerTracking )
		{
			$contentLinkEngagements[] = $_mailerTracking;
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 
			) 
		);
		
	}
	
	public function actionCadenceReportOpened( $mailerId, $startDate, $endDate )
	{
		$this->pageTitle = 'Opened Emails List';
		$this->reportType = 'mailer';

		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_opened >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_opened <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		
		$params['scopes'] = array('liveTracking');
		$contentLinkEngagements = array();
		$campaignModel = MailerContent::model()->findByPk($mailerId);
		
		$this->pageSubTitle = 'Emailer: '.$campaignModel->outbound_name.' - '.$campaignModel->subject;
		
		$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
		
		foreach ( $mailerTrackingsAll as $_mailerTracking )
		{
			if ( $_mailerTracking->opened_flag == 1 )
			{
				$contentLinkEngagements[] = $_mailerTracking;
			}
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 'engagement' => 'opened',
			) 
		);
	}
	
	public function actionCadenceReportUnsubscribed( $mailerId, $startDate, $endDate )
	{
		$this->pageTitle = 'Unsubscribed List';
		$this->reportType = 'mailer';
		
		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$campaignModel = MailerContent::model()->findByPk($mailerId);
		$this->pageSubTitle = 'Emailer: '.$campaignModel->outbound_name.' - '.$campaignModel->subject;
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$contentLinkEngagements = array();
		
		$_params = array( 'condition' => 'mailer_id = :mailer_id ',
			 'params' => array( ':mailer_id' => $campaignModel->id )
		   );
		$_params['scopes'] = array('liveTracking');
		$mailerContentTrackingIds = array();
		
		$mailerTrackings = $campaignModel->mailerContentTrackings( $_params );
		foreach ( $mailerTrackings as $trackingData )
		{
			$mailerContentTrackingIds[] = $trackingData->id;
		}
		
		$params['params'][':mailer_id'] = $campaignModel->id;
		
		$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
		
		foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
		{
			if( $mailerContentTrackingLink->mailer_content_link )
				$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
			
			if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
			{
				$emailContactModel = EmailContact::model()->findByPk( $mailerContentTrackingLink->email_contact_id );
					
				if( $emailContactModel->subscription_status == EmailContact::SUBSCRIPTION_STATUS_UNSUBSCRIBED )
				{
					if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
					{
						$contentLinkEngagements[$mailerContentTrackingLink->email_contact_id] = $mailerContentTrackingLink;
					}
				}
			}
		}
			
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
															'pageSize'=>100,
														),
												)
				);
				
				
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 
			) 
		);

	}
	
	/* AGENT ACTIVITY */
	public function actionCadenceAgentReportSent( $agentId, $startDate, $endDate )
	{
		$this->pageTitle = 'Sent Emails List';
		$this->reportType = 'agent';
		
		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_created BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		
		$params['scopes'] = array('liveTracking');
		
		// filter by agent
		$params['condition'] = $params['condition'].' AND account_id = :account_id';
		$params['params'] = array_merge( $params['params'], array(':account_id' => $agentId) );
		
		$accountModel = Account::model()->findByPk($agentId);
		$this->pageSubTitle = 'Agent Name: '.$accountModel->getFullName();
		
		$contentLinkEngagements = array();
		
		$cadenceEmailerIds = MailerContent::getCadenceEmailerIds();
		foreach( $cadenceEmailerIds as $cadenceEmailerId )
		{
			$campaignModel = MailerContent::model()->findByPk($cadenceEmailerId);
			$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );

			foreach ( $mailerTrackingsAll as $_mailerTracking )
			{
				$contentLinkEngagements[] = $_mailerTracking;
			}
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 
			) 
		);
		
	}
	
	public function actionCadenceAgentReportOpened( $agentId, $startDate, $endDate )
	{
		$this->pageTitle = 'Opened Emails List';
		$this->reportType = 'agent';
		
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		$params = array( 'scopes' => array('liveTracking') );

		if( $startDate AND $endDate )
		{
			$params['condition'] = 'date_opened BETWEEN :start_date AND :end_date ';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = 'date_opened >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = 'date_opened <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}
		
		$params['scopes'] = array('liveTracking');
		
		// filter by agent
		$params['condition'] = $params['condition'].' AND account_id = :account_id';
		$params['params'] = array_merge( $params['params'], array(':account_id' => $agentId) );
		
		$accountModel = Account::model()->findByPk($agentId);
		$this->pageSubTitle = 'Agent Name: '.$accountModel->getFullName();
		
		$contentLinkEngagements = array();
		
		$cadenceEmailerIds = MailerContent::getCadenceEmailerIds();
		foreach( $cadenceEmailerIds as $cadenceEmailerId )
		{
			$campaignModel = MailerContent::model()->findByPk($cadenceEmailerId);
			$mailerTrackingsAll = $campaignModel->mailerContentTrackings( $params );
			
			foreach ( $mailerTrackingsAll as $_mailerTracking )
			{
				if ( $_mailerTracking->opened_flag == 1 )
				{
					$contentLinkEngagements[] = $_mailerTracking;
				}
			}
		}
		
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
			'pageSize'=>100,
		)));
		
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 'engagement' => 'opened',
			) 
		);
	}
	
	public function actionCadenceAgentReportUnsubscribed( $agentId, $startDate, $endDate )
	{
		$this->pageTitle = 'Unsubscribed List';
		$this->reportType = 'agent';
		
		$startDate = date('Y-m-d', strtotime($startDate) );
		$endDate = date('Y-m-d', strtotime($endDate) );
		$startDate = $startDate.' 00:00:01';
		$endDate = $endDate.' 23:59:59';
		
		$this->activeSideNav = array('cadence_dashboard');
		$this->openParentNav = array('manage_cadence');
		
		
		/* Date Filter */
		if( $startDate AND $endDate )
		{
			$params['condition'] = '( date_created BETWEEN :start_date AND :end_date )';
			$params['params'] = array( ':start_date'=> $startDate , ':end_date' => $endDate );
		}
		else if ( $startDate )
		{
			$params['condition'] = '  date_created >= :start_date';
			$params['params'] = array( ':start_date'=> $startDate );
		}
		else if ( $endDate )
		{
			$params['condition'] = '  date_created <= :end_date';
			$params['params'] = array( ':end_date'=> $endDate );
		}

		$params['group'] = 'date_created';

		
		$unsubCount = array();

		$mailerContentIds = MailerContent::getCadenceEmailerIds();
		
		$params['condition'] .= ' AND mailer_id = :mailer_id ';
		
		$accountModel = Account::model()->findByPk($agentId);
		$this->pageSubTitle = 'Agent Name: '.$accountModel->getFullName();
		
		$contentLinkEngagements = array();
		
		foreach( $mailerContentIds as $mailerContentId )
		{
			$campaignModel = MailerContent::model()->findByPk($mailerContentId);
			
			$_params = array( 'condition' => 'mailer_id = :mailer_id ',
					 'params' => array( ':mailer_id' => $campaignModel->id )
				   );
			$_params['scopes'] = array('liveTracking');
			
			// filter by agent
			$_params['condition'] = $_params['condition'].' AND account_id = :account_id';
			$_params['params'] = array_merge( $_params['params'], array(':account_id' => $agentId) );
			
			$mailerContentTrackingIds = array();
			
			$mailerTrackings = $campaignModel->mailerContentTrackings( $_params );
			foreach ( $mailerTrackings as $trackingData )
			{
				$mailerContentTrackingIds[] = $trackingData->id;
			}
			
			$params['params'][':mailer_id'] = $campaignModel->id;
			
			$mailerContentTrackingLinks = MailerContentTrackingLink::model()->findAll( $params );
			
			foreach ( $mailerContentTrackingLinks as $mailerContentTrackingLink )
			{
				if( $mailerContentTrackingLink->mailer_content_link )
					$trackingLinkVar = MailerContentLinkVar::model()->findByPk($mailerContentTrackingLink->mailer_content_link);
				
				if ( in_array($mailerContentTrackingLink->mailer_content_tracking_id, $mailerContentTrackingIds) )
				{
					$emailContactModel = EmailContact::model()->findByPk( $mailerContentTrackingLink->email_contact_id );
						
					if( $emailContactModel->subscription_status == EmailContact::SUBSCRIPTION_STATUS_UNSUBSCRIBED )
					{
						if ( $trackingLinkVar->link_variable_name == 'unsubscribe_link' )
						{
							$contentLinkEngagements[$mailerContentTrackingLink->mailer_content_link] = $mailerContentTrackingLink;
							// Dev::pv($contentLinkEngagements);
						}
						
					}
				}
			}
			
		}
		
		// echo 'xxxxxxxxxxxxxxxxx';
		// Dev::pvx($contentLinkEngagements);
		$dataProvider = new CArrayDataProvider($contentLinkEngagements, array( 'pagination'=>array(
					'pageSize'=>100,
				)));
		$this->render('cadenceReport', array( 'dataProvider' => $dataProvider, 
			) 
		);

	}

	public function actionImage($name) {
		$name = 'images/woocommerce-placeholder.png';
		$fp = fopen($name, 'rb');

		// send the right headers
		header("Content-Type: image/png");
		header("Content-Length: " . filesize($name));

		// dump the picture and stop the script
		fpassthru($fp);
		exit;
	}
}