<?php

class SettingsController extends Controller
{
	public $layout = 'dashboard';
	public $activeSideNav = array('manage_settings');
	public $pageTitle = 'Settings';

	public function actionIndex()
	{
		$settingColumnMapping = SettingColumnMapping::model()->find(array(
			'condition' => 'status = 1'
		));

		$settingDefaultValue = SettingDefaultValue::model()->find(array(
			'condition' => 'status = 1'
		));

		if (!$settingColumnMapping) {
			$settingColumnMapping = new SettingColumnMapping;
		}
		
		if (!$settingDefaultValue) {
			$settingDefaultValue = new SettingDefaultValue;
		}

		if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			$error = 0;

			if (isset($_POST['SettingColumnMapping'])) {
				$settingColumnMapping->attributes = $_POST['SettingColumnMapping'];

				if (!$settingColumnMapping->save(false)) {
					$error++;
				}

			} else if (isset($_POST['SettingDefaultValue'])) {
				$settingDefaultValue->attributes = $_POST['SettingDefaultValue'];

				if (!$settingDefaultValue->save(false)) {
					$error++;
				}
			}

			if ($error <= 0) {
				Yii::app()->user->setFlash('success', 'Changes successfully saved.');
				$this->refresh();
			} else {
				Yii::app()->user->setFlash('danger', 'Changes failed to saved.');
			}
		}

		$this->render('index', array(
			'settingColumnMapping' => $settingColumnMapping,
			'settingDefaultValue' => $settingDefaultValue
		));
	}

	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}