<?php
class GoogleMerchantApiController extends Controller
{
	public function actionCheckStatus(){
		//check if cron switch is on
        $cronState = Yii::app()->db->createCommand('SELECT `value`, `serialized_options` FROM gss_system_settings WHERE `key` = "googleMerchantStatusCheckCron"')->queryRow();
        // If nothing to process
        if( $cronState['value'] == 0 ) exit('CRON IS OFF');

        $cronArray = unserialize($cronState['serialized_options']);
        //token for next page
        $sbbPageToken = '';
        $gssPageToken = '';
        if(isset($cronArray['sbbPageToken']))
        	$sbbPageToken = $cronArray['sbbPageToken'];
        if(isset($cronArray['gssPageToken']))
        	$gssPageToken = $cronArray['gssPageToken'];

        if($_GET['process'] == 'sbb'){
        	$products = Product::model()->findAll(array(
        		'condition' => 'platform_3_rest_status = '.Product::GOOGLE_MERCHANT_STATUS_PENDING.' and platform_3_rest_status_checked = '.Product::GOOGLE_MERCHANT_STATUS_NOT_CHECKED.' and platform_3_id != ""',
        	));

        	if(!empty($products)){
        		try{
	        		//get the product sbb google merchant id
	        		$sbbProduct = [];
		        	foreach ($products as $product) {
		        		$sbbProduct[$product->platform_3_id] = $product->id;
		        	}

		        	//get google merchant product sbb
		        	$sbbGoogleMerchant = new GoogleMerchant;
		        	$sbbGoogleMerchantProducts = $sbbGoogleMerchant->batchGetProductStatus($sbbPageToken);

		        	foreach ($sbbGoogleMerchantProducts->resources as $key => $sbbGoogleMerchantProduct) {
		        		if(isset($sbbProduct[$sbbGoogleMerchantProduct->productId])){
		        			$productUpdate = Product::model()->findByPk($sbbProduct[$sbbGoogleMerchantProduct->productId])

		        			//get the status of the product on google merchant
		        			$sbbProductStatus = Product::GOOGLE_MERCHANT_STATUS_APPROVED;
		        			foreach ($sbbGoogleMerchantProduct->destinationStatuses as $key => $destinationStatus) {
		        				if($destinationStatus->status == 'disapproved'){
		        					$sbbProductStatus = Product::GOOGLE_MERCHANT_STATUS_DISAPPROVED;
		        				}

		        				if($destinationStatus->status == 'pending'){
		        					$sbbProductStatus = Product::GOOGLE_MERCHANT_STATUS_PENDING;
		        				}
		        			}

		        			$productUpdate->platform_3_rest_status = $sbbProductStatus;
		        			$productUpdate->platform_3_rest_status_checked = Product::GOOGLE_MERCHANT_STATUS_CHECKED;
		        		}
		        	}
		        	$cronArray['sbbPageToken'] = $sbbGoogleMerchantProducts->nextPageToken;
	                Yii::app()->db->createCommand()->update('gss_system_settings', 
	            	array(
	                	'serialized_options' => serialize($cronArray),
	            	), '`key` = "googleMerchantStatusCheckCron"');
		        }catch(Exception $e){
		        	$errorMsg = date('m-d-Y H:i:s'). ' SBB Google Merchant Status check Error:'.PHP_EOL.
		        			$e->getMessage();
		        	error_log($errorMsg, 3, Yii::app()->baseUrl."/logs/sbbGoogleMerchantError.log");
		        }
	        }else{
	        	//update system setting for google merchant status check cron
	        	$cronArray['sbbPageToken'] = '';
                Yii::app()->db->createCommand()->update('gss_system_settings', 
            	array(
                	'serialized_options' => serialize($cronArray),
            	), '`key` = "googleMerchantStatusCheckCron"');

                //update checked but still pending product
                Yii::app()->db->createCommand()->update('{{product}}', 
            	array(
                	'platform_3_rest_status_checked' => Product::GOOGLE_MERCHANT_STATUS_NOT_CHECKED,
            	), '`platform_3_rest_status_checked` = '.Product::GOOGLE_MERCHANT_STATUS_CHECKED.' AND platform_3_rest_status = '.Product::GOOGLE_MERCHANT_STATUS_PENDING);
	        }
        }

        if($_GET['process'] == 'gss'){
        	$products = Product::model()->findAll(array(
        		'condition' => 'platform_4_rest_status = '.Product::GOOGLE_MERCHANT_STATUS_PENDING.' and platform_4_rest_status_checked = '.Product::GOOGLE_MERCHANT_STATUS_NOT_CHECKED.' and platform_4_id != ""',
        	));
        	
        	if(!empty($products)){
        		try{
	        		//get the product gss google merchant id
	        		$gssProduct = [];
		        	foreach ($products as $product) {
		        		$gssProduct[$product->platform_4_id] = $product->id;
		        	}

		        	//get google merchant product gss
		        	$gssGoogleMerchant = new GoogleMerchantGSS;
		        	$gssGoogleMerchantProducts = $gssGoogleMerchant->batchGetProductStatus($gssPageToken);

		        	foreach ($gssGoogleMerchantProducts->resources as $key => $gssGoogleMerchantProduct) {
		        		if(isset($gssProduct[$gssGoogleMerchantProduct->productId])){
		        			$productUpdate = Product::model()->findByPk($gssProduct[$gssGoogleMerchantProduct->productId])

		        			//get the status of the product on google merchant
		        			$gssProductStatus = Product::GOOGLE_MERCHANT_STATUS_APPROVED;
		        			foreach ($gssGoogleMerchantProduct->destinationStatuses as $key => $destinationStatus) {
		        				if($destinationStatus->status == 'disapproved'){
		        					$gssProductStatus = Product::GOOGLE_MERCHANT_STATUS_DISAPPROVED;
		        				}

		        				if($destinationStatus->status == 'pending'){
		        					$gssProductStatus = Product::GOOGLE_MERCHANT_STATUS_PENDING;
		        				}
		        			}

		        			$productUpdate->platform_4_rest_status = $gssProductStatus;
		        			$productUpdate->platform_4_rest_status_checked = Product::GOOGLE_MERCHANT_STATUS_CHECKED;
		        		}
		        	}
		        	$cronArray['gssPageToken'] = $gssGoogleMerchantProducts->nextPageToken;
	                Yii::app()->db->createCommand()->update('gss_system_settings', 
	            	array(
	                	'serialized_options' => serialize($cronArray),
	            	), '`key` = "googleMerchantStatusCheckCron"');
		        }catch(Exception $e){
		        	$errorMsg = date('m-d-Y H:i:s'). ' GSS Google Merchant Status Check Error:'.PHP_EOL.
		        			$e->getMessage();
		        	error_log($errorMsg, 3, Yii::app()->baseUrl."/logs/gssGoogleMerchantError.log");
		        }
	        }else{
	        	//update system setting for gss token
	        	$cronArray['gssPageToken'] = '';
                Yii::app()->db->createCommand()->update('gss_system_settings', 
            	array(
                	'serialized_options' => serialize($cronArray),
            	), '`key` = "googleMerchantStatusCheckCron"');

                //update checked but still pending product
                Yii::app()->db->createCommand()->update('{{product}}', 
            	array(
                	'platform_4_rest_status_checked' => Product::GOOGLE_MERCHANT_STATUS_NOT_CHECKED,
            	), '`platform_4_rest_status_checked` = '.Product::GOOGLE_MERCHANT_STATUS_CHECKED.' AND platform_4_rest_status = '.Product::GOOGLE_MERCHANT_STATUS_PENDING);
	        }
        }
	}
}