<?php

class AccountController extends Controller
{
	public $layout = 'dashboard';
	public $activeSideNav = array('manage_account');
	public $pageTitle = 'Account';
	
	public function filters()
	{
		return array(
			'accessControl', 
		);
	}

	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('index', 'view', 'saveData'),
				'users' => array('@'),
			),
			array(
				'deny',
				'users' => array('*'),
			),
		);
	}

	public function actionIndex() {
		$authAccount = Yii::app()->user;

		$account = $authAccount->account;

		if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			$account->username = $_POST['Account']['username'];
			$account->current_password = $_POST['Account']['current_password'];
			$account->new_password = $_POST['Account']['new_password'];

			if ($account->validate()) {
				$account->password = $account->hashPassword($account->new_password, $account->username);

				if ($account->save(false)) { 	
					Yii::app()->user->setFlash('success', 'Account details successfuly saved.');
					$this->refresh();
				} else {
					Yii::app()->user->setFlash('danger', 'Account details failed to saved.');
				}
			} else {
				$message = '<p>Please fixed following errors:<p><ul>';

				foreach ($account->getErrors() as $errors) {
					foreach ($errors as $error) {
						$message .= '<li>'. $error .'</li>';
					}
				}

				Yii::app()->user->setFlash('danger', $message);
			}
		}

		return $this->render('index', [
			'account' => $account 
		]);
	}
	
	// public function actionIndex($searchQuery = '')
	// {
	// 	$accountModel = new Account;
	// 	$accountUserInfoModel = new UserInfo;
		
	// 	$criteria = new CDbCriteria;
	// 	if ( !empty($searchQuery) )
	// 	{
	// 		$criteria->mergeWith(array(
	// 			'condition' => 'username LIKE "%'.addslashes($searchQuery).'%"',
	// 		));
	// 	}
	// 	$accountModels = Account::model()->existing()->findAll($criteria);
	// 	$dataProvider = new CArrayDataProvider($accountModels,array(
	// 		'pagination'=>array(
	// 			'pageSize' => 20,
	// 		)
	// 	));
		
	// 	$this->render('index',array(
	// 		'dataProvider' => $dataProvider,
	// 		'accountModel' => $accountModel,
	// 		'accountUserInfoModel' => $accountUserInfoModel,
	// 		'accountModels' => $accountModels,
	// 		'searchQuery' => $searchQuery
	// 	));
	// }
	
	public function actionView($id, $searchQuery = '')
	{
		// not yet complete
		$clientModel = new Client;
		$clientModels = Client::model()->existing()->findAll();
		$dataProvider = new CArrayDataProvider($clientModels,array(
			'pagination'=>array(
				'pageSize' => 20,
			)
		));
		
		$this->render('index',array(
			'dataProvider' => $dataProvider,
			'clientModel' => $clientModel,
			'clientModels' => $clientModels,
			'searchQuery' => $searchQuery
		));
	}
	
	public function actionSaveData( $ajax = false )
	{
		$response = array(
			'status' => 'warning',
			'message' => 'Unauthorized access',
			'redirect' => array('account/index')
		);
		
		if ( isset($_POST['Account']) )
		{
			$model = Account::model()->findByPk($_POST['Account']['id']);
			if ( $model === null )
			{
				$model = new Account;
				$userInfomodel = new UserInfo;
				$response['message'] = 'New account has been successfully added';
			}
			else
			{
				$userInfomodel = $model->userInfo;
				$model->current_password = $model->password;
				$response['message'] = 'Selected record has been successfully updated';
			}
			
			$model->attributes = $_POST['Account'];
			$model->confirm_password = $_POST['Account']['confirm_password'];
			
			$userInfomodel->attributes = $_POST['UserInfo'];
			
			
			if ( $model->status == Account::STATUS_DELETED )
				$response['message'] = 'The record has been successfully deleted';
			
			$isValid = true;
			if( !$model->validate() )
				$isValid = false;
			
			
			
			if( !$userInfomodel->validate() )
				$isValid = false;
			
			if ( $isValid )
			{	
				if( !empty($_POST['Account']['confirm_password']) )
					$model->password = $model->hashPassword($model->password, $model->username);
				
				if ( $model->save(false) )
				{
					$userInfomodel->user_id = $model->id;
					if( $userInfomodel->save(false) )
						$response['status'] = 'success';
				}
				else
				{
					$response['status'] = 'danger';
					$response['message'] = 'Please fix the following errors: <Br /> '. ZCommon::parseError($model->getErrors());
				}
			}
			else
			{
				$response['message'] = 'Please fix the following errors: <Br /> '. ZCommon::parseError( array_merge( $model->getErrors(), $userInfomodel->getErrors() ) ) ;
			}
		}
		
		if ( $ajax )
		{
			echo CJSON::encode($response);
			Yii::app()->end();
		}
		else
		{
			Yii::app()->user->setFlash($response['status'], $response['message']);
			$this->redirect($response['redirect']);
		}
	}
}
