<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{

	private $_id;
	
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate()
	{
		$username=strtolower($this->username);
        $account=Account::model()->active()->find('LOWER(username)=?',array($username));

 	    if($account===null or $account->status == 3)
            $this->errorCode=self::ERROR_USERNAME_INVALID;
        else if(!$account->validatePassword($this->password))
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else
        {
            $this->_id=$account->id;
            $this->username=$account->username;
            $this->errorCode=self::ERROR_NONE;
			Yii::app()->user->setState('firstName', $account->userInfo->first_name);
			Yii::app()->user->setState('lastName', $account->userInfo->last_name);
			Yii::app()->user->setState('type', $account->account_type);
        }
        return $this->errorCode==self::ERROR_NONE;
		
	}
}
