<?php
// new widget by DL111914 // needs included css files and js files and contoller file
//upload_max_filesize=99M
//post_max_size=99M
//or whatever is appropriate
class Uploader extends CWidget
{
	public $allowedFileTypes = '7'; // 1 = image, 2 = video, 3 = audio, 4 = application, 5 = text, 6 = x-word, 7 = all, 8 = csv
	public $maxFileCount = 'null';// null is set to unlimited uploads
	public $submitContainer = 'data-form';	// form id
	public $preloadItems = array();	
	public $classContainer = '';	
	public $inputName = 'file';	
	public $accountID = null;
	
	private $controllerUrl;
	private $maxFileSizeAllowed = 10;//mb
	
	public function init()
	{	
		if($this->allowedFileTypes == Fileupload::FILE_TYPE_ALL)
		{
			$fileTypes = explode(',',Fileupload::FILE_TYPE_IMAGE_LIST);
			$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_VIDEO_LIST));
			$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_AUDIO_LIST));
			$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_APPLICATION_LIST));
			$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_TEXT_LIST));
			$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_X_WORLD_LIST));
			$fileTypes = implode(',',$fileTypes);			
			$this->allowedFileTypes = $fileTypes;
		}
		else
		{
			$allowedFileTypes = explode(',',$this->allowedFileTypes);
			$fileTypes = array();
			foreach($allowedFileTypes as $chunk)
			{
				switch($chunk)
				{
					case Fileupload::FILE_TYPE_IMAGE:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_IMAGE_LIST));
					break;
					case Fileupload::FILE_TYPE_VIDEO:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_VIDEO_LIST));
					break;
					case Fileupload::FILE_TYPE_AUDIO:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_AUDIO_LIST));
					break;		
					case Fileupload::FILE_TYPE_APPLICATION:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_APPLICATION_LIST));
					break;	
					case Fileupload::FILE_TYPE_TEXT:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_TEXT_LIST));
					break;			
					case Fileupload::FILE_TYPE_X_WORLD:
						$fileTypes = array_merge($fileTypes,explode(',',Fileupload::FILE_TYPE_X_WORLD_LIST));
					break;
				}			
			}
			$fileTypes = implode(',',$fileTypes);				
			$this->allowedFileTypes = $fileTypes;
		}
		if($this->accountID == null)
		{
			$this->controllerUrl = Yii::app()->createAbsoluteUrl('uploader/index');
		}
		else
		{
			$this->controllerUrl = Yii::app()->createAbsoluteUrl('uploader/index').'?account_id='.$this->accountID;
		}
		
		if(empty($this->maxFileSizeAllowed))
			$this->maxFileSizeAllowed = preg_replace("/[^0-9,.]/", "", LookUp::getMaxFileSize());
	}
	
	public function run()
	{		
		$this->render('uploader/index', array(
			'preloadItems' => $this->preloadItems,
			'inputName' => $this->inputName,
			'submitContainer' => $this->submitContainer,
			'allowedFileTypes' => $this->allowedFileTypes,
			'maxFileCount' => $this->maxFileCount,
			'controllerUrl' => $this->controllerUrl,
			'maxFileSizeAllowed' => $this->maxFileSizeAllowed,
			'classContainer' => $this->classContainer
		));
	}
}
?>
