<?php
class EmailWrapper
{
	private $_sender;
	private $_receivers;
	private $_subject;
	private $_message;
	private $_attachment = null;
	private $_emailType;
	private $_errors;
	private $token = Yii::app()->params->SENDINBLUE_KEY; 
	
	// private $token = 'Z1hmcaG5zJBfSXvj'; 
	
	// private $token = 'SfAg3QvI9sV7Ut0p'; //reynan
	
	private $emailerType = 2;
	CONST EMAILER_TYPE_SENDINBLUE = 1;
	CONST EMAILER_TYPE_SWITFMAILER = 2;
	
	public function __construct()
	{
		
		// $this->_sender = array('aaron@cloudagesolutions.com' => 'Aaron Krotman');
		$this->_sender = array('ed@tryretain.com' => 'Ed Wooller');
		if( $this->emailerType == self::EMAILER_TYPE_SENDINBLUE )
		{	
			$extPath = Yii::getPathOfAlias('ext.sendinblue');
			include_once($extPath . DIRECTORY_SEPARATOR . 'Mailin.php');
				
			// $this->_sender = array('aaron@cloudagesolutions.com' , 'Aaron Krotman');
			$this->_sender = array('ed@tryretain.com', 'Ed Wooller');

		}
		
		// Load swift mailer library if needed
		/*if (!defined('SWIFT_LIB_DIRECTORY'))
		{
			$phpExcelPath = Yii::getPathOfAlias('ext.swiftMailer.lib');
			include($phpExcelPath . DIRECTORY_SEPARATOR . 'swift_required.php');
		}*/

		// $this->_sender = array('info@cloudagesolutions.com' => 'Cloudage');
		// $this->_sender = array('ricka.zeniark@gmail.com' => 'Cloudage');
		$this->_subject = 'Try RetainInternational';
		$this->_errors = array();
		$this->_emailType = 'text/html';
	}
		
	public function setMessage($message)
	{
		$this->_message = $message;
	}
		
	public function setReceivers($receivers)
	{
		$this->_receivers = $receivers;
	}
	
	public function setSender($sender)
	{
		$this->_sender = $sender;
	}
	
	public function setSubject($subject)
	{
		$this->_subject = $subject;
	}
	
	public function getSubject()
	{
		return $this->_subject;
	}
	
	public function setAttachment($attachment)
	{
		$this->_attachment = $attachment;
	}
	
	public function getErrors()
	{
		return $this->_errors;
	}
	
	public function loadTemplate($template = null)
	{
		switch ($template)
		{
			case 'default':
				$templateBody = 
					sprintf('
									<table width="650" cellspacing="0" cellpadding="0" border="0" align="center" style="border:1px solid #cccccc;">
										<tbody>
											<tr>
												%s
											</tr>
										</tbody>
									</table>
					', $this->_message);
				break;
			
			case 'blank':
				$templateBody = $this->_message;
				break;
			
			default:
				$templateBody = $this->_message;
		}
		
		return $templateBody;
	}
	
	public function sendMessage($template = null)
	{ 
		//return true;
		$this->validateAttributes();
		
		if (empty($this->_errors))
		{
			
			if( $this->emailerType == self::EMAILER_TYPE_SENDINBLUE )
			{
				$mailin = new Mailin('https://api.sendinblue.com/v2.0', $this->token);

				// $receivers = array_combine($this->_receivers, $this->_receivers);
				// foreach($this->_receivers as $key => $val) {
					// $receivers[$val]=$val;
				// }
				$data = array(
					'to' => $this->_receivers,	
					// 'to' => $receivers,	
					'from' => $this->_sender,
					'subject' => $this->_subject,
					'html' => $this->loadTemplate($template),
				);
				
				$result = $mailin->send_email($data);
				
				if( $result['code'] !=  'success')
				{
					// Dev::pv($this->_sender);
					// Dev::pvx($result);
					$this->_errors[] = 'Sorry but an error has occurred processing the email message';
					// $this->_errors[] = $result;
					return false;
				}
				else
				{
					// Dev::pvx($result);
					return true;
				}
			}
			elseif( $this->emailerType == self::EMAILER_TYPE_SWITFMAILER )
			{
				// $transport = Swift_SmtpTransport::newInstance('localhost', 25);
				// $transport = Swift_SmtpTransport::newInstance('smtpout.asia.secureserver.net', 25)
				/*$transport = Swift_SmtpTransport::newInstance('smtpout.secureserver.net', 25)
					// ->setUsername('info1@zaccessdomain.com')
					// ->setUsername('info2@zaccessdomain.com')
					->setUsername('summitig6@zaccessdomain.com')
					// ->setUsername('info4@zaccessdomain.com')
					->setPassword('12345')
				;*/

				// $transport = Swift_SmtpTransport::newInstance('localhost', 2525);
				
				$transport = Swift_SmtpTransport::newInstance('smtpout.secureserver.net', 25)
					// ->setUsername('info1@zaccessdomain.com')
					// ->setUsername('info2@zaccessdomain.com')
					->setUsername('capitolma1@zaccessdomain.com')
					// ->setUsername('info4@zaccessdomain.com')
					->setPassword('12345')
				;
				
				
				
			/* 	
				$transport = Swift_SmtpTransport::newInstance('email-smtp.us-east-1.amazonaws.com',587,'tls')
							->setUsername('AKIAJ3J7UAJBNE56ED6A')
							->setPassword('BEigQtivEmXse3X31uhi+p9Qgv3Di+FT7T5JD3Q7TXy8');
			*/
				$mailer = Swift_Mailer::newInstance($transport);
				
				$message = Swift_Message::newInstance()
					->setSubject($this->_subject)
					->setFrom($this->_sender)
					->setTo($this->_receivers)
					// ->setReturnPath(	'noreply@tryretain.com')
					// ->setBcc(array('francis.zeniark@gmail.com'))
					->setBody($this->loadTemplate($template), $this->_emailType);
				
				if(!empty($this->_attachment))
					$message->attach(Swift_Attachment::fromPath($this->_attachment));

				if ($mailer->send($message))
				{
					return true;
				}
				else
				{
					$this->_errors[] = 'Sorry but an error has occurred processing the email message';
					return false;
				}
			}
		}
		else
		{
			return false;
		}
	}
	
	public function validateAttributes()
	{
		if ($this->_receivers === null || empty($this->_receivers))
		{
			$this->_errors[] = 'Please set at least 1 receiver';
		}
		
		if ($this->_message === null)
		{
			$this->_errors[] = 'Please enter a message for the email';
		}
	}
}
?>
