<?php
class ZenCurl
{

	private $_options = array();
	private $_response;
	private $_jsonData;
	private $_url;
	private $_postData;
	private $_getData;
	private $_verbose = 0;
	private $_status;


	private $_ch;

	function __construct($url) {

		$this->_url = $url;

		$this->_options = array(
			CURLOPT_RETURNTRANSFER => true, 
			CURLOPT_HEADER => false,
		); 

	}

	public function execute($options = array()) {



		if(is_array($options) && count($options) > 0)
			$this->_options = $options;

		if($this->_postData !== null && count($this->_postData) > 0) {

			$this->_options[CURLOPT_POSTFIELDS] = $this->_postData;
			$this->_options[CURLOPT_POST] = 1;

		}

		$this->_options[CURLOPT_URL] = $this->getUrl();
		$this->_options[CURLOPT_VERBOSE] = $this->_verbose;

		$this->_ch = curl_init();
		curl_setopt_array($this->_ch, $this->_options);
		
		$this->_response  = curl_exec($this->_ch);

		$this->setStatus('http_code', curl_getinfo($this->_ch, CURLINFO_HTTP_CODE));

		curl_close($this->_ch);

		/*$ch = @curl_init();
		$endpoint = $this->getUrl();
		@curl_setopt($ch, CURLOPT_URL, $endpoint);
		@curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		    'Content-Type: application/json'
		));
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response    = @curl_exec($ch); //Log the response from HubSpot as needed.
		$status_code = @curl_getinfo($ch, CURLINFO_HTTP_CODE); //Log the response status code
		@curl_close($ch);
		echo $status_code . " " . $response;*/

	}

	public function getResponse() {

		return $this->_response;

	}

	public function getJsonData($array = false) {

		$this->_jsonData = json_decode($this->_response, $array);

		return $this->_jsonData;

	}

	public function setOptions($options) {

		$this->_options = $options;

	}

	public function setOption($index, $value) {

		$this->_options[$index] = $value;

	}

	public function setPostData($data) {

		$this->_postData = $data;

	}

	public function getPostData() {

		return $this->_postData;

	}

	public function setGetData($data) {

		$this->_getData = $data;
	}

	public function getGetData() {

		return $this->_getData;

	}

	public function getUrl() {

		$url = $this->_url;

		if($this->_getData !== null && count($this->_getData) > 0) {

			$urlGetParams = '';

			foreach($this->_getData as $key => $value) {

				if(!empty($urlGetParams))
					$urlGetParams .='&';

				$urlGetParams .= $key.'='.$value;

			}

			$url .= '?'.$urlGetParams;

		}

		return $url;

	}

	public function setVerbose($switch) {

		$this->_verbose = $switch;

	}

	public function getVerbose() {

		return $this->_verbose;

	}

	public function setStatus($index, $value) {

		$this->_status[$index] = $value;

	}

	public function getStatus() {

		return $this->_status;

	}

}