<tr>
    <td class="text-left"><?php echo $data->id; ?></td>
    <td><?php echo $data->vendor->name; ?></td>
    <td><small><?php echo $data->fileupload->original_filename; ?></small></td>
    <td class="text-left"><span class="badge"><?php echo (int) $data->total_product; ?></span></td>
    <?php if($data->sync_status == VendorFile::SYNC_STATUS_SYNCING && $data->status == VendorFile::STATUS_FOR_REVIEW): ?>
    <td><span class="label label-primary">Syncing</span></td>
    <?php else: ?>
    <td class="text-left"><?php echo VendorFile::getStatusLabelWithColor($data->status); ?></td>
    <?php endif; ?>
    <td class="text-left"><small><?php echo ZCommon::formatDate($data->fileupload->date_created); ?> (EST)</small></td>
    <td class="text-left">
        <?php
        
        $progressBarParseing = '<div class="progress" style="width: 100%; display: inline-block; margin: 0; padding: 0;">
            <div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px;">
            <span>Parsing Data ('. VendorNormalized::countTotalParsed($data->id) . '/' . $data->total_product . ')</span>
            </div></div>'; 

        $progressBarPending = '<div class="progress" style="width: 100%; display: inline-block; margin: 0; padding: 0;">
            <div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px;">
            <span>Waiting for parsing...</span>
            </div></div>'; 

        $btnReview = CHtml::link('<span class="glyphicon glyphicon-stats"></span> Review', 
               ['reviewVendorSpreadsheet/index', 'id' => $data->id], 
                ['class' => 'btn btn-primary btn-sm text-left', 'title' => 'Review Vendor Spreadsheet']);

        $btnViewPublished = CHtml::link('<span class="fa fa-product-hunt"></span> Published Data', 
               ['product/index', 'search[vendor]' => $data->vendor_id, 'batchId' => 'BTC' . $data->id], 
                ['class' => 'btn btn-primary btn-sm text-left']);

        $btnViewParsed = CHtml::link('<span class="glyphicon glyphicon-stats"></span> Parsed Data', 
               ['reviewVendorSpreadsheet/index', 'id' => $data->id], 
                ['class' => 'btn btn-primary btn-sm text-left']);

        $btnError = CHtml::link('<span class="glyphicon glyphicon-question-sign"></span> View Error', 
            ['reviewVendorSpreadsheet/index', 'id' => $data->id], 
            ['class' => 'btn btn-primary btn-sm btn-view-report-error text-left', 'title' => 'View Vendor Spreadsheet Error', 'data-report' => $data->report]); 
            
        $btnDelete = CHtml::link('<span class="glyphicon glyphicon-remove"></span> Delete', 
            ['uploadVendorSpreadsheet/delete', 'fileId' => $data->id], 
            ['class' => 'btn btn-danger btn-sm delete-file text-left']);    
            
        $btnArchive = CHtml::link('<span class="glyphicon glyphicon-briefcase"></span> Archive', 
            ['uploadVendorSpreadsheet/archive', 'fileId' => $data->id], 
            ['class' => 'btn btn-danger btn-sm archive-file text-left']);   
        
        $btnViewActions = '
             <div class="dropdown" style="display: inline !important;">
              <a class="btn btn-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">View <span class="caret"></span></a>
              <ul class="dropdown-menu">
                <li style="text-align: left !important;">'.  str_replace('btn btn-primary btn-sm', '', $btnViewPublished) .'</li>
                <li style="text-align: left !important;">'.  str_replace('btn btn-primary btn-sm', '',  $btnViewParsed) .'</li>
              </ul>
            </div> 
        ';

        $btnViewActions2 = '
             <div class="dropdown" style="display: inline !important;">
              <a class="btn btn-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">View <span class="caret"></span></a>
              <ul class="dropdown-menu">
                <li>'.  str_replace('btn btn-primary btn-sm', '',  $btnViewParsed) .'</li>
              </ul>
            </div> 
        ';
        
        switch ($data->status) {
            case VendorFile::STATUS_PENDING:
                echo $progressBarPending;
                echo $btnDelete;
            break;

            case VendorFile::STATUS_PARSING:
                echo $progressBarParseing;
                echo $btnDelete;
            break;
    
            case VendorFile::STATUS_FOR_REVIEW:
                echo $btnViewActions2 . '&nbsp;';
                echo $btnDelete;
            break;

            case VendorFile::STATUS_PUSHING:
                echo $btnViewActions2 . '&nbsp;';
                echo $btnDelete;
            break;

            case VendorFile::STATUS_PUSHED:
                echo $btnViewActions . '&nbsp;';
                echo $btnArchive;
            break;
    
            case VendorFile::STATUS_ERROR:
                echo $btnError . '&nbsp;';
                echo $btnDelete;
            break;

            case VendorFile::STATUS_ARCHIVED:
                echo $btnViewActions . '&nbsp;';
                echo $btnDelete;
            break;
        }

        ?>

    </td>
</tr>