<?php

$clientScript = Yii::app()->clientScript;

$clientScript->registerScriptFile("https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.3.3/bootbox.min.js");

$clientScript->registerCss("list_style", "

.table-list thead th, table tbody td {
    white-space: nowrap;
    text-align: left;
    padding-left: 5px !important;
    padding-right: 20px !important;
}

.table-list thead th.default-padding, table tbody td.default-padding {
    padding-left: 5px !important;
    padding-right: 5px !important;
}

.table-list tbody td {
    font-size: 13px;
}

.table-list input[type=checkbox] {
    margin: 0px !important;
}

.alert-hovering {
    position: absolute;
    z-index: 10;
    font-size: 13px;
    padding: 10px 15px;
    left: 55%;
    top: -55px;
}

a.disabled {
    cursor: not-allowed;
}

.list-view  .label {
    font-size: 11px;
}

.progress-bar {
    padding: 6px;   
}

.progress-bar {
    font-size: 14px;
}

.container-gss-pricing .popover {
    min-width: 460px !important;
    top: 0px !important;
}

.container-gss-pricing .popover .arrow {
    display: none !important;
}

/*
#popup-push-confirm ul {
    padding-left: 10px;
    margin: 0;
}*/

");

$htmlAlertVendorParsedData = '<div class="alert alert-info alert-hovering" style="font-weight: bold;"><span class="glyphicon glyphicon-info-sign"></span> Spreadsheet data successfully <strong>parsed</strong> and ready for publish.</div>';
$htmlAlertVendorPushedData = '<div class="alert alert-success alert-hovering" style="font-weight: bold;"><span class="glyphicon glyphicon-ok-sign"></span> Spreadsheet data successfully <strong>published to live</strong>.</div>';
$htmlAlertVendorPushingData = '<div class="alert alert-info alert-hovering" style="font-weight: bold;"><span class="glyphicon glyphicon-info-sign"></span> Spreadsheet data currently <strong>publishing to live</strong>.</div>';
$htmlAlertVendorSyncingData = '<div class="alert alert-info alert-hovering" style="font-weight: bold;"><span class="glyphicon glyphicon-info-sign"></span> Spreadsheet data currently <strong>syncing to platforms</strong>.</div>'

?>

<h1 class="page-header">
    <?php echo $this->pageTitle; ?>
    <span style="font-size: 12px; font-weight: bold;">
    <?php echo CHtml::link('Upload Spreadsheets', ['UploadVendorSpreadsheet/index']); ?>
    &nbsp;&nbsp;>>&nbsp;&nbsp;
    <?php echo CHtml::link('Review Spreadsheet', ['ReviewVendorSpreadsheet/index', 'id' => $vendorFile->id]); ?>
    </span>

</h1>

<div class="row">
    <div class="col-md-12" id="container-alert-hover">
        <?php if($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCED) {   
                if ($vendorFile->status == VendorFile::STATUS_FOR_REVIEW) :
                    echo $htmlAlertVendorParsedData;
                elseif ($vendorFile->status == VendorFile::STATUS_PUSHED) :
                    echo $htmlAlertVendorPushedData;
                elseif ($vendorFile->status == VendorFile::STATUS_PUSHING) :
                    echo $htmlAlertVendorPushingData;
                endif;
            } else {
                echo $htmlAlertVendorSyncingData;
            } ?>
    </div>
    <div class="col-md-12" style="margin-bottom: 10px;">
        <div class="row">
            <div class="col-md-7">
                <?php echo CHtml::link('<span class="glyphicon glyphicon-info-sign"></span> Details (<span class="count-parsed-data"></span>)', '#', ['class' => 'btn btn-info btn-parsed-details ']); ?>
                <?php echo CHtml::link('<span class="glyphicon glyphicon-refresh"></span> Reload', '#', ['class' => 'btn btn-primary btn-refresh-parsed-list', 'title' => 'Refresh List']); ?>
                <?php //echo CHtml::link('<span class="glyphicon glyphicon-cog"></span> Price Settings', '#', ['class' => 'btn btn-primary btn-parsed-settings']); ?>
                <div class="dropdown" style="display: inline;">
                    <button class="btn btn-primary dropdown-toggle btn-price-settings" type="button" data-toggle="dropdown" <?php echo ($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING) ? 'disabled' : ''; ?> >
                        <span class="glyphicon glyphicon-cog"></span> Price Settings
                    </button>
                    <ul class="dropdown-menu">
                        <li><a href="#" class="btn-parsed-settings">SBB Price Setting</a></li>
                        <li><a href="#" class="btn-gss-price-setting">GSS Price Setting</a></li>
                    </ul>
                </div>

                <?php echo CHtml::link('<span class="glyphicon glyphicon-filter"></span> Filters', '#', ['class' => 'btn btn-primary btn-advance-search ']); ?>
                <div class="dropdown btn-options" style="display: none">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown" <?php echo ($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING || $vendorFile->status == VendorFile::STATUS_PUSHED) ? 'disabled' : ''; ?> ><span class="fa fa-bars"></span> Options</button>
                    <ul class="dropdown-menu">
                        <li><a href="#" class="btn-set-products-check-status" data-product-check-id="<?php echo VendorNormalized::PRODUCT_STATUS_EOL; ?>">Set Products as <?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_EOL); ?></a></li>
                        <li><a href="#" class="btn-set-products-check-status" data-product-check-id="<?php echo VendorNormalized::PRODUCT_STATUS_NOT_CHECKED; ?>">Set Products as Not EOL</a></li>
                        <!-- <li role="presentation" class="divider"></li>
                        <li><a href="#" class="btn-set-products-check-status" data-product-check-id="<?php //echo VendorNormalized::PRODUCT_STATUS_UPDATED; ?>">Set Products as <?php //echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_UPDATED); ?></a></li>
                        <li><a href="#" class="btn-set-products-check-status" data-product-check-id="<?php //echo VendorNormalized::PRODUCT_STATUS_REMAIN; ?>">Set Products as <?php //echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_REMAIN); ?></a></li>-->
                        <li><a href="#" class="btn-delete-data-multiple">Set Products as Deleted</a></li> 
                        <li role="presentation" class="divider"></li>
                        <li><a href="#" class="btn-options-lock-pricing">MPN Pricing Lock</a></li>
                        <li><a href="#" class="btn-options-unlock-pricing">MPN Pricing Un-Lock</a></li>
                    </ul>
                </div>

                <?php //echo CHtml::link('<span class="glyphicon glyphicon-remove"></span> Delete', '#', ['class' => 'btn btn-danger btn-delete-data-multiple ', 'style' => 'display: none;']); ?>
            </div>
            <div class="col-md-5 text-right">
                <?php
                
                $displayProgressParsing = array(
                    VendorFile::STATUS_PENDING,
                    VendorFile::STATUS_PARSING
                );

                $displayPushVendorStatus = array(
                    VendorFile::STATUS_FOR_REVIEW
                );

                $displayViewProductStatus = array(
                    VendorFile::STATUS_PUSHED,
                     VendorFile::STATUS_ARCHIVED
                );

                $btnDisplayViewProductStatus = array(
                    VendorFile::STATUS_PUSHED
                );

                $displayPushingProgressStatus = array(
                    VendorFile::STATUS_PUSHING
                );

               echo CHtml::link('<span class="glyphicon glyphicon-cloud-download"></span> Download Quick Books '.($vendorFile->status == VendorFile::STATUS_PUSHED ? '(Published)' : ''), ['reviewVendorSpreadsheet/DownloadQuickbook', 'vendorFileId' => $vendorFile->id], ['class' => 'btn btn-primary p btnDownload '.($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING ? 'hide' : ''), 'title' => 'Download Quickbooks Format', 'style' => 'margin-right: 4px; display: inline-block;']);

                $btnDisplayPushVendor = in_array($vendorFile->status, $displayPushVendorStatus) ? 'inline-block': 'none';
                $syncingHide =  ($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING || $vendorFile->status == VendorFile::STATUS_PUSHED) ? "hide" : "";
                echo CHtml::link('<span class="glyphicon glyphicon-cloud-upload"></span> Publish Vendor Data to Live', '#', ['class' => 'btn btn-success '.$syncingHide, 'id' => 'btn-push-vendor-to-live', 'style' => 'display: '. $btnDisplayPushVendor .';']);

                $btnDisplayViewProduct = in_array($vendorFile->status, $displayViewProductStatus) ? 'inline-block': 'none';
                echo CHtml::link('<span class="fa fa-product-hunt"></span> View Published Products', ['product/index', 'search[vendor]' => $vendorFile->vendor_id, 'batchId' => VendorFile::generateBatchId($vendorFile->id)], ['class' => 'btn btn-success  display-view-products', 'id' => 'btn-push-vendor-to-live', 'style' => 'display: '. $btnDisplayViewProduct .';']);

                ?>
            </div>
        </div>
    </div>
    <div class="col-md-12"> 
        <div class="progress" id="progress-parsing" style="display: <?php echo in_array($vendorFile->status, $displayProgressParsing) ? 'initial': 'none'; ?>;">
            <div class="progress-bar progress-bar-striped active" role="progressbar"
            aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px;">
                <span>Parsing...</span>
            </div>
        </div>        

        <div class="progress" id="progress-pushing" style="display: <?php echo in_array($vendorFile->status, $displayPushingProgressStatus) ? 'initial': 'none'; ?>;">
            <div class="progress-bar progress-bar-striped active" role="progressbar"
            aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px;">
                <span>Publishing Spreadsheet Data to Live....</span>
            </div>
        </div>        

        <div class="progress" id="progress-syncing" style="display: <?php echo $vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING ? 'initial': 'none'; ?>;">
            <div class="progress-bar progress-bar-striped active" role="progressbar"
            aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:100%; margin-bottom: 15px;">
                <span>Checking Spreadsheet Data Platform Status....</span>
            </div>
        </div>      
    </div>
    <div class="col-md-12">
        <?php 

        $advanceSearchParamsHtml = '';
        $advanceSearchParamsData = '';

        if (!empty($advanceSearchParams['search'])) {
            foreach ($advanceSearchParams['search'] as $advanceSearchParamIdx => $advanceSearchParamVal) {
                $advanceSearchParamName = $advanceSearchParamIdx;
                $advanceSearchParamValue = $advanceSearchParamVal;

                if ($advanceSearchParamName == 'status' && $advanceSearchParamValue != '') {
                    $advanceSearchParamValue = VendorNormalized::getProductStatusLabel($advanceSearchParamValue);
                }

                if ($advanceSearchParamName == 'status_parsed' && $advanceSearchParamValue != '') {
                    if ($advanceSearchParamValue == 1) {
                        $advanceSearchParamValue = 'Active';
                    } else if ($advanceSearchParamValue == 2) {
                        $advanceSearchParamValue = 'Deleted';
                    } else if ($advanceSearchParamValue == 3) {
                        $advanceSearchParamValue = 'Errors';
                    }

                    $advanceSearchParamName == 'Parsed-Status';
                }

                if (trim($advanceSearchParamName) == 'mpn') {
                    $advanceSearchParamName = 'MPN';
                }

                if (trim($advanceSearchParamName) == 'sku') {
                    $advanceSearchParamName = 'SKU';
                }

                $advanceSearchParamsData .= '<span class="label label-default" style="font-size: 13px; display: inline-block:">Filter-' .  ucfirst($advanceSearchParamName) . ' : ' . $advanceSearchParamValue . '</span>&nbsp;';
            }
        }

        if ($advanceSearchParamsData != '') {
            $advanceSearchParamsData = '<span style="font-size: 13px; margin-bottom: 10px; display: inline-block;" id="advance-search-params-data"><strong></strong> '. $advanceSearchParamsData .' <a href="#" class="btn-reset-advance-search"><strong><span class="glyphicon glyphicon-remove"></span> Reset Filters</strong></a></span>';
        }

        $this->widget('zii.widgets.CListView', array(
            'id' => 'list-vendor-normalized',
            'dataProvider' => $vendorNormalisedDataProvider,
            'itemView' => '_index',
            'viewData' => [
                'gssPricingGroupName' => $gssPricingGroupName,
                'vendorFile' => $vendorFile,
            ],
            'template' => '
                <span class="count-parsed-data-tmp-holder" style="display: none;">'. $itemTotalCount .'</span>
                <div class="row">
                    <div class="col-md-12">
                        '. $advanceSearchParamsData .'
                    </div>
                </div>
                <div class="table-responsive table-scrolled" style="width: 100%; overflow: scroll;">
                    <form id="form-normalized-vendor">
                        <table class="table table-condensed table-striped table-hover header-fixed table-list">
                            <thead>
                                <tr class="active" style="position: sticky; top: 0;  position: -webkit-sticky;">
                                    <th class="text-center default-padding"><input type="checkbox" class="select-all-review-data"></th>
                                    <th class="text-center">Status</th>
                                    <th>Vendor</th>
                                    <th>MPN</th>
                                    <th>SBB Price</th>
                                    <th>GSS Price</th>
                                    <th>Cost</th>
                                    <th>MSRP</th>
                                    <th>SKU</th>
                                    <th>EAN/GTIN</th>
                                    <th>Weight</th>
                                    <th>Width</th>
                                    <th>Length</th>
                                    <th>Height</th>
                                    <!-- <th>Quantity</th>-->
                                </tr>
                            </thead>
                            <tbody>
                                {items}
                            </tbody>
                        </table>
                    </form>
                    {pager}
                </div>
            ',
            'emptyText' => '<tr><td colspan="16">No result.</td></tr>',
            'pager' => array(
                'cssFile' => false, 
                'header' => false, 
                'firstPageLabel' => '&lt;&lt;',
                'prevPageLabel' => '&lt;',
                'nextPageLabel' => '&gt;',
                'lastPageLabel' => '&gt;&gt;'
            ),
            'afterAjaxUpdate' => "function() {
                $('document').ready(function() {
                    activateLisTableScroll(); 
                    $('[data-toggle=\"popover\"]').popover();
                    $('.count-parsed-data').html($('.count-parsed-data-tmp-holder').text());
                });
            }"
        ));

        ?>
    </div>
</div>

<div id="popup-push-confirm-x" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body" style="padding-bottom: 0;">
                <div class="alert alert-info">
                    <p>Are you sure you want to <strong>publish parsed data</strong> to following websites?</p>
                    <ul>
                        <li>WooCommerce</li>
                        <li>Google Merchant</li>
                    </ul>
                </div>
                <!-- <div class="alert alert-warning">
                    <p style="margin-bottom: 5px;">Re-check to make sure product status are updated before publishing.</p>
                    
                </div> -->
            </div>
            <div class="modal-footer">
            <a href="#" class="btn btn-warning btn-re-check-product pull-left"><span class="glyphicon glyphicon-refresh"></span> Re-check Product Status Before Publishing</a>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><span class="glyphicon glyphicon-remove-circle"></span> No</button>
                <button type="button" class="btn btn-success" id="confirm-btn-push-vendor"><span class="glyphicon glyphicon-ok-circle"></span> Yes</button>
            </div>
        </div>
    </div>
</div>

<div id="popup-push-confirm" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-heading">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title" style="font-size: 16px;">Publish Confirmations</h4>
                </div>
            </div>
            <div class="modal-body" style="padding-bottom: 0;">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-primary" id="panel-step-confirm-1">
                            <div class="panel-heading" style="padding-top: 3px !important; padding-bottom: 3px !important; font-size: 11px !important;" >
                                <strong>STEP 1 : Review Products</strong>
                            </div>
                            <div class="panel-body" style="padding: 10px; padding-top: 3px;">
                                <div class="alertx alert-infox" style="margin-bottom: 5px !important; padding: 5px !important;">
                                    Make sure you're done reviewing products data before publishing.
                                    <small>
                                    <ul>
                                        <li>Products price setting for GSS</li>
                                        <li>Products price setting for SBB</li>
                                        <li>Products with empty MPN</li>
                                    </ul>
                                    </small>
                                </div>
                                <a href="#" class="btn btn-primary pull-left" id="btn-confirm-step-1">Confirm</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="panel panel-primary" id="panel-step-confirm-2">
                            <div class="panel-heading" style="padding-top: 3px !important; padding-bottom: 3px !important; font-size: 11px !important;">
                                <strong>STEP 2 : Re-check Product Status</strong>
                            </div>
                            <div class="panel-body" style="padding: 10px;  padding-top: 3px;">
                                <div class="alertx alert-infox" style="margin-bottom: 5px !important; padding: 5px !important;">
                                    Recheck product status and update if necessary to prevent conflicts.
                                </div>
                                <a href="#" class="btn btn-primary pull-left" disabled id="btn-confirm-step-2"></span> Confirm</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="panel panel-primary" id="panel-step-confirm-3" style="margin-bottom: 0px;">
                            <div class="panel-heading" style="padding-top: 3px !important; padding-bottom: 3px !important; font-size: 11px !important;">
                                <strong>STEP 3 : Publish Products</strong>
                            </div>
                            <div class="panel-body" style="padding: 10px;  padding-top: 3px;">
                                <div class="alertx alert-infox" style="margin-bottom: 5px !important; padding: 5px !important;">
                                    Once you click confirm, products will start to publish to platforms. 
                                    <small>
                                    <ul>
                                        <li><?php echo Product::getWebsiteLabel(Product::WEBSITE_SBB); ?></li>
                                        <li><?php echo Product::getWebsiteLabel(Product::WEBSITE_GSS); ?></li>
                                        <li>
                                            <p>
                                                Google Feed
                                                <label class="toggleSwitch" onclick="">
                                                    <input type="checkbox" name="toggle_google" id="toggleGoogle" checked/>
                                                    <span>
                                                        <span>OFF</span>
                                                        <span>ON</span>
                                                    </span>
                                                    <a></a>
                                                </label>
                                            </p>
                                        </li>
                                    </ul>
                                    </small>
                                </div>
                                <a href="#" class="btn btn-primary pull-left" disabled id="btn-confirm-step-3"></span> Confirm</a>
                            </div>
                        </div>
                    </div>
                </div>
                 <!-- <div class="alert alert-info">
                    <p>Are you sure you want to <strong>publish parsed data</strong> to following websites?</p>
                    <ul>
                        <li>WooCommerce</li>
                        <li>Google Merchant</li>
                    </ul>
                </div> -->
                <!-- <div class="alert alert-warning">
                    <p style="margin-bottom: 5px;">Re-check to make sure product status are updated before publishing.</p>
                    
                </div> -->
            </div>
            <div class="modal-footer">
                <!--<a href="#" class="btn btn-warning btn-re-check-product pull-left"><span class="glyphicon glyphicon-refresh"></span> Re-check Product Status Before Publishing</a>-->
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                <!--<button type="button" class="btn btn-success" id="confirm-btn-push-vendor" disabled><span class="glyphicon glyphicon-ok-circle"></span> Publish</button>-->
            </div>
        </div>
    </div>
</div>

<div id="popup-error" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body" style="padding-bottom: 0;">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Ok</button>
            </div>
        </div>
    </div>
</div>

<div id="popup-parsed-settings" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="price-settings" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">SBB Price Setting</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert" style="display:none;"></div>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Price Setting</label>
                            <select class="form-control" name="price_setting[type]">
                                <option value="<?php echo SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN; ?>" <?php echo ($priceSettingDefault && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN ? 'selected': ''); ?>>From Spreadsheet Column</option>
                                <option value="<?php echo SettingSalesPrice::SALES_PRICE_SETTING_COST; ?>" <?php echo ($priceSettingDefault && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST ? 'selected': ''); ?>>Based on Cost</option>
                                <option value="<?php echo SettingSalesPrice::SALES_PRICE_SETTING_MSRP; ?>" <?php echo ($priceSettingDefault && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_MSRP ? 'selected': ''); ?>>Based on MSRP</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label>Column Name</label>
                            <input type="text" name="price_setting[column_name]" class="form-control" <?php echo ($priceSettingDefault && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN) ? 'value="' . $priceSettingDefault['column_name'] . '"' : 'disabled="disabled"'; ?> placeholder="Enter Spreadsheet Column Name">
                        </div>
                    </div>

                    <div class="row form-group" style="display: <?php echo ($priceSettingDefault && $priceSettingDefault['type'] != SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN) ? 'block': 'none'; ?>;" id="container-sales-price-setting-based">
                        <div class="col-md-6 base-cost-markup-container" style="display: <?php echo $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST ? 'block' : 'none'; ?>;">
                            <label>Cost Markup</label>
                            <div class="input-group">
                                <input id="password" type="text" class="form-control" name="price_setting[sales_margin_cost_markup]" placeholder="Enter Sales Margin" value="<?php echo ($priceSettingDefault && $priceSettingDefault['type'] != SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST) ? $priceSettingDefault['sales_margin']: 0; ?>">
                                <span class="input-group-addon"><strong>%</strong></span>
                            </div>
                        </div>
                        <div class="col-md-6 base-msrp-markup-container" style="display: <?php echo $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_MSRP ? 'block' : 'none'; ?>;">
                            <label>MSRP Markdown</label>
                            <div class="input-group">
                                <input id="password" type="text" class="form-control" name="price_setting[sales_margin_msrp_markdown]" placeholder="Enter Sales Margin" value="<?php echo ($priceSettingDefault && $priceSettingDefault['type'] != SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN && $priceSettingDefault['type'] == SettingSalesPrice::SALES_PRICE_SETTING_MSRP) ? $priceSettingDefault['sales_margin']: 0; ?>">
                                <span class="input-group-addon"><strong>%</strong></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label>Shipping Dollar</label>
                            <div class="input-group"> 
                                <span class="input-group-addon"><strong>+</strong></span>
                                <input type="text"  name="price_setting[dollor]" class="form-control" value="<?php echo ($priceSettingDefault && $priceSettingDefault['type'] != SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN) ? $priceSettingDefault['dollars']: 0; ?>" placeholder="Enter Added Dollars">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Apply</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-gss-price-setting" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="form-gss-price-setting" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">GSS Price Setting</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert-gss-price-setting alert" style="display:none;"></div>
                        </div>
                                   
                        <div class="col-md-6">
                                <div class="form-group">
                                <label>Pricing Group</label>
                                <?php echo CHtml::dropDownList('pricing_group_id', '', PricingGroup::getDataList(), [
                                    'class' => 'form-control', 
                                    'empty' => 'None']); ?>
                            </div>
                        </div>

                        <div class="col-md-12 text-center container-price-tier-gss-price-setting"  style="display: none;">
                        </div>
                        <!-- 
                        <div class="col-md-12 container-empty-price-tier-gss-price-setting">
                            <div class="alert alert-info">No pricing tier selected.</div>
                        </div> 
                        -->
                    </div>                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Apply</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-parsed-details" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Spreadsheet Parsed Details</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                <div class="col-md-12">
                    <div class="alert" style="display: none;"></div>
                </div>
                <div class="col-md-12">
                    <table class="table table-condensed table-small-text"> 
                        <thead>
                            <tr class="active">
                                <th colspan="2">Vendor Details</th>
                            </tr>
                        </thead>
                        <colgroup>
                            <col style="width: 20%;">
                            <col style="width: 80%;">
                        </colgroup>
                        <tr>
                            <td>Vendor</th>
                            <td class="data-vendor-file-vendor"></th>
                        </tr>
                        <tr>
                            <td>Parsed Data</th>
                            <td class="data-vendor-file-parsed-data"></th>
                        </tr>
                        <tr>
                            <tr>
                                <td>File</th>
                                <td class="data-vendor-file-filename"></th>
                            </tr>
                            <tr>
                                <td>Status</th>
                                <td class="data-vendor-file-status"></th>
                            </tr>
                            <tr>
                                <td>#Id</th>
                                <td class="data-vendor-file-details-id"></th>
                            </tr>
                            <tr>
                                <td>Date Created</th>
                                <td class="data-vendor-file-details-date-created"></th>
                            </tr>
                        </tr>
                    </table>
                </div>

                    <div class="col-md-6 hide">
                        <table class="table table-condensed table-small-text">
                            <colgroup>
                                <col style="width: 50%;">
                                <col style="width: 50%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="2">Product Status</th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_NEW); ?></strong>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-product-ck-status-new">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_UPDATED); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-product-ck-status-updated">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_REMAIN); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-product-ck-status-remain">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_EOL); ?></strong>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-product-ck-status-eol">0</span>
                                </td>
                            </tr>

                            <!-- <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_NOT_CHECKED); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-product-ck-status-not-checked">0</span>
                                </td>
                            </tr> -->
                        </table>  
                    </div>
                    <div class="col-md-6">
                        <table class="table table-condensed table-small-text">
                            <colgroup>
                                <col style="width: 50%;">
                                <col style="width: 50%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="2" >SBB Platform Status</th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_PENDING, 'SBB'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-sbb-pending">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_NEW, 'SBB'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-sbb-new" >0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EXISTING, 'SBB'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-sbb-existing">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EOL, 'SBB'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-sbb-eol">0</span>
                                </td>
                            </tr>
                        </table>  
                    </div>
                    <div class="col-md-6">
                        <table class="table table-condensed table-small-text">
                            <colgroup>
                                <col style="width: 50%;">
                                <col style="width: 50%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="2" >GSS Platform Status</th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_PENDING, 'GSS'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-gss-pending">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_NEW, 'GSS'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-gss-new" >0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EXISTING, 'GSS'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-gss-existing">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EOL, 'GSS'); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-gss-eol">0</span>
                                </td>
                            </tr>
                        </table>  
                    </div>
                    <div class="col-md-6">
                        <table class="table table-condensed table-small-text">
                            <colgroup>
                                <col style="width: 50%;">
                                <col style="width: 50%;">
                            </colgroup>
                            <thead>
                                <tr class="active">
                                    <th colspan="2" >Progress Status</th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_FOR_REVIEW); ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-status-for-review">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_PUSHING); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-status-pushing" >0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span><?php echo VendorNormalized::getStatusLabel(VendorNormalized::STATUS_PUSHED); ?></span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-status-pushed">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span>Deleted</span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-status-deleted">0</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span>Errors</span>
                                    &nbsp;
                                </td>
                                <td class="text-center">
                                    <span class="badge data-count-status-error">0</span>
                                </td>
                            </tr>
                        </table>  
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div id="popup-advance-search" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="advance-search">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Filters</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Product Status</label>
                            <select class="form-control" name="search[status]">
                                <option value="">All Status</option>
                                <option value="<?php echo VendorNormalized::PRODUCT_STATUS_NEW; ?>"><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_NEW); ?></option>
                                <option value="<?php echo VendorNormalized::PRODUCT_STATUS_UPDATED; ?>"><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_UPDATED); ?></option>
                                <option value="<?php echo VendorNormalized::PRODUCT_STATUS_REMAIN; ?>"><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_REMAIN); ?></option>
                                 <option value="<?php echo VendorNormalized::PRODUCT_STATUS_EOL; ?>"><?php echo VendorNormalized::getProductStatusLabel(VendorNormalized::PRODUCT_STATUS_EOL); ?></option>
                            </select>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Progress Status</label>
                            <select class="form-control" name="search[status_parsed]">
                                <option value="">All Status</option>
                                <option value="1">Active</option>
                                <option value="2">Deleted</option>
                                <option value="3">Errors</option>
                            </select>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>MPN</label>
                            <input type="name" class="form-control" placeholder="Enter MPN" name="search[mpn]">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>SKU</label>
                            <input type="name" class="form-control" placeholder="Enter SKU" name="search[sku]">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Description</label>
                            <input type="name" class="form-control" placeholder="Enter Description  Keyword" name="search[description]">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-default btn-reset-advance-search">Reset</button>
                    <button type="submit" class="btn btn-primary"  id="btn-apply-advance-search">Apply</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="popup-edit-parsed-data" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <?php echo CHtml::beginForm('', 'POST', ['id' => 'edit-parsed-data']); ?>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Parsed Data</h4>
            </div>
            <div class="modal-body" style="padding-bottom: 0;">
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert" style="display: none:"></div>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeHiddenField($vendorNormalizedInfo, 'vendor_normalized_id'); ?>
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'Vendor'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'brand_name', ['class' => 'form-control input-sm', 'disabled' => true, 'readonly' => true]); ?>
                    </div>
                    <div class="col-md-6 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'mpn'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'mpn', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                    <?php echo CHtml::activeHiddenField($vendorNormalized, 'id'); ?>
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'status'); ?>
                        <?php echo CHtml::activeDropdownList($vendorNormalized, 'status', VendorNormalized::getStatusListEdit(), ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <label>SBB Price</label>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'price_sbb', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'cost'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'cost', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-4 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'msrp'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'msrp', ['class' => 'form-control input-sm']); ?>
                    </div>

                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'weight'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'weight', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'width'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'width', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'length'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'length', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-3 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'height'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'height', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <!-- <div class="col-md-6 form-group">
                        <?php //echo CHtml::activeLabel($vendorNormalizedInfo, 'quantity'); ?>
                        <?php //echo CHtml::activeTextField($vendorNormalizedInfo, 'quantity', ['class' => 'form-control input-sm']); ?>
                    </div> -->
                    <div class="col-md-6 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'sku'); ?>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'sku', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-6 form-group">
                        <?php //echo CHtml::activeLabel($vendorNormalizedInfo, 'ean'); ?>
                        <label>GTIN / EAN</label>
                        <?php echo CHtml::activeTextField($vendorNormalizedInfo, 'ean', ['class' => 'form-control input-sm']); ?>
                    </div>
                    <div class="col-md-12 form-group">
                        <?php echo CHtml::activeLabel($vendorNormalizedInfo, 'description'); ?>
                        <?php echo CHtml::activeTextArea($vendorNormalizedInfo, 'description', ['class' => 'form-control input-sm']); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
            <?php echo CHtml::endform(); ?>
        </div>
    </div>
</div>

<div id="popup-item-report" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="advance-search">
                <div class="modal-body" style="padding-bottom: 0;">
                    <div class="alert alert-danger"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php

$clientScript->registerScript("init", "
    $('[data-toggle=\"popover\"]').popover();
");

$clientScript->registerScript("push-vendor-script", "

    $('document').ready(function() {
        var btnPushVendorToLive = $('#btn-push-vendor-to-live');

        var progressPushing = $('#progress-pushing');
        var popupPushConfirm = $('#popup-push-confirm');
        var popupError = $('#popup-error');

        btnPushVendorToLive.click(function(e) {
            e.preventDefault();
            popupPushConfirm.modal('show');
        });

        $('#btn-confirm-step-3').click(function() {
            var toggleGoogle = $('#toggleGoogle').is(':checked');
            
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/setVendorForPushing', ['vendorFileId' => $vendorFile->id]) ."&toggleGoogle='+toggleGoogle,
                dataType: 'JSON',
                success: function(res) {
                    if (res.status == 'ok') {
                        progressPushing.css('display', 'initial'); 
                        btnPushVendorToLive.hide();

                        popupPushConfirm.modal('hide');

                        popupError.find('.modal-body').html('<div class=\"alert alert-success\">'+ res.message +'</div>');
                        popupError.modal('show');

                        lockParsedDataActions();
                        $('#container-alert-hover').html('". $htmlAlertVendorPushingData ."'); 

                        getProgressDetailsIntervalx();

                                              
                    } else {
                        popupPushConfirm.modal('hide');
                        
                        popupError.find('.modal-body').html('<div class=\"alert alert-danger\">'+ res.message +'</div>');
                        popupError.modal('show');
                    }
                },
                error: function(res) {
                    // alert('someting went wrong.');
                }
            });
        });
    });

");

$clientScript->registerScript("parsed-details", "

    var btnParsedDetails = $('.btn-parsed-details');
    var popupParsedDetails = $('#popup-parsed-details');
    
    btnParsedDetails.click(function() {
        popupParsedDetails.modal('show');

        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/GetParsedDetails', ['vendorFileId' => $vendorFile->id]) ."',
            dataType: 'JSON',
            method: 'GET',
            success: function(res) {
                $('.data-count-total-parsed').html(res.count_total_parsed);
                $('.data-count-status-for-review').html(res.status_count.for_review);
                $('.data-count-status-pushing').html(res.status_count.pushing);
                $('.data-count-status-pushed').html(res.status_count.pushed);
                $('.data-count-status-error').html(res.status_count.error);
                $('.data-count-status-deleted').html(res.status_count.deleted);

                $('.data-vendor-file-details-id').html(res.vendor_file_details.id);
                $('.data-vendor-file-vendor').html(res.vendor_file_details.vendor);
                $('.data-vendor-file-filename').html(res.vendor_file_details.filename);
                $('.data-vendor-file-status').html(res.vendor_file_details.status);
                $('.data-vendor-file-parsed-data').html(res.vendor_file_details.parsed_data);
                $('.data-vendor-file-details-date-created').html(res.vendor_file_details.date_created);

                $('.data-count-product-ck-status-new').html(res.count_product_check_status.new);
                $('.data-count-product-ck-status-updated').html(res.count_product_check_status.updated);
                $('.data-count-product-ck-status-remain').html(res.count_product_check_status.remain);
                $('.data-count-product-ck-status-not-checked').html(res.count_product_check_status.not_checked);
                $('.data-count-product-ck-status-eol').html(res.count_product_check_status.eol);

                $('.data-count-sbb-pending').html(res.count_platform_status.sbb_pending);
                $('.data-count-sbb-new').html(res.count_platform_status.sbb_new);
                $('.data-count-sbb-existing').html(res.count_platform_status.sbb_existing);
                $('.data-count-sbb-eol').html(res.count_platform_status.sbb_eol)
                $('.data-count-gss-pending').html(res.count_platform_status.gss_pending);
                $('.data-count-gss-new').html(res.count_platform_status.gss_new);
                $('.data-count-gss-existing').html(res.count_platform_status.gss_existing);
                $('.data-count-gss-eol').html(res.count_platform_status.gss_eol)

                $('table.vendor-files').find('tbody').html(res.vendor_files_html);
            },
            error: function(res) {
                alert('something went wrong.');
            }
        });
    });

");

$clientScript->registerScript("buttons-data", "
    var btnDeleteDataMultiple = $('.btn-delete-data-multiple');
    var btnPriceOptions = $('.btn-options');
    var btnPriceOptionsButton = btnPriceOptions.find('button');
    var btnPriceOptionsButtonDefault = btnPriceOptionsButton.html();

    $('body').on('click', '.select-all-review-data', function() {
        if ($(this).is(':checked')) {
            $('.checkbox-review-data').prop('checked', true);
            btnDeleteDataMultiple.show();
            btnPriceOptions.show().css('display', 'inline');
        } else {
            $('.checkbox-review-data').prop('checked', false);
            btnDeleteDataMultiple.hide();
            btnPriceOptions.hide();
        }
    });

    $('body').on('click', '.checkbox-review-data', function() {
        if ($('.checkbox-review-data').is(':checked')) {
            btnDeleteDataMultiple.show();
            btnPriceOptions.show().css('display', 'inline');
        } else {
            btnDeleteDataMultiple.hide();
            btnPriceOptions.hide();
        }
    });
   
    $('body').on('click', '.btn-delete-data-multiple', function() {
        var formVendor = $('form#form-normalized-vendor');

        if (confirm('Are you sure you want to delete selected data?')) {
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/DeleteParsedData') ."',
                data: formVendor.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    btnPriceOptions.hide();
                    
                    $.fn.yiiListView.update('list-vendor-normalized');

                    bootbox.alert({
                        size: 'small',
                        message: res.message
                    });
                },
                error: function(res) {
                    alert(res);
                }
            });
        }
    });

    $('body').on('click', '.btn-set-products-check-status', function() {
        var self = $(this);
        var formVendor = $('form#form-normalized-vendor');
        var productCheckId = self.attr('data-product-check-id');
        var productCheckText = self.text();

        if (confirm('Are you sure you want to '+ productCheckText +'?')) {
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/setProductsCheckStatus') ."',
                data: formVendor.serialize() + '&product_check_id=' + productCheckId,
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    btnPriceOptions.hide();
                    
                    $.fn.yiiListView.update('list-vendor-normalized');

                    bootbox.alert({
                        message: res.message
                    });
                },
                error: function(res) {
                    alert(res);
                }
            });
        }
    });

    $('body').on('click', '.btn-options-lock-pricing', function() {
        var formVendor = $('form#form-normalized-vendor');

        if (confirm('Are you sure you want to lock the pricing of the selected data?')) {
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/lockPricing') ."',
                data: formVendor.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    bootbox.alert({
                        size: 'medium',
                        message: res.message
                    });

                    btnPriceOptions.hide();
                    
                    $.fn.yiiListView.update('list-vendor-normalized');
                },
                error: function(res) {
                    alert(res);
                },
                beforeSend: function() {
                    btnPriceOptionsButton.html('Locking Items MPN Pricing... Please Wait...');
                    btnPriceOptionsButton.attr('disabled', true);
                },
                complete: function() {
                    btnPriceOptionsButton.html(btnPriceOptionsButtonDefault);
                    btnPriceOptionsButton.attr('disabled', false);
                }
            });
        }
    });

    $('body').on('click', '.btn-options-unlock-pricing', function() {
        var formVendor = $('form#form-normalized-vendor');

        if (confirm('Are you sure you want to unlock the pricing of the selected data?')) {
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/unlockPricing') ."',
                data: formVendor.serialize(),
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    bootbox.alert({
                        size: 'medium',
                        message: res.message
                    });

                    btnPriceOptions.hide();
                    
                    $.fn.yiiListView.update('list-vendor-normalized');
                },
                error: function(res) {
                    alert(res);
                },
                beforeSend: function() {
                    btnPriceOptionsButton.html('UnLocking Items MPN Pricing... Please Wait...');
                    btnPriceOptionsButton.attr('disabled', true);
                },
                complete: function() {
                    btnPriceOptionsButton.html(btnPriceOptionsButtonDefault);
                    btnPriceOptionsButton.attr('disabled', false);
                }
            });
        }
    });

    $('body').on('click', '.btn-delete-parsed-data', function() {
        var self = $(this);

        if (confirm('Are you sure you want to delete selected data?')) {
            $.ajax({
                url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/DeleteParsedData') ."',
                data: {normalize_data_ids: [self.attr('data-id')]},
                dataType: 'JSON',
                method: 'POST',
                success: function(res) {
                    btnDeleteDataMultiple.hide();
                    
                    $.fn.yiiListView.update('list-vendor-normalized');

                    bootbox.alert({
                        size: 'small',
                        message: res.message
                    });
                }, 
                error: function(res) {
                    alert(res);
                }
            });
        }
    });
");

$clientScript->registerScript("table-scrolled-main", "

    function activateLisTableScroll() {
        var listScrollHeight = window.innerHeight-218;
        var advanceSearchParamsDataHeight = $('#advance-search-params-data').height();
    
        if (advanceSearchParamsDataHeight != null) {
            listScrollHeight -= advanceSearchParamsDataHeight + 15;
            console.log(listScrollHeight);
        }
    
        $('.table-scrolled').css('height', listScrollHeight + 'px');
        $('.table-scrolled').css('overflow-y', 'scroll');
    }

");

if ($vendorNormalisedDataProvider->itemCount  > 0) {

    $clientScript->registerScript("table-scrolled", "

        $('document').ready(function() {
            activateLisTableScroll(); 
        });

    ");

} else {

    $clientScript->registerScript("table-scrolled", "

    $('document').ready(function() {
        $('.table-scrolled').css('height', 80 + 'px');
        $('.table-scrolled').css('overflow-y', 'hidden');
    });

    ");
 
}

$clientScript->registerScript("count-parsed-data", "
    var popupError = $('#popup-error');

    countParsedData();

    var countParsedDataInterval = setInterval(function() {
       countParsedData();
        //$.fn.yiiListView.update('list-vendor-normalized');
    }, 3000);

    function countParsedData() {
        console.log('countParsedData...');
        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/countParsedData', ['vendorFileId' => $vendorFile->id]) ."',
            type: 'GET',
            dataType: 'JSON',
            success: function(res) {
                if (res.status == 3 || res.status == 4 || res.status == 5) {
                    clearInterval(countParsedDataInterval);
                }

                if (!$('.advance-search-params-data').is(':visible')) {
                    $('.count-parsed-data').html(res.count);
                }
            },
            error: function(res) {
                console.log(res);
                //alert('Something went wrong.');
            }
        });
    }

");

$clientScript->registerScript("addvance-search", "

    var btnApplyAdvanceSearch = $('#btn-apply-advance-search');
    var btnResetAdvanceSearch = $('.btn-reset-advance-search');
    var popupAdvanceSearch = $('#popup-advance-search')
    var formAdvanceSearch = $('form#advance-search');

    $('.btn-advance-search').click(function() {
        popupAdvanceSearch.modal('show');
    });

    formAdvanceSearch.submit(function(e) {
        e.preventDefault();
        
        $.fn.yiiListView.update('list-vendor-normalized', {
            data: formAdvanceSearch.serialize(),
            beforeSend: function() {
                btnApplyAdvanceSearch.html('Applying...');
                btnApplyAdvanceSearch.prop('disabled', true);
            },
            complete: function() {
                popupAdvanceSearch.modal('hide');

                btnApplyAdvanceSearch.html('Apply');
                btnApplyAdvanceSearch.prop('disabled', false);
            }
        });
    });

    
    $('body').on('click', '.btn-reset-advance-search', function() {
        formAdvanceSearch.find('input').val('');
        formAdvanceSearch.find('select').val('');

        if (!btnResetAdvanceSearch.is(':disabled')) {
            $.fn.yiiListView.update('list-vendor-normalized', {
                data: formAdvanceSearch.serialize(),
                beforeSend: function() {
                    btnResetAdvanceSearch.html('Resetting ...');
                    btnResetAdvanceSearch.prop('disabled', true);
                },
                complete: function() {
                    popupAdvanceSearch.modal('hide');

                    btnResetAdvanceSearch.html('Reset');
                    btnResetAdvanceSearch.prop('disabled', false);
                }
            });
        }
    });
");

$clientScript->registerScript("progress-details", "
    var progressParsing = $('#progress-parsing');
    var progressPushing= $('#progress-pushing');
    var progressSyncing = $('#progress-syncing');
    var popupError = $('#popup-error');
    var getProgressDetailsInterval 

    getProgressDetailsIntervalx();

    function getProgressDetailsIntervalx() {
        getProgressDetailsInterval = setInterval(function() {
        getProgressDetails();
        }, 5000);
    }

    function getProgressDetails() {
        var btnPushVendorToLive = $('.display-push-vendor');
        var btnViewProducts = $('.display-view-products');
        var displayPushingProgress = $('.display-pushing-vendor');
        
        var listParsedItems = $('.parsed-items');

        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/getProgressDetails', ['vendorFileId' => $vendorFile->id]) ."',
            dataType: 'JSON',
            success: function(res) {
                if (res.status == 1 || res.status == 2) {
                    progressParsing.find('span').html('(Parsing...' + res.item_count_parsing + ')');
                    progressParsing.show();
                } else {
                    progressParsing.hide();
                }

                if(res.sync_status == 0 && res.status == 3){
                    progressSyncing.find('span').html('Checking Spreadsheet Data Platform Status.. ' + res.item_count_syncing);
                    progressSyncing.show();
                    $('.btnDownload').addClass('hide');
                    $.fn.yiiListView.update('list-vendor-normalized');
                }else{
                    progressSyncing.hide();
                    $('#btn-push-vendor-to-live').removeClass('hide');
                    $('.btn-price-settings').attr('disabled', false);
                    $('.btn-options button').attr('disabled', false);
                    $('.btn-edit-parsed-data').removeClass('hide');
                    $('#container-alert-hover').html('". $htmlAlertVendorParsedData ."');
                    $('.btnDownload').removeClass('hide');
                    $.fn.yiiListView.update('list-vendor-normalized');
                }

                if ((res.status == 3 || res.status == 8) && res.sync_status == 1) {
                    btnPushVendorToLive.show();

                    //if (listParsedItems.length < res.item_count) {
                    $.fn.yiiListView.update('list-vendor-normalized');
                    //}

                    $('#container-alert-hover').html('". $htmlAlertVendorParsedData ."');
                    //popupError.modal('show');

                    clearInterval(getProgressDetailsInterval);
                }

                if (res.status == 4) {
                    // $('.btn-price-settings').attr('disabled', true);
                    
                    btnPushVendorToLive.hide();
                    btnViewProducts.hide();

                    progressPushing.find('span').html('Publishing Spreadsheet Data to Live (' + res.item_count_pushing + ')');
                    progressPushing.show();

                    lockParsedDataActions();
                } else if (res.status == 5) {
                    // $('.btn-price-settings').attr('disabled', true);

                    btnPushVendorToLive.hide();
                    btnViewProducts.show();
                    $('.btnDownload').html('<span class=\"glyphicon glyphicon-cloud-download\"></span> Download Quick Books (Published)');
                    
                    progressPushing.hide();
                    
                    $('#container-alert-hover').html('". $htmlAlertVendorPushedData ."');
                    
                    //popupError.modal('show');
                    clearInterval(getProgressDetailsInterval);
                } else {
                    btnViewProducts.hide();
                }

                console.log(listParsedItems.length);
            },
            error: function(res) {
                console.log(res);
                //alert('something went wrong!!');
            }
        });
    }

");

$clientScript->registerScript("price-settings", "

    var btnParsedSettings = $('.btn-parsed-settings');
    var popupParsedSettings = $('#popup-parsed-settings');
    var alertParsedSettings = popupParsedSettings.find('.alert');

    btnParsedSettings.click(function() {
        alertParsedSettings.hide();
        alertParsedSettings.removeClass('alert-success');
        alertParsedSettings.removeClass('alert-danger');
        alertParsedSettings.html('');

        popupParsedSettings.modal('show');
    });

    var baseOnColumn = parseInt('". SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN ."');
    var baseOnCost = parseInt('". SettingSalesPrice::SALES_PRICE_SETTING_COST ."');
    var baseOnMSRP = parseInt('". SettingSalesPrice::SALES_PRICE_SETTING_MSRP ."');
    var containerSalesPriceSettingBased = $('#container-sales-price-setting-based');
    var baseCostMarkupContainer  = $('.base-cost-markup-container');
    var baseMsrpMarkupContainer  = $('.base-msrp-markup-container');
    
    var inputPriceSettingColumnName = $('input[name=\"price_setting[column_name]\"]');

    $('select[name=\"price_setting[type]\"]').change(function() {
        var self = $(this);
        var value = self.val();

        if (value == baseOnColumn) {
            containerSalesPriceSettingBased.hide();
            inputPriceSettingColumnName.removeAttr('disabled');
        } else if (value == baseOnCost || value == baseOnMSRP) {
            containerSalesPriceSettingBased.show();
            inputPriceSettingColumnName.attr('disabled', true);
        
            if (value == baseOnCost) {
                baseCostMarkupContainer.show();
                baseMsrpMarkupContainer.hide();
            } else if (value == baseOnMSRP) {
                baseCostMarkupContainer.hide();
                baseMsrpMarkupContainer.show();
            }

        }
    });

    $('body').on('submit', 'form#price-settings', function(e) {
        e.preventDefault();
        
        var self = $(this);

        var submitBtn = self.find('button[type=submit]');
        var submitBtnDefaultText = submitBtn.html();

        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/UpdatePriceSetting', ['vendorFileId' => $vendorFile->id]) ."',
            data: self.serialize(),
            dataType: 'JSON',
            type: 'POST',
            success: function(res) {
                if (res.status == 'ok') {
                    alertParsedSettings.addClass('alert-success');
                    alertParsedSettings.html('<p>'+ res.message +'</p>');
                    alertParsedSettings.fadeIn();

                    $.fn.yiiListView.update('list-vendor-normalized');
                } else {
                    alertParsedSettings.addClass('alert-danger');
                    alertParsedSettings.html('<p>'+ res.message +'</p>');
                    alertParsedSettings.fadeIn();
                }
            },
            error: function(res) {
                console.log(res);
                alert('Something went wrong');
            },
            beforeSend: function() {
                alertParsedSettings.hide();
                alertParsedSettings.removeClass('alert-success');
                alertParsedSettings.removeClass('alert-danger');
                alertParsedSettings.html('');
 
                submitBtn.prop('disabled', true);
                submitBtn.html('Applying...')
            },
            complete: function() {
                submitBtn.prop('disabled', false);
                submitBtn.html(submitBtnDefaultText)
            }
        });
    });

");

$clientScript->registerScript("edit-parsed-data", "

    var formEditParsedData = $('form#edit-parsed-data');
    var alertEditParsedData = formEditParsedData.find('.alert');

    $('body').on('click', '.btn-edit-parsed-data', function(e) {
        e.preventDefault();

        var self = $(this);

        alertEditParsedData.removeClass('alert-success');
        alertEditParsedData.removeClass('alert-danger');
        alertEditParsedData.hide();

        $('#popup-edit-parsed-data').modal('show');
    
        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/getParsedData') ."',
            data: {id: self.attr('data-id')},
            dataType: 'JSON',
            success: function(res) {
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[vendor_normalized_id]\"]').val(res.vendor_normalized_id);
                
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[brand_name]\"]').val(res.brand_name);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[mpn]\"]').val(res.mpn);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[price_sbb]\"]').val(res.price_sbb);

                formEditParsedData.find('input[name=\"VendorNormalizedInfo[cost]\"]').val(res.cost);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[msrp]\"]').val(res.msrp);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[sku]\"]').val(res.sku);

                formEditParsedData.find('input[name=\"VendorNormalizedInfo[ean]\"]').val(res.ean);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[weight]\"]').val(res.weight);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[width]\"]').val(res.width);

                formEditParsedData.find('input[name=\"VendorNormalizedInfo[length]\"]').val(res.length);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[height]\"]').val(res.height);
                formEditParsedData.find('input[name=\"VendorNormalizedInfo[quantity]\"]').val(res.quantity);

                formEditParsedData.find('textarea[name=\"VendorNormalizedInfo[description]\"]').val(res.description);

                formEditParsedData.find('select[name=\"VendorNormalized[status]\"]').val(res.status);
            },
            error: function(res) {
                console.log(res);
                alert('Something went wrong!!');
            }
        });
    });

    formEditParsedData.submit(function(e) {
        e.preventDefault();

        var self = $(this);

        $.ajax({
            url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/EditParsedData') ."',
            data: self.serialize(),
            dataType: 'JSON',
            method: 'POST',
            success: function(res) {
                if (res.status == 'ok') {
                    alertEditParsedData.addClass('alert-success');
                    $.fn.yiiListView.update('list-vendor-normalized');
                } else {
                    alertEditParsedData.addClass('alert-danger');
                }

                alertEditParsedData.html('<p>'+ res.message +'</p>');
                alertEditParsedData.show();
            },
            error: function(res) {
                console.log(res);

            },
            beforeSend: function() {
                alertEditParsedData.removeClass('alert-success');
                alertEditParsedData.removeClass('alert-danger');
                alertEditParsedData.hide();
            }
        });
    });

");

$clientScript->registerScript("list-item-report", "

$('body').on('click', '.btn-item-report', function(e) {
    e.preventDefault();

    var self = $(this);
    var popupItemReport = $('#popup-item-report');
    
    popupItemReport.find('.alert').html(self.attr('data-report'));
    popupItemReport.modal('show');
});

");

$clientScript->registerScript("review-list", "
    $('.btn-refresh-parsed-list').click(function(e){
        e.preventDefault();

        var self = $(this);
        var defaultText = self.html();

        self.html('Re-loading...');

        $.fn.yiiListView.update('list-vendor-normalized', {
            complete: function() {
                self.html(defaultText);
            }
        });
    });
");

if ($vendorFile->status != VendorFile::STATUS_FOR_REVIEW) {

    $clientScript->registerScript("", "

        $(document).ready(function() {
            lockParsedDataActions();
        });
     ");

}

$clientScript->registerScript("review-general", "
    function lockParsedDataActions() {
        var btn1 = $('.btn-refresh-parsed-list');
        var btn2 = $('.btn-parsed-settings');
        var btn3 = $('.btn-advance-search');
        var btn4 = $('.btn-parsed-details');
        var btn5 = $('.btn-delete-data-multiple');
        var btn6 = $('.btn-options');

        var listCheckbox1 = $('.checkbox-review-data');
        var listCheckbox2 = $('.select-all-review-data');
        var listBtn1 = $('.btn-edit-parsed-data');

        //btn1.addClass('disabled');
        btn2.addClass('disabled');
        //btn3.addClass('disabled');
        //btn4.addClass('disabled');
        btn5.addClass('disabled');
        btn6.hide();

        listCheckbox1.prop('disabled', true);
        listCheckbox2.prop('disabled', true);
        listBtn1.hide();
    }
");

$clientScript->registerScript("re-check-product-status", "

$('.btn-re-check-product').click(function(e) {
    e.preventDefault();

    var self = $(this);
    var selfDefaultText = self.html();

    $.ajax({
        url: '". Yii::app()->createAbsoluteUrl('ReviewVendorSpreadsheet/RecheckProductStatus', ['vendorFileId' => $vendorFile->id]) ."',
        dataType: 'JSON',
        success: function(res) {

            if (res.status == 'error') {
                $('#popup-push-confirm').modal('hide');

                bootbox.alert({
                    size: 'medium',
                    message: res.message
                });          

                btnConfirmStep1.attr('disabled', true);
                btnConfirmStep2.attr('disabled', false);
                btnConfirmStep3.attr('disabled', true);

                btnConfirmStep2.html('Confirm');
            } else {
                btnConfirmStep2.removeClass('btn-primary');
                btnConfirmStep2.addClass('btn-success');
                btnConfirmStep2.html('<span class=\"glyphicon glyphicon-ok\"></span> Confirmed');
    
                panelStepConfirm2.removeClass('panel-primary');
                panelStepConfirm2.addClass('panel-success');
            }

            $.fn.yiiListView.update('list-vendor-normalized');
        },
        error: function(res) {
            console.log(res);
            alert('Something went wrong');
        },
        beforeSend: function() {
            btnConfirmStep1.attr('disabled', true);
            btnConfirmStep2.attr('disabled', true);
            btnConfirmStep3.attr('disabled', true);

            btnConfirmStep2.html('Confirming... Please Wait...');
        },
        complete: function() {
            btnConfirmStep3.attr('disabled', false);
        }
    });
});

");


$clientScript->registerScript("publish-confirmation", "
    var panelStepConfirm1 = $('#panel-step-confirm-1');
    var panelStepConfirm2 = $('#panel-step-confirm-2');
    var panelStepConfirm3 = $('#panel-step-confirm-3');

    var btnConfirmStep1 = $('#btn-confirm-step-1');
    var btnConfirmStep2 = $('#btn-confirm-step-2');
    var btnConfirmStep3 = $('#btn-confirm-step-3');

    btnConfirmStep1.click(function() {
        btnConfirmStep1.attr('disabled', true);
        btnConfirmStep2.attr('disabled', false);
        btnConfirmStep3.attr('disabled', true);

        btnConfirmStep1.removeClass('btn-primary');
        btnConfirmStep1.addClass('btn-success');
        btnConfirmStep1.html('<span class=\"glyphicon glyphicon-ok\"></span> Confirmed');

        panelStepConfirm1.removeClass('panel-primary');
        panelStepConfirm1.addClass('panel-success');
    });

    btnConfirmStep2.click(function() {
        $('.btn-re-check-product').trigger('click');
    });

");

$clientScript->registerScript("price-setting-gss", "

var btnGssPriceSetting = $('.btn-gss-price-setting'); 
var popupGssPriceSetting = $('#popup-gss-price-setting');
var formGssPriceSetting = $('#form-gss-price-setting');
var dropdownGssPriceSetting = formGssPriceSetting.find('select#pricing_group_id');
var dropdownPriceTypeGssPriceSetting = formGssPriceSetting.find('select#pricing_type');
var containerPriceTierGssPriceSetting = popupGssPriceSetting.find('.container-price-tier-gss-price-setting'); 
var containerEmptyPriceTierGssPriceSetting = popupGssPriceSetting.find('.container-empty-price-tier-gss-price-setting'); 
var alertGssPriceSetting = popupGssPriceSetting.find('.alert-gss-price-setting');
var autoSelectPricingGroupIdGssPriceSetting = '". (isset($priceSettingDefaultGss['pricing_group_id']) ? $priceSettingDefaultGss['pricing_group_id'] : '') ."';
var autoSelectPricingTypeGssPriceSetting = '". (isset($priceSettingDefaultGss['pricing_type']) ? $priceSettingDefaultGss['pricing_type'] : '') ."';

btnGssPriceSetting.click(function(e) {
    e.preventDefault();

    alertGssPriceSetting.removeClass('alert-danger alert-success');
    alertGssPriceSetting.html('');
    alertGssPriceSetting.hide();

    if (autoSelectPricingGroupIdGssPriceSetting != '') {
        dropdownGssPriceSetting.val(autoSelectPricingGroupIdGssPriceSetting);
        getPricingGroupPricingTier(autoSelectPricingGroupIdGssPriceSetting, autoSelectPricingTypeGssPriceSetting);
    }

    popupGssPriceSetting.modal('show');
});

dropdownGssPriceSetting.change(function() {
    if ($(this).val() != '') {
        getPricingGroupPricingTier($(this).val());
        dropdownPriceTypeGssPriceSetting.attr('disabled', false);
    } else {
        containerPriceTierGssPriceSetting.hide();
        dropdownPriceTypeGssPriceSetting.attr('disabled', true);
        $('#pricing_type_x').val('');
    }
});

formGssPriceSetting.submit(function(e) {
    e.preventDefault();

    var submitFormButton = formGssPriceSetting.find('button.btn-primary');
    var submitFormButtonOriginalState = submitFormButton.text();

    $.ajax({
        url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/createUpdatePriceSettingGss', ['spreedsheetId' => $vendorFile->id]) ."',
        data: formGssPriceSetting.serialize(),
        method: 'POST',
        dataType: 'JSON',
        success: function(res) {
            if (res.status == 'ok') {
                alertGssPriceSetting.addClass('alert-success');
                alertGssPriceSetting.html(res.message);
                alertGssPriceSetting.fadeIn();

                autoSelectPricingGroupIdGssPriceSetting = formGssPriceSetting.find('select[name=pricing_group_id]').val();
                autoSelectPricingTypeGssPriceSetting = formGssPriceSetting.find('input[name=pricing_type]:checked').val();

                $.fn.yiiListView.update('list-vendor-normalized');
            } else {
                alertGssPriceSetting.addClass('alert-danger');
                alertGssPriceSetting.html(res.message);
                alertGssPriceSetting.fadeIn();
            }
        },
        beforeSend: function() {
            submitFormButton.text('Applying... Please wait...');
            submitFormButton.attr('disabled', true);

            alertGssPriceSetting.removeClass('alert-danger alert-success');
            alertGssPriceSetting.html('');
            alertGssPriceSetting.hide();
        },
        error: function(res) {
            console.log(res);
            alertGssPriceSetting.addClass('alert-danger');
            alertGssPriceSetting.html('Something went wrong with the request.');
            alertGssPriceSetting.fadeIn();
        },
        complete: function() {
            submitFormButton.text(submitFormButtonOriginalState);
            submitFormButton.attr('disabled', false);


            $('.btn-options').hide();
        }
    });
});

function getPricingGroupPricingTier(pricingGroupId, pricingType) {
    var pringGroupId = parseInt(pricingGroupId);
    var pricingType = (typeof pricingType != 'undefined') ? parseInt(pricingType) : '';

    containerEmptyPriceTierGssPriceSetting.hide();
    containerPriceTierGssPriceSetting.hide();

    if (pringGroupId == '') {
        containerEmptyPriceTierGssPriceSetting.fadeIn();
        containerPriceTierGssPriceSetting.hide();
        return;
    }

    $.ajax({
        url: '". Yii::app()->createAbsoluteUrl('pricingGroup/getPricingGroupPricingTier') ."',
        data: {id: pringGroupId},
        success: function(res) {
            containerPriceTierGssPriceSetting.html(res);
            containerPriceTierGssPriceSetting.fadeIn();

            if (pricingType != '') {
                formGssPriceSetting.find('#pricing_type').attr('disabled', false);
                formGssPriceSetting.find('#pricing_type').val(pricingType);
               //$('input[type=radio][value='+pricingType+']').prop('checked', true);
            }
        }, 
        error: function(e) {
            alert('Invalid Request');
        }
    });
}

$('body').on('mouseenter', '.show-product-pricing-gss', function() {
    var self = $(this);
    var parsedId = self.attr('data-parsed-id');
    var popover = self.next('.popover');
    var popoverContent = popover.find('.popover-content');

    $.ajax({
        url: '". Yii::app()->createAbsoluteUrl('reviewVendorSpreadsheet/getParsedDataGssPricing') ."',
        data: {parsedId: parsedId},
        success: function(res) {
            popoverContent.html(res);
        },
        error: function(res) {
            console.log(res);
            popoverContent.html('Something went wrong.');
        },
        beforeSend: function() {
            popoverContent.html('<em>Retrieving product pricing... Please wait...</em>');
        }
    });
});

");

if (in_array($vendorFile->status, [VendorFile::STATUS_PUSHING, VendorFile::STATUS_PUSHED])) {
    $clientScript->registerScript("pricing-button-disabled", "
        $('.btn-price-settings').attr('disabled', true);
    ");
}



?>