<?php

$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
    'condition' => 'mpn = :mpn AND status = :status',
    'params' => [
        ':mpn' => trim($data['mpn']),
        ':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
    ]
]);

$statusBackgroundColor = '';
$disabledDelCheckbox = false;
$report = '';

if ($data['product_status'] == VendorNormalized::PRODUCT_STATUS_NEW) {
    $statusBackgroundColor = 'success';
}

if ($data['product_status'] == VendorNormalized::PRODUCT_STATUS_REMAIN) {

}

if ($data['product_status'] == VendorNormalized::PRODUCT_STATUS_UPDATED) {
    $statusBackgroundColor = 'info';
}

if ($data['product_status'] == VendorNormalized::PRODUCT_STATUS_EOL) {
    $statusBackgroundColor = 'warning';
}

if ($data['status'] == VendorNormalized::STATUS_ERROR_VALIDATION) {
    $statusBackgroundColor = 'danger';
    $report = '<span class="label label-danger">' . $data['report'] . '</span>';
}

if ($data['status'] == VendorNormalized::STATUS_DELETED) {
    $statusBackgroundColor = 'danger';
    $disabledDelCheckbox = true;
}

if($data['product_from'] == VendorNormalized::PRODUCT_FROM_WEBSITE && $data['product_status'] != VendorNormalized::PRODUCT_STATUS_EOL){
    $statusBackgroundColor = 'info';
    $report = '<span class="label label-info">NON-EOL</span>';
}

if($data['cost'] == 0 || $data['msrp'] == 0){
    $statusBackgroundColor = 'danger';
}




?>

<tr class="<?php echo $statusBackgroundColor; ?>">
    <td class="text-center default-padding  parsed-items">
        <input type="checkbox" name="normalize_data_ids[]" value="<?php echo $data['id']; ?>" class="checkbox-review-data" <?php echo $disabledDelCheckbox ? 'disabled' : '';?>>
    </td>
    <td class="text-center">
        <?php if($data['product_status'] != VendorNormalized::PRODUCT_STATUS_EOL): ?>
        <?php echo VendorNormalized::getPlatformStatusLabelWithColor($data['platform_1_rest_status'], 'SBB'); ?>
        <?php echo VendorNormalized::getPlatformStatusLabelWithColor($data['platform_2_rest_status'], 'GSS'); ?>
        <?php else: ?>
        <?php echo VendorNormalized::getPlatformStatusLabelWithColor(VendorNormalized::REST_STATUS_EOL, 'SBB'); ?>
        <?php echo VendorNormalized::getPlatformStatusLabelWithColor(VendorNormalized::REST_STATUS_EOL, 'GSS'); ?>
        <?php endif; ?>
        <?php //echo VendorNormalized::getProductStatusLabelWithColor($data['product_status']); ?>
    </td>
    <td><?php echo $data['brand_name']; ?></td>
    <td>
        <a href="#" title="Edit Data" class="btn-edit-parsed-data <?php echo ($vendorFile->sync_status == VendorFile::SYNC_STATUS_SYNCING || $vendorFile->status == VendorFile::STATUS_PUSHED) ? 'hide' : ''; ?>" data-id="<?php echo $data['id']; ?>"><span class="fa fa-pencil"></span></a>
        <?php 
        
        echo '<span>' . $data['mpn'] . '</span>&nbsp;'; 
        echo  $report; 
        
        ?>
        <?php if ($data['status'] == VendorNormalized::STATUS_ERROR_PUSHING) : ?>
            <?php echo CHtml::link('<span class="glyphicon glyphicon-question-sign"></span> Error', '#', ['class' => 'label label-danger btn-item-report', 'data-report' => $data['report']]); ?>
        <?php endif; ?>

        <?php if ($data['status'] == VendorNormalized::STATUS_DELETED) : ?>
            <?php echo VendorNormalized::getStatusLabelWithColor(VendorNormalized::STATUS_DELETED); ?>
         <?php endif; ?>

         <?php if ($data['product_status'] == VendorNormalized::PRODUCT_STATUS_EOL && $data['status'] != VendorNormalized::STATUS_DELETED){
         	echo VendorNormalized::getProductStatusLabelWithColor(VendorNormalized::PRODUCT_STATUS_EOL);
         }?>
    </td>
    <td>
        <?php if (!empty($data['price_sbb']) && $data['price_sbb'] != '0.00') : ?>
            <?php if ($normalizedLockPricing) : ?>
                <i class="fa fa-lock" title="Pricing is lock and cannot be changed"></i>
            <?php endif; ?>

            <?php echo ZCommon::formatWithDecimal($data['price_sbb']); ?>
        <?php else : ?>
            <span class="label label-danger" style="font-size: 8px;">Price Not Set</span>
        <?php endif; ?>

        
    </td>
    <td class="container-gss-pricing">
        <?php
            if($data['product_from'] == VendorNormalized::PRODUCT_FROM_SPREADSHEET){
                if ($gssPricingGroupName != '') {
                    echo CHtml::link($gssPricingGroupName, '#', [
                        'class' => 'label label-info show-product-pricing-gss',
                        'data-trigger' => 'hover',
                        'data-toggle' => 'popover',
                        'data-placement' => 'left',
                        'data-title' => 'Product Pricing Levels',
                        'data-parsed-id' => $data['id']]);
                } else {
                    echo "<span class='label label-danger' style='font-size: 8px;'>Price Not Set</span>";
                }
            }else{
                echo "<span class='label label-danger' style='font-size: 8px;'>Price Not Set</span>";
            }
        ?>
    </td> 
    <td><span class="<?php echo ($data['cost'] == 0 ? 'label label-warning' : '' ); ?>"> <?php echo ($data['cost'] == 0 ? '<span class="fa fa-exclamation-triangle"></span>' : ''); ?> <?php echo ZCommon::formatWithDecimal($data['cost']); ?></span></td>
    <td><span class="<?php echo ($data['msrp'] == 0 ? 'label label-warning' : '' ); ?>"> <?php echo ($data['msrp'] == 0 ? '<span class="fa fa-exclamation-triangle"></span>' : ''); ?> <?php echo ZCommon::formatWithDecimal($data['msrp']); ?></span></td>
    <td><?php echo $data['sku']; ?></td>
    <td><?php echo $data['ean']; ?></td>
    <td><?php echo $data['weight']; ?></td>
    <td><?php echo $data['width']; ?></td>
    <td><?php echo $data['length']; ?></td>
    <td><?php echo $data['height']; ?></td>
    <!-- <td><?php echo $data['quantity']; ?></td> -->
</tr>