<h1 class="page-header"><?php echo $title; ?> - <?php echo $model->subject; ?></h1>

<div>
	<h3>Emailer Details</h3>

	<table class="table table-bordered">
		<colgroup>
			<col class="col-md-4">
			<col class="col-md-8">
		</colgroup>
		<tr>
			<th>Subject</th>
			<td><?php echo $model->subject; ?></td>
		</tr>
		<tr>
			<th>Outbound Name</th>
			<td><?php echo $model->outbound_name; ?></td>
		</tr>
		<tr>
			<th>Date Created</th>
			<td><?php echo (new DateTime($model->date_created))->format('M d, Y'); ?></td>
		</tr>
	</table>
</div>

<h3>Contacts <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ":""); ?></h3>
<div class="table-responsive">
	<?php 
	$this->widget('zii.widgets.CListView', array(
		'dataProvider' => $dataProvider,
		'itemsTagName' => 'table',
		'itemsCssClass' => 'table table-hover',
		// 'template' => ' {items} <br/> {pager}'   ,
		'template' => ' {items} {summary} {pager}',
		'itemView' => 'application.yii_app_emailer.yii_app_emailer_views.report._contact',
		'viewData' => array(
			'pagination' => $dataProvider->getPagination(),
			'model' => $model
		),
		'pager' => array(
			// 'class' => 'BootstrapLinkPager', 
			'cssFile' => false, 
			'header' => false, 
			'firstPageLabel' => '&lt;&lt;',
			'prevPageLabel' => '&lt;',
			'nextPageLabel' => '&gt;',
			'lastPageLabel' => '&gt;&gt;',
		),
		'htmlOptions' => array(
			'style' => 'width:2000px;overflow-x:auto;'
		)
	));
	?>
</div>