<?php

$product = $data->product;

$productPricingGroup = PricingGroup::getProductPricingGroup($product->id);

$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
    'condition' => 'mpn = :mpn AND status = :status',
    'params' => [
        ':mpn' => trim($data['mpn']),
        ':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
    ]
]);

$itemBackground = '';
$itemLabel = '';

$platform1StatusIcon = 'fa-exclamation-triangle';
$platform2StatusIcon = 'fa-exclamation-triangle';
$platform3StatusIcon = 'fa-exclamation-triangle';
$platform4StatusIcon = 'fa-exclamation-triangle';

$platform1StatusLabelColor = 'danger';
$platform2StatusLabelColor = 'danger';
$platform3StatusLabelColor = 'danger';
$platform4StatusLabelColor = 'danger';

$platform1StatusLabel = Product::getRestStatusLabel($product->platform_1_rest_status, 1);
$platform2StatusLabel = Product::getRestStatusLabel($product->platform_2_rest_status, 2);
$platform3StatusLabel = Product::getRestStatusLabel($product->platform_3_rest_status, 3);
$platform4StatusLabel = Product::getRestStatusLabel($product->platform_4_rest_status, 4);

$platform1StatusContent = Product::getRestStatusContent($product->platform_1_rest_status, 1, $product->platform_1_rest_error);
$platform2StatusContent = Product::getRestStatusContent($product->platform_2_rest_status, 2, $product->platform_2_rest_error);
$platform3StatusContent = Product::getRestStatusContent($product->platform_3_rest_status, 3, $product->platform_3_rest_error);
$platform4StatusContent = Product::getRestStatusContent($product->platform_4_rest_status, 4, $product->platform_4_rest_error);

$platFormSuccessStatus = Product::getPlatformSuccessStatus();

if (in_array($product->platform_1_rest_status, $platFormSuccessStatus)) {
    $platform1StatusIcon = 'fa-check';
    $platform1StatusLabelColor = 'success';
} else {
    $itemBackground = 'danger';
}

if (in_array($product->platform_2_rest_status, $platFormSuccessStatus)) {
    $platform2StatusIcon = 'fa-check';
    $platform2StatusLabelColor = 'success';
} else {
    $itemBackground = 'danger';
}

if (in_array($product->platform_3_rest_status, $platFormSuccessStatus)) {
    $platform3StatusIcon = 'fa-check'; 
    $platform3StatusLabelColor = 'success'; 
} else if($product->platform_3_rest_status == Product::REST_STATUS_DISABLED){
    $platform3StatusIcon = 'fa-info';
    $platform3StatusLabelColor = 'info';
} else {
    $itemBackground = 'danger';
}

if (in_array($product->platform_4_rest_status, $platFormSuccessStatus)) {
    $platform4StatusIcon = 'fa-check'; 
    $platform4StatusLabelColor = 'success'; 
} else if($product->platform_4_rest_status == Product::REST_STATUS_DISABLED){
    $platform4StatusIcon = 'fa-info';
    $platform4StatusLabelColor = 'info';
} else {
    $itemBackground = 'danger';
}

if ($product->product_status == Product::PRODUCT_STATUS_EOL) {
    $itemBackground = 'warning';
    $itemLabel = '<label class="label label-warning">'. Product::getProductStatusLabel(Product::PRODUCT_STATUS_EOL) .'</label>';
    $platformEOLLabel = 'API : EOL Product Status';
    $platformEOLContent = 'Product data was not update in website due to possible reasons: <ul>
    <li>Product status is EOL</li>';
    $platformEOLIcon = 'fa-exclamation-triangle';
    $platformEOLLabelColor = 'warning';
}

if($data->cost == 0 || $data->msrp == 0){
    $itemBackground = 'danger';
}

$brandName = Vendor::getVendorNameLabel($product->vendor_id);

$priceSbb = (float) $data->sbb_price;

?>

<tr class="<?php echo $itemBackground; ?>">
    <td class="default-padding">
        <input type="checkbox" name="product_ids[]" value="<?php echo $product->id; ?>" class="checkbox-review-data">
    </td>
    <td>        
        <?php 

        echo CHtml::link('<span class="fa '. $platform1StatusIcon .'"></span> '. Product::getStatusLabelShort(Product::WEBSITE_SBB), '#', [
            'class' => 'label label-' . $platform1StatusLabelColor,
            'data-html' => true,
            'data-toggle' => 'popover',
            'data-trigger' => 'hover',
            'data-title' => $platform1StatusLabel,
            'data-content' => '<small>' . $platform1StatusContent. '</small>']) . '&nbsp;'; 

        echo CHtml::link('<span class="fa '. $platform2StatusIcon .'"></span> '. Product::getStatusLabelShort(Product::WEBSITE_GSS), '#', [
            'class' => 'label label-' . $platform2StatusLabelColor,
            'data-html' => true,
            'data-toggle' => 'popover',
            'data-trigger' => 'hover',
            'data-title' => $platform2StatusLabel,
            'data-content' => '<small>' . $platform2StatusContent. '</small>']) . '&nbsp;'; 

        echo CHtml::link('<span class="fa '. ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform3StatusIcon : $platformEOLIcon) .'""></span> '. Product::getStatusLabelShort(Product::WEBSITE_GOOGLE_MERCHANT), '#', [
            'class' => 'label label-' . ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform3StatusLabelColor : $platformEOLLabelColor),
            'data-html' => true,
            'data-toggle' => 'popover',
            'data-trigger' => 'hover',
            'data-title' => ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform3StatusLabel : $platformEOLLabel),
            'data-content' => '<small>' . ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform3StatusContent : $platformEOLContent) . '</small>']) . '&nbsp;'; 

        echo CHtml::link('<span class="fa '. ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform4StatusIcon : $platformEOLIcon) .'""></span> '. Product::getStatusLabelShort(Product::WEBSITE_GOOGLE_MERCHANT_GSS), '#', [
            'class' => 'label label-' . ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform4StatusLabelColor : $platformEOLLabelColor),
            'data-html' => true,
            'data-toggle' => 'popover',
            'data-trigger' => 'hover',
            'data-title' => ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform4StatusLabel : $platformEOLLabel),
            'data-content' => '<small>' . ($product->product_status != Product::PRODUCT_STATUS_EOL ? $platform4StatusContent : $platformEOLContent) . '</small>']) . '&nbsp;'; 

        ?>
    </td>
    <td><?php echo $brandName; ?></td>
    <td>   
        <a href="#" title="Edit Data" class="btn-edit-product-data" data-id="<?php echo $product->id; ?>"><span class="fa fa-pencil"></span></a>
        <?php echo $data->mpn; ?>&nbsp;
        <?php echo $itemLabel;  ?>
    </td>
    <td>
        <?php if ($normalizedLockPricing) : ?>
            <i class="fa fa-lock" title="Pricing is lock and cannot be changed"></i>
        <?php endif; ?>

        <?php if (!empty($priceSbb)) : ?>
            <?php echo ZCommon::formatWithDecimal($priceSbb); ?>
        <?php else : ?>
            <span class="label label-danger" style="font-size: 8px;">Price Not Set</span>
        <?php endif; ?>
    </td>
    <td class="container-gss-pricing">
        <?php

        $productPricingGroupStatusLabelColor = 'label-warning';
        $productPricingGroupStatusLabel = '<span class="label label-warning">Pending in Live</span>';
        
        if (!$product->hasPendingPriceLevel()) {
            $productPricingGroupStatusLabelColor = 'label-info';
            $productPricingGroupStatusLabel = '<span class="label label-info">Published in Live</span>';
        }

        if ($productPricingGroup != '') {
            echo CHtml::link('<span class="label product-pricing-tier-label-status-' . $product->id . ' ' . $productPricingGroupStatusLabelColor .'">'. $productPricingGroup->group_name . '</span>', '#', [
				'class' => 'show-product-pricing-gss',
                'data-trigger' => 'hover',
                'data-html' => true,
				'data-toggle' => 'popover',
                'data-placement' => 'left',
                'data-title' => '<strong>Product Pricing Level</strong> - ' . $data->mpn,
                'data-product-id' => $product->id]);
        } else {
            echo '<span class="label label-danger" style="font-size: 8px;">Price Not Set</span>';
        }

        ?>
    </td>
    <td><span class="<?php echo ($data->cost == 0 ? 'label label-warning' : '' ); ?>"> <?php echo ($data->cost == 0 ? '<span class="fa fa-exclamation-triangle"></span>' : ''); ?> <?php echo ZCommon::formatWithDecimal($data->cost); ?></span></td>
    <td><span class="<?php echo ($data->msrp == 0 ? 'label label-warning' : '' ); ?>"> <?php echo ($data->msrp == 0 ? '<span class="fa fa-exclamation-triangle"></span>' : ''); ?> <?php echo ZCommon::formatWithDecimal($data->msrp); ?></span></td>
    <td><?php echo $data->sku; ?></td>
    <td><?php echo $data->ean; ?></td>
    <td><?php echo $data->description; ?></td>
    <td><?php echo $data->weight; ?></td>
    <td><?php echo $data->width; ?></td>
    <td><?php echo $data->length; ?></td>
    <td><?php echo $data->height; ?></td>
    <!--<td><?php echo $data->quantity; ?></td>-->
</tr>