<h1 class="page-header">Pricing Group: <?php echo $pricingGroup->group_name; ?>&nbsp;<?php echo CHtml::link('<span><i class="fa fa-pencil"></i>&nbsp;Edit</span>', Yii::app()->createUrl('pricingGroup/update', array('id' => $pricingGroup->id)), [
  'title' => 'Update Details',
  'class' => 'edit btn btn-primary btn-xs'
  ]); ?>
</h1>
<div class="row" style="margin-bottom: 10px;">
  <div class="col-md-12">
    <?php $this->widget('Flash', array('flashes' => Yii::app()->user->getFlashes())); ?>
  </div>
  <div class="col-md-12 text-right">
    <?php echo CHtml::link('<span class="glyphicon glyphicon-plus"></span> Add More Pricing Tier', ['pricingGroup/tier/action/create/group/' . $pricingGroup->id], [
      'class' => 'btn btn-primary btn-sm', 
      'title' => 'Create Account Group'
    ]); ?>
  </div>
</div>
<?php

$this->widget('zii.widgets.CListView', array(
  'dataProvider' => $pricingTierDataProvider,
  'viewData' => array('parentGroupStatus' => $pricingGroup->status),
  'itemView' => '_priceTierListing',
  'template' => '
          {items}
    {pager}
  ',
  'itemsCssClass' => 'row items',
  'emptyText' => '<tr><td colspan="16" class="text-center">No data available.</td></tr>',
  'pager' => array(
    'cssFile' => false,
    'header' => false,
    'firstPageLabel' => '&lt;&lt;',
    'prevPageLabel' => '&lt;',
    'nextPageLabel' => '&gt;',
    'lastPageLabel' => '&gt;&gt;'
  ),
));

$clientScript = Yii::app()->clientScript;
$clientScript->registerCss("list_style", "
  .list-view table thead th, table tbody td {
      white-space: nowrap;
      padding-left: 5px !important;
      padding-right: 20px !important;
  }

  .list-view table thead th.default-padding, table tbody td.default-padding {
      padding-left: 5px !important;
      padding-right: 5px !important;
  }

  .list-view table tbody td {
      font-size: 13px;
  }


  /* make this code global */
  ul.yiiPager {
      padding-left: 0px !important;
      margin-bottom: 0px !important;
  }

  ul.yiiPager .previous {
      float: left !important;
  }

  .list-view div.summary, .list-view .pager {
      text-align: center !important;
  }

  .pager li > a, .pager li > span {
      padding: 0px 15px !important;
      border-radius: initial;
  }

  .list-view  .label {
      font-size: 11px;
  }

  .progress-bar {
      padding: 6px;   
  }

  .progress-bar {
      font-size: 14px;
  }

  .pager .next > a, .pager .next > span {
      float: none;
  }

  ul.yiiPager .previous {
      float: none !important;
  }

  .pager .previous > a, .pager .previous > span {
      float: none;
  }

  /*.items{
    display: -webkit-box;
    display: -webkit-flex;
    display: -ms-flexbox;
    display: flex;
    flex-wrap: wrap;
  }
  .items > [class*='col-'] {
    display: flex;
    flex-direction: column;

  }*/

  .table{
    margin: 0;
    table-layout: fixed;
    white-space: nowrap;
  }

  .table thead tr th, .table tbody tr td{
    white-space: normal;
  }


  .item-container{
    height: 100%;
    min-height: 360px;
  }

  .tier-footer{
    background-color: #F5F5F5;
    padding: 10px;
  }

  .swal-title{
    font-size:17px;
  }

  .swal-text{
    font-size:12px;
    text-align: center;
  }

  .swal-modal{
    height:280px;
    width: 300px;
  }

  .swal-icon{
    padding:0;
    margin-bottom: 0;
    margin-top: 0;
  }  

  .swal-icon--warning{
    width:50px;
    height:50px;
  }

  .swal-icon--warning > [class*='swal-icon--']{
    margin-top: 0;
    width:5px;
    height:22px;
  }

");
$clientScript->registerScriptFile(Yii::app()->request->baseUrl.'/js/plugins/sweetalert/sweetalert.min.js', 0);
$clientScript->registerScript('script', '
  $(".confirmation").on("click", function(e){
    e.preventDefault();
    var link = $(this).attr("href");
    var action = $(this).attr("data-action");

    swal({
        icon: "warning",
        imageWidth: "50",
        imageHeight: "50",
        title: "Are you sure you want to "+action+" this pricing group?",
        text: "You will not be able to undo this once you confirmed!",
        buttons: {
          cancel: {
            text: "Cancel",
            value: null,
            visible: true,
            className: "btn btn-default",
            closeModal: true,
          },
          confirm: {
            text: "Confirm",
            value: true,
            visible: true,
            className: "btn btn-info",
            closeModal: true
          },
        },
      }).then((isConfirm) => {
          if(isConfirm){
            window.location.href = link;
          }
      });
  })
');

?>