<?php

/*Mix the javascript and php*/
    $wpRoles = PricingTierWpRole::model()->getActiveWpRole(); 
    $script = 'var count = '.($action != "update" ? 1 : count($pricingTierDescriptions)).'
    var div = '.($action != "update" ? 1 : count($pricingTierDescriptions)).'

/*Javascript event area*/
    $(".addTier").on("click", function(){
      $(".addTier").attr("disabled", true);
      div++;
      count++;

      var divTier = "#tier"+div;

      var contentClone = \'<div class="price-tier-content" id="tier\'+div+\'">\
      <hr width="100%" style="border: solid 1px black;">\
      <div class="row">\
        <div class="col-md-12">\
          <div class="form-group">\
            <label>Tier Name</label>\
            <input type="text" class="form-control" name="tierName[]" placeholder="Tier Name" required="required">\
          </div>\
        </div>\
      </div>\
      <div class="row">\
        <div class="col-md-12">\
          <table class="table table-condensed table-bordered table-striped table-hover header-fixed table-list">\
            <thead>\
              <th width="30%">Vendor</th>\
              <th>Cost Markup</th>\
              <th>MSRP Markdown</th>\
              <th>Price Type</th>\
            </thead>\
            <tbody>';

                foreach ($vendors as $vendor):

                $script .= '<tr>\
                  <td>'.$vendor->name.'</td>\
                  <td>\
                    <div class="input-group">\
                      <input class="form-control" type="number" name="markUp['.$vendor->id.'][]" placeholder="0" min="0" max="100">\
                      <span class="input-group-addon">%</span>\
                    </div>\
                  </td>\
                  <td>\
                    <div class="input-group">\
                      <input class="form-control" type="number" name="markDown['.$vendor->id.'][]" placeholder="0" min="0" max="100">\
                      <span class="input-group-addon">%</span>\
                    </div>\
                  </td>\
                  <td>\
                    <select class="form-control" name="priceType['.$vendor->id.'][]" required>\
                      <option value="">Select Price Type</option>\
                      <option value="1">Markup</option>\
                      <option value="2">Markdown</option>\
                    </select>\
                  </td>\
                </tr>';

              endforeach;

            $script .= '</tbody>\
          </table>\
        </div>\
      </div>\
      <div class="row">\
        <div class="col-md-6">\
          <div class="form-group">\
            <label>Description</label>\
            <textarea class="form-control" name="description[]" placeholder="Description"></textarea>\
          </div>\
        </div>\
        <div class="col-md-6">\
          <div class="form-group">\
            <label>Woocommerce Price role&nbsp;</label>\
            <select class="form-control wp-role" name="wpRole[]" onChange="customRole($(this),\'+"\'"+divTier+"\'"+\')" required>\
              <option value="">Select Pricing Role</option>';
              foreach ($wpRoles as $key => $wpRole) 
              {
                $script .= '<option value="'.$key.'">'.$wpRole.'</option>';
              }
    $script .= '</select>\
          </div>\
        </div>\
      </div>\
      <div class="row">\
        <div class="col-md-8 pull-right div-remove">\
          <button type="button" class="btn btn-danger btn-remove-tier pull-right hide" onclick="removeTier(\'+"\'"+divTier+"\'"+\')">Remove</button>\
        </div>\
      </div>\
    </div>\
  \';

      $(contentClone).appendTo("#tierList");
      $(".wp-role").trigger("change");
      if($(".btn-remove-tier").hasClass("hide"))
      {
        $(".btn-remove-tier").removeClass("hide");
      }
      $("html, body").animate({
        scrollTop: $(divTier).offset().top
      },1000);
      $(".addTier").attr("disabled", false);
    })


    //get back to validate button if role key is change.
    $("#roleKey").on("change", function(e){
      if($("#btnValidateRole").hasClass("hide")){
        $("#roleKey").removeClass("is-valid");
        $("#roleKey").removeClass("is-invalid");
        $("#roleName").removeClass("is-valid");
        $("#roleName").removeClass("is-invalid");
        $("#btnValidateRole").removeClass("hide");
        $("#btnSaveRole").addClass("hide");
      }
    });

    //get back to validate button if role name is empty.
    $("#roleName").on("change", function(e){
      if($("#btnValidateRole").hasClass("hide") && $(this).val() == ""){
        $("#roleKey").removeClass("is-valid");
        $("#roleKey").removeClass("is-invalid");
        $("#roleName").removeClass("is-valid");
        $("#roleName").removeClass("is-invalid");
        $("#btnValidateRole").removeClass("hide");
        $("#btnSaveRole").addClass("hide");
      }
    });

    $("#customPricingRole").on("hidden.bs.modal", function () {
      $("#roleKey").removeClass("is-valid");
      $("#roleKey").removeClass("is-invalid");
      $("#roleName").removeClass("is-valid");
      $("#roleName").removeClass("is-invalid");
      $("#btnValidateRole").removeClass("hide");
      $("#btnSaveRole").addClass("hide");
    });

    //for validating custom role
    $("#btnValidateRole").on("click", function(e){
      e.preventDefault();
      var validName = true;
      var validKey = true;
      $("#btnValidateRole").attr("disabled", true);
      $("#roleKey").removeClass("is-invalid");
      $("#roleKey").removeClass("is-valid");
      $("#roleName").removeClass("is-invalid");
      $("#roleName").removeClass("is-valid");

      if($("#roleName").val() == ""){
        $("#roleName").addClass("is-invalid");
        $("#roleNameFeedback").html("Role name can\'t be empty!");
        validName = false;
      }

      if($("#roleKey").val() == ""){
        $("#roleKey").addClass("is-invalid");
        $("#roleKeyFeedback").html("Role key can\'t be empty!");
        validKey = false;
      }
      if($("#roleKey").val().indexOf(" ")>=0){
        $("#roleKey").addClass("is-invalid");
        $("#roleKeyFeedback").html("Role key cannot have white space!");
        validKey = false;
      }

      //check if role key already exist
      $.ajax({
        type: "POST",
        url: "'.Yii::app()->createUrl("pricingGroup/CustomWPRole").'",
        dataType: "json",
        data: {
          "action" : "validate",
          "roleKey" : $("input[name=\'pricingRoleKey\']").val(),
          "roleName" : $("input[name=\'pricingRoleName\']").val()
        },
        success: function(exist){
            var existRole = exist;

            //check if key is already exist
            if(existRole.key == true && validKey){
              $("#roleKey").addClass("is-invalid");
              $("#roleKeyFeedback").html("Role key already exist, please change it!");
              valid = false;
            }
            else{
              $("#roleKey").addClass("is-valid");
            }

            //check if role name is already exist
            if(existRole.name == true && validName){
              $("#roleName").addClass("is-invalid");
              $("#roleNameFeedback").html("Role name already exist, please change it!");
              valid = false;
            }
            else{
              $("#roleName").addClass("is-valid");
            }

            if(validName && validKey){
              $("#btnValidateRole").attr("disabled", false);
              $("#btnValidateRole").addClass("hide");
              $("#btnSaveRole").removeClass("hide");
            }
            else
            {
              $("#btnValidateRole").attr("disabled", false);
            }
        },
         error: function (jqXHR, exception) {
            var msg = "";
            if (jqXHR.status === 0) {
                msg = "Not connect.\n Verify Network.";
            } else if (jqXHR.status == 404) {
                msg = "Requested page not found. [404]";
            } else if (jqXHR.status == 500) {
                msg = "Internal Server Error [500].";
            } else if (exception === "parsererror") {
                msg = "Requested JSON parse failed.";
            } else if (exception === "timeout") {
                msg = "Time out error.";
            } else if (exception === "abort") {
                msg = "Ajax request aborted.";
            } else {
                msg = "Uncaught Error.\n" + jqXHR.responseText;
            }
            console.log(msg);
        },
      });
    });

    //for submitting/saving custom role
    $("#btnSaveRole").on("click", function(e)
    {
      e.preventDefault();
      $("#btnSaveRole").attr("disabled", true);
      $(".error div").remove();
      var tier = $("input[name=tier]").val();

      if($("input[name=\'pricingRoleKey\']").val() != "" && $("input[name=\'pricingRoleName\']").val() != "")
      {
        $.ajax({
          type: "POST",
          url: "'.Yii::app()->createUrl("pricingGroup/CustomWPRole").'",
          data: {
            "action" : "save",
            "roleKey" : $("input[name=\'pricingRoleKey\']").val(),
            "roleName" : $("input[name=\'pricingRoleName\']").val()
          },
          success: function(data){
            //error not saving
            var wpRole = JSON.parse(data);
            if(wpRole.message != undefined)
            {
              var message = \'<div class="alert-box alert alert-danger alert-dismissable "><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>Saving Custom Pricing Role failed.</div>\';

              $("#btnSaveRole").attr("disabled", false);
              $(".error").append(message);
            }
            else
            {
              var option = "<option value=\'"+wpRole.wpRoleId+"\'>"+wpRole.wpRoleLabel+"</option>";
              $(tier+" .wp-role").append(option);
              $(tier+" .wp-role").val(wpRole.wpRoleId);
              $("input[name=pricingRoleKey]").val("");
              $("input[name=pricingRoleName]").val("");
              $("#btnSaveRole").attr("disabled", false);
              $("#customPricingRole").modal("hide");
            }
          },
          error : function(){
            alert("Error occured");
            $("#btnSaveRole").attr("disabled", false);
          }
        });
      }
      else
      {
        var message = \'<div class="alert-box alert alert-danger alert-dismissable "><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>Pricing Role Key or Pricing Role Name Cannot be empty.</div>\';

        $("#btnSaveRole").attr("disabled", false);
        $(".error").append(message);
      }
    });

/*Javascript function area*/
    //checking if user select custom Woocommerce role
    function customRole(role, tier){
      var roleVal = [];
      //pushing selected value and tier div id
      $(".wp-role option:selected").each(function() {
        roleVal.push({
          "id" : $(this).parent().parent().parent().parent().parent().attr("id"),
          "selected" : $(this).val()
        });
      });
      //disabled selected option
      $(".wp-role option").each(function() {
        var thisSelect = $(this);
        roleVal.forEach(function(item){
          if(thisSelect.val() != "custom"){
            if(item["selected"] == thisSelect.val()){
              if(thisSelect.parent().parent().parent().parent().parent().attr("id") != item["id"]){
                thisSelect.attr("disabled", true);
              }
            }
          }
        });
      });
      //pop up modal create custom is clicked
      if(role.val() == "custom")
      {
        $(tier+" .wp-role").val("");
        $("#customPricingRole").modal("show");
        $("input[name=tier]").val(tier);
        $("#btnSaveRole").attr("data-tier", tier);
      }
    }

    //remove added pricing tier ui
    function removeTier(tier){
      swal({
        title: "Are you sure you want to remove this price tier?",
        text: "You will not be able to undo this once you confirmed the deletion!",
        icon: "warning",
        buttons: {
          cancel: {
            text: "Cancel",
            value: null,
            visible: true,
            className: "btn btn-default",
            closeModal: true,
          },
          confirm: {
            text: "Confirm",
            value: true,
            visible: true,
            className: "btn btn-info",
            closeModal: true
          },
        }
      }).then((isConfirm) => {
          if(isConfirm){
            var cloneOption = $(tier+" .wp-role option[value=\'custom\']").nextAll();
            $(".wp-role").append(cloneOption.clone());
            $(tier).remove();
            count--;
            if(count == 1)
            {
              $(".btn-remove-tier").addClass("hide");
            }
            swal({
              title: "Successfully removed price tier",
              text: "This will be close in 2 seconds",
              icon: "success",
              timer: 2000,
            });
          }
      });
    }

    //remove pricing tier in database also
    function removeAjax(tier, desc_id){
      swal({
        title: "Are you sure you want to remove this price tier?",
        text: "You will not be able to undo this once you confirmed the deletion!",
        icon: "warning",
        buttons: {
          cancel: {
            text: "Cancel",
            value: null,
            visible: true,
            className: "btn btn-default",
            closeModal: true,
          },
          confirm: {
            text: "Confirm",
            value: true,
            visible: true,
            className: "btn btn-info",
            closeModal: true
          },
        }
      }).then((isConfirm) => {
          if(isConfirm){
            $.ajax({
              method: "POST",
              url: "'.Yii::app()->createUrl("pricingGroup/RemoveTierAjax").'",
              data: {
                "id" : desc_id,
              },
              success: function(data)
              {
                if(data == "Success")
                {
                  var cloneOption = $(tier+" .wp-role option[value=\'custom\']").nextAll();
                  var descriptionCount = $(".btn-delete-tier").attr("data-count");
                  count--;
                  descriptionCount--;
                  $(".wp-role").append(cloneOption.clone());
                  $(tier).remove();
                  if(descriptionCount <= 1)
                  {
                    $(".btn-delete-tier").addClass("hide");
                  }

                  $(".btn-delete-tier").attr("data-count", descriptionCount);
                  swal({
                    title: "Successfully removed price tier",
                    text: "This will be close in 2 seconds",
                    icon: "success",
                    timer: 2000,
                  });
                }
                else
                {
                  swal({
                    title: "Failed to remove price tier!",
                    text: "This will be close in 2 seconds",
                    icon: "error",
                    timer: 2000,
                  });
                }
              },
              error: function(XMLHttpRequest, textStatus, errorThrown)
              {
                swal({
                    title: "Failed to remove price tier! "+ errorThrown,
                    text: "This will be close in 2 seconds",
                    icon: "error",
                    timer: 2000,
                  });
              }
            })
          }
      });
    }';
    echo $script;
?>