<?php 

if((int)$dataType == MailerContentTracking::TYPE_SEED_DATA)
	$mailerTrackings = $model->mailerContentTrackings(array('scopes' => array('seeds')));
else
	$mailerTrackings = $model->mailerContentTrackings(array('scopes' => array('liveTracking')));

$successfullySentCount = 0;
$openedCount = 0;

foreach ( $mailerTrackings as $trackingData )
{
	if ( $trackingData->status == MailerContentTracking::STATUS_SUCCESS )
	{
		$successfullySentCount++;
		
		if ( $trackingData->opened_flag == 1 )
		{
			$openedCount++;
		}
	}
}
?>
<h1 class="page-header">Report</h1>
<h3><?php echo $model->outbound_name; ?> || <?php echo $model->subject; ?></h3>
<br />

<?php if( Yii::app()->user->account->account_type == Account::TYPE_ADMIN ) { ?>
<div>
	<form id="stat-form">
		<div class="row">
			<div class="col-md-3">
				<div class="form-group">
					<?php echo CHtml::dropdownList('data_type', $dataType, array(MailerContentTracking::TYPE_LIVE_DATA => 'Live Data',MailerContentTracking::TYPE_SEED_DATA => 'Seed Data'), array('class' => 'form-control', 'data-filter' => 1)); ?>
				</div>		
			</div>
		</div>
	</form>
</div>
<?php } ?>

<hr />

<div>
	<div class="row">
		<div class="col-md-3">
			<div class="panel panel-default text-center">
				<div class="panel-heading">
					<h5>Total <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h5>
				</div>
				<div class="panel-body">
					<?php 
						
						if((int)$dataType == MailerContentTracking::TYPE_SEED_DATA)
							$count = $model->getSeedRecipientCount();
						else
							$count = $model->getLiveRecipientCount();

						echo CHtml::link($count, array('report/recipients', 'id' => $model->id,'dataType' => $dataType), array('target' => '_blank')); 
					?>
				</div>
			</div>
		</div>
		<div class="col-md-3">
			
			<div class="panel panel-default text-center">
				<div class="panel-heading">
					<h5>Delivered <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h5>
				</div>
				<div class="panel-body">
					<?php echo CHtml::link($successfullySentCount, array('report/deliveries', 'id' => $model->id,'dataType' => $dataType), array('target' => '_blank')); ?>
				</div>
			</div>
		</div>
		<div class="col-md-3">
			
			<div class="panel panel-default text-center">
				<div class="panel-heading">
					<h5>Undelivered <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h5>
				</div>
				<div class="panel-body">
					<?php 

						if((int)$dataType == MailerContentTracking::TYPE_SEED_DATA)
							$count = $model->getUnderliveredSeedCount();
						else
							$count = $model->getUnderliveredLiveCount();

						echo CHtml::link($count, array('report/pendings', 'id' => $model->id,'dataType' => $dataType), array('target' => '_blank')); 
					?>
				</div>
			</div>
		</div>
		<div class="col-md-3">
			<div class="panel panel-default text-center">
				<div class="panel-heading">
					<h5>Opened <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h5>
				</div>
				<div class="panel-body">
					<?php echo CHtml::link($openedCount, array('report/readers', 'id' => $model->id,'dataType' => $dataType), array('target' => '_blank')); ?>
				</div>
			</div>
		</div>
	</div>	
</div>

<div>
	<div class="row">
		<div class="col-md-6">
			<h4>Redirects/Landing Page Visits <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h4>
			<table class="table">
				<colgroup>
					<col class="col-md-8">
					<col class="col-md-4">
				</colgroup>
				<tr>
					<th>Link</th>
					<th class="text-center">No. of Clicks</th>
				</tr>
				<?php
					foreach($model->mailerContentLinkVars(array('scopes' => array('redirects', 'active'))) as $link) {
						if($dataType == MailerContentTracking::TYPE_SEED_DATA)
							$count = $link->getSeedStatisticCount();
						else
							$count = $link->getLiveStatisticCount(); 
				?>
					<tr>
						<td>
							<?php 
								// echo CHtml::link($link->text_value, $link->url); 
								echo CHtml::link($link->text_value, array('report/linkStats', 'id' => $link->id, 'dataType' => $dataType), array('target' => '_blank'));
							?>
						</td>
						<td class="text-center">
							<?php 
								echo CHtml::link($count, array('report/linkStats', 'id' => $link->id, 'dataType' => $dataType), array('target' => '_blank'));
							?>
						</td>
					</tr>
				<?php } ?>
			</table>
		</div>
		<div class="col-md-6">
			<h4>Downloads <?php echo (($dataType == MailerContentTracking::TYPE_SEED_DATA)? " ( SEEDS ) ": ""); ?></h4>
			<table class="table">
				<colgroup>
					<col class="col-md-8">
					<col class="col-md-4">
				</colgroup>
				<tr>
					<th>Link</th>
					<th class="text-center">No. of Downloads</th>
				</tr>
				<?php
					foreach($model->mailerContentLinkVars(array('scopes' => array('downloads', 'active'))) as $link) {
						if($dataType == MailerContentTracking::TYPE_SEED_DATA)
							$count = $link->getSeedStatisticCount();
						else
							$count = $link->getLiveStatisticCount();
				?>
				<tr>
					<td>
						<?php 
							// echo CHtml::link($link->text_value, $link->url); 
							echo CHtml::link($link->text_value, array('report/linkStats', 'id' => $link->id, 'dataType' => $dataType), array('target' => '_blank'));
						?>
					</td>
					<td class="text-center">
					<?php 
						echo CHtml::link($count, array('report/linkStats', 'id' => $link->id, 'dataType' => $dataType), array('target' => '_blank'));
					?>
					</td>
				</tr>
				<?php } ?>
			</table>
		</div>
	</div>
	
	<?php 
	$count = MailerContentFormSubmissions::countMailerFormSubmissions( $model->id ); 
	
	if ( $count > 0 )
	{
	?>
	<div class="row">
		<div class="col-md-6">
			<h4>Submitted Registrations: </h4>
				<table class="table">
				<colgroup>
					<col class="col-md-8">
					<col class="col-md-4">
				</colgroup>
				<tr>
					<th>Link</th>
					<th class="text-center">Total</th>
				</tr>
				<?php
					foreach($model->mailerContentLinkVars() as $link) {
						
						if( $link->link_type == MailerContentLinkVar::LINK_TYPE_FORM_SUBMISSION )
						{
				?>
				<tr>
						<td><?php echo CHtml::link($link->text_value, $link->url); ?></td>
						<td class="text-center">
							<?php 
								// if($dataType == MailerContentTracking::TYPE_SEED_DATA)
									// $count = $link->getSeedStatisticCount();
								// else
								

								echo CHtml::link($count, array('report/formSubmissionStats', 'id' => $link->id, 'dataType' => $dataType), array('target' => '_blank'));
							?>
						</td>
				</tr>
				<?php } } ?>
			</table>
		</div> 
	</div>
	<?php 
	}
	?>
	
</div>
<?php 

$clientScript = Yii::app()->clientScript;

$clientScript->registerScript('filsterScript', "

	$('select[data-filter]').change(function(){
		
		$('form#stat-form').submit();

	});

");

?>