<?php	
$mailerTrackings = $data->mailerContentTrackings(array('scopes' => array('liveTracking')));
$successfullySentCount = 0;
$openedCount = 0;

foreach ( $mailerTrackings as $trackingData )
{
	if ( $trackingData->status == MailerContentTracking::STATUS_SUCCESS )
	{
		$successfullySentCount++;
		
		if ( $trackingData->opened_flag == 1 )
		{
			$openedCount++;
		}
	}
}

if ($index == 0){ ?>
	<thead> 
		<tr>
			<th>Outbound Name</th>
			<th>Email Subject</th>
			<th>Last Date Sent</th>
			<th>Total Sent</th>
			<th>Successfully Sent</th>
			<th>Opened</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
<?php } ?>
	<tr>
		<td><?php echo CHtml::link($data->outbound_name, array('/mailer/stats', 'id' => $data->id)); ?></td>
		<td>
			<?php echo $data->subject ?>
			<?php echo (($data->hasPendingQueue)? '<br /> <label class="badge badge-warning">In Queue</label>':''); ?>		
		</td>
		<td><?php echo ZCommon::formatDate($data->date_updated); ?></td>
		<td><?php echo count($mailerTrackings); ?></td>
		<td><?php echo $successfullySentCount; ?></td>
		<td><?php echo $openedCount; ?></td>
		<td>
			<div class="table-actions">
				<?php
					echo CHtml::link('<span class="glyphicon glyphicon-stats"></span>', array('/mailer/stats', 'id' => $data->id), array('class'=>'btn', 'title' =>'View Statistics'));
					
					if ( Yii::app()->user->account->account_type == Account::TYPE_ADMIN )	
					{
						echo CHtml::link('<span class="glyphicon glyphicon-send"></span>', array('/mailer/setup', 'id' => $data->id), array('class'=>'btn', 'title' =>'Setup Email Blast'));
						
						echo CHtml::link('<span class="fa fa-copy"></span>', array('/mailer/duplicateMailer', 'mailerId' => $data->id), array('class'=>'btn', 'title' =>'Duplicate Emailer', 'confirm' => 'Duplicate this emailer?'));
						
						echo CHtml::link('<span class="glyphicon glyphicon-remove"></span>', array('mailer/deleteRecord', 'id' => $data->id), array('title' => 'Remove Record', 'class' => 'btn btn-delete', 'data-toggle' => 'modal','data-target' => '.modal-form',
						'data-id' => $data->id, 
						'data-status' => $data->status, 
						));  
					}
					
				?>
			</div>
		</td>
	</tr>
<?php	if ($index == 0){ ?>
	</tbody>
<?php } ?>
