<?php	
$mailerTrackings = $data->mailerContentTrackings(array('scopes' => array('liveTracking')));
$successfullySentCount = 0;
$openedCount = 0;

foreach ( $mailerTrackings as $trackingData )
{
	if ( $trackingData->status == MailerContentTracking::STATUS_SUCCESS )
	{
		$successfullySentCount++;
		
		if ( $trackingData->opened_flag == 1 )
		{
			$openedCount++;
		}
	}
}

if ($index == 0){ ?>
	<thead> 
		<tr>
			<th>Outbound Name</th>
			<th>Email Subject</th>
			<th>Date Created</th>
			<!-- <th>Total Sent</th> -->
			<th>Successfully Sent</th>
			<th>Opened</th>
			<?php if ( Yii::app()->user->account->account_type == Account::TYPE_ADMIN ): ?>
				<th>Action</th>
			<?php endif; ?>
		</tr>
	</thead>
	<tbody>
<?php } ?>
	<tr>
		<td><?php echo $data->outbound_name; ?><?php //echo CHtml::link($data->outbound_name, array('/mailer/stats', 'id' => $data->id)); ?></td>
		<td>
			<?php echo $data->subject; ?>
			<?php echo (($data->hasPendingQueue)? '<br /> <label class="badge badge-warning">In Queue</label>':''); ?>		
		</td>
		<td><?php echo ZCommon::formatDate($data->date_created); ?></td>
		<!-- <td><?php echo count($mailerTrackings); ?></td> -->
		<td><?php echo $successfullySentCount; ?></td>
		<td><?php echo $openedCount; ?></td>
		<?php if ( Yii::app()->user->account->account_type == Account::TYPE_ADMIN ): ?>
		<td>
			<div class="table-actions">
				<?php
					/* echo CHtml::link('<span class="glyphicon glyphicon-stats"></span>', array('/mailer/stats', 'id' => $data->id), array('class'=>'btn', 'title' =>'View Statistics')); */
					
					if ( Yii::app()->user->account->account_type == Account::TYPE_ADMIN )	
					{
						/* echo CHtml::link('<span class="glyphicon glyphicon-pencil"></span>', array('/mailer/cadenceSetup', 'id' => $data->id), array('class'=>'btn', 'title' =>'Setup Email Blast'));
						
						echo CHtml::link('<span class="fa fa-copy"></span>', array('/mailer/duplicateCadenceEmailer', 'mailerId' => $data->id), array('class'=>'btn', 'title' =>'Duplicate Emailer', 'confirm' => 'Duplicate this emailer?'));
						
						echo CHtml::link('<span class="glyphicon glyphicon-remove"></span>', array('mailer/deleteRecord', 'id' => $data->id, 'cadence' => true), array('title' => 'Remove Record', 'class' => 'btn btn-delete', 'data-toggle' => 'modal','data-target' => '.modal-form',
						'data-id' => $data->id, 
						'data-status' => $data->status, 
						));   */
						
						$this->widget('CListDropdownActions', array(
							'options' => array(
								'<span class="glyphicon glyphicon-pencil"></span> Setup Email Blast' => array(
									'link' =>  array('/mailer/cadenceSetup', 'id' => $data->id),
									'htmlOptions' => array(
										'class' => 'btn btn_view-setup-email-blast',
									)
								),
								'<span class="fa fa-copy"></span> Duplicate Emailer' => array(
									'link' =>  array('/mailer/duplicateCadenceEmailer', 'mailerId' => $data->id),
									'htmlOptions' => array(
										'class' => 'btn btn_view-duplicate-email', 
										'confirm' => 'Duplicate this emailer?'
									)
								),
								'<span class="glyphicon glyphicon-remove"></span> Remove Record' => array(
									'link' =>  array('/mailer/duplicateCadenceEmailer', 'mailerId' => $data->id),
									'htmlOptions' => array(
										'class' => 'btn btn-delete', 
										'data-toggle' => 'modal',
										'data-target' => '.modal-form',
										'data-id' => $data->id, 
										'data-status' => $data->status, 
									)
								),
							),
							'style' => ''
						));
						
					}
					
				?>
			</div>
		</td>
		<?php endif; ?>
		
	</tr>
<?php	if ($index == 0){ ?>
	</tbody>
<?php } ?>
