<?php
$this->pageTitle = 'Manage Categories | '.Yii::app()->name;
$baseUrl = Yii::app()->request->baseUrl; 

  
Yii::app()->clientScript->registerScriptFile($baseUrl.'/js/jquery-ui.js');
Yii::app()->clientScript->registerCssFile($baseUrl.'/css/jquery-ui.css');

Yii::app()->clientScript->registerScript('pageScript',"
	$('.btn-add-category').click(function(e){
		e.preventDefault();
		$('.modal-form .modal-title').html('Add New Category');
		
		// $('.field-status option').each(function() {
		// 	if ( $(this).val() == '".Categories::STATUS_DELETED."' ) {
		// 		$(this).remove();
		// 	}
		// });
		
		$('.field-firname').val('');
		$('.field-status').val('');
		$('.field-status').parent().hide();
		$('.field-id').val('');
	});
	
	$('.table').on('click', '.btn-edit-category', function(){
		$('.modal-form .modal-title').html('Update Category');
		
		// $('.field-status').append($('<option>', { value: '".Categories::STATUS_DELETED."', text: 'DELETE' }));
		
		var dataName = $(this).data('name');
		var dataStatus = $(this).data('status');
		var dataId = $(this).data('id');
		
		$('.field-name').val(dataName);
		$('.field-status').val(dataStatus);
		$('.field-status').parent().show();
		$('.field-id').val(dataId);
	});
");

?>

<h1 class="sub-header">Tags/Category List</h1>

<?php $this->widget('Flash', array('flashes'=>Yii::app()->user->getFlashes(), 'hide'=>false)); ?>

<?php	echo CHtml::beginForm(array('categories/index'),'get');  ?>
<div class="row">
	<div class="col-lg-6">
		<div class="input-group" style="padding-bottom:5px;">
			<span class="input-group-btn">
				<button class="btn btn-primary" type="submit"><i class="glyphicon glyphicon-search"></i></button>
			</span>
			<?php echo CHtml::textField('searchQuery',$searchQuery,array('class'=>'form-control','placeholder'=>'Search by Category Name')); ?>
		</div><!-- /input-group -->	
<?php	echo CHtml::endForm(); ?>	
	</div><!-- /.col-lg-6 -->
	
	<div class="col-lg-6">
	
		<?php echo CHtml::link('<span class="glyphicon glyphicon-plus"></span> Add New Category', '#', array('data-target' => '.modal-form', 'data-toggle'=>'modal', 'class'=>'btn btn-primary btn-sm pull-right btn-add-category')); ?>
		
	</div><!-- /.col-lg-6 -->
	
</div>

<div class="table-responsive" style="position:relative;">
<?php 
	$this->widget('zii.widgets.CListView', array(
		'dataProvider' => $dataProvider,
		'itemsTagName' => 'table',
		'itemsCssClass' => 'table table-hover',
		// 'summaryText' => "{start} - {end} of {count}",
		'template' => ' {summary} {items} {pager}',
		'itemView' => 'application.yii_app_emailer.yii_app_emailer_views.categories._manage',
		'pager' => array(
			// 'class' => 'BootstrapLinkPager', 
			'cssFile' => false, 
			'header' => false, 
			'firstPageLabel' => '&lt;&lt;',
			'prevPageLabel' => '&lt;',
			'nextPageLabel' => '&gt;',
			'lastPageLabel' => '&gt;&gt;',
		),
	));
?>
</div>

<?php

$_urlParams = array('/categories/saveData');
if ( $searchQuery )
	$_urlParams['searchQuery'] = $searchQuery;

$form=$this->beginWidget('CActiveForm', array(
	'action' => $_urlParams,
	'id'=>'model-form',
	'enableAjaxValidation'=>false,
)); ?>
<div class="modal fade modal-form">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				<h4 class="modal-title">Add New Category</h4>
			</div>
			<div class="modal-body">
				<div>
					<div class="row">
						<div class="col-sm-6 form-group">
							<?php 
								echo $form->labelEx($category,'name'); 
								echo $form->textField($category,'name', array('class' => 'form-control field-name')); 
							?>
						</div>
						<div class="col-sm-6 form-group">
							<?php 
								$categoryStatus = Categories::model()->getStatus();
								
								echo $form->labelEx($category,'status'); 
								echo $form->dropDownList($category,'status', $categoryStatus, array('class' => 'form-control field-status', 'empty' => 'Select Status')); 
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
				<?php
				echo $form->hiddenField($category, 'id', array('class' => 'field-id'));
				echo CHtml::submitButton('Submit' ,array('class'=>'btn btn-primary'));  ?>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php $this->endWidget();
	