<?php

/**
 * This is the model class for table "{{vendor_normalized_info}}".
 *
 * The followings are the available columns in table '{{vendor_normalized_info}}':
 * @property integer $vendor_normalized_id
 * @property string $brand_name
 * @property string $sku
 * @property string $mpn
 * @property string $msrp
 * @property string $cost
 * @property string $price_sbb
 * @property string $description
 * @property string $qb_description
 * @property string $ean
 * @property string $width
 * @property string $length
 * @property string $height
 * @property string $weight
 * @property string $quantity
 * @property string $sync_qb
 *
 * The followings are the available model relations:
 * @property VendorNormalized $vendorNormalized
 */
class VendorNormalizedInfo extends CActiveRecord
{

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{vendor_normalized_info}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_normalized_id', 'numerical', 'integerOnly'=>true),
			array('brand_name, cost, price_sbb, width, length, height, weight, quantity', 'length', 'max'=>50),
			array('description, qb_description', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('vendor_normalized_id, brand_name, sku, mpn, msrp, cost, price_sbb, description, qb_description, ean, width, length, height, weight, quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorNormalized' => array(self::BELONGS_TO, 'VendorNormalized', 'vendor_normalized_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_normalized_id' => 'Vendor Normalized',
			'brand_name' => 'Brand Name',
			'sku' => 'SKU',
			'mpn' => 'MPN',
			'msrp' => 'MSRP',
			'cost' => 'Cost',
			'price_sbb' => 'Sbb Price',
			'description' => 'Description',
			'qb_description' => 'Qb Description',
			'ean' => 'EAN',
			'width' => 'Width',
			'length' => 'Length',
			'height' => 'Height',
			'weight' => 'Weight',
			'quantity' => 'Quantity'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_normalized_id',$this->vendor_normalized_id);
		$criteria->compare('brand_name',$this->brand_name,true);
		$criteria->compare('sku',$this->sku,true);
		$criteria->compare('mpn',$this->mpn,true);
		$criteria->compare('msrp',$this->msrp,true);
		$criteria->compare('cost',$this->cost,true);
		$criteria->compare('price_sbb',$this->price_sbb,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('qb_description',$this->qb_description,true);
		$criteria->compare('ean',$this->ean,true);
		$criteria->compare('width',$this->width,true);
		$criteria->compare('length',$this->length,true);
		$criteria->compare('height',$this->height,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('quantity',$this->quantity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VendorNormalizedInfo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
