<?php

/**
 * This is the model class for table "{{setting_column_mapping}}".
 *
 * The followings are the available columns in table '{{setting_column_mapping}}':
 * @property integer $id
 * @property string $sku
 * @property string $mpn
 * @property string $msrp
 * @property string $cost
 * @property string $sbb_price
 * @property string $description
 * @property string $qb_description
 * @property string $ean
 * @property string $width
 * @property string $length
 * @property string $height
 * @property string $weight
 * @property string $quantity
 * @property integer $status
 * @property string $date_created
 * @property string $date_updated
 */
class SettingColumnMapping extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{setting_column_mapping}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status', 'numerical', 'integerOnly'=>true),
			array('sku, mpn, msrp, cost, sbb_price, description, qb_description, ean, width, length, height, weight, quantity, date_created, date_updated', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, sku, mpn, msrp, cost, sbb_price, description, qb_description, ean, width, length, height, weight, quantity, status, date_created, date_updated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'sku' => 'SKU',
			'mpn' => 'MPN',
			'msrp' => 'MSRP',
			'cost' => 'Cost',
			'sbb_price' => 'Sbb Price',
			'description' => 'Description',
			'qb_description' => 'Qb Description',
			'ean' => 'EAN',
			'width' => 'Width',
			'length' => 'Length',
			'height' => 'Height',
			'weight' => 'Weight',
			'quantity' => 'Quantity',
			'status' => 'Status',
			'date_created' => 'Date Created',
			'date_updated' => 'Date Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('sku',$this->sku,true);
		$criteria->compare('mpn',$this->mpn,true);
		$criteria->compare('msrp',$this->msrp,true);
		$criteria->compare('cost',$this->cost,true);
		$criteria->compare('sbb_price',$this->sbb_price,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('qb_description',$this->qb_description,true);
		$criteria->compare('ean',$this->ean,true);
		$criteria->compare('width',$this->width,true);
		$criteria->compare('length',$this->length,true);
		$criteria->compare('height',$this->height,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('date_created',$this->date_created,true);
		$criteria->compare('date_updated',$this->date_updated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SettingColumnMapping the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function beforeSave() {
		if (parent::beforeSave()) {
			if ($this->isNewRecord) {
				$this->date_created = date('Y-m-d H:i:s');
				$this->date_updated = date('Y-m-d H:i:s');
			} else {
				$this->date_updated = date('Y-m-d H:i:s');
			}
		}

		return true;
	}
}
