<?php

class GoogleMerchantGSS {

    protected $service;
    protected $merchantId = 8824681;
    //dev merchant id //153027410;
    protected $developerKey = 'd76b592c00e6327e71ec0dac8f67eebea7696133';
    // dev api //'99c7997e063cb9e5546ee34224b3a8f9587dd9c7'; // private_key_id
    protected $appCredencials = 'content-api-key-gss.json';

    protected $productDimensionUnit = 'cm';
    protected $productWeightUnit = 'kg';
    protected $productChannel = 'online';
    protected $productLanguage = 'en';
    protected $productCountry = 'US';
    protected $productCurrency = 'USD';
    protected $productAvailability = 'in stock';
    protected $productAvailabilityInStock = 'in stock';
    protected $productAvailabilityOutStock = 'out of stock';
    protected $productLink = 'https://orders.gsscctv.com/wp-content/uploads/';//'http://szsb-gl2x.accessdomain.com/test-google-merchant/';

    public function __construct() {
        putenv('GOOGLE_APPLICATION_CREDENTIALS=' . $this->appCredencials);

        $client = new Google_Client();
        $client->useApplicationDefaultCredentials();
        $client->setDeveloperKey($this->developerKey);
        $client->addScope(Google_Service_ShoppingContent::CONTENT);

        $this->service = new Google_Service_ShoppingContent($client);
    }
    
    public function batchInsertEditData($productFeeds, $params = []) {
        $batchData = [];
        foreach ($productFeeds as $productFeed) {
            $productId = (!empty($productFeed['platform_4_rest_id'])) ? $productFeed['platform_4_rest_id'] : 'online:en:US:'.$productFeed['platform_2_rest_id'];            

            $brandName = Vendor::getVendorNameLabel($productFeed['vendor_id']);
            $brandNameUcWords = ucwords(strtolower($brandName));
            $brandNameUrl = str_replace(' ', '', ucwords($brandNameUcWords));
            $tmpData = array(
                'batchId' => $productFeed['id'],
                'merchantId' => $this->merchantId,
                'method' => 'insert',
                'product' => array(
                    'brand' => $brandNameUcWords,
                    'title' => $productFeed['product_name'],
                    'mpn' => $productFeed['mpn'],
                    'gtin' => $productFeed['ean'],
                    'link' => isset($productFeed['link']) ? $productFeed['link'] : '',
                    'description' => strip_tags($productFeed['description']),
                    'contentLanguage' => $this->productLanguage,
                    'targetCountry' => $this->productCountry,
                    'channel' => $this->productChannel,
                    'condition' => 'new',
                    'availability' => (string) ($productFeed['product_status'] != Product::PRODUCT_STATUS_EOL) 
                        ? $this->productAvailabilityInStock : $this->productAvailabilityOutStock,
                    'price' => [
                        'value' => $productFeed['msrp'],
                        'currency' => $this->productCurrency
                    ],
                    // 'sellOnGoogleQuantity' => $productFeed['quantity'],
                    'shippingLength' => array(
                        'value' => (float) $productFeed['length'],
                        'unit' => $this->productDimensionUnit
                    ),
                    'shippingHeight' => array(
                        'value' => (float) $productFeed['height'],
                        'unit' => $this->productDimensionUnit
                    ),
                    'shippingWidth' => array(
                        'value' => (float) $productFeed['width'],
                        'unit' => $this->productDimensionUnit
                    ),
                    'shippingWeight' => array(
                        'value' => (float) $productFeed['weight'],
                        'unit' => $this->productWeightUnit
                    ),
                )
            );
            $tmpData['product']['offerId'] = $productFeed['platform_2_rest_id'];
            if (!empty($params['gss_product_images']) && $params['gss_product_images'][$productFeed['id']]) {
                $tmpData['product']['imageLink'] = $params['gss_product_images'][$productFeed['id']];
            }

            try{
                $res = $this->service->products->get($this->merchantId, $productId);
                $description = (!$res && strlen($res->description) >= strlen($productFeed['description'])) ? $res->description : $productFeed['description'];
                $tmpData['product']['description'] = strip_tags($description);


            }catch(Google_Service_Exception $e){

            }

            /* if(!isset($tmpData['product']['imageLink']))
                $tmpData['product']['imageLink'] = $productFeed['image_link'];  */ 
            

            $batchData[] = $tmpData;
        }

        $customBatchRequest = new Google_Service_ShoppingContent_ProductsCustomBatchRequest;
        $customBatchRequest->setEntries($batchData);

        $result = $this->service->products->custombatch($customBatchRequest);
        
        return $result;
    }

    public function batchDelete($productFeeds) {
        $batchData = [];

        foreach ($productFeeds as $productFeed) {
            $batchData[] = array(
                'batchId' => $productFeed['id'],
                'merchantId' => $this->merchantId,
                'method' => 'delete',
                'productId' => $productFeed['platform_2_rest_id']
            );
        }

        $customBatchRequest = new Google_Service_ShoppingContent_ProductsCustomBatchRequest;
        $customBatchRequest->setEntries($batchData);

        $result = $this->service->products->custombatch($customBatchRequest);
        
        return $result;
    }

    public function batchGetProductStatus($nextPageToken){
        $optParams['maxResults'] = 250;
        if($nextPageToken != '' || $nextPageToken != null){
            $optParams['pageToken'] = $nextPageToken;
        }
        $res = $this->service->productstatuses->listProductstatuses($this->merchantId, $optParams);

        return $res;
    }
}