<?php

/**
 * This is the model class for table "{{vendor_normalized}}".
 *
 * The followings are the available columns in table '{{vendor_normalized}}':
 * @property integer $id
 * @property integer $action_id
 * @property integer $product_id
 * @property integer $status
 * @property string $date_initialized
 * @property string $date_updated
 *
 * The followings are the available model relations:
 * @property CronProductActionStatus $cronProductActionStatus
 */
class CronProductActionProductList extends CActiveRecord
{
	const STATUS_PENDING = 0;
	const STATUS_PROCESSING = 1;
	const STATUS_DONE = 2;
	const STATUS_ERROR = 3;


	/* 	new, updated, deleted, remain*/
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cron_product_action_product_list}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('action_id, product_id, status', 'required'),
			array('action_id, product_id, status', 'numerical', 'integerOnly'=>true),
			array('date_created, date_updated', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, action_id, product_id, status, date_created, date_updated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'actionStatus' => array(self::BELONGS_TO, 'CronProductActionStatus', 'action_id'),
			'product' => array(self::BELONGS_TO, 'Product', 'product_id'),
			'productInfo' => array(self::BELONGS_TO, 'ProductInfo', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'action_id' => 'Action ID',
			'product_id' => 'Product ID',
			'status' => 'Status',
			'date_created' => 'Date Created',
			'date_updated' => 'Date Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('status',$this->status);
		$criteria->compare('type',$this->type);
		$criteria->compare('date_initialized',$this->date_initialized,true);
		$criteria->compare('date_updated',$this->date_updated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VendorNormalized the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function beforeSave() {
		if (parent::beforeSave()) {
			if ($this->isNewRecord) {
				$this->date_created = date('Y-m-d H:i:s');
				$this->date_updated = date('Y-m-d H:i:s');
			} else {
				$this->date_updated = date('Y-m-d H:i:s');
			}
		}

		return true;
	}

	public function setStatusProcessing(){
		$this->status = self::STATUS_PROCESSING;
		$this->save(false);
	}

	public function setStatusDone(){
		$this->status = self::STATUS_DONE;
		$this->save(false);
	}
}
