<?php
class WoocommerceApiController extends Controller
{
  /**
   * Get 15 products on ProductPricingTierLookup
   * Submit each product to Woocommerce API.
   * Set proper status after request.
   * Doesn't use transaction because REST API for Woocommerce is realtime.
   */
  public function actionPushRSP()
  {
    // Get all pending products on lookup table.
    $productPricingTierLookupModels = ProductPricingTierLookup::model()->wc_pending()->findAll(array(
      'join' => 'INNER JOIN {{product}} AS p ON p.id = product_id
                INNER JOIN {{pricing_tier}} AS pt ON pt.id = pricing_tier_id
                INNER JOIN {{pricing_tier_description}} AS ptd ON ptd.id = pt.desc_id',
      'condition' => 'p.platform_2_rest_id != "" AND p.platform_2_rest_id is not null AND ptd.pricing_tier_wp_role_id IS NOT NULL',
      'limit' => 7
    ));

    $cronState = current(Yii::app()->db->createCommand('SELECT `value` FROM gss_system_settings WHERE `key` = "woocommerceCron";')->queryRow());
    // If nothing to process
    if( $cronState == 0 ) exit('CRON IS OFF'); 
    // Loop each product
    foreach ($productPricingTierLookupModels as $productPricingTierLookupModel)
    {
      // Build the required woocommerce API details
      $productDetails = $productPricingTierLookupModel->buildWcApiDetails();
      
      $customSuccessStatus = null;
      if($productPricingTierLookupModel->status == ProductPricingTierLookup::STATUS_ACTIVE){
        $apiResponse = WoocommercePricingTierApi::addUpdateRSP($productDetails);
      }

      elseif($productPricingTierLookupModel->status == ProductPricingTierLookup::STATUS_INACTIVE)
      {
        $apiResponse = WoocommercePricingTierApi::deleteRSP($productDetails);
        $customSuccessStatus = ProductPricingTierLookup::WC_STATUS_DEACTIVATED;
      }
      elseif($productPricingTierLookupModel->status == ProductPricingTierLookup::STATUS_DELETED)
      {
        $apiResponse = WoocommercePricingTierApi::deleteRSP($productDetails);
        $customSuccessStatus = ProductPricingTierLookup::WC_STATUS_DELETED;
      }
      //Dev::pvx($apiResponse);

      $productPricingTierLookupModel->setWcStatus($apiResponse, $customSuccessStatus);

	
      Dev::pv( $apiResponse );
		sleep(1);
    }
  }

  public function actionDeactivateRSP()
  {
    // Get all pending products on lookup table.
    $productPricingTierLookupModels = ProductPricingTierLookup::model()->wc_success()->findAll(array(
      'condition' => 'pricing_tier_id = :pricing_tier_id',
      'params' => array( ':pricing_tier_id' => $pricingTierId),
      'limit' => 2,
    ));

    Dev::pvx($productPricingTierLookupModels);

    $cronState = current(Yii::app()->db->createCommand('SELECT `value` FROM gss_system_settings WHERE `key` = "woocommerceCron";')->queryRow());

    // If nothing to process
    if( $cronState == 0 ) exit('CRON IS OFF'); 
    
    // Loop each product
    foreach ($productPricingTierLookupModels as $productPricingTierLookupModel)
    {
      // Build the required woocommerce API details
      $productDetails = $productPricingTierLookupModel->buildWcApiDetails();
      
      $apiResponse = WoocommercePricingTierApi::deleteRSP($productDetails);

      $productPricingTierLookupModel->setWcStatus($apiResponse, $customSuccessStatus = ProductPricingTierLookup::WC_STATUS_DEACTIVATED);

      Dev::pv( $productPricingTierLookupModel->attributes );
    }
  }

  // Activate

  // Delete

  public function actionCronSwitcher()
  {
    // Check if there are woocommerce_status = 0 - pending
    $productPricingTierLookupTotal = ProductPricingTierLookup::model()->wc_pending()->count();
    
    $cronState = 0;

    if($productPricingTierLookupTotal > 0) $cronState = 1;

    echo Yii::app()->db->createCommand('UPDATE gss_system_settings SET `value` = '.$cronState.' WHERE `key` = "woocommerceCron";')->execute();
  }
}