<?php
class UploaderController extends Controller
{	
	public function actionIndex()
	{
		//broken on the server
		//self::tempCleanUp(); //clean temp files

		if(isset($_FILES['file']) && $_FILES['file']['error'] == 0)
		{
            $authAccount = Yii::app()->user->account;

			$extension = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
			$uniqueName = sha1($_FILES['file']['name'].time());			
			$transaction = Yii::app()->db->beginTransaction();
			$model = new Fileupload;
			
			if(isset($_GET['account_id']))
				if(isset($model->account_id))
					$model->account_id = $_GET['account_id'];				
				
			$model->original_filename = $_FILES['file']['name'];
			$model->name = $uniqueName;
			$model->extension = $extension;
			$model->status = Fileupload::STATUS_TEMP;
            $model->size =  $_FILES['file']['size'];
            $model->date_created =  date('Y-m-d H:i:s');
            $model->account_id = $authAccount->id;

			try
			{
				if($model->validate() && $model->save())
				{
					if(move_uploaded_file($_FILES['file']['tmp_name'], LookUp::TEMP_FOLDER.$uniqueName.'.'.$extension))
					{						
						$transaction->commit();
						die(json_encode(array(
							'status'=>'success',
							'id'=>$model->id,
						)));						
					}
				}
			}
			catch(Exception $e)
			{						

				Dev::pvx($e->getMessage());
				$transaction->rollBack();
				die(json_encode(array(
					'status'=>'error'
				)));
			}
		}
 	
		die(json_encode(array(
			'status'=>'error',
			'errors' => 'An error occured'
		)));	
	}
	
	private function tempCleanUp()
	{
		$baseUrl = Yii::app()->request->baseUrl;
		// $tempFolder = $_SERVER["DOCUMENT_ROOT"].$baseUrl.'/'.LookUp::TEMP_FOLDER;		
		$tempFolder = Yii::getPathOfAlias('webroot').DIRECTORY_SEPARATOR.LookUp::TEMP_FOLDER;  


		// $files = glob($tempFolder."*");
		$files = scandir($tempFolder);

		$time  = time();
		$days =  60*60*24*LookUp::TEMP_FILE_DAYS;
		
		foreach($files as $file)
		{
			$name = $file;
			$file = $tempFolder.$file;
			if(is_file($file))
			{
				if($time - filemtime($file) >= $days)
				{
					$name = explode('.',$name);
					if(count($name) > 0)
					{
						$model = Fileupload::model()->temp()->find(array('condition'=>"name = '".$name[0]."' AND extension = '".$name[1]."'"));
						if(!empty($model))
						{
							$model->status = Fileupload::STATUS_DELTED;
							$model->save(false);
						}
					}
					@unlink($file);
				}
			}
		}
		return true;
	}
	
	public function actionTest()
	{
			// $tempFolder = Yii::getPathOfAlias('webroot').DIRECTORY_SEPARATOR.LookUp::TEMP_FOLDER;  
			// echo $tempFolder;
				// $files = scandir($tempFolder);

				// Dev::print_data($files);
		// self::tempCleanUp(); //clean temp files
	}

	public function actionAjaxSave($account_id)
	{
		$response = array();

		$account = Account::model()->findByPk($accountId);

		$model = Fileupload::model()->sample()->findAll();
		$deletedIDs = array();
		foreach($model as $file)
		{
			$deletedIDs[] = $file->id;
		}
		$error = array();
 		if(isset($_POST['file']))
		{
			if($_POST['file'] == 'empty')
			{
				$modelFile = Fileupload::model()->sample()->findAll();
				foreach($modelFile as $file)
				{
					$deletedIDs[] = $file->id;
				}
			}
			else				
			{		
				foreach($_POST['file'] as $file)
				{
					$fileModel  = Fileupload::model()->temp()->findByPk($file);
					if(!empty($fileModel))
					{						
						if(!$fileModel->moveMediaV2($account->identity_no))
						{
							$error[] = 'File ID '.$file. ' failed to process';
						}
					}
				}
				$deletedIDs = array_diff($deletedIDs,$_POST['file']);
			}
			foreach($deletedIDs as $file)
			{
				$fileModel  = Fileupload::model()->sample()->findByPk($file);
				if(!empty($fileModel))
				{
					if(!$fileModel->deleteFile())
					{
						$error[] = 'File ID '.$file. ' failed to delete';
					}
				}
			}
		}
		$model = Fileupload::model()->sample()->findAll();
		$preloadItems = array();
		foreach($model as $file)
		{
			$preloadItems[] = Fileupload::model()->findByPk($file->id)->createPreloadObject();
		}

		$accountID = $account->id;
		
		if (empty($error)) {

			$response['status'] = 1;
			$response['message'] = 'Successfully uploaded';

		} else {

			$response['status'] = 1;
			$response['message'] = $error[0];

		}

		echo CJSON::encode($response);
		Yii::app()->end();

	}

	public function actionAjaxAddAccountFile()
	{
		Dev::pvx(Yii::app()->session);
	}
}
