<?php

use Akeneo\Component\SpreadsheetParser\SpreadsheetParser;

class ReviewVendorSpreadsheetController extends Controller
{
	public $layout = 'dashboard';
	public $activeSideNav = array('manage_vendor_spreadsheet');
	public $pageTitle = 'Review Vendor Spreadsheet';

	public function actionIndex($id)
	{
		$vendorFile = VendorFile::model()->findByPk($id);

		if (!$vendorFile) {
			throw new CHttpException(403, 'Invalid vendor file.');
		}

		$advanceSearchParams = array();
		$additionalConditions = '';

		if ($_SERVER['REQUEST_METHOD'] == 'GET') {
			if (!empty($_GET['search']['status'])) {
				$advanceSearchParams['search']['status'] = (int) trim($_GET['search']['status']);
			}

			if (!empty($_GET['search']['mpn'])) {
				$advanceSearchParams['search']['mpn'] = (string) trim($_GET['search']['mpn']);
			}

			if (!empty($_GET['search']['description'])) {
				$advanceSearchParams['search']['description'] = (string) trim($_GET['search']['description']);
			}

			if (!empty($_GET['search']['sku'])) {
				$advanceSearchParams['search']['sku'] = (string) trim($_GET['search']['sku']);
			}

			if (!empty($_GET['search']['status_parsed'])) {
				$advanceSearchParams['search']['status_parsed'] = (int) trim($_GET['search']['status_parsed']);
			}

			if (isset($advanceSearchParams['search']['status'])) {
				$additionalConditions .= ' AND vn.product_status = ' . (int) trim($_GET['search']['status']);
			}

			if (isset($advanceSearchParams['search']['mpn'])) {
				$additionalConditions .= ' AND vni.mpn LIKE "%' . (string) trim($_GET['search']['mpn']) . '%"';
			}

			if (isset($advanceSearchParams['search']['description'])) {
				$additionalConditions .= ' AND vni.description LIKE "%' . (string) trim($_GET['search']['description']) . '%"';
			}

			if (isset($advanceSearchParams['search']['sku'])) {
				$additionalConditions .= ' AND vni.sku LIKE "%' . (string) trim($_GET['search']['sku']) . '%"';
			}

			if (isset($advanceSearchParams['search']['status_parsed'])) {
				if ($advanceSearchParams['search']['status_parsed'] == 1) {
					$additionalConditions .= ' AND vn.status IN (
						'. VendorNormalized::STATUS_FOR_REVIEW .',
						'. VendorNormalized::STATUS_PUSHING .',
						'. VendorNormalized::STATUS_PUSHED .')
					';
				} else if ($advanceSearchParams['search']['status_parsed'] == 2)  {
					$additionalConditions .= ' AND vn.status IN (
						'. VendorNormalized::STATUS_DELETED .')
					';
				} else if ($advanceSearchParams['search']['status_parsed'] == 3)  {
					$additionalConditions .= ' AND vn.status IN (
						'. VendorNormalized::STATUS_ERROR_PUSHING .',
						'. VendorNormalized::STATUS_ERROR_VALIDATION .',
						'. VendorNormalized::STATUS_ERROR .')
					';
				}
			}
		}

		$vendorNormalisedQuery = '
			SELECT * FROM {{vendor_normalized_info}} AS vni
			INNER JOIN {{vendor_normalized}} AS vn ON vni.vendor_normalized_id = vn.id
			WHERE vendor_fileupload_id = '. (int) $vendorFile->id .'
			
			AND vn.status in (
				'. VendorNormalized::STATUS_PENDING .',
				'. VendorNormalized::STATUS_FOR_REVIEW .',
				'. VendorNormalized::STATUS_PUSHING .',
				'. VendorNormalized::STATUS_PUSHED .',
				'. VendorNormalized::STATUS_ERROR .',
				'. VendorNormalized::STATUS_ERROR_PUSHING .',
				'. VendorNormalized::STATUS_DELETED .',
				'. VendorNormalized::STATUS_ERROR_VALIDATION .')

			'. $additionalConditions .'

			ORDER BY vn.status, vni.mpn ASC
		';

		$vendorNormalisedCommand = Yii::app()->db->createCommand($vendorNormalisedQuery);
		$vendorNormalisedData = $vendorNormalisedCommand->queryAll();
		
		$vendorNormalisedDataProvider = new CArrayDataProvider($vendorNormalisedData, array(
			'pagination' => false
		));	

		$vendorNormalized = new vendorNormalized;
		$vendorNormalizedInfo = new VendorNormalizedInfo;

		if (!empty($vendorFile->json_price_setting_sbb)) {
			$priceSettingDefault = CJSON::decode($vendorFile->json_price_setting_sbb);
		} else {
			$priceSettingDefault = null;
		}

		if (!empty($vendorFile->json_price_setting_gss)) {
			$priceSettingDefaultGss = CJSON::decode($vendorFile->json_price_setting_gss);
			$gssPricingGroupData = PricingGroup::getGroupById($priceSettingDefaultGss['pricing_group_id']);
			$gssPricingGroupName = $gssPricingGroupData->group_name;
		} else {
			$priceSettingDefaultGss = null;
			$gssPricingGroupName = null;
		}

		$vendorDataPendingCount = count(VendorNormalized::getPendingData($id));
		$itemTotalCount = $vendorNormalisedDataProvider->getTotalItemCount();

		$this->render('index', array(
			'vendorFile' => $vendorFile,
			'vendorNormalisedDataProvider' => $vendorNormalisedDataProvider,
			'vendorDataPendingCount' => $vendorDataPendingCount,
			'vendorNormalized' => $vendorNormalized,
			'vendorNormalizedInfo' => $vendorNormalizedInfo,
			'advanceSearchParams' => $advanceSearchParams,
			'priceSettingDefault' => $priceSettingDefault,
			'priceSettingDefaultGss' => $priceSettingDefaultGss,
			'gssPricingGroupName' => $gssPricingGroupName,
			'itemTotalCount' => $itemTotalCount
		));
	}

	// action type ajax
	public function actionSetVendorForPushing($vendorFileId, $toggleGoogle) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);

		if ($vendorFile->status == VendorFile::STATUS_PUSHING) {
			echo CJSON::encode(array(
				'status' => 'error',
				'message' => 'Vendor file already started pushing to live, please reload the page.'
			)); exit;
		} else {
			if ($vendorFile->status != VendorFile::STATUS_FOR_REVIEW) {

				if ($vendorFile->status == VendorFile::STATUS_PUSHED) {
					echo CJSON::encode(array(
						'status' => 'error',
						'message' => 'Vendor file already pushed in live.'
					)); exit;				
				} else {
					echo CJSON::encode(array(
						'status' => 'error',
						'message' => 'Vendor file is not yet ready for pushing to live.'
					)); exit;
				}
			}
		}

		$vendorFile->status = VendorFile::STATUS_PUSHING;
		$vendorFile->google_feed_publish = $toggleGoogle;

		if ($vendorFile->save(false)) {
			$actionLog = new ActionLog;
			$actionLog->action = "Publish";
			$actionLog->description = "Publish vendor file ID: ".$vendorFile->id.", with Google Feed ".($toggleGoogle == "true" ? 'on' : 'off');
			if($actionLog->save(false)){
				echo CJSON::encode(array(
					'status' => 'ok',
					'message' => 'Publishing vendor data successfully started.'
				)); exit;
			}else{
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'Error in pushing vendor to live.'
				)); exit;
			}
		} else {
			echo CJSON::encode(array(
				'status' => 'error',
				'message' => 'Error in pushing vendor to live.'
			)); exit;
		}
	}

	// action type cronjob
	public function actionSetVendorDataForPushing() {
		$pushingVendorFiles = VendorFile::model()->findAll(array(
			'condition' => 'status = :status',
			'params' => array(':status' => VendorFile::STATUS_PUSHING)
		));

		if (empty($pushingVendorFiles)) {
			echo 'No vendor files with for pushing status.'; exit;
		}

		$errorProcess = 0;

		foreach ($pushingVendorFiles as $pushingVendorFile) {
			$forReviewVendorNormalisedData = VendorNormalized::model()->findAll(array(
				'condition' => 'status = :status AND vendor_fileupload_id = :vendor_fileupload_id',
				'params' => array(
					':status' => VendorNormalized::STATUS_FOR_REVIEW,
					':vendor_fileupload_id' => $pushingVendorFile->id)
			));

			if (count($forReviewVendorNormalisedData) <= 0) {
				continue;
			} 

			$processDataLimit = 10;
			$processData = 0;

			foreach ($forReviewVendorNormalisedData as $forReviewVendorNormalised) {
				$forReviewVendorNormalised->status = VendorNormalized::STATUS_PUSHING;
				
				if (!$forReviewVendorNormalised->save(false)) {
					$errorProcess++;
				}

				$processData++;

				if ($processData >= $processDataLimit) {
					$processData = 0;
					break;
				} 
			}

			echo 'for review normalize: ' . count($forReviewVendorNormalisedData) . '<br>';
			echo 'for pushing normalize:' . $processData;

			break;
		}
	}

	// action type cronjob test
	public function actionTestPublishData() {
		set_time_limit(0);
		$pushingVendorFiles = VendorFile::model()->findAll(array(
			'condition' => 'status = :status',
			'params' => array(
				':status' => VendorFile::STATUS_PUSHING
			),
			'limit' => 1
		));

		if (empty($pushingVendorFiles)) {
			die(CJSON::encode(array(
				'error' => 'No publishing vendor found!'
			)));
		}
		try {
			$errorProcess = 0;

			foreach ($pushingVendorFiles as $pushingVendorFile) {
				$forPushingVendorDatas = VendorNormalized::model()->findAll(array(
					'condition' => 'status = :status AND vendor_fileupload_id = :vendor_fileupload_id',
					'params' => array(
						':status' => VendorNormalized::STATUS_FOR_REVIEW,
						':vendor_fileupload_id' => $pushingVendorFile->id),
					'limit' => 1
				));

				$productFeeds = array();
				
				$publishedDataCount = 0;
				$processData = 0;

				foreach ($forPushingVendorDatas as $index => $forPushingVendorData) {
					$vendorNormalizedInfo = $forPushingVendorData->vendorNormalizedInfo;
					$vendorName = ucwords(strtolower(Vendor::getVendorNameLabel($forPushingVendorData->vendorFile->vendor->id)));

					$forPushingVendorData->status = VendorNormalized::STATUS_PUSHING;
					$forPushingVendorData->save(false);
					
					$gssSearchResponseStart = date('m-d-Y H:i:s');
		            $gssSearch = WooCommerceGSS::getProductBySKU($forPushingVendorData->vendorNormalizedInfo->sku);
					$gssSearchResponseEnd = date('m-d-Y H:i:s');
					$sbbSearchResponseStart = date('m-d-Y H:i:s');
		            $sbbSearch = WooCommerce::getProductBySKU($forPushingVendorData->vendorNormalizedInfo->sku);
					$sbbSearchResponseEnd = date('m-d-Y H:i:s');

					$gssSearchResponse = strtotime($gssSearchResponseEnd) - strtotime($gssSearchResponseStart);
					$sbbSearchResponse = strtotime($sbbSearchResponseEnd) - strtotime($sbbSearchResponseStart);

		            //checking description length on website
		            $gssDescription = $gssSearch[0]->description ?: '';
		            $sbbDescription = $sbbSearch[0]->description ?: '';
		            $websiteDescription = (strlen($gssDescription) > strlen($sbbDescription) ? $gssDescription : $sbbDescription);
		            $description = (strlen($websiteDescription) > strlen($forPushingVendorData->vendorNormalizedInfo->description) ? $websiteDescription : $forPushingVendorData->vendorNormalizedInfo->description);
		            $forPushingVendorData->vendorNormalizedInfo->description = $description;

					//checking short description length on website
		            $gssShortDescription = $gssSearch[0]->short_description ?: '';
		            $sbbShortDescription = $sbbSearch[0]->short_description ?: '';
					$websiteShortDescription = (strlen($gssShortDescription) > strlen($sbbShortDescription) ? $gssShortDescription : $sbbShortDescription);
					$shortDescription = (strlen($websiteShortDescription) > strlen($forPushingVendorData->vendorNormalizedInfo->qb_description) ? $websiteShortDescription : $forPushingVendorData->vendorNormalizedInfo->qb_description);
		            $forPushingVendorData->vendorNormalizedInfo->qb_description = $shortDescription;
					
					//checking product name length on websites
					$forPushingVendorData->vendorNormalizedInfo->product_name = substr($vendorName.' '.$forPushingVendorData->vendorNormalizedInfo->mpn.' '. strip_tags($forPushingVendorData->vendorNormalizedInfo->qb_description) ?: strip_tags($forPushingVendorData->vendorNormalizedInfo->description),0,70);
		            $gssProductName = $gssSearch[0]->name ?: '';
		            $sbbProductName = $sbbSearch[0]->name ?: '';
					$websiteProductName = (strlen($gssProductName) > strlen($sbbProductName) ? $gssProductName : $sbbProductName);
					$productName = (strlen($websiteProductName) > strlen($forPushingVendorData->vendorNormalizedInfo->product_name) ? $websiteProductName : $forPushingVendorData->vendorNormalizedInfo->product_name);
					$forPushingVendorData->vendorNormalizedInfo->product_name = $productName;

		            $forPushingVendorData->vendorNormalizedInfo->save(false);

					$product = Product::model()->find(array(
						'alias' => 'p',
						'join' => 'INNER JOIN {{product_info}} AS pi ON p.id = pi.product_id',
						'condition' => 'pi.mpn = :mpn AND p.status in (
							'. Product::STATUS_ACTIVE .')',
						'params' => [
							':mpn' => trim($forPushingVendorData->vendorNormalizedInfo->mpn)
						]
					));

					if (!$product) {
						$product = new Product;							
					}
					
					$product->vendor_id = $pushingVendorFile->vendor_id;
					$product->batch_id = VendorFile::generateBatchId($pushingVendorFile->id);
					$product->platform_1_rest_id = $forPushingVendorData->platform_1_rest_id ?: $sbbSearch[0]->id;
					$product->platform_2_rest_id = $forPushingVendorData->platform_2_rest_id ?: $gssSearch[0]->id;
					if ($forPushingVendorData->product_status == VendorNormalized::PRODUCT_STATUS_EOL) {
						$product->product_status = Product::PRODUCT_STATUS_EOL;
					} else {
						$product->product_status = Product::PRODUCT_STATUS_EXISTING;
					}

					if ($product->validate() && $product->save()) {
						if (isset($product->productInfo)) {
							$productInfo = $product->productInfo;
						} else {
							$productInfo = new ProductInfo;
							$productInfo->product_id = $product->id;
						}				

						$productInfo->brand_name = trim($vendorNormalizedInfo->brand_name);
						$productInfo->sku = trim($vendorNormalizedInfo->sku);
						$productInfo->mpn = trim($vendorNormalizedInfo->mpn);
						$productInfo->product_name = trim($vendorNormalizedInfo->product_name);
						$productInfo->msrp = (float) $vendorNormalizedInfo->msrp;
						
						$productInfo->cost = (float) $vendorNormalizedInfo->cost;
						$productInfo->sbb_price = (float) $vendorNormalizedInfo->price_sbb;

						if(empty($productInfo->description) || strlen($productInfo->description) < strlen(trim($vendorNormalizedInfo->description)))
							$productInfo->description = trim($vendorNormalizedInfo->description);

						if (isset($product->productInfo))
							$productInfo->description = $productInfo->description;
						
						$productInfo->qb_description = trim($vendorNormalizedInfo->qb_description);
						$productInfo->ean = trim($vendorNormalizedInfo->ean);

						$productInfo->width = trim($vendorNormalizedInfo->width);
						$productInfo->length = trim($vendorNormalizedInfo->length);
						$productInfo->height = trim($vendorNormalizedInfo->height);
						$productInfo->weight = trim($vendorNormalizedInfo->weight);
						//$productInfo->quantity = trim($vendorNormalizedInfo->quantity);
						
						if ($productInfo->validate()) {
							if ($productInfo->save()) {
								$forPushingVendorData->status = VendorNormalized::STATUS_PUSHED;
								$forPushingVendorData->save(false);
			
								$existProductPricingTiers = ProductPricingTierLookup::model()->findAll([
									'condition' => 'product_id = :product_id and status = :status',
									'params' => [
										'product_id' => $product->id,
										'status' => PricingGroup::STATUS_ACTIVE
									]
								]);
								
								foreach ($existProductPricingTiers as $existProductPricingTier) {
									$existProductPricingTier->status = ProductPricingTierLookup::STATUS_DELETED;
									$existProductPricingTier->woocommerce_status = 0;
									$existProductPricingTier->save(false);
								}

								$parsedProductPricingTiers = NormalizedPricingTierLookup::model()->findAll([
									'condition' => 'parsed_id = :parsed_id and status = :status',
									'params' => [
										'parsed_id' => $forPushingVendorData->id,
										'status' => PricingGroup::STATUS_ACTIVE
									]
								]);

								foreach ($parsedProductPricingTiers as $parsedProductPricingTierData) {
									$productPrice = new ProductPricingTierLookup;
									$productPrice->product_id = $product->id;
									$productPrice->selected_price_type = $parsedProductPricingTierData->selected_price_type;
									$productPrice->cost_markup_computed = $parsedProductPricingTierData->cost_markup_computed;
									$productPrice->msrp_markdown_computed = $parsedProductPricingTierData->msrp_markdown_computed;
									$productPrice->pricing_tier_id = $parsedProductPricingTierData->pricing_tier_id;
									$productPrice->group_id = $parsedProductPricingTierData->group_id;
									$productPrice->status = PricingGroup::STATUS_ACTIVE;
									$productPrice->woocommerce_status = 0; /* pending */
									$productPrice->save(false);
								}
								$tmpData = $product->attributes + $productInfo->attributes;
								$tmpData['brand'] = $forPushingVendorData->vendorFile->vendor->name;
								$tmpData['product_from'] = $forPushingVendorData->product_from;
								$tmpData['publishing'] = true;

								$productFeeds[$index] = $tmpData;

							} else {
								throw new Exception('error: ' . json_encode($productInfo->getErrors()));												
							}
						} else {
							throw new Exception('error: ' . json_encode($productInfo->getErrors()));												
						}
					} else {
						throw new Exception('error: ' . json_encode($product->getErrors()));									
					}
				}

			//if ($errorProcess <= 0) {
				$productResponse[] = Product::apisBatchInsertEditData($productFeeds, [
					'success_status' => Product::REST_STATUS_PUBLISH_ADD_DATA_SUCCESS,
					'success_error' => Product::REST_STATUS_PUBLISH_ADD_DATA_ERROR
				], true, true);

				$forPushingVendorDatas = VendorNormalized::model()->findAll(array(
					'condition' => 'status = :status AND vendor_fileupload_id = :vendor_fileupload_id',
					'params' => array(
						':status' => VendorNormalized::STATUS_FOR_REVIEW,
						':vendor_fileupload_id' => $pushingVendorFile->id),
					'limit' => 1
				));

				if (count($forPushingVendorDatas) <= 0) {
					$pushingVendorFile->setStatusPushed();
					Yii::app()->db->createCommand()->update('gss_product', array(
						'product_status' => Product::PRODUCT_STATUS_EOL,
						'platform_1_rest_status' => 0,
						'platform_2_rest_status' => 0,
					), 	'batch_id != :batch_id AND vendor_id = :vendor_id', array(
						':batch_id' => VendorFile::generateBatchId($pushingVendorFile->id),
						':vendor_id' => $pushingVendorFile->vendor_id,
					));

					//$transaction->commit();
					exit;
				}

				//} else {
					//$transaction->rollBack();
				//}

				break;
			}
		
		} catch (Exception $e) {
			//$transaction->rollBack();
			Dev::pvx($e);
		}
		die(CJSON::encode(array(
			'sbbSearchResponse' => $sbbSearchResponse,
			'gssSearchResponse' => $gssSearchResponse,
			'sbbInsertResponse' => $productResponse[0]['sbbResponse'],
			'gssInsertResponse' => $productResponse[0]['gssResponse'],
			'sbbGoogleResponse' => $productResponse[0]['sbbGoogleResponse'],
			'gssGoogleResponse' => $productResponse[0]['gssGoogleResponse']
		)));
		/* echo 'for published data:' . $publishedDataCount . '/' . count($forPushingVendorDatas); */
	}

	public function actionGetProductBySKU(){
		
		$sbbSearch = WooCommerce::getProductBySKU("QNAP:QVP-21A-04CH-US");
		Dev::pvx($sbbSearch);
	}
	
	// action type cronjob publish vendor data to websites and google
	public function actionPublishVendorData() {
		set_time_limit(0);
		$pushingVendorFiles = VendorFile::model()->findAll(array(
			'condition' => 'status = :status',
			'params' => array(':status' => VendorFile::STATUS_PUSHING),
			'limit' => 1
		));
		if (empty($pushingVendorFiles)) {
			echo 'No vendor files with for pushing status.'; exit;
		}
		try {
			$errorProcess = 0;

			foreach ($pushingVendorFiles as $pushingVendorFile) {
				$forPushingVendorDatas = VendorNormalized::model()->findAll(array(
					'condition' => 'status = :status AND vendor_fileupload_id = :vendor_fileupload_id',
					'params' => array(
						':status' => VendorNormalized::STATUS_FOR_REVIEW,
						':vendor_fileupload_id' => $pushingVendorFile->id),
					'limit' => 7
				));

				$productFeeds = array();
				
				$publishedDataCount = 0;
				$processData = 0;
				if(count($forPushingVendorDatas) > 0){
					foreach ($forPushingVendorDatas as $index => $forPushingVendorData) {
						$vendorNormalizedInfo = $forPushingVendorData->vendorNormalizedInfo;
						$vendorName = ucwords(strtolower(Vendor::getVendorNameLabel($forPushingVendorData->vendorFile->vendor->id)));

						$forPushingVendorData->status = VendorNormalized::STATUS_PUSHING;
						$forPushingVendorData->save(false);
						
						$gssSearch = WooCommerceGSS::getProductBySKU($forPushingVendorData->vendorNormalizedInfo->sku);
						$sbbSearch = WooCommerce::getProductBySKU($forPushingVendorData->vendorNormalizedInfo->sku);

						//checking description length on website
						$gssDescription = $gssSearch[0]->description ?: '';
						$sbbDescription = $sbbSearch[0]->description ?: '';
						$websiteDescription = (strlen($gssDescription) > strlen($sbbDescription) ? $gssDescription : $sbbDescription);
						$description = (strlen($websiteDescription) > strlen($forPushingVendorData->vendorNormalizedInfo->description) ? $websiteDescription : $forPushingVendorData->vendorNormalizedInfo->description);
						/* Removed 20220115
						$forPushingVendorData->vendorNormalizedInfo->description = $description; */

						//checking short description length on website
						$gssShortDescription = $gssSearch[0]->short_description ?: '';
						$sbbShortDescription = $sbbSearch[0]->short_description ?: '';
						$websiteShortDescription = (strlen($gssShortDescription) > strlen($sbbShortDescription) ? $gssShortDescription : $sbbShortDescription);
						$shortDescription = (strlen($websiteShortDescription) > strlen($forPushingVendorData->vendorNormalizedInfo->qb_description) ? $websiteShortDescription : $forPushingVendorData->vendorNormalizedInfo->qb_description);
						/* Removed 20220115
						$forPushingVendorData->vendorNormalizedInfo->qb_description = $shortDescription; */
						
						//checking product name length on websites
						$forPushingVendorData->vendorNormalizedInfo->product_name = substr($vendorName.' '.$forPushingVendorData->vendorNormalizedInfo->mpn.' '. strip_tags($forPushingVendorData->vendorNormalizedInfo->qb_description) ?: strip_tags($forPushingVendorData->vendorNormalizedInfo->description),0,70);
						$gssProductName = $gssSearch[0]->name ?: '';
						$sbbProductName = $sbbSearch[0]->name ?: '';
						$websiteProductName = (strlen($gssProductName) > strlen($sbbProductName) ? $gssProductName : $sbbProductName);
						$productName = (strlen($websiteProductName) > strlen($forPushingVendorData->vendorNormalizedInfo->product_name) ? $websiteProductName : $forPushingVendorData->vendorNormalizedInfo->product_name);
						$forPushingVendorData->vendorNormalizedInfo->product_name = substr($productName,0,70);

						$forPushingVendorData->vendorNormalizedInfo->save(false);

						$product = Product::model()->find(array(
							'alias' => 'p',
							'join' => 'INNER JOIN {{product_info}} AS pi ON p.id = pi.product_id',
							'condition' => 'pi.mpn = :mpn AND p.status in (
								'. Product::STATUS_ACTIVE .')',
							'params' => [
								':mpn' => trim($forPushingVendorData->vendorNormalizedInfo->mpn)
							]
						));

						if (!$product) {
							$product = new Product;							
						}
						
						$product->vendor_id = $pushingVendorFile->vendor_id;
						$product->batch_id = VendorFile::generateBatchId($pushingVendorFile->id);
						$product->platform_1_rest_id = $forPushingVendorData->platform_1_rest_id ?: $sbbSearch[0]->id;
						$product->platform_2_rest_id = $forPushingVendorData->platform_2_rest_id ?: $gssSearch[0]->id;
						if ($forPushingVendorData->product_status == VendorNormalized::PRODUCT_STATUS_EOL) {
							$product->product_status = Product::PRODUCT_STATUS_EOL;
						} else {
							$product->product_status = Product::PRODUCT_STATUS_EXISTING;
						}

						if ($product->validate() && $product->save()) {
							if (isset($product->productInfo)) {
								$productInfo = $product->productInfo;
							} else {
								$productInfo = new ProductInfo;
								$productInfo->product_id = $product->id;
							}				

							$productInfo->brand_name = trim($vendorNormalizedInfo->brand_name);
							$productInfo->sku = trim($vendorNormalizedInfo->sku);
							$productInfo->mpn = trim($vendorNormalizedInfo->mpn);
							$productInfo->product_name = trim($vendorNormalizedInfo->product_name);
							$productInfo->msrp = (float) $vendorNormalizedInfo->msrp;
							
							$productInfo->cost = (float) $vendorNormalizedInfo->cost;
							$productInfo->sbb_price = (float) $vendorNormalizedInfo->price_sbb;

							if(empty($productInfo->description) || strlen($productInfo->description) < strlen(trim($description)))
								$productInfo->description = trim($description);

							if (isset($product->productInfo))
								$productInfo->description = $productInfo->description;
							
							$productInfo->qb_description = trim($shortDescription);
							$productInfo->ean = trim($vendorNormalizedInfo->ean);

							$productInfo->width = trim($vendorNormalizedInfo->width);
							$productInfo->length = trim($vendorNormalizedInfo->length);
							$productInfo->height = trim($vendorNormalizedInfo->height);
							$productInfo->weight = trim($vendorNormalizedInfo->weight);
							//$productInfo->quantity = trim($vendorNormalizedInfo->quantity);
							
							if ($productInfo->validate()) {
								if ($productInfo->save()) {
									$forPushingVendorData->status = VendorNormalized::STATUS_PUSHED;
									$forPushingVendorData->save(false);
				
									$existProductPricingTiers = ProductPricingTierLookup::model()->findAll([
										'condition' => 'product_id = :product_id and status = :status',
										'params' => [
											'product_id' => $product->id,
											'status' => PricingGroup::STATUS_ACTIVE
										]
									]);
									
									foreach ($existProductPricingTiers as $existProductPricingTier) {
										$existProductPricingTier->status = ProductPricingTierLookup::STATUS_DELETED;
										$existProductPricingTier->woocommerce_status = 0;
										$existProductPricingTier->save(false);
									}

									$parsedProductPricingTiers = NormalizedPricingTierLookup::model()->findAll([
										'condition' => 'parsed_id = :parsed_id and status = :status',
										'params' => [
											'parsed_id' => $forPushingVendorData->id,
											'status' => PricingGroup::STATUS_ACTIVE
										]
									]);

									foreach ($parsedProductPricingTiers as $parsedProductPricingTierData) {
										$productPrice = new ProductPricingTierLookup;
										$productPrice->product_id = $product->id;
										$productPrice->selected_price_type = $parsedProductPricingTierData->selected_price_type;
										$productPrice->cost_markup_computed = $parsedProductPricingTierData->cost_markup_computed;
										$productPrice->msrp_markdown_computed = $parsedProductPricingTierData->msrp_markdown_computed;
										$productPrice->pricing_tier_id = $parsedProductPricingTierData->pricing_tier_id;
										$productPrice->group_id = $parsedProductPricingTierData->group_id;
										$productPrice->status = PricingGroup::STATUS_ACTIVE;
										$productPrice->woocommerce_status = 0; /* pending */
										$productPrice->save(false);
									}
									$tmpData = $product->attributes + $productInfo->attributes;
									$tmpData['brand'] = $forPushingVendorData->vendorFile->vendor->name;
									$tmpData['product_from'] = $forPushingVendorData->product_from;
									$tmpData['publishing'] = true;

									$productFeeds[$index] = $tmpData;

								} else {
									throw new Exception('error: ' . json_encode($productInfo->getErrors()));												
								}
							} else {
								throw new Exception('error: ' . json_encode($productInfo->getErrors()));												
							}
						} else {
							throw new Exception('error: ' . json_encode($product->getErrors()));									
						}
					}
					sleep(1);
				}

			//if ($errorProcess <= 0) {
				if(count($productFeeds) > 0){
					$productAPI = Product::apisBatchInsertEditData($productFeeds, [
						'success_status' => Product::REST_STATUS_PUBLISH_ADD_DATA_SUCCESS,
						'success_error' => Product::REST_STATUS_PUBLISH_ADD_DATA_ERROR
					], false, $forPushingVendorData->vendorFile->google_feed_publish);
				}
				$forPushingVendorDatas = VendorNormalized::model()->findAll(array(
					'condition' => 'status = :status AND vendor_fileupload_id = :vendor_fileupload_id',
					'params' => array(
						':status' => VendorNormalized::STATUS_FOR_REVIEW,
						':vendor_fileupload_id' => $pushingVendorFile->id),
					'limit' => 1
				));
				if (count($forPushingVendorDatas) <= 0) {
					$pushingVendorFile->setStatusPushed();
					Yii::app()->db->createCommand()->update('gss_product', array(
						'product_status' => Product::PRODUCT_STATUS_EOL,
						'platform_1_rest_status' => 0,
						'platform_2_rest_status' => 0,
					), 	'batch_id != :batch_id AND vendor_id = :vendor_id', array(
						':batch_id' => VendorFile::generateBatchId($pushingVendorFile->id),
						':vendor_id' => $pushingVendorFile->vendor_id,
					));

					//$transaction->commit();
					Dev::pvx('done');
					exit;
				}
				

				//} else {
					//$transaction->rollBack();
				//}

				break;
			}
			
		
		} catch (Exception $e) {
			//$transaction->rollBack();
			Dev::pvx($e);
		}

		echo 'for published data:' . $publishedDataCount . '/' . count($forPushingVendorDatas);
	}

	// action type ajax
	public function actionGetParsedDetails($vendorFileId) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);

		$response = array(
			'count_total_parsed' => 0,
			'status_count' => [
				'for_review' => 0,
				'pushing' => 0,
				'pushed' => 0,
				'error' => 0,
				'deleted' => 0
			],
			'vendor_file_details' => [
				'id' => '',
				'vendor' => '',
				'filename' => '',
				'status' => '',
				'date_created' => '',
				'parsed_data' => ''
			],
			'count_product_check_status' => [
				'new' => 0,
				'updated' => 0,
				'remain' => 0,
				'not_checked' => 0,
				'eol' => 0
			],
			'count_platform_status' => [
				'sbb_pending' => 0,
				'sbb_new' => 0,
				'sbb_existing' => 0,
				'gss_pending' => 0,
				'gss_new' => 0,
				'gss_existing' => 0,
			],

		);

		$response['count_total_parsed'] = VendorNormalized::countTotalParsed($vendorFile->id) . ' / ' . $vendorFile->total_product;
		
		$response['status_count']['for_review'] = VendorNormalized::countStatusForReview($vendorFile->id);
		$response['status_count']['pushing'] = VendorNormalized::countStatusPushing($vendorFile->id);
		$response['status_count']['pushed'] = VendorNormalized::countStatusPushed($vendorFile->id);
		$response['status_count']['error'] = VendorNormalized::countStatusError($vendorFile->id);
		$response['status_count']['deleted'] = VendorNormalized::countStatusDeleted($vendorFile->id);

		$normalizedVendorFiles = VendorNormalized::getNormalizedFiles($vendorFile->id);

		foreach ($normalizedVendorFiles as $normalizedVendorFile) {
			$response['vendor_file_details']['id'] = $normalizedVendorFile['id'];
			$response['vendor_file_details']['vendor'] = $normalizedVendorFile['vendor_name'];
			$response['vendor_file_details']['filename'] = $normalizedVendorFile['original_filename'];
			$response['vendor_file_details']['status'] = VendorFile::getStatusLabel($normalizedVendorFile['status']);
			$response['vendor_file_details']['date_created'] = date('M, d Y H:i a', strtotime($normalizedVendorFile['date_created']));
			$response['vendor_file_details']['parsed_data'] = '<span class="badge">' . $response['count_total_parsed'] . '</span>';
			break;
		}

		$productCheckDataStatus = $vendorFile->getProductCheckDataStatus();
		$response['count_product_check_status']['new'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_NEW];
		$response['count_product_check_status']['updated'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_UPDATED];
		$response['count_product_check_status']['remain'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_REMAIN];
		$response['count_product_check_status']['not_checked'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_NOT_CHECKED];
		$response['count_product_check_status']['eol'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_EOL];

		$response['count_platform_status']['sbb_pending'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_PENDING, $vendorFile->id, 'sbb'));
		$response['count_platform_status']['sbb_new'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_NEW, $vendorFile->id, 'sbb'));
		$response['count_platform_status']['sbb_existing'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_EXISTING, $vendorFile->id, 'sbb'));
		$response['count_platform_status']['sbb_eol'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_EOL];
		$response['count_platform_status']['gss_pending'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_PENDING, $vendorFile->id, 'gss'));
		$response['count_platform_status']['gss_new'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_NEW, $vendorFile->id, 'gss'));
		$response['count_platform_status']['gss_existing'] = count(VendorNormalized::getPlatformStatus(VendorNormalized::REST_STATUS_EXISTING, $vendorFile->id, 'gss'));
		$response['count_platform_status']['gss_eol'] = $productCheckDataStatus[VendorNormalized::PRODUCT_STATUS_EOL];

		echo CJSON::encode($response); exit;
	}

	// action type ajax
	public function actionDeleteParsedData() {
		$normalizeDataIds = !empty($_POST['normalize_data_ids']) 
			? $_POST['normalize_data_ids'] : '';

		if ($normalizeDataIds == '') {
			echo CJSON::encode(array(
				'status' => 'error',
				'message' => 'Nothing to delete, No selected data.'
			));
		}
		
		$error = 0;

		foreach ($normalizeDataIds as $normalizeDataId) {
			$normalizedData = VendorNormalized::model()->findByPk($normalizeDataId);

			$normalizedData->status = VendorNormalized::STATUS_DELETED;
			
			if (!$normalizedData->save(false)) {
				$error++;
				break;
			}
		}

		if ($error <= 0) {
			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'Selected data successfully deleted.'
			]); exit;
		} else {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Selected data failed to delete.'
			]); exit;
		}
	}

	// action type ajax
	public function actionCountParsedData($vendorFileId) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);

		if ($vendorFile) {
			$countTotalParsed = VendorNormalized::countTotalParsed($vendorFile->id);

			$response['count'] = $countTotalParsed;
			$response['status'] = $vendorFile->status;				
		
			echo CJSON::encode($response); exit;
		}

		throw CHttpException(403, 'Unable to process request.');
	}

	// action type ajax
	public function actionGetProgressDetails($vendorFileId) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);

		if ($vendorFile) {
			$countTotalParsed = VendorNormalized::countTotalParsed($vendorFile->id);
			$countTotalParsing = VendorNormalized::countTotalParsing($vendorFile->id);
			$countTotalPending = VendorNormalized::countStatusPending($vendorFile->id);
			$countTotalForReview = VendorNormalized::countStatusForReview($vendorFile->id);
			$countTotalPushed = VendorNormalized::countStatusPushed($vendorFile->id);
			$countTotalSynced = VendorNormalized::countStatusSynced($vendorFile->id);
			
			$response['item_count'] = $countTotalParsed;
			$response['status'] = $vendorFile->status;
			$response['sync_status'] = $vendorFile->sync_status;
			
			$response['item_count_parsing'] = $countTotalParsing .' / '. $vendorFile->total_product;
			$response['item_count_pushing'] = $countTotalPushed . ' / ' . $countTotalParsed;
			$response['item_count_syncing'] = $countTotalSynced . ' / ' .$vendorFile->total_product;
			
		
			echo CJSON::encode($response); exit;
		}

		throw CHttpException(403, 'Unable to process request.');
	}

	public function actionUpdatePriceSetting($vendorFileId) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);

		$transaction = Yii::app()->db->beginTransaction();

		try {

			if (!$vendorFile) {
				throw new Exception('Error: Invalid vendor.');
			}

			if ($vendorFile->status != VendorFile::STATUS_FOR_REVIEW) {
				throw new Exception('Error: Invalid vendor status.');
			}
		
			$errors = 0;
			$affectedDataCount = 0;
			if ($_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_FROM_COLUMN) {

				$columnNameRaw = $_POST['price_setting']['column_name'];
				$columnName = ZCommon::cleanString($_POST['price_setting']['column_name']);

				$parsedDataRaw = $vendorFile->parsedSpreedSheetData(['rawData' => true]);

				$parsedData = $vendorFile->getParsedData();
		
				foreach ($parsedData as $parsedDataKey => $parsedDataVal) {
					$parsedDataInfo = $parsedDataVal->vendorNormalizedInfo;

					$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
						'condition' => 'mpn = :mpn AND status = :status',
						'params' => [
							':mpn' => trim($parsedDataInfo->mpn),
							':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
						]
					]);

					if ($normalizedLockPricing) {
						continue;
					}

					if (isset($parsedDataRaw[$parsedDataVal->sheet_row_index_code])) {
						foreach ($parsedDataRaw[$parsedDataVal->sheet_row_index_code] as $parsedDataRawKey => $parsedDataRawVal) {
							if ($parsedDataRawKey == $columnName) {
								if (trim($parsedDataVal->sheet_row_index_code) == trim($parsedDataVal->sheet_row_index_code)) {
									$parsedDataInfo->price_sbb = (float) $parsedDataRawVal;
									$parsedDataInfo->save(false);

									$affectedDataCount++;				
									break;
								}
							}
						}
					}
				}

				if ($affectedDataCount <= 0) {
					throw new Exception('Error: column name don\'t match or all price are locked.');
				}

				if ($errors <= 0) {
					$vendorFile->json_price_setting_sbb = json_encode([
						'type' => $_POST['price_setting']['type'],
						'column_name' => $columnNameRaw,
						'sales_margin' => '',
						'dollars' => ''
					]);

					if (!$vendorFile->save(false)) {
						throw new Exception('Failed to save price setting json.');
					}
				}
				
			} else if ($_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST 
			|| $_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_MSRP) {
				$parsedData = $vendorFile->getParsedData(true);

				$salesMarginCostMarkup = (float) $_POST['price_setting']['sales_margin_cost_markup'];
				$salesMarginMsrpMarkDown = (float) $_POST['price_setting']['sales_margin_msrp_markdown'];

				$salesDollor = (int) $_POST['price_setting']['dollor'];
				
				foreach ($parsedData as $vendorFileParsedDataModel) {
					$vendorNormalizedInfo = $vendorFileParsedDataModel->vendorNormalizedInfo;

					$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
						'condition' => 'mpn = :mpn AND status = :status',
						'params' => [
							':mpn' => trim($vendorNormalizedInfo->mpn),
							':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
						]
					]);

					if ($normalizedLockPricing) {
						continue;
					}

					$salesBasedPrice = (float) ($_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST) 
						? $vendorNormalizedInfo->cost : $vendorNormalizedInfo->msrp;

					if ($_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_COST) {
						$salesMarginCostMarkupDivision = 1 - ($salesMarginCostMarkup / 100);
						$tmpPrice = ($salesBasedPrice / $salesMarginCostMarkupDivision) + $salesDollor;

						$salesMargin = $salesMarginCostMarkup;
					} else if ($_POST['price_setting']['type'] == SettingSalesPrice::SALES_PRICE_SETTING_MSRP) {
						$salesMarginMsrpMarkDownDivision = 1 - ($salesMarginMsrpMarkDown / 100);
						
						$tmpPrice = ($salesBasedPrice * $salesMarginMsrpMarkDownDivision) + $salesDollor;
						$salesMargin = $salesMarginMsrpMarkDown;
					}

					$vendorNormalizedInfo->price_sbb = (float) $tmpPrice;

					if ($vendorNormalizedInfo->save(false)) { 
						$affectedDataCount++;	
					} else {
						$errors++;
					}
				}

				if ($affectedDataCount <= 0) {
					throw new Exception('Error: empty data or all price are locked.');
				}

				if ($errors <= 0) {
					$vendorFile->json_price_setting_sbb = json_encode([
						'type' => $_POST['price_setting']['type'],
						'column_name' => '',
						'sales_margin' => $salesMargin,
						'dollars' => $salesDollor
					]);

					if (!$vendorFile->save(false)) {
						throw new Exception('Error: failed to save price setting json.');
					}
				}
			} else {
				throw new Exception('Error: price setting invalid type.');
			}

			if ($errors <= 0) {
				$transaction->commit();

				echo CJSON::encode([
					'status' => 'ok',
					'message' => 'Price setting successfully applied. affected data('. $affectedDataCount .').'
				]); exit;
			} else {
				throw new Exception('Error: price setting cannot be saved.');
			}
		} catch (Exception $e) {
			$transaction->rollBack();

			echo CJSON::encode(array(
				'status' => 'error',
				'message' => $e->getMessage()
			)); exit;
		}

		throw CHtttpError(403, 'Invalid request.');
	}

	public function actionCreateUpdatePriceSettingGss($spreedsheetId) {
		$countAffectedProducts = 0;

		$spreadsheet = VendorFile::model()->findByPk($spreedsheetId);

		if (!$spreadsheet) {
			throw CHttpException(403, 'Invalid request, spreadsheet not exists.');
		}

		$spreadsheetParsedData = $spreadsheet->getParsedData(true);

		if (count($spreadsheetParsedData) <= 0) {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Spreadsheet has no products available.'
			]); exit;
		}

		$pricingGroupId = !empty($_POST['pricing_group_id']) ? $_POST['pricing_group_id'] : '';

		if ($pricingGroupId == '') {
			foreach ($spreadsheetParsedData as $parsedData) {
				$parsedDataInfo = $parsedData->vendorNormalizedInfo;

				$parsedDataPriceExisting = NormalizedPricingTierLookup::model()->findAll([
					'condition' => 'parsed_id = :parsed_id AND status = :status',
					'params' => [
						':parsed_id' => $parsedData->id,
						':status' => PricingGroup::STATUS_ACTIVE
					]
				]);
				
				foreach ($parsedDataPriceExisting as $parsedDataPriceExistingData) {
					$parsedDataPriceExistingData->status = PricingGroup::STATUS_INACTIVE;
					$parsedDataPriceExistingData->save(false);
				}

				$countAffectedProducts++;
			}

			$spreadsheet->json_price_setting_gss = null;

			$spreadsheet->save(false);

			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'GSS Product ('. $countAffectedProducts .') pricing levels successfully apply.'
			]); exit;
		}

		// if ($pricingType == '') {
		// 	echo CJSON::encode([
		// 		'status' => 'error',
		// 		'message' => 'Select Pricing Type between Markup or Markdown.'
		// 	]); exit;
		// }

		$pricingGroup = PricingGroup::model()->findByPk($pricingGroupId);

		if (!$pricingGroup) {
			throw new CHttpException(403, 'Invalid request, price group not exists.');
		}

		$pricingGroupPrices = $pricingGroup->getPrices();

		if (count($pricingGroupPrices) <= 0) {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Pricing Group don\'t have any price levels.'
			]); exit;
		}

		$countAffectedProducts = 0;

		$transaction = Yii::app()->db->beginTransaction();

		try {
			foreach ($spreadsheetParsedData as $parsedData) {
				$parsedDataInfo = $parsedData->vendorNormalizedInfo;

				$parsedDataPriceExisting = NormalizedPricingTierLookup::model()->findAll([
					'condition' => 'parsed_id = :parsed_id AND status = :status',
					'params' => [
						':parsed_id' => $parsedData->id,
						':status' => PricingGroup::STATUS_ACTIVE
					]
				]);
				
				foreach ($parsedDataPriceExisting as $parsedDataPriceExistingData) {
					$parsedDataPriceExistingData->status = PricingGroup::STATUS_INACTIVE;
					$parsedDataPriceExistingData->save(false);
				}

				foreach ($pricingGroupPrices as $pricingGroupPrice) {
					if($pricingGroupPrice->vendor_id == $spreadsheet->vendor_id){
						$parsedDataPrice = NormalizedPricingTierLookup::model()->find([
							'condition' => 'parsed_id = :parsed_id
								AND selected_price_type = :selected_price_type
								AND pricing_tier_id = :pricing_tier_id',
							'params' => [
								':parsed_id' => $parsedData->id,
								':selected_price_type' => (int) $pricingGroupPrice->default_type,
								':pricing_tier_id' => $pricingGroupPrice->id,
							]
						]);

						if (!$parsedDataPrice) {
							$parsedDataPrice = new NormalizedPricingTierLookup;
						}

						$parsedDataPrice->parsed_id = $parsedData->id;
						$parsedDataPrice->selected_price_type = (int) $pricingGroupPrice->default_type;
						//$parsedDataPrice->cost_markup_computed = $parsedDataInfo->cost * (1 + ($pricingGroupPrice->cost_markup / 100)); //old wrong formula 02-16-21
						$parsedDataPrice->cost_markup_computed = $parsedDataInfo->cost / (1 - ($pricingGroupPrice->cost_markup / 100));
						$parsedDataPrice->msrp_markdown_computed = $parsedDataInfo->msrp * (1 - ($pricingGroupPrice->msrp_markdown / 100));
						$parsedDataPrice->pricing_tier_id = $pricingGroupPrice->id;
						$parsedDataPrice->group_id = $pricingGroup->id;
						$parsedDataPrice->status = PricingGroup::STATUS_ACTIVE;
						$parsedDataPrice->save(false);
					}
				}

				$countAffectedProducts++;
			}

			$transaction->commit();
		
			$spreadsheet->json_price_setting_gss = json_encode([
				'pricing_group_id' => $pricingGroup->id,
			]);

			$spreadsheet->save(false);

			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'GSS Product ('. $countAffectedProducts .') pricing levels successfully apply.'
			]); exit;
		} catch (Exception $e) {
			Dev::pvx($e);
			$transaction->rollBack();
		}

		throw new CHttpException(403, 'Invalid request.');
	}

	public function actionGetParsedData($id) {
		$parsedData = VendorNormalizedInfo::model()->find([
			'condition' => 'vendor_normalized_id = :vendor_normalized_id',
			'params' => [':vendor_normalized_id' => $id]
		]);

		if (!$parsedData) {
			throw new CHttpException(403, 'Invalid request.');
		}

		$responseData = $parsedData->attributes;

		$responseData['price'] = ZCommon::formatWithDecimal($parsedData['price_sbb']);
		$responseData['price_sbb'] = ZCommon::formatWithDecimal($parsedData['price_sbb']);
		$responseData['cost'] = ZCommon::formatWithDecimal($parsedData['cost']);
		$responseData['msrp'] = ZCommon::formatWithDecimal($parsedData['msrp']);
		$responseData['status'] = $parsedData->vendorNormalized->status;

		echo CJSON::encode($responseData); exit;
	}

	public function actionEditParsedData() {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') {
			throw new CHttpException(403, 'Invalid request.');
		}

		if (!isset($_POST['VendorNormalizedInfo'])) {
			throw new CHttpException(403, 'Invalid request. Form is missing.');
		}

		$postParsedData = $_POST['VendorNormalizedInfo'] + $_POST['VendorNormalized'];
		
		$parsedData = VendorNormalizedInfo::model()->find([
			'condition' => 'vendor_normalized_id = :vendor_normalized_id',
			'params' => [':vendor_normalized_id' => $postParsedData['vendor_normalized_id']]
		]);

		if (!$parsedData) {
			throw new CHttpException(403, 'Invalid request. Parsed data not exists.');
		}

		$parsedData->mpn = $postParsedData['mpn'];

		$parsedData->price_sbb = (float) $postParsedData['price_sbb'];
		$parsedData->cost = (float) $postParsedData['cost'];
		$parsedData->msrp = (float) $postParsedData['msrp'];
		$parsedData->description = $postParsedData['description'];
		$parsedData->sku = $postParsedData['sku'];
		$parsedData->ean = $postParsedData['ean'];
		$parsedData->weight = $postParsedData['weight'];
		$parsedData->width = $postParsedData['width'];
		$parsedData->length = $postParsedData['length'];
		$parsedData->height = $postParsedData['height'];
		//$parsedData->quantity = $postParsedData['quantity'];

		$parsedDataInfo = $parsedData->vendorNormalized;
		
		if (isset($postParsedData['status']) && $postParsedData['status'] == VendorNormalized::STATUS_DELETED) {
			$parsedDataInfo->status = VendorNormalized::STATUS_DELETED;
		} else {
			$parsedDataInfo->status = VendorNormalized::STATUS_FOR_REVIEW;
		}

		if ($parsedData->mpn == '') {	
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Error empty mpn id.'
			]); exit;
		} else {
			$mpnExist = VendorNormalizedInfo::model()->find([
				'alias' => 'vni',
				'join' => 'INNER JOIN {{vendor_normalized}} AS vn ON vn.id = vni.vendor_normalized_id',
				'condition' => 'vendor_fileupload_id = :vendor_fileupload_id AND vni.vendor_normalized_id <> :vendor_normalized_id AND vn.status <> :status AND vni.mpn = :mpn',
				'params' => [
					':vendor_fileupload_id' => $parsedDataInfo->vendor_fileupload_id,
					':status' => VendorNormalized::STATUS_DELETED,
					':mpn' => $parsedData->mpn,
					':vendor_normalized_id' => $postParsedData['vendor_normalized_id']
				]
			]);
			//	var_dump($postParsedData['vendor_normalized_id']); exit;
			if ($mpnExist) {
				echo CJSON::encode([
					'status' => 'error',
					'message' => 'Unable to save, MPN already exists.'
				]); exit;
			}

		}

		$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
			'condition' => 'mpn = :mpn AND status = :status',
			'params' => [
				':mpn' => trim($parsedData->mpn),
				':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
			]
		]);

		if ($normalizedLockPricing) {
			$normalizedLockPricing->price = $parsedData->price_sbb;
			$normalizedLockPricing->save(false);
		}

		if ($parsedDataInfo->save(false) && $parsedData->save(false)) {
			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'Parsed data successfully saved.'
			]); exit;
		} else {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Unable to save parsed data.'
			]); exit;
		}
	}

	public function actionRecheckProductStatus($vendorFileId) {
		$changes = 0;

		$vendorFile = VendorFile::model()->findByPk($vendorFileId);
		
		$parsedData = $vendorFile->getParsedData();
		
		foreach ($parsedData as $parsedDataKey => $parsedDataVal) {
			if ($parsedDataVal->product_status == VendorNormalized::PRODUCT_STATUS_EOL) {
				continue;
			}

			$parsedDataValInfo = $parsedDataVal->vendorNormalizedInfo;
			$oldProductStatus = $parsedDataVal->product_status;

			$parsedDataVal->product_status = VendorNormalized::productCheckStatus($parsedDataValInfo->attributes);

			if ($oldProductStatus != $parsedDataVal->product_status) {
				if ($parsedDataVal->save(false)) {
					$changes++;
				}
			}
		}

		if ($changes > 0) {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'There are updates on products status. Please re-review the data again.'
			]); exit;
		} else {
			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'No product status updates.'
			]); exit;
		}
	}

	public function actionLockPricing() {
		$normalizedIds = $_POST['normalize_data_ids'];

		$lockItems = 0;

		foreach ($normalizedIds as $normalizedId) {
			$normalized = VendorNormalized::model()->findByPk($normalizedId);
			$normalizedInfo = $normalized->vendorNormalizedInfo;

			$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
				'condition' => 'mpn = :mpn AND status = :status',
				'params' => [
					':mpn' => trim($normalizedInfo->mpn),
					':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
				]
			]);

			if (!$normalizedLockPricing) {
				$normalizedLockPricing = new VendorNormalizedPricingLock;
			}

			$normalizedLockPricing->mpn = trim($normalizedInfo->mpn);
			$normalizedLockPricing->price = (float) $normalizedInfo->price_sbb;
			$normalizedLockPricing->status = VendorNormalizedPricingLock::STATUS_ACTIVE;
			$normalizedLockPricing->date_created = date('Y-m-d H:i:s');

			if ($normalizedLockPricing->save(false)) {
				$lockItems++;
			}
		}

		echo CJSON::encode([
			'status' => 'ok',
			'message' => 'Successfully lock pricing. ('. $lockItems .' items)'
		]); exit;
	}

	public function actionUnLockPricing() {
		$normalizedIds = $_POST['normalize_data_ids'];

		$unLockItems = 0;

		foreach ($normalizedIds as $normalizedId) {
			$normalized = VendorNormalized::model()->findByPk($normalizedId);
			$normalizedInfo = $normalized->vendorNormalizedInfo;

			$normalizedLockPricing = VendorNormalizedPricingLock::model()->find([
				'condition' => 'mpn = :mpn AND status = :status',
				'params' => [
					':mpn' => trim($normalizedInfo->mpn),
					':status' => VendorNormalizedPricingLock::STATUS_ACTIVE,
				]
			]);

			if (!$normalizedLockPricing) {
				continue;
			} 

			$normalizedLockPricing->status = VendorNormalizedPricingLock::STATUS_DELETED;

			if ($normalizedLockPricing->save(false)) {
				$unLockItems++;
			}
		}

		echo CJSON::encode([
			'status' => 'ok',
			'message' => 'Successfully unlock pricing. ('. $unLockItems .' items)'
		]); exit;
	}

	public function actionDownloadQuickbook($vendorFileId) {
		$vendorFile = VendorFile::model()->findByPk($vendorFileId);
		$vendorFileload = $vendorFile->fileupload;
		$vendor = $vendorFile->vendor;

		$data = [];

		$data[] = [
			'Brand Name', 
			'SKU', 
			'MPN',
			'MSRP', 
			'Cost', 
			'SBB Price', 
			'Description',
			// 'QB Description',
			'GTIN',
			'Width',
			'Length',
			'Height',
			'Weight',
			'Quantity',
			'SBB Status',
			'GSS Status',
			//'Status',
			'Same Length Description on Spreadsheet',
			'Re-enabled or Relisted'
		];

		$vendorNormalisedQuery = '
			SELECT * FROM {{vendor_normalized_info}} AS vni
			INNER JOIN {{vendor_normalized}} AS vn ON vni.vendor_normalized_id = vn.id
			WHERE vn.vendor_fileupload_id = '. (int) $vendorFile->id .'
			
			AND vn.status in (
				'. VendorNormalized::STATUS_FOR_REVIEW .',
				'. VendorNormalized::STATUS_PUSHING .',
				'. VendorNormalized::STATUS_PUSHED .',
				'. VendorNormalized::STATUS_ERROR .',
				'. VendorNormalized::STATUS_ERROR_PUSHING .',
				'. VendorNormalized::STATUS_DELETED .',
				'. VendorNormalized::STATUS_ERROR_VALIDATION .')
			ORDER BY vn.status, vni.mpn ASC
		';

		$vendorNormalisedCommand = Yii::app()->db->createCommand($vendorNormalisedQuery);
		$vendorNormalisedData = $vendorNormalisedCommand->queryAll();
		//Dev::pvx($vendorNormalisedData);
		foreach ($vendorNormalisedData as $vendorNormalisedDataValue) {
			if ($vendorNormalisedDataValue['product_status'] == VendorNormalized::PRODUCT_STATUS_NEW) {
				$statusLabel = 'New';
			} else if ($vendorNormalisedDataValue['product_status'] == VendorNormalized::PRODUCT_STATUS_UPDATED) {
				$statusLabel = 'Updated';
			} else {
				$statusLabel = 'Remain';
			}
			$sbbStatus = ($vendorNormalisedDataValue['product_status'] != VendorNormalized::PRODUCT_STATUS_EOL) ? VendorNormalized::getPlatformStatusLabel($vendorNormalisedDataValue['platform_1_rest_status'], '') : VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EOL, '');
			$sbbImageStatus = ($vendorNormalisedDataValue['platform_1_image_status'] == VendorNormalized::IMAGE_STATUS_MISSING ? 'Missing' : 'Exist');
			$gssStatus = ($vendorNormalisedDataValue['product_status'] != VendorNormalized::PRODUCT_STATUS_EOL) ? VendorNormalized::getPlatformStatusLabel($vendorNormalisedDataValue['platform_2_rest_status'], '') : VendorNormalized::getPlatformStatusLabel(VendorNormalized::REST_STATUS_EOL, '');
			$gssImageStatus = ($vendorNormalisedDataValue['platform_2_image_status'] == VendorNormalized::IMAGE_STATUS_MISSING ? 'Missing' : 'Exist');
			$descriptionSpreadsheet = (trim(strip_tags($vendorNormalisedDataValue['description'])) == trim($vendorNormalisedDataValue['qb_description']) ? 'True' : 'False');
			$relisted = ($vendorNormalisedDataValue['product_from'] == VendorNormalized::PRODUCT_FROM_WEBSITE) ? 'True' : 'False';

			$data[] = [
				$vendorNormalisedDataValue['brand_name'], // Brand Name 
				$vendorNormalisedDataValue['sku'], // SKU
				$vendorNormalisedDataValue['mpn'], // MPN
				ZCommon::formatWithDecimal($vendorNormalisedDataValue['msrp']), // MSRP 
				ZCommon::formatWithDecimal($vendorNormalisedDataValue['cost']), // Cost 
				ZCommon::formatWithDecimal($vendorNormalisedDataValue['price_sbb']), // SBB Price 
				strip_tags($vendorNormalisedDataValue['description']), // Description
				// strip_tags($vendorNormalisedDataValue['qb_description']), // QB Description
				$vendorNormalisedDataValue['ean'], // GTIN
				$vendorNormalisedDataValue['width'], // Width
				$vendorNormalisedDataValue['length'], // Length
				$vendorNormalisedDataValue['height'], // Height
				$vendorNormalisedDataValue['weight'], // Weight
				$vendorNormalisedDataValue['quantity'], // Quantity
				//$statusLabel, // Status
				$sbbStatus,
				// $sbbImageStatus,
				$gssStatus,
				// $gssImageStatus,
				$descriptionSpreadsheet,
				$relisted
			];
		}
		//Dev::pvx($data);
		//Dev::pvx(count($vendorNormalisedData));

		$filename = $vendor->name;
		$filename .= '_' . $vendorFile->id;
		$filename .= '_' . date('Y_m_d_H_i_s', strtotime($vendorFileload->date_created));
		$filename .= '.csv';

		$f = fopen(LookUp::TEMP_FOLDER . "/" . $filename, "w");
		
		foreach ($data as $dataval) {
			fputcsv($f, $dataval);
		}
	
		header('Content-Encoding: UTF-8');
		header('Content-type: text/csv; charset=UTF-8');
		header('Content-Disposition: attachment; filename="'. $filename .'"');
		readfile(LookUp::TEMP_FOLDER . '/' . $filename);
	}

	public function actionSetProductsCheckStatus() {
		$affectedProducts = 0;

		$selectedProductIDs = !empty($_POST['normalize_data_ids']) ? $_POST['normalize_data_ids'] : [];

		foreach ($selectedProductIDs as $selectedProductID) {
			$product = VendorNormalized::model()->findByPk($selectedProductID);

			if ($_POST['product_check_id'] == VendorNormalized::PRODUCT_STATUS_NOT_CHECKED) {
				$product->product_status = VendorNormalized::productCheckStatus($product->vendorNormalizedInfo->attributes);
			} else {
				$product->product_status = $_POST['product_check_id'];
			}

			if ($product->save(false)) {
				$affectedProducts++;
			}
		}

		if ($affectedProducts > 0 ) {
			echo CJSON::encode([
				'status' => 'ok',
				'message' => 'Successfully updated products('. $affectedProducts .') to '. VendorNormalized::getProductStatusLabel($_POST['product_check_id']) .'.'
			]); exit;
		} else {
			echo CJSON::encode([
				'status' => 'error',
				'message' => 'Unable to update selected products.'
			]); exit;
		}
	}

	public function actionGetParsedDataGssPricing($parsedId) 
	{
		$this->layout = 'none';

		$parsedData = VendorNormalized::model()->findByPk($parsedId);

		if (!$parsedData) {
			throw new CHttpException(403, 'Invalid data, Parsed data is not exists.');
		}

		$productLevels = NormalizedPricingTierLookup::model()->findAll([
			'condition' => 'status = :status and parsed_id = :parsed_id',
			'params' => [
				':status' => NormalizedPricingTierLookup::STATUS_ACTIVE,
				':parsed_id' => $parsedData->id
			]
		]);

		$this->render('getParsedDataGssPricing', [
			'productLevels' => $productLevels
		]);
	}

	public function actionCronStatusCheck(){

		$startDatetime = new DateTime();
		Dev::pv($startDatetime->format("%H:%I:%S"));

		$maxSec = 30;
		$initSec = 0;
		$intervalSec = 1;

		// simulate second interval per minutes.
		for($ctr = $initSec; $ctr <= $maxSec; $ctr += $intervalSec) {

			//check if cron switch is on
			$cronState = Yii::app()->db->createCommand('SELECT `value`, `serialized_options` FROM gss_system_settings WHERE `key` = "woocommerceSyncCron"')->queryRow();
			// If nothing to process
			if( $cronState['value'] == 0 ) exit('CRON IS OFF'); 
			//get new published vendor
			$syncingVendorFiles = VendorFile::model()->findAll(array(
				'condition' => 'sync_status = :sync_status and status = :status',
				'params' => array(
					':sync_status' => VendorFile::SYNC_STATUS_SYNCING,
					':status' => VendorFile::STATUS_FOR_REVIEW
				),
				'limit' => 1
			));

			if(empty($syncingVendorFiles)){
				echo 'No vendor files with for syncing status.'; exit;
			}

			try{

				foreach($syncingVendorFiles as $syncingVendorFile){
						
						//get categories product on both woocommerce
						$pageArr = unserialize($cronState['serialized_options']);
						if(!isset($pageArr['page'][$syncingVendorFile->id])){
							$pageArr['page'] = array(
								$syncingVendorFile->id => 1,
							);
						}
						$products = Product::apisBatchSyncProduct($syncingVendorFile->vendor_id, $pageArr['page'][$syncingVendorFile->id]);
						if(empty($products['gssProducts']) && empty($products['sbbProducts'])){
							//Update all the pending data
							$queryNormalized = 'UPDATE {{vendor_normalized}} set status = '.VendorNormalized::STATUS_FOR_REVIEW.', platform_1_rest_status = '.VendorNormalized::REST_STATUS_NEW.', platform_2_rest_status = '.VendorNormalized::REST_STATUS_NEW.' WHERE vendor_fileupload_id = '.$syncingVendorFile->id.' AND status = '.VendorNormalized::STATUS_PENDING;
							Yii::app()->db->createCommand($queryNormalized)->execute();
		
							$queryNormalized2 = 'UPDATE {{vendor_normalized}} set platform_1_rest_status = '.VendorNormalized::REST_STATUS_NEW.', platform_2_rest_status = '.VendorNormalized::REST_STATUS_NEW.' WHERE vendor_fileupload_id = '.$syncingVendorFile->id.' AND status != '.VendorNormalized::STATUS_FOR_REVIEW.' and status != '.VendorNormalized::STATUS_DELETED;
							Yii::app()->db->createCommand($queryNormalized2)->execute();
							
							//change sync status of vendorfile 
							$syncingVendorFile->setSyncStatusSynced();
							unset($pageArr['page'][$syncingVendorFile->id]);
							Yii::app()->db->createCommand()->update('gss_system_settings', array(
									'serialized_options' => serialize($pageArr),
								), '`key` = "woocommerceSyncCron"');
							echo 'All product synced';
							exit;
						}
						else{
							$pageArr['page'][$syncingVendorFile->id] = $pageArr['page'][$syncingVendorFile->id] + 1;
							Yii::app()->db->createCommand()->update('gss_system_settings', array(
									'serialized_options' => serialize($pageArr),
								), '`key` = "woocommerceSyncCron"');
						}
		
						if(!empty($products['gssProducts'])){
							//syncing gss products
							foreach ($products['gssProducts'] as $gssProduct) {
								$platformIds['platform_1_id'] = '';
								$platformIds['platform_2_id'] = $gssProduct->id;
								$platform = 'gss';
								$syncProducts[] = $syncingVendorFile->normalizedSyncingData($gssProduct, $platformIds,$platform);
					
							}
						}
						if(!empty($products['sbbProducts'])){
							//syncing sbb products
							foreach ($products['sbbProducts'] as $sbbProduct) {
								$platformIds['platform_1_id'] = $sbbProduct->id;
								$platformIds['platform_2_id'] = '';
								$platform = 'sbb';
								$syncProducts[] = $syncingVendorFile->normalizedSyncingData($sbbProduct, $platformIds, $platform);
							}
						}
						if(isset($error) && !empty($error)){
							$pageArr['page'][$syncingVendorFile->id] = $pageArr['page'][$syncingVendorFile->id] - 1;
							Yii::app()->db->createCommand()->update('gss_system_settings', array(
									'serialized_options' => serialize($pageArr),
								), '`key` = "woocommerceSyncCron"');
		
							Dev::pvx($error);
						}
						



				}

			} catch (Exception $e) {
				Dev::pvx($e);
			}

			sleep($intervalSec); // pause processing for 1 sec

		}

		$endDatetime = new DateTime();
		Dev::pv($endDatetime->format("%H:%I:%S"));

		$dteDiff  = $startDatetime->diff($endDatetime); 

		Dev::pv($dteDiff->format("%H:%I:%S"));
	}

	public function getProgressDataStatus($id){
		$vendorFile = VendorFile::model()->find(array(
            'condition' => 'id = :id',
            'params' => array(
                ':id' => $id,
            )
        ));

        if($vendorFile){
        	$response['totalPending'] = count(VendorNormalized::getPendingData($vendorFile->id));
        	$response['totalDone'] = count(VendorNormalized::getForReviewData($vendorFile->id));
        	$response['totalProduct'] = count(VendorNormalized::getVendorData($vendorFile->id));
        	$response['status'] = $vendorFile->sync_status;
        }else{
        	$response['status'] = 3;
        }
			echo CJSON::encode($response); exit;
	}
}