<?php

class PricingGroupController extends Controller
{
	public $layout = 'dashboard';
	public $activeSideNav = array('manage_pricing_group');
	public $pageTitle = 'Pricing Group';

	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	public function accessRules()
	{
		return array(
			array(
				'allow',
				'actions' => array('test', 'activate', 'deactivate', 'delete', 'view', 'create', 'update', 'tier', 'activateTier', 'deactivateTier', 'deleteTier', 'index', 'GetPricingGroupPricingTier', 'removetierajax', 'customWPRole'),
				'users' => array('@'),
			),
			array(
				'allow',
				'actions' => array('login', 'error'),
				'users' => array('*'),
			),
			array(
				'deny',
				'users' => array('*'),
			),
		);
	}

	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha' => array(
				'class' => 'CCaptchaAction',
				'backColor' => 0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page' => array(
				'class' => 'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		$pricingGroup = PricingGroup::model()->existing()->findAll(['order' => 'id DESC']);

		$pricingGroupDataProvider = new CArrayDataProvider($pricingGroup, array(
			'pagination' => array(
				'pageSize' => 10,
			)
		));

		$this->render('index', array(
			'pricingGroupDataProvider' => $pricingGroupDataProvider,
		));
	}

	public function actionCreate()
	{
		$pricingGroup = new PricingGroup;
		$vendors = Vendor::model()->findAll();

		if (isset($_POST['PricingGroup'])) {
			$tierNames = $_POST['tierName'];

			$connection = Yii::app()->db;
			$transaction = $connection->beginTransaction();

			//insert new pricing group
			$pricingGroup->attributes = $_POST['PricingGroup'];
			
			$message = '<p>Please fixed following errors:<p><ul>';

			if ($pricingGroup->validate()) {
				if ($pricingGroup->save(false)) {
					if(!empty($tierNames))	{
						$err = false;
						foreach ($tierNames as $key => $tierName) {
							//insert pricing tier description
							$tierDescription = new PricingTierDescription;
							$tierDescription->group_id = $pricingGroup->id;
							$tierDescription->tier_name = $tierName;
							$tierDescription->description = $_POST['description'][$key];
							$tierDescription->pricing_tier_wp_role_id = $_POST['wpRole'][$key];

							if($tierDescription->validate()){
								if($tierDescription->save(false)){
									foreach ($vendors as $vendor) {
										//insert new pricing tier
										$pricingTier = new PricingTier;
										$pricingTier->group_id = $pricingGroup->id;
										$pricingTier->desc_id = $tierDescription->id;
										$pricingTier->vendor_id = $vendor->id;
										$pricingTier->cost_markup = $_POST['markUp'][$vendor->id][$key] ?: 0;
										$pricingTier->msrp_markdown = $_POST['markDown'][$vendor->id][$key] ?: 0;
										$pricingTier->default_type = $_POST['priceType'][$vendor->id][$key];

										if($pricingTier->validate()){
											if(!$pricingTier->save(false)){
												$err = true;
											}
										}
										else{
											$err = true;
											//Getting error of pricing tier
											foreach ($pricingTier->getErrors() as $errors){
												foreach ($errors as $error) {
													$message .= '<li>' . $error . '</li>';
												}
											}

											Yii::app()->user->setFlash('danger', $message);
										}
									}
								}
								else{
									$err = true;
									$transaction->rollback();
									Yii::app()->user->setFlash('danger', 'Pricing Group failed to create.');
								}
							}
							else{
								$err = true;
								//Getting error of pricing tier description
								$transaction->rollback();
								foreach ($tierDescription->getErrors() as $errors) {
									foreach ($errors as $error) {
										$message .= '<li>' . $error . '</li>';
									}
								}

								Yii::app()->user->setFlash('danger', $message);
							}
						}
						if(!$err){
							$transaction->commit();
							Yii::app()->user->setFlash('success', 'Pricing Group Successfully created.');
							$this->redirect(['pricingGroup/view/'.$pricingGroup->id]);
						}
						else{
							$transaction->rollback();
							Yii::app()->user->setFlash('danger', 'Pricing Group failed to create.');
						}
					}
				} 
				else {
					$transaction->rollback();
					Yii::app()->user->setFlash('danger', 'Pricing Group failed to create.');
				}
			}
			else {
				//Getting error of pricing group

				foreach ($pricingGroup->getErrors() as $errors) {
					foreach ($errors as $error) {
						$message .= '<li>' . $error . '</li>';
					}
				}

				Yii::app()->user->setFlash('danger', $message);
			}

		}

		//passing empty/new tier and description
		$pricingTiers = new PricingTier;
		$pricingTierDescriptions = new PricingTierDescription;
		$action = 'create';
		$this->render('pricingGroupForm', array(
			'pricingGroup' => $pricingGroup,
			'pricingTiers' => $pricingTiers,
			'pricingTierDescriptions' => $pricingTierDescriptions,
			'vendors' => $vendors,
			'action' => $action,
		));
	}

	public function actionUpdate($id)
	{
		$pricingGroup = PricingGroup::model()->findByPk($id);
		if(!empty($pricingGroup)){
			$vendors = Vendor::model()->findAll();

			if (isset($_POST['PricingGroup'])){
				$message = '<p>Please fixed following errors:<p><ul>';
				$connection = Yii::app()->db;
				$transaction = $connection->beginTransaction();
				$pricingGroup->attributes = $_POST['PricingGroup'];
				//$this->dd($_POST['tierName']);
				if ($pricingGroup->validate()) {
					if ($pricingGroup->save(false)) {
						//flag for error
						$err = false;
						//foreach ($pricingTierDescriptions as $pricingTierDescription) 
						foreach ($_POST['tierName'] as $key => $tierName){
							$desc_id = $key;
							$tierDescription = PricingTierDescription::model()->existing()->find(array(
								'condition' => 'id = '.$desc_id.' AND group_id = '.$pricingGroup->id,
							));
							if(empty($tierDescription)){
								$tierDescription = new PricingTierDescription;
								$tierDescription->group_id = $pricingGroup->id;
							}
							else{
								$tierDescription->status = $_POST['tierStatus'][$desc_id];
							}
							$tierDescription->tier_name = $tierName;
							$tierDescription->description = $_POST['description'][$desc_id];
							$tierDescription->pricing_tier_wp_role_id = $_POST['wpRole'][$desc_id];
							if($tierDescription->validate()){
								if($tierDescription->save(false)){
									foreach ($vendors as $vendor) {
										//flag for checking if the pricing tier is update or not
										$update = true;
										$pricingTier = PricingTier::model()->find(array(
											'condition' => 'vendor_id = '.$vendor->id.' and desc_id = '.$tierDescription->id.' and group_id = '.$pricingGroup->id,
										));
										if(empty($pricingTier)){
											$update = false;
											$pricingTier = New PricingTier;
											$pricingTier->group_id = $pricingGroup->id;
											$pricingTier->desc_id = $tierDescription->id;
											$pricingTier->vendor_id = $vendor->id;
										}
										else
										{
											$pricingTier->status = $_POST['tierStatus'][$desc_id];
										}
										$pricingTier->cost_markup = $_POST['markUp'][$vendor->id][$desc_id];
										$pricingTier->msrp_markdown = $_POST['markDown'][$vendor->id][$desc_id];
										$pricingTier->default_type = $_POST['priceType'][$vendor->id][$desc_id];

										if($pricingTier->validate()){
											if($pricingTier->save(false)){
												if($update)	{
													//update product pricing tier when pricing tier is just update
													$productData = ProductPricingTierLookup::model()->findAllByAttributes(array(
														'pricing_tier_id' => $pricingTier->id, 'status' => 1
													));
														
													foreach ($productData as $product) 
													{
														$product->cost_markup_computed = $product->product->productInfo->cost / (1 - ($pricingTier->cost_markup / 100));
														$product->msrp_markdown_computed = $product->product->productInfo->msrp * (1 - ($pricingTier->msrp_markdown / 100));
														$product->status = $pricingTier->status;
														
														// Set the wc status to pending so that it will be pushed back to wc.
														$product->woocommerce_status = ProductPricingTierLookup::WC_STATUS_PENDING;
														
														if(!$product->save(false))
														{
															$err = true;
															$message .= '<li>Failed to save product pricing tier</li>';

														}
													}
												}
												else{
													//creating new product pricing tier look up if pricing tier is new
													$groupProductPricingTierLookup = ProductPricingTierLookup::model()->with(array(
														'product' => array(
															'with' => 'productInfo',
															'alias' => 'p',
															'condition' => 'p.vendor_id = :vendor_id and p.status <> :p_status',
															'params' => array(
																':vendor_id' => $vendor->id,
																':p_status' => Product::STATUS_DELETED,
															)
														)
													))->findAll(array(
														'alias' => 'pptl',
														'condition' => 'pptl.status = :status and pptl.group_id = :group_id',
														'params' => array(
															':status' => 1,
															':group_id' => $pricingTier->group_id,
														),
														'group' => 'p.id'
													));
													//$transaction->rollback();
													if (count($groupProductPricingTierLookup) > 0) {
														foreach ($groupProductPricingTierLookup as $pptl) {
															$productPrice = new ProductPricingTierLookup;
															$productPrice->product_id = $pptl->product_id;
															$productPrice->selected_price_type = $pricingTier->default_type;
															$productPrice->cost_markup_computed = $pptl->product->productInfo->cost / (1 - ($pricingTier->cost_markup / 100));
															$productPrice->msrp_markdown_computed = $pptl->product->productInfo->msrp * (1 - ($pricingTier->msrp_markdown / 100));
															$productPrice->pricing_tier_id = $pricingTier->id;
															$productPrice->group_id = $pricingTier->group_id;
															if(!$productPrice->save(false))	{
																$err = true;
																$message .= '<li>Failed to save product pricing tier</li>';

															}
														}
													}
												}
											}
										}
										else{
											$err = true;

											foreach ($pricingTier->getErrors() as $errors) {
												foreach ($errors as $error) {
													$message .= '<li>' . $error . '</li>';
												}
											}

											Yii::app()->user->setFlash('danger', $message);
										}
									}
								}
								else{
									$err = true;
									$message .= '<li>Failed to save pricing tier description</li>';
								}
							}
							else{
								$err = true;
								//get the error
								foreach ($tierDescription->getErrors() as $errors) {
									foreach ($errors as $error) {
										$message .= '<li>' . $error . '</li>';
									}
								}

								Yii::app()->user->setFlash('danger', $message);
							}
						}
						//if all the query are success
						if(!$err){
							//commit the query
							$transaction->commit();
							Yii::app()->user->setFlash('success', 'Pricing Group Successfully updated.');
							$this->redirect(['pricingGroup/view/'.$pricingGroup->id]);
						}
						//error occured on foreach
						else{
							//rollback query
							$transaction->rollback();
							Yii::app()->user->setFlash('danger', $message);
						}
					}
					else {
						//rollback the query
						$transaction->rollback();
						Yii::app()->user->setFlash('danger', 'Pricing Group failed to update.');
					}
				}
				else {
					//getting the error msg
					foreach ($pricingGroup->getErrors() as $errors) {
						foreach ($errors as $error) {
							$message .= '<li>' . $error . '</li>';
						}
					}
					//rollback the query
					$transaction->rollback();

					Yii::app()->user->setFlash('danger', $message);
				}
			}

			//$pricingTiers = $pricingTierDescriptions = array();
			$pricingTierDescriptions = PricingTierDescription::model()->existing()->findAll(array(
				'condition' => 'group_id = '.$pricingGroup->id,
			));
			
			//$this->dd($pricingTierDescriptions);
			foreach ($pricingTierDescriptions as $pricingTierDescription){
				foreach ($vendors as $vendor){
					$_pricingTier = PricingTier::model()->find(array(
						'condition' => 'group_id = '.$pricingGroup->id.' and vendor_id = '.$vendor->id.' and desc_id = '.$pricingTierDescription->id,
					));
					if(!empty($_pricingTier))
				    	$pricingTiers[$pricingTierDescription->id][$vendor->id] = $_pricingTier;
				    else{
				    	$pricingTiers[$pricingTierDescription->id][$vendor->id] = $_pricingTier;
				    }
				}
			}
			//Dev::pvx($pricingTiers);
			$action = 'update';
			$this->render('pricingGroupForm', array(
				'pricingGroup' => $pricingGroup,
				'pricingTiers' => $pricingTiers,
				'pricingTierDescriptions' => $pricingTierDescriptions,
				'vendors' => $vendors,
				'action' => $action,
			));
		}
		else{
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionCustomWPRole()
	{
		if($_POST['roleKey'] != '' && $_POST['roleName'] != ''){
			$role = $_POST;
			if($role['action'] == 'validate')
			{
				$wpRolesAPI = WordPressUserRoleAPI::getRoleData();
				if($wpRolesAPI){
					$wpRoles = json_decode($wpRolesAPI, true);
					//if($wpRoles != ''){
						$wpRolesKey = array_change_key_case($wpRoles, CASE_LOWER);
					//}
					//Dev::pvx($wpRoles);
					$data['key'] = false;
					$data['name'] = false;
					//if($wpRoles != ''){
						if(array_key_exists(strtolower($role['roleKey']), $wpRolesKey)){
							$data['key'] = true;
						}
					//}
					//flag for checking if role name is exist
					$name_exist = false;
					//if($wpRoles != ''){
						foreach ($wpRoles as $wpRole) {
							if(strtolower($role['roleName']) == strtolower($wpRole['name'])){
								$name_exist = true;
							}
						}
					//}
					if($name_exist){
						$data['name'] = true;
					}
				}else{
					$data['message'] = 'error';
				}
			}
			if($role['action'] == 'save'){
				//Dev::pvx();
				$data = array();
				$connection = Yii::app()->db;
				$transaction = $connection->beginTransaction();

				$pricingTierWpRole = new PricingTierWpRole;
				$pricingTierWpRole->key = strtolower($role['roleKey']);
				$pricingTierWpRole->label = $role['roleName'];
				if($pricingTierWpRole->validate()){
					if($pricingTierWpRole->save(false)){
						$data['wpRoleLabel'] = $pricingTierWpRole->label;
						$data['wpRoleId'] = $pricingTierWpRole->id;
						$data['wpRoleKey'] = $pricingTierWpRole->key;
						//passing data to api model
						$insertNewRole = WordPressUserRoleAPI::insertNewRole($data);
						//Dev::pvx($insertNewRole);
						if(!$insertNewRole){
							$data = '';
							$data['message'] = 'error';
							$transaction->rollback();
						}
						else{
							$transaction->commit();
						}
					}
					else{
						$data['message'] = 'error';
					}
				}
				else{
					$message = '<p>Please fixed following errors:<p>';
					foreach ($pricingGroup->getErrors() as $errors) {
						foreach ($errors as $error) {
							$message .= '<li>' . $error . '</li>';
						}
					}
					$data['message'] = $message;
				}
			}
		}
		else{
			$data['message'] = 'Please fill the role name and key';
		}
		echo json_encode($data);
	}

	public function actionRemoveTierAjax()
	{
		$id = $_POST['id'];
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingTierDescription = PricingTierDescription::model()->findByPK($id);
		if(!empty($pricingTierDescription)){
			$pricingTierDescription->status = PricingTierDescription::STATUS_DELETED;
			if($pricingTierDescription->validate()){
				$err = false;
				if($pricingTierDescription->save(false)){
					$pricingTiers = PricingTier::model()->findAll(array(
						'condition' => 'desc_id = '.$pricingTierDescription->id
					));

					foreach ($pricingTiers as $pricingTier){
						$pricingTierUpdate = PricingTier::model()->findByPK($pricingTier->id);
						$pricingTierUpdate->status = PricingTier::STATUS_DELETED;

						if($pricingTierUpdate->save(false)){
							ProductPricingTierLookup::model()->updateAll(
								[
									'status' => PricingTierDescription::STATUS_DELETED
								],
								'pricing_tier_id = ' . $id
							);
						}
						else{
							$err = true;
						}
					}
					if(!$err){
						$transaction->commit();
						echo 'Success';
					}
					else{
						$transaction->rollback();
						echo 'Failed';
					}
				}
				else{
					echo 'Failed';
				}
			}
			else{
				echo 'Failed';
			}
			
		}
		Yii::app()->end();
	}

	public function actionView($id)
	{
		$pricingGroup = PricingGroup::model()->existing()->findByPK($id);

		if (!empty($pricingGroup)) {
			$pricingTierDescription = PricingTierDescription::model()->existing()->with(array(
				'pricingTier' => array(
					'with' => 'vendor',
				)
			))->findAllByAttributes(array(
				'group_id' => $pricingGroup->id,
			));

			//$this->dd($pricingTierDescription);

			$pricingTierDataProvider = new CArrayDataProvider($pricingTierDescription, array(
				'pagination' => array(
					'pageSize' => 6,
				)
			));

			$this->render('view', array(
				'pricingGroup' => $pricingGroup,
				'pricingTierDataProvider' => $pricingTierDataProvider,
			));
		} else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionActivate($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingGroup = PricingGroup::model()->findByPK($id);

		if (!empty($pricingGroup)) {
			$pricingGroup->status = PricingGroup::STATUS_ACTIVE;

			if ($pricingGroup->save(false)) {
				PricingTierDescription::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_ACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_INACTIVE
				);

				PricingTier::model()->updateAll(
					[
						'status' => PricingTier::STATUS_ACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTier::STATUS_INACTIVE
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_ACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_INACTIVE
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_ACTIVE .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_DEACTIVATED
				);

				$transaction->commit();
				Yii::app()->user->setFlash('success', 'Pricing Group Successfully activated.');
				$this->redirect(['pricingGroup/']);
			} else {
				Yii::app()->user->setFlash('danger', 'Pricing Group failed to activate.');
			}
		} else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionDeactivate($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingGroup = PricingGroup::model()->findByPK($id);

		if (!empty($pricingGroup)) {
			$pricingGroup->status = PricingGroup::STATUS_INACTIVE;

			if ($pricingGroup->save(false)) {
				PricingTierDescription::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_INACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_ACTIVE
				);

				PricingTier::model()->updateAll(
					[
						'status' => PricingTier::STATUS_INACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTier::STATUS_ACTIVE
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_INACTIVE
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_ACTIVE
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_INACTIVE .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_SUCCESS
				);

				$transaction->commit();
				Yii::app()->user->setFlash('success', 'Pricing Group Successfully deactivated.');
				$this->redirect(['pricingGroup/']);
			} else {
				Yii::app()->user->setFlash('danger', 'Pricing Group failed to deactivate.');
			}
		} else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionDelete($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingGroup = PricingGroup::model()->findByPK($id);

		if (!empty($pricingGroup)) {
			$pricingGroup->status = PricingGroup::STATUS_DELETED;

			if ($pricingGroup->save(false)) {
				PricingTierDescription::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_DELETED
					],
					'group_id = ' . $id
				);

				PricingTier::model()->updateAll(
					[
						'status' => PricingTier::STATUS_DELETED
					],
					'group_id = ' . $id
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'status' => PricingTierDescription::STATUS_DELETED
					],
					'group_id = ' . $id
				);

				ProductPricingTierLookup::model()->updateAll(
					[
						'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
					],
					'group_id = ' . $id . ' AND status = ' . PricingTierDescription::STATUS_DELETED .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_SUCCESS
				);

				$transaction->commit();
				Yii::app()->user->setFlash('success', 'Pricing Group Successfully deleted.');
				$this->redirect(['pricingGroup/']);
			} else {
				Yii::app()->user->setFlash('danger', 'Pricing Group failed to delete.');
			}
		} else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	// Pricing Tier
	public function actionTier($action = 'create', $id = null, $group = null)
	{
		
		$vendors = Vendor::model()->findAll();

		if ($action === 'create' && $group != null) {

			$pricingGroup = PricingGroup::model()->existing()->findByPK($group);
			//for form value only.
			$pricingTierDescriptions = new PricingTierDescription;
			$pricingTiers = new PricingTier;

			if (isset($_POST['tierName'])) {
				$tierNames = $_POST['tierName'];
				$connection = Yii::app()->db;
				$transaction = $connection->beginTransaction();

				//flag error
				$err = false;
				foreach ($tierNames as $key => $tierName) 
				{
					//insert pricing tier description
					$tierDescription = new PricingTierDescription;
					$tierDescription->group_id = $group;
					$tierDescription->tier_name = $tierName;
					$tierDescription->description = $_POST['description'][$key];
					$tierDescription->pricing_tier_wp_role_id = $_POST['wpRole'][$key];

					if($tierDescription->validate()){
						if($tierDescription->save(false)){
							foreach ($vendors as $vendor) {
								//insert new pricing tier
								$pricingTier = new PricingTier;
								$pricingTier->group_id = $group;
								$pricingTier->desc_id = $tierDescription->id;
								$pricingTier->vendor_id = $vendor->id;
								$pricingTier->cost_markup = $_POST['markUp'][$vendor->id][$key] ?: 0;
								$pricingTier->msrp_markdown = $_POST['markDown'][$vendor->id][$key] ?: 0;
								$pricingTier->default_type = $_POST['priceType'][$vendor->id][$key];

								if($pricingTier->validate()){
									if($pricingTier->save(false)){
										$groupProductPricingTierLookup = ProductPricingTierLookup::model()->with(array(
											'product' => array(
												'with' => 'productInfo',
												'alias' => 'p',
												'condition' => 'p.vendor_id = :vendor_id and p.status <> :p_status',
												'params' => array(
													':vendor_id' => $vendor->id,
													':p_status' => Product::STATUS_DELETED,
												)
											)
										))->findAll(array(
											'alias' => 'pptl',
											'condition' => 'pptl.status = :status and pptl.group_id = :group_id',
											'params' => array(
												':status' => 1,
												':group_id' => $group,
											),
											'group' => 'p.id'
										));

										if (count($groupProductPricingTierLookup) > 0) {
											foreach ($groupProductPricingTierLookup as $pptl) {
												$productPrice = new ProductPricingTierLookup;
												$productPrice->product_id = $pptl->product_id;
												$productPrice->selected_price_type = $pricingTier->default_type;
												$productPrice->cost_markup_computed = $pptl->product->productInfo->cost / (1 - ($pricingTier->cost_markup / 100));
												$productPrice->msrp_markdown_computed = $pptl->product->productInfo->msrp * (1 - ($pricingTier->msrp_markdown / 100));
												$productPrice->pricing_tier_id = $pricingTier->id;
												$productPrice->group_id = $group;
												if(!$productPrice->save(false))
												{
													$err = true;
												}
											}
										}
									}
									else{
										$err = true;										
									}
								}
								else{
									$err = true;
									//Getting error of pricing tier
									foreach ($pricingTier->getErrors() as $errors) {
										foreach ($errors as $error) {
											$message .= '<li>' . $error . '</li>';
										}
									}

									Yii::app()->user->setFlash('danger', $message);
								}
							}
						}
						else{
							$err = true;
						}
					}
					else{
						$err = true;
						//Getting error of pricing tier description
						foreach ($tierDescription->getErrors() as $errors) {
							foreach ($errors as $error) {
								$message .= '<li>' . $error . '</li>';
							}
						}

						Yii::app()->user->setFlash('danger', $message);
					}
				}
				if(!$err){
					$transaction->commit();
					Yii::app()->user->setFlash('success', 'Pricing Tier Successfully created.');
					$this->redirect(['pricingGroup/view/' . $group]);
				}
				else{
					$transaction->rollback();
					Yii::app()->user->setFlash('danger', 'Pricing Tier failed to create.');
				}
			}
		}
		else if ($action === 'update' && $id != null) {
			$pricingTierDescriptions = PricingTierDescription::model()->findByPK($id);
			$pricingGroup = $pricingTierDescriptions->group;
			//passing pricing tiers variable
			foreach ($vendors as $vendor){
				$_pricingTier = PricingTier::model()->find(array(
					'condition' => 'group_id = '. $pricingTierDescriptions->group_id .' and vendor_id = '.$vendor->id.' and desc_id = '.$pricingTierDescriptions->id,
				));

			    $pricingTiers[$pricingTierDescriptions->id][$vendor->id] = $_pricingTier;
			}

			if (isset($_POST['tierName'])) {

				$connection = Yii::app()->db;
				$transaction = $connection->beginTransaction();

				$pricingTierDescriptions->tier_name = $_POST['tierName'][$pricingTierDescriptions->id];
				$pricingTierDescriptions->description = $_POST['description'][$pricingTierDescriptions->id];
				$pricingTierDescriptions->pricing_tier_wp_role_id = $_POST['wpRole'][$pricingTierDescriptions->id];
				$pricingTierDescriptions->status = $_POST['tierStatus'][$pricingTierDescriptions->id];

				if ($pricingTierDescriptions->validate()) {
					if ($pricingTierDescriptions->save(false)) {
						//update pricing tier
						foreach ($vendors as $vendor) {
							$pricingTier = PricingTier::model()->find(array(
								'condition' => 'vendor_id = '.$vendor->id.' and desc_id = '.$pricingTierDescriptions->id.' and group_id = '.$pricingTierDescriptions->group_id,
							));
							$pricingTier->cost_markup = $_POST['markUp'][$vendor->id][$pricingTierDescriptions->id];
							$pricingTier->msrp_markdown = $_POST['markDown'][$vendor->id][$pricingTierDescriptions->id];
							$pricingTier->default_type = $_POST['priceType'][$vendor->id][$pricingTierDescriptions->id];
							$pricingTier->status = $_POST['tierStatus'][$pricingTierDescriptions->id];

							if($pricingTier->validate()){
								if($pricingTier->save(false)){
									//update prroduct pricing tier lookup based on pricing tier id
									$productData = ProductPricingTierLookup::model()->findAllByAttributes(array(
										'pricing_tier_id' => $pricingTier->id, 'status' => 1
									));

									foreach ($productData as $product) {
										$product->cost_markup_computed = $product->product->productInfo->cost / (1 - ($pricingTier->cost_markup / 100));
										$product->msrp_markdown_computed = $product->product->productInfo->msrp * (1 - ($pricingTier->msrp_markdown / 100));
										$product->selected_price_type = $pricingTier->default_type;
										
										// Set the wc status to pending so that it will be pushed back to wc.
										$product->woocommerce_status = ProductPricingTierLookup::WC_STATUS_PENDING;
										$product->save(false);
									}
								}
							}
							else{
								$message = '<p>Please fixed following errors:<p><ul>';

								foreach ($pricingTier->getErrors() as $errors) {
									foreach ($errors as $error) {
										$message .= '<li>' . $error . '</li>';
									}
								}

								Yii::app()->user->setFlash('danger', $message);
							}							
						}

						$transaction->commit();
						Yii::app()->user->setFlash('success', 'Pricing Tier Successfully updated.');
						$this->redirect(['pricingGroup/view/' . $pricingTier->group_id]);
					} else {
						Yii::app()->user->setFlash('danger', 'Pricing Tier failed to save.');
					}
				} else {
					$message = '<p>Please fixed following errors:<p><ul>';

					foreach ($pricingTier->getErrors() as $errors) {
						foreach ($errors as $error) {
							$message .= '<li>' . $error . '</li>';
						}
					}

					Yii::app()->user->setFlash('danger', $message);
				}
			}
		} else {
			throw new CHttpException(403, 'Invalid request.');
		}

		$pricingTierWPRoleModels = PricingTierWpRole::model()->active()->findAll();
		$pricingTierWPRoleOptions = array();
		foreach($pricingTierWPRoleModels as $pricingTierWPRoleModel){
			$pricingTierWPRoleOptions[$pricingTierWPRoleModel->id] = $pricingTierWPRoleModel->label;
		}

		$this->render('pricingTierForm', array(
			//'pricingTierWPRoleOptions' => $pricingTierWPRoleOptions,
			'pricingGroup' => $pricingGroup,
			'pricingTiers' => $pricingTiers,
			'pricingTierDescriptions' => $pricingTierDescriptions,
			'vendors' => $vendors,
			'action' => $action,
		));
	}

	public function actionActivateTier($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingTierDescription = PricingTierDescription::model()->findByPK($id);

		if ($pricingTierDescription && !empty($pricingTierDescription->group->status) && $pricingTierDescription->group->status == PricingGroup::STATUS_ACTIVE){
			$pricingTierDescription->status = PricingTierDescription::STATUS_ACTIVE;

			if ($pricingTierDescription->save(false)) {
				$err = false;
				$pricingTiers = PricingTier::model()->existing()->findAll(array(
					'condition' => 'desc_id = '.$pricingTierDescription->id
				));

				foreach ($pricingTiers as $pricingTier) {
					$pricingTierUpdate = PricingTier::model()->findByPK($pricingTier->id);
					$pricingTierUpdate->status = PricingTier::STATUS_ACTIVE;
					
					if($pricingTierUpdate->save(false))
					{
						ProductPricingTierLookup::model()->updateAll(
							[
								'status' => PricingTierDescription::STATUS_ACTIVE
							],
							'pricing_tier_id = ' . $pricingTier->id . ' AND status = ' . PricingTierDescription::STATUS_INACTIVE
						);

						ProductPricingTierLookup::model()->updateAll(
							[
								'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
							],
							'pricing_tier_id = ' . $pricingTier->id . ' AND status = ' . PricingTierDescription::STATUS_ACTIVE .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_DEACTIVATED
						);
					}
					else
					{
						$err = true;
					}
				}
				if(!$err)
				{
					$transaction->commit();
					Yii::app()->user->setFlash('success', 'Pricing Tier Successfully activated.');
					$this->redirect(['pricingGroup/view/' . $pricingTierDescription->group_id]);
				}
				else
				{
					$transaction->rollback;
					Yii::app()->user->setFlash('danger', 'Pricing Tier failed to activate.');
				}
			} 
			else 
			{
				Yii::app()->user->setFlash('danger', 'Pricing Tier failed to activate.');
			}
		} 
		else 
		{
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionDeactivateTier($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingTierDescription = PricingTierDescription::model()->existing()->findByPK($id);

		if (!empty($pricingTierDescription)) {
			$pricingTierDescription->status = PricingTierDescription::STATUS_INACTIVE;

			if ($pricingTierDescription->save(false)) {
				$err = false;
				$pricingTiers = PricingTier::model()->existing()->findAll(array(
					'condition' => 'desc_id = '.$pricingTierDescription->id
				));

				foreach ($pricingTiers as $pricingTier) {
					$pricingTierUpdate = PricingTier::model()->findByPK($pricingTier->id);
					$pricingTierUpdate->status = PricingTier::STATUS_INACTIVE;
					
					if($pricingTierUpdate->save(false))	{
						ProductPricingTierLookup::model()->updateAll(
							[
								'status' => ProductPricingTierLookup::STATUS_INACTIVE,
							],
							'pricing_tier_id = ' . $pricingTier->id . ' AND status = ' . PricingTierDescription::STATUS_ACTIVE
						);

						ProductPricingTierLookup::model()->updateAll(
							[
								'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
							],
							'pricing_tier_id = ' . $pricingTier->id . ' AND status = ' . PricingTierDescription::STATUS_INACTIVE .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_SUCCESS
						);
					}
					else{
						$err = true;
					}
				}

				if(!$err){
					$transaction->commit();
					Yii::app()->user->setFlash('success', 'Pricing Tier Successfully deactivated.');
					$this->redirect(['pricingGroup/view/' . $pricingTierDescription->group_id]);
				}
				else{
					$transaction->rollback();
					Yii::app()->user->setFlash('danger', 'Pricing Tier failed to activate.');
				}
			} 
			else {
				Yii::app()->user->setFlash('danger', 'Pricing Tier failed to deactivate.');
			}
		} 
		else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionDeleteTier($id)
	{
		$connection = Yii::app()->db;
		$transaction = $connection->beginTransaction();
		$pricingTierDescription = PricingTierDescription::model()->existing()->findByPK($id);

		if (!empty($pricingTierDescription)) {
			$pricingTierDescription->status = PricingTierDescription::STATUS_DELETED;

			if ($pricingTierDescription->save(false)) {
				$err = false;
				$pricingTiers = PricingTier::model()->existing()->findAll(array(
					'condition' => 'desc_id = '.$pricingTierDescription->id
				));

				foreach ($pricingTiers as $pricingTier) {
					$pricingTierUpdate = PricingTier::model()->findByPK($pricingTier->id);
					$pricingTierUpdate->status = PricingTier::STATUS_DELETED;
					
					if($pricingTierUpdate->save(false))	{
						ProductPricingTierLookup::model()->updateAll(
							[
								'status' => ProductPricingTierLookup::STATUS_DELETED,
							],
							'pricing_tier_id = ' . $pricingTier->id
						);

						ProductPricingTierLookup::model()->updateAll(
							[
								'woocommerce_status' => ProductPricingTierLookup::WC_STATUS_PENDING
							],
							'pricing_tier_id = ' . $pricingTier->id . ' AND status = ' . PricingTierDescription::STATUS_DELETED .' AND woocommerce_status = '.ProductPricingTierLookup::WC_STATUS_SUCCESS
						);
					}
					else{
						$err = true;
					}
				}

				if(!$err){
					$transaction->commit();
					Yii::app()->user->setFlash('success', 'Pricing Tier Successfully deleted.');
					$this->redirect(['pricingGroup/view/' . $pricingTierDescription->group_id]);
				}
				else{
					$transaction->rollback();
					Yii::app()->user->setFlash('danger', 'Pricing Tier failed to delete.');
				}
			} 
			else {
				Yii::app()->user->setFlash('danger', 'Pricing Tier failed to delete.');
			}
		} 
		else {
			throw new CHttpException(403, 'Invalid request.');
		}
	}

	public function actionGetPricingGroupPricingTier($id) {
		$this->layout = 'none';

		$pricingGroup = PricingGroup::model()->active()->findByPK($id);

		if ($pricingGroup) {
			$pricingTierDescription = PricingTierDescription::model()->active()->findAll([
				'condition' => 'group_id = :group_id',
				'params' => ['group_id' => $pricingGroup->id],
				'order' => 'id DESC'
			]);
		
			$this->render('getPricingGroupPricingTier', [
				'pricingGroup' => $pricingGroup,
				'pricingTierDescription' => $pricingTierDescription
			]);
		} else {
			throw new CHttpException(403, 'Invalid Request, Pricing group is not exist.');
		}
	}
}
