<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
    'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
    'name'=>'RetainInternational',

    // preloading 'log' component
    'preload'=>array('log'),

    // autoloading model and component classes
    'import'=>array(

        // 'application.yii_app_email_queue.models.*',
        // 'application.yii_app_email_queue.components.*',
        // 'application.yii_app_email_queue.test.controllers.*',

        // 'application.yii_app_emailer.components.*',
        // 'application.yii_app_emailer.controllers.*',
        // 'application.yii_app_emailer.models.*',

        'application.models.*',
        'application.components.*',
        /*'application.controllers.*',
        'application.modules.*',*/
    ),

    'modules'=>array(
        // uncomment the following to enable the Gii tool

        'gii'=>array(
            'class'=>'system.gii.GiiModule',
            'password'=>'ZEN_CA2018!',
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            'ipFilters'=>array('127.0.0.1','::1','124.106.156.210', '111.125.109.18', '111.125.109.3'),
        ),

    ),

    // application components
    'components'=>array(

        'user'=>array(
            // enable cookie-based authentication
            'allowAutoLogin'=>true,
            'class' => 'WebUser'
        ),

        // uncomment the following to enable URLs in path-format

        'urlManager'=>array(
            'urlFormat'=>'path',
            'rules'=>array(

                // REST patterns
                array('cloudageApi/list', 'pattern'=>'api/<model:\w+>', 'verb'=>'GET'),
                array('cloudageApi/view', 'pattern'=>'api/<model:\w+>/<id:\d+>', 'verb'=>'GET'),
                array('cloudageApi/update', 'pattern'=>'api/<model:\w+>/<id:\d+>', 'verb'=>'PUT'),
                array('cloudageApi/delete', 'pattern'=>'api/<model:\w+>/<id:\d+>', 'verb'=>'DELETE'),
                array('cloudageApi/create', 'pattern'=>'api/<model:\w+>', 'verb'=>'POST'),
                // Other controllers

                '<controller:\w+>/<id:\d+>'=>'<controller>/view',
                '<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
                '<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
            ),
        ),

        // database settings are configured in database.php
        'db'=>require(dirname(__FILE__).'/database.php'),

        'errorHandler'=>array(
            // use 'site/error' action to display errors
            'errorAction'=>YII_DEBUG ? null : 'site/error',
        ),

        'log'=>array(
            'class'=>'CLogRouter',
            'routes'=>array(
                array(
                    'class'=>'CFileLogRoute',
                    'levels'=>'error, warning',
                ),
                // uncomment the following to show log messages on web pages
                /*
                array(
                    'class'=>'CWebLogRoute',
                ),
                */
            ),
        ),
    ),

    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params'=>array(
        // this is used in contact page
        'adminEmail'=>'webmaster@example.com',
        'website_published_product_switch' => true,
        'SENDINBLUE_KEY' => 'xsmtpsib-19004d0634f2aebbcc7b67b90accc6b40af34e64fa2bbe0918317c78c789b782-0GrYE6BcytvCAq9P',
        'woocommerceAPIURL' => 'https://orders.gsscctv.com',//'https://zeniarkmt.com/gss-orders',
        'API_GSS' => [
            'enable' => false,
            'storeUrl' => 'http://gss.zeniarkmt.com', //'https://szsb-gl2x.accessdomain.com/sbb-2019-dev',
            'apiConsumerKey' => 'ck_1144c002a12bedf8e28372e45bd8800ac8797509', //'ck_f93b4f93a26e351a6a46b990b82433a0582dea44',
            'apiConsumerSecret' => 'cs_66797e1381155267e87dc6ffc36e38ad387de0c5', //'cs_0e06ff26b2c63fec9f7eb55f2a2a158bfb4530df',
        ],
        'API_SBB' => [
            'enable' => true,
            'storeUrl' => 'http://sbb.zeniarkmt.com', //'https://szsb-gl2x.accessdomain.com/sbb-2019-dev',
            'apiConsumerKey' => 'ck_fd91f9b30c7ab89dc4fae38109f9b153941589db', //'ck_f93b4f93a26e351a6a46b990b82433a0582dea44',
            'apiConsumerSecret' => 'cs_aa5a19c3c70b922d82457bb781f99b92dd3f77f2', //'cs_0e06ff26b2c63fec9f7eb55f2a2a158bfb4530df',
        ],
        'SBB_ProductImages_Url' => 'http://sbb.zeniarkmt.com/prod_image/', //dev 'https://szsb-gl2x.accessdomain.com/sbb-2019-dev/prod_image/'
        'GSS_ProductImages_Url' => 'https://orders.gsscctv.com/prod_image/',
    ),
);
