<?php 

$baseUrl = Yii::app()->request->baseUrl; 
$clientScript = Yii::app()->clientScript;

$clientScript->registerScriptFile($baseUrl.'/js/plugins/dropzone/dropzone.min.js');   
$clientScript->registerCssFile($baseUrl.'/css/dropzone/dropzone.css');

?>

<!-- 
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.3.0/min/dropzone.min.js"></script>   
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.3.0/dropzone.css" />
 -->

<?php

$clientScript->registerCss("overide_uploader_style", "

.dropzone.dropzone-mini {
	min-height: 160px;
}

.dropzone .dz-preview {
	display: block !important; 
	margin: 5px !important;
}

.dropzone .dz-preview.dz-file-preview .dz-image {
	display: none !important;
}

.dropzone .dz-preview .dz-image {
	display: none;
}

.dropzone .dz-preview .dz-details {
	position: initial !important;
	padding: initial !important;
}

.dropzone.dropzone-mini .dz-message::after {
	font-size: 80px !important;
	top: 50px !important;
}

.dropzone .dz-preview .dz-remove {
	margin-top: 15px !important;
}

.dropzone .dz-preview .dz-details .dz-size {
	margin-bottoml: initial !important;
	font-size: 12px !important;
}

.dropzone .dz-preview .dz-details .dz-filename:not(:hover) {
	overflow: initial !important;
	text-overflow: initial !important;
}

.dropzone .dz-preview .dz-details .dz-filename {
	white-space: nowrap;
}

.dropzone .dz-preview .dz-details .dz-filename {
	white-space: initial !important;
}

.dropzone .dz-preview .dz-details {
	opacity: initial !important;
}

.dropzone .dz-preview .dz-progress {
	left: 0 !important;
	top: 0 !important;
	margin-top: 10px !important;
	margin-bottom: 0px !important;
	margin-left: 0px !important;
	position: initial;
	width: 100% !important;
}

// .dropzone .dz-preview.dz-processing .dz-progress {
// 	display: none !important;
// }

");

$clientScript->registerScript("uploadVariables".$submitContainer, "
	var preLoad = ".json_encode($preloadItems)."
	Dropzone.autoDiscover = false;
	var dropVar = new Dropzone('div#".$submitContainer."',{ 
		url: '".$controllerUrl."', 
		acceptedFiles: 'text/csv,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
		maxFilesize: '".$maxFileSizeAllowed."', 
		maxFiles: '".$maxFileCount."', 
		addRemoveLinks: true,
	    init: function() {
	
			this.on('maxfilesexceeded', function(file) {

				return false;

		    });

		    this.on('error', function(file, response) {
		    	
		    	if (file.status != 'canceled') {

			    	alert(response);
			    	this.removeFile(file);

		    	}

		    });

		},
		dictFileTooBig: 'File is too big ({{filesize}}MB). Max filesize: {{maxFilesize}}MB.',
		dictDefaultMessage: 'Max ',
		dictMaxFilesExceeded: 'Cannot upload anymore files',
		dictRemoveFile: 'Remove file',
		dictCancelUpload: 'Cancel Upload',
		dictCancelUploadConfirmation: 'Are you sure you want to cancel this upload?'

	});
	
	dropVar.on('success', function(file) {

		var progressElement = $('.dz-progress');
		progressElement.hide();
		console.log(file.xhr.response);
		var responseID = $.parseJSON(file.xhr.response);
		var inputID = '".$submitContainer."-".$inputName."-' + responseID.id;
		var appendInput = '<input id='+ inputID +' name=\'".$inputName."[]\' type=\'hidden\' value='+ responseID.id +'  />';
		$('div#".$submitContainer.".dropzone').closest('form').append(appendInput);
		if($('input.empty-holder').length > 0)
		{
			$('div#".$submitContainer.".dropzone').closest('form').find('.empty-holder').remove();
		}
	});

	dropVar.on('removedfile', function(file) {
		
		var progressElement = $('.dz-progress');
		progressElement.hide();

		if (file.hasOwnProperty('id')) 
		{
			var inputID = '".$submitContainer."-".$inputName."-' + file.id;
		}
		else if (file.hasOwnProperty('xhr')) 
		{	
			var responseID = {};

			if ( file.status == 'success' ) {

				responseID = $.parseJSON(file.xhr.response);	
				var inputID = '".$submitContainer."-".$inputName."-' + responseID.id;
			
			}
		}
		 if(file.status == 'success')
		 {
			 $('input#'+inputID).remove();
		 }
		 var count= dropVar.files.length;

		 if(count < 1)
		 {
			var appendInput = '<input class=\'empty-holder\' name=\'".$inputName."\' type=\'hidden\' value=\'empty\'  />';
			$('div#".$submitContainer.".dropzone').closest('form').append(appendInput);
		 }

	});
	
	dropVar.on('uploadprogress', function(file, progress, bytesSent) {

		var progressElement = $('#uploader-progress');

		progressElement.show();
		progressElement.find('.progress-bar').css('width', progress + '%');

	});

	$.each(preLoad,function(i,chunk){
 
		chunk['accepted'] = 'true';
		chunk['status'] = 'success';
		// dropVar.options.addedfile.call(dropVar, chunk);
		dropVar.emit('addedfile', chunk);
		if(chunk.thumbnail != '')
		{
			dropVar.createThumbnailFromUrl(chunk, chunk.thumbnail);
			// dropVar.options.thumbnail.call(dropVar, chunk, chunk.thumbnail);			
		}
		chunk.previewElement.classList.add('dz-success');
		chunk.previewElement.classList.add('dz-processing');
		chunk.previewElement.classList.add('preload-add');
		dropVar.emit('complete', chunk);
		dropVar.files.push(chunk);
		var inputID = '".$submitContainer."-".$inputName."-' + chunk.id;
		var appendInput = '<input id='+ inputID +' name=\'".$inputName."[]\' type=\'hidden\' value='+ chunk.id +' />';
		$('div#".$submitContainer.".dropzone').closest('form').append(appendInput);
	});
 
",2);
 ?>

<div id="<?php echo $submitContainer; ?>" class="dropzone dropzone-mini <?php echo $classContainer; ?>">
	<div class="dz-default dz-message">
		<div class="alert alert-info" style="padding-top: 0; padding-bottom: 0;">
			<small><strong>Attach Spreadsheet File</strong></small>
		</div>
	</div>
</div>

<!-- <div class="progress" id="uploader-progress" style="display: none; margin-top: 10px;">
    <div class="progress-bar progress-bar-striped active" role="progressbar" style="width: 0%;">
        <span class="progress-text" style="text-shadow: 0px 0px 4px #000; margin-left: 10px;"><strong>Attching...</strong></span>
    </div>
</div> -->
