<?php
/* 
 * Class for common and general reusable functions that are not dependant on other models/modules
 */
class ZCommon
{
	/* 
	 * Commonly used for $model->getErrors(). 
	 * It will parse 2 level dimensional error array and return string output
	 * Feel free to adjust the params, like adding a format parameter for the string output
	*/
	public static function parseError($errorItems = array())
	{
		$errorText = '';
		foreach($errorItems as $key => $errors)
		{
			foreach ( $errors as $value )
			{
				$errorText .= '<li>'.$value.'</li>';
			}
		}
		
		return $errorText = '<ul>'.$errorText.'</ul>';
	}
	
	/* 
	 * General date formater
	*/
	public static function formatDate( $date = null, $format = 'M d, Y g:i a' )
	{
		if ( $date == null )
			$date = date('Y-m-d H:i:s');
			
		return date($format, strtotime($date));
	}
	
	/* 
	 * Shortening string function
	*/
	public function stringTruncate($sting, $length, $end = '...')
	{
		$count = strlen($sting);
		if ($length <> 0)
		{
			if($count > $length)
				$sting = substr($sting,0,$length) . $end;
		}
		return string;
	}

	public static function formatWithDecimal($number) {
		if (empty($number)) {
			$number = 0;
		}

		return number_format($number, 2, '.', '');
	}

	public static function cleanString($string) {
		if (gettype($string) == 'object'){
			return $string;	
		}

		$string = trim($string);
		$string = str_replace(' ', '', $string);
		$string = str_replace(' ', '', $string);
		$string = preg_replace("/[\n\r]/","",$string);
		$string = self::cleanSpecialCharacter($string);

		return $string;
	}

	public static function cleanAmmount($number) {
		$number = (float) str_replace(',', '', trim($number));

		return $number;
	}

	public static function cleanArray($array){
		if(gettype($array) != 'array'){
			return $array;
		}
		$result [] = '';
		foreach ($array as $key => $value) {
			if(gettype($value) != 'object'){
				$string = trim($value);
				$string = str_replace(' ', '', $string);
				$string = str_replace(' ', '', $string);
				$string = preg_replace("/[\n\r]/","",$string);
				// $string = self::cleanSpecialCharacter($string);
				$result[$key] = $string;
			}
			else{
				$result[] = '';
			}
		}

		return $result;
	}

	public static function cleanSpecialCharacter($string) {
		$string = preg_replace('/[^A-Za-z0-9\-\(\)\.\,\_\ ]/', '', $string); // Removes special chars.
		return preg_replace('/-+/', '-', $string); // Replaces multiple hyphens with single one.
	}
}
?>
