<?php
/* add variables or conditions if need */
class SideNav extends CWidget
{
	/* sample variables */
	public $active = array();
	public $openParent = array();
	public $menu = array();
	
	
	public function init()
	{
		// $menu['id']
		$this->menu = array(
			'manage_dashboard' => array(
				'label' => '<i class="glyphicon glyphicon-stats fa-fw"></i> Dashboard',
				'link' => array('site/dashboard')
			),
			'manage_vendor_spreadsheet' => array(
				'label' => '<i class="fa fa-upload fa-fw"></i> Upload Spreadsheets',
				'link' => array('/uploadVendorSpreadsheet')
			),
			'manage_products' => array(
				'label' => '<i class="fa fa-product-hunt fa-fw"></i> Published Products',
				'link' => array('/product')
			),
			'manage_settings' => array(
				'label' => '<i class="fa fa-cog fa-fw"></i> Settings',
				'link' => array('/settings')
			),
			'manage_pricing_group' => array(
				'label' => '<i class="fa fa-dollar fa-fw"></i> Pricing Group',
				'link' => array('/pricingGroup')
			),
			'manage_account' => array(
				'label' => '<i class="fa fa-user fa-fw"></i> Account',
				'link' => array('/account')
			),
			/* 'settings' => array(
				'label' => 'Settings',
				'subpages' => array(
					'main_settings' => array(
						'label' => 'Main Settings',
						'link' => array('/admin/setting')
					),
					'api_settings_list' => array(
						'label' => 'API Settings List',
						'link' => array('/admin/setting/manageApi')
					),
					// 'Venue_filters' => array(
						// 'label' => 'Venue List',
						// 'link' => array('/admin/setting/manageVenue')
					// ),
				)
				
			), */
		);
	}
	
	public function run()
	{	
		$this->render('sidenav', array(
			'menu' => $this->menu,
		));
	}
	
	public function extractMenu($menu, $level = 1, $id = 'sidebar', $collapse = 'out')
	{
		if ($level == 1)
			$return = '<ul id="'.$id.'" class="nav nav-sidebar">';
		else
			$return = '<ul id="'.$id.'" class="nav panel-collapse collapse '.$collapse.' ">';
		
		foreach($menu as $key => $mm)
		{
			
			if (in_array($key, $this->active)) {
				$class = "active";
				$collapse = "in";
				$linkClass = '';
			} 
			else if ( true ) //in_array($key, $this->openParent)
			{
				$class = "";
				$collapse = "in";
				$linkClass = '';
			} else {
				$class = "";
				$collapse = "out";
				$linkClass = 'collapsed';
			}
			
			if (isset($mm['link']))
			{
				$return .= '<li class='.$class.'>';
					$return .= CHtml::link($mm['label'], $mm['link']);
				$return .= '</li>';
			}
			else
			{
				$return .= '<li class="has-dropdown '.$class.'">';
					$return .= CHtml::link($mm['label'], '', array('style' => 'color: black;','class'=>$linkClass, 'data-toggle'=>'collapse', 'data-parent'=>$id, 'href'=>'#'.$key ));
					$return .= $this->extractMenu($mm['subpages'], ($level + 1),$key, $collapse);
				$return .= '</li>';
			}
		}
		$return .= '</ul>';
		return $return;
	}
	
}
?>
