<?php
class MailerContactQueueProcessor extends ContactQueueProcessor{

	private $_model;
	private $_limit = 500;

	public function run() {

		echo 1;
	
		$inProcess = $this->_findInProcessMailerContactFilter();

		if($inProcess !== null) # do not continue if still has a current process working on.
			return;


		
		$this->_model = $this->_findPendingMailerContactFilter();

		if($this->_model == null)
			return; # no result found
		
		echo 2;
		
		$emailQueueGroup = $this->_model->emailQueueGroup;

		if($emailQueueGroup === null)
			throw new Exception("EmailQueueGroup is null", 1);

		$this->_model->setInProcess(true); # update record to indicate that there is a currently in process

		$joinSQL="";
		$conditionSQL = "";
		
		$filterObj = CJSON::decode($this->_model->contact_filter);

		if(!empty($filterObj['filter']['category'])) {

			// $joinSQL .= " INNER JOIN {{contact_categories_lookup}} AS ccl ON (ccl.contact_id = ".EmailContact::model()->getTableAlias().'.id AND ccl.category_id='.$filterObj['filter']['category'].')';
			$joinSQL .= " RIGHT JOIN {{contact_categories_lookup}} AS ccl ON (ccl.contact_id = ".EmailContact::model()->getTableAlias().'.id AND ccl.status='.MailerContactCategoriesLookup::STATUS_ACTIVE.' AND ccl.category_id='.$filterObj['filter']['category'].')';

		} 
		
		
		
		$currentInQueueCount = $emailQueueGroup->getContactCount();

		if($currentInQueueCount > 0) {

			$lastInQueueId = $emailQueueGroup->getLastQueueId();
				
			if ( $lastInQueueId == 3901 )			//remove this code, this i just a patch
			{

				$lastInQueueId = 9;
				
				$conditionSQL .= "

						AND (".EmailContact::model()->getTableAlias().".id > ".$lastInQueueId." AND ".EmailContact::model()->getTableAlias().".id < 2489 )

					";
				
			}
			else if ( $lastInQueueId < 2461 )		//remove this code this is just patch
			{
				  $conditionSQL .= "

						AND (".EmailContact::model()->getTableAlias().".id > ".$lastInQueueId." AND ".EmailContact::model()->getTableAlias().".id < 2489 )

					";
			}
			else
			{
				if($lastInQueueId) {

					$conditionSQL .= "

						AND ".EmailContact::model()->getTableAlias().".id > ".$lastInQueueId."

					";

				}
			}
				

		}

		// get contacts to insert
		$contactQuery = "

			SELECT ".EmailContact::model()->getTableAlias().".id,email_address,first_name,last_name
			FROM {{email_contact}} AS ".EmailContact::model()->getTableAlias()."
			
			".$joinSQL."

			WHERE ".EmailContact::model()->getTableAlias().".status = ".EmailContact::STATUS_ACTIVE." AND type <> ".EmailContact::TYPE_SEED_INPUT." AND subscription_status=".EmailContact::SUBSCRIPTION_STATUS_SUBSCRIBED."
			".$conditionSQL."
		";

		$contactQuery .= " LIMIT ".$this->_limit;
	
		echo $contactQuery;
		
		$command = Yii::app()->db->createCommand($contactQuery);

		$contactRecords = $command->queryAll();

		// end get contacts
		
		echo '<br />';
 		echo count($contactRecords);
		// exit;
		foreach($contactRecords as $contact) {

			$emailQueueGroup->addContact($contact['id']);

		}
		
		$this->_model->setPending(true); # after each process set the record back to pending for re-processing.

		$totalEmailerCount = $this->_getEmailerContactCount();
		
		echo '<Br />';
		echo $totalEmailerCount;
		echo '<Br />';
		echo $currentInQueueCount;
		echo '<Br />';
		
		if($currentInQueueCount >= $totalEmailerCount){
		// if( true ){

			if(!$this->_model->isDone)
				$this->_model->setDone(true);

			return;
		}
		echo 3;
	}

	private function _findPendingMailerContactFilter() {

		$models = MailerContentContactFilter::model()->pending()->findAll();

		if(count($models) > 0)
			return $models[0];
		else
			return null;

	}

	private function _findInProcessMailerContactFilter() {

		$models = MailerContentContactFilter::model()->inProcess()->findAll();

		if(count($models) > 0)
			return $models[0];
		else
			return null;

	}

	private function _getEmailerContactCount(){

		// return EmailContact::model()->countByAttributes(array('status'=> EmailContact::STATUS_ACTIVE));
			
		$criteria = new CDbCriteria;
		$criteria->alias = "t";
		$criteria->mergeWith(array(
			'condition' => (EmailContact::model()->getTableAlias().'.status=:status AND '.EmailContact::model()->getTableAlias().'.type<>:type AND subscription_status=:subs_status'),
			'params' => array(':status' => EmailContact::STATUS_ACTIVE, ':type'=>EmailContact::TYPE_SEED_INPUT, ':subs_status' => EmailContact::SUBSCRIPTION_STATUS_SUBSCRIBED)
		));

		$filterObj = CJSON::decode($this->_model->contact_filter);

		if(!empty($filterObj['filter']['category'])) {

			// $joinSQL = " INNER JOIN {{contact_categories_lookup}} AS ccl ON (ccl.contact_id = ".EmailContact::model()->getTableAlias().'.id AND ccl.category_id='.$filterObj['filter']['category'].')';
			$joinSQL = " RIGHT JOIN {{contact_categories_lookup}} AS ccl ON (ccl.contact_id = ".EmailContact::model()->getTableAlias().'.id AND ccl.status='.MailerContactCategoriesLookup::STATUS_ACTIVE.'  AND ccl.category_id='.$filterObj['filter']['category'].')';

			$criteria->mergeWith(array(
				'join' => $joinSQL
			));

		}

		$criteria->group = "t.id";
		$criteria->select = "t.id";

		return EmailContact::model()->count($criteria);

	}

}