<?php
   if( isset($_POST) && !empty($_POST) )
   {
		$errors = array();
      
		$returnJson = array(
			'status' => 'success',
			'message' => 'Your webinar registration has been successfully saved!',
		);

		if( empty($_POST['WebinarForm']['first_name']) )
			$errors[] = 'Firstname is required';
		if( empty($_POST['WebinarForm']['last_name']) )
			$errors[] = 'Lastname is required';
		if( empty($_POST['WebinarForm']['email_address']) )
			$errors[] = 'Email is required';
		
		if( $_POST['WebinarForm']['email_address'] == 'your@email.com' )
			$errors[] = 'Please enter a valid email address';
		
		if( empty($_POST['WebinarForm']['tId']) )
			$errors[] = 'tId is required';

		if(isset($_POST['g-recaptcha-response'])  && empty($_POST['g-recaptcha-response']))
		{
			$errors[] = "Invalid reCAPTCHA.";
		}
		else
		{
			$secret = '6LdrklwUAAAAAPbLQSQn_18EYWBcFpX20ru2gbm2';
			
			$verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$_POST['g-recaptcha-response']);
			
			$responseData = json_decode($verifyResponse);
			
			if(!$responseData->success) 
			{
				$errors[] = "Invalid reCAPTCHA.";
			}
		}
      
      if(empty($errors))
      {
         include_once("../class/DatabaseConnection.php"); 
         $databaseConnection = new DatabaseConnection;
         
		 $mailerContentTracking = $databaseConnection->selectTable( 'ca_mailer_content_tracking', " id = " .addslashes($_POST['WebinarForm']['tId']) );
		 
		 if( empty($mailerContentTracking) )
			 $errors[] = 'No tracking record found by this id '.$_POST['WebinarForm']['tId'];
		 
		 $linkTypeFormSubmission = 3;
		 
		 // get the mailer content link var
		 $mailerContentLinkVar = $databaseConnection->selectTable( 'ca_mailer_content_link_var', " mailer_content_id = ".$mailerContentTracking['mailer_id']." AND link_type = ".$linkTypeFormSubmission );
		 

		 
         $formSubmissionTableFields['mailer_id'] = $mailerContentTracking['mailer_id'];
         $formSubmissionTableFields['email_contact_id'] = $mailerContentTracking['email_contact_id'];
         $formSubmissionTableFields['mailer_content_link_var_id'] = $mailerContentLinkVar['id'];
		 
		 $mailerContent = $databaseConnection->selectTable( 'ca_mailer_content', " id = ".$mailerContentTracking['mailer_id'] );
		 $mailerContentSubject = $mailerContent['subject'];
		 
		 $webinarFormFields = array('email_address','position','company','last_name','first_name');
		 
		 $databaseConnection->beginTransaction();
		 
		 foreach( $_POST['WebinarForm'] as $webinarFormFieldKey => $webinarFormFieldValue )
		 {
			 
			 if( in_array($webinarFormFieldKey, $webinarFormFields)  )
			 {
				// echo "<pre>";
				// print_r($webinarFormFieldKey);
				// print_r($webinarFormFieldValue);
				// echo "</pre>";
				// exit;
				
				if(empty($webinarFormFieldValue))
					continue;
				 
				$formSubmissionTableFields['key'] = $webinarFormFieldKey;
				$formSubmissionTableFields['value'] = $webinarFormFieldValue;
				 
				// echo "<pre>";
				// print_r($formSubmissionTableFields);
				// echo "</pre>";
				// exit;
				 
				if(!$databaseConnection->insertTo("ca_mailer_content_form_submissions",$formSubmissionTableFields))
				{
					$errors[] = 'Error on saving submission record.';
					break;
				}
			 }
		 }
		 
		 if( !empty($error) )
		 {
			 $formSubmissionTableFields['key'] = 'date_submitted';
			 $formSubmissionTableFields['value'] = date('Y-m-d H:i:s');
			 if(!$databaseConnection->insertTo("ca_mailer_content_form_submissions",$formSubmissionTableFields))
				$errors[] = 'Error on saving submission record.';
		 }
		 
		 $trackingLinkFields['mailer_id'] = $mailerContentTracking['mailer_id'];
		 $trackingLinkFields['mailer_content_link'] = $mailerContentLinkVar['id'];
         $trackingLinkFields['mailer_content_tracking_id'] = $_POST['WebinarForm']['tId'];
		 $trackingLinkFields['email_contact_id'] = $mailerContentTracking['email_contact_id'];
		 $trackingLinkFields['status'] = 1;
		 $trackingLinkFields['date_created'] = date('Y-m-d H:i:s');
		 
		if(!$databaseConnection->insertTo("ca_mailer_content_tracking_link",$trackingLinkFields))
			$errors[] = 'Error on saving the record.';
		 
		 
		 if( empty($error) )
		 {
		  include_once("../includes/swiftMailer/lib/swift_required.php");
		  include_once("../includes/EmailWrapper.php");
          include_once("../includes/Emailer.php"); 
		
		  // $receiver = array(  'reynana.zeniark@gmail.com' => 'Reynan Agapito'); //$_POST['email'] => $_POST['first_name'].' '.$_POST['last_name'] ,
		  $receiver = array(  $_POST['WebinarForm']['email_address'] => $_POST['WebinarForm']['first_name'].' '.$_POST['WebinarForm']['last_name'] ); //$_POST['email'] => $_POST['first_name'].' '.$_POST['last_name'] ,
          $subject = 'Webinar Confirmation - '.$mailerContentSubject;
		
          $emailer = new Emailer;
          $emailer->receivers = $receiver;
          $emailer->subject = $subject;
          $emailer->firstname = $_POST['WebinarForm']['first_name'];
         
		  $template = isset($_POST['WebinarForm']['emailer'])?$_POST['WebinarForm']['emailer']:'cloudageWebinar';

         if( $emailer->send($template) )
			$databaseConnection->commit();
		 }
		 else
			 $databaseConnection->rollback();
		 
		 
		if(!empty($errors))
		 {
			 $returnJson['status'] = 'error';
			 $returnJson['message'] = 'ERROR!';			 
		 }
		 
      }
      else
      {
         $returnJson['status'] = 'error';
         $returnJson['message'] = $errors;
      }
      
      $returnJson['post_data'] = $_POST['WebinarForm'];
      
      exit( json_encode($returnJson) );
   }
   
